define([], function() {
	"use strict";
	var ctrl = ["$scope","constsService","appUtils","restService", function($scope, Consts, appUtils, Rest) {
		var resource = appUtils.resource();

		var dsg = appUtils.getWinData();

		$scope.desc  = resource.get("protection_VMware_task_createPG_setProtectedObject_viewDSGroup_des_label",dsg.dsgName);
		$scope.table = {
			id : "storageResourseTable",
			displayLength : Consts.TABLE_COUNT_PER_PAGE,
			data : [],
			enablePagination : false,
            columns : [{
	        	"sTitle": "",
                "mData": "detail",
                "bSortable": false,
                "sWidth": "30px"
	         }, {
				"sTitle" : resource.get("common_term_name_label"),
				"mData" : "virtualStorageName"
			},{
				"sTitle" : resource.get("ism.drm.lun.wwn"),
				"mData" : "name",
				"bSortable" : false
			},{
				"sTitle" : resource.get("common_term_ower_storage_label"),
				"mData" : "storageDeviceName",
				"bSortable" : false
			}],
			showDetails:{
			    "colIndex":0,
			    "domPendType": "nopend",
				"openClick":function(event){
			        var tr = $(event.target).parents("tr")[0];
			        var dsData = $("#storageResourseTable").widget().getTableData(tr);
			        var child = dsData.storageResource;
			        var html = "";
					for(var z= 0; z < child.length ; z++){
						var lunName = $.encoder.encodeForHTML(child[z].name);
						var lunWwn  = child[z].wwn;
						var devName = $.encoder.encodeForHTML(child[z].storageDeviceName);

						//同一个vCenter下,virtualStorageName唯一
						html+='<tr class="odd clickTrColor" parentId="'+dsData.virtualStorageName+'">';
						html+='<td tdname="detail" class="tiny-tdStyle"></td>';
						html+='<td tdname="name" class="tiny-tdStyle" style="padding-left:20px">'+lunName+'</td>';
						html+='<td tdname="wwn" class="tiny-tdStyle">'+lunWwn+'</td>';
						html+='<td tdname="storageDeviceName" class="tiny-tdStyle">'+devName+'</td></tr>';
					}
					$(event.target).parents("tr").eq(0).after(html);
                },
                "closeClick":function(event){
                   $(event.target).parents("tr").eq(0).nextAll().filter(function(){
                	   return  $(this).attr("parentId") === $("#storageResourseTable").widget().getTableData($(event.target).parents("tr")[0]).virtualStorageName;
                   }).unbind().remove();
                }
	        },
			renderRow : function(nRow, aData, iDataIndex){
				if( aData.detail == "true" ){
					$("td:eq(0)", nRow).html("<div class='default_show_style btn-link'>&nbsp;</div>");
				}
		    }
		};

		var updateDb = appUtils.newUpdateTable($scope.table,$scope,null,function(){
			 var switchDiv = $("div.default_show_style");
	 	     if(switchDiv && switchDiv.length!=0){
	 	        switchDiv.click();
	 	     }
		});

		function init(){
			var dsgId = dsg.dsgId;
			var poType = dsg.poType;
			$("#resWindesc").html($scope.desc);

			if( dsgId != "-1" ){
				poType == "10" ? Rest.getDataStoreStorageGroupStorageResource(dsgId,callback) :
				Rest.queryUsedStorageResourceSet(dsgId,callback);
			}
		}

		function callback(data){

			//格式化数据
			angular.isArray(data) && data.forEach(function(item){
				item.detail  = "true";
				item.name = "--";
				item.storageDeviceName = "--";
				angular.isArray(item.storageResource) && item.storageResource.forEach(function(lun){
					lun.detail = "";
				});
			});
			updateDb(data);
		}

		init();
	}];

	var module = angular.module("recoverydirector.protection.config");
	module.tinyController("viewStorageResWinCtrl", ctrl);
	return module;
});