define([], function() {
    "use strict";
    var ctrl = ["$scope", "constsService", "appUtils", "restService", "model",
        function($scope, constsService, appUtils, restService, Model) {
            var _winData = $("#" + constsService.SAN_CREATE_REPLICA_WIN.winId).widget().option("data");
            //查询本地服务器信息
            restService.queryLocalServer([], function(data) {
                if (data) {
                    $scope.serverUuid = data.uuid;
                };
            });
            $scope.text = {
                siteInfo: appUtils.getStringWithColon("common_term_remoteSite_label"),
                configLabel: appUtils.getString("ism.drm.settings.menuname")
            };
            $scope.startVmTooltip = {
                content: appUtils.getString("protection_start_vm_explain_label"),
                width: "300",
                position:"bottom-right"
            };
            $scope.model = {
                enableCheck: {
                    id: "enableAutoMount",
                    text: appUtils.getString("protection_vmware_auto_mount_hosts_label"),
                    checked: false,
                    change: function() {
                        var checked = $("#enableAutoMount").widget().option("checked");
                        $scope.model.siteSelect.disable = !checked;
                        $scope.model.siteSelect.require = checked;
                        $scope.model.vCenter.disable = !checked;
                        $scope.model.vCenter.require = checked;
                        $scope.model.cluster.disable = !checked;
                        $scope.model.cluster.require = checked;
                        appUtils.resetSelectValues("siteSelect");
                        appUtils.resetSelectValues("vCenterSelect");
                        appUtils.resetSelectValues("clusterSelect");
                        if (checked) {
                            $("#netWorkBtn").removeClass("btn-link-disable").addClass("btn-link");
                            $("#vmIpBtn").removeClass("btn-link-disable").addClass("btn-link");
                        } else {
                            $("#netWorkBtn").removeClass("btn-link").addClass("btn-link-disable");
                            $("#vmIpBtn").removeClass("btn-link").addClass("btn-link-disable");
                        };
                        $scope.model.netWork.disable = !checked;
                        $scope.model.netWork.require = checked;
                        $scope.model.startVM.disable = !checked;
                        $scope.model.vmIp.disable = !checked;
                        $scope.$apply();
                    }
                },
                siteSelect: {
                    id: "siteSelect",
                    require: false,
                    disable: true,
                    text: appUtils.getStringWithColon("common_term_remoteSite_label"),
                    width: 220,
                    values: [{
                        "selectId": "-1",
                        "label": appUtils.getString("common_term_pleaseSelect_listbox")
                    }],
                    defaultSelectid: "-1",
                    openFn: function(object) {
                        var that = this;
                        restService.querySites([$scope.serverUuid], function(data) {
                            if (!_.isEmpty(data)) {
                                appUtils.updateSelectValues(that.id, data, "siteId", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                                object.open();
                            } else {
                                object.open();
                            };
                        });
                    },
                    change: function() {
                        //重置参数
                        appUtils.resetSelectValues("vCenterSelect");
                        appUtils.resetSelectValues("clusterSelect");
                        $scope.model.vCenter.defaultSelectid = "-1";
                        $scope.model.cluster.defaultSelectid = "-1";
                        $scope.model.netWork.values = [];
                        _.extend($("#" + constsService.SAN_CREATE_REPLICA_WIN.winId).widget().option("data"), {
                            mappingSets: []
                        });
                        $scope.$apply();
                    }
                },
                vCenter: {
                    id: "vCenterSelect",
                    text: appUtils.getStringWithColon("common.term.vCenter.tab"),
                    width: 220,
                    disable: true,
                    require: false,
                    values: [{
                        "selectId": "-1",
                        "label": appUtils.getString("common_term_pleaseSelect_listbox")
                    }],
                    defaultSelectid: "-1",
                    openFn: function(object) {
                        var that = this;
                        var selectSiteId = $("#siteSelect").widget().getSelectedId();
                        if (selectSiteId == "-1") {
                            object.open();
                            return;
                        };
                        restService.queryVCenterBySite([selectSiteId], function(data) {
                            if (!_.isEmpty(data)) {
                                appUtils.updateSelectValues(that.id, data, "vCenterUuid", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                                object.open();
                            } else {
                                object.open();
                            };
                        });
                    },
                    change: function() {
                        //重置参数
                        appUtils.resetSelectValues("clusterSelect");
                        $scope.model.cluster.defaultSelectid = "-1";
                        $scope.model.netWork.values = [];
                        _.extend($("#" + constsService.SAN_CREATE_REPLICA_WIN.winId).widget().option("data"), {
                            mappingSets: []
                        });
                        $scope.$apply();
                    }
                },
                cluster: {
                    id: "clusterSelect",
                    text: appUtils.getStringWithColon("resource_mapping_cluster"),
                    width: 220,
                    disable: true,
                    require: false,
                    values: [{
                        "selectId": "-1",
                        "label": appUtils.getString("common_term_pleaseSelect_listbox")
                    }],
                    defaultSelectid: "-1",
                    openFn: function(object) {
                        var that = this;
                        var selectVcenterId = $("#vCenterSelect").widget().getSelectedId();
                        if (selectVcenterId == "-1") {
                            object.open();
                            return;
                        };
                        restService.getvCenterTestCluster([selectVcenterId], function(data) {
                            if (!_.isEmpty(data)) {
                                appUtils.updateSelectValues(that.id, data, "uuid", "name", appUtils.getString("protection_mount_site_select_label"));
                                object.open();
                            } else {
                                object.open();
                            };
                        });
                    },
                    change: function() {
                        //重置参数
                        $scope.model.netWork.values = [];
                        _.extend($("#" + constsService.SAN_CREATE_REPLICA_WIN.winId).widget().option("data"), {
                            mappingSets: []
                        });
                        $scope.$apply();
                    }
                },
                netWork: {
                    id: "netWorkBtn",
                    text: appUtils.getStringWithColon("resource_mapping_network"),
                    require: false,
                    disable: true,
                    values: [],
                    config: function() {
                        if (this.disable) {
                            return;
                        };
                        var that = this;
                        var win = angular.copy(constsService.VM_MOUNT_NETWORK_CONFIG_WIN);
                        win.title = appUtils.getString("protection_vmware_cdm_network_win_label");
                        _.extend(win.data, {
                            hostUuid: $("#clusterSelect").widget().getSelectedId(),
                            vcenterUuid: $("#vCenterSelect").widget().getSelectedId(),
                            pg: _.first($("#pgTable").widget().getTableCheckedItems()),
                            mappingDatas: that.values
                        });
                        appUtils.showWindow(win, function() {
                            var data = $("#mappingViewTable").widget().getTableData();
                            if (_.isEmpty(data)) {
                                message.error(appUtils.getString("protection_vmware_cdm_network_mapping_error_label"));
                                return;
                            };
                            that.values = [];
                            _.each(data, function(obj) {
                                that.values.push({
                                    "srcNetworkId": obj.id[0],
                                    "srcNetworkName": obj.name[0],
                                    "remoteNetworkId": obj.id[1],
                                    "remoteNetworkName": obj.name[1]
                                });
                            });
                            _.extend($("#" + constsService.SAN_CREATE_REPLICA_WIN.winId).widget().option("data"), {
                                mappingSets: that.values
                            });
                            $scope.$apply();
                            $("#" + constsService.VM_MOUNT_NETWORK_CONFIG_WIN.winId).widget().destroy();
                        });
                    }
                },
                vmIp: {
                    id: "vmIpBtn",
                    text: appUtils.getStringWithColon("protection_mount_vm_ip_set_label"),
                    require: false,
                    disable: true,
                    values: [],
                    config: function(){
                        if (this.disable) {
                            return;
                        };
                        var that = this;
                        //设置虚拟机IP
                        var win = angular.copy(constsService.VMWARE_MOUNT_IP_CONFIG_WIN);
                        _.extend(win.data, _.first($("#pgTable").widget().getTableCheckedItems()), {vmIpConfigs: that.values});
                        win.title = appUtils.getString("protection_mount_vm_ip_set_win_label");
                        appUtils.showWindow(win, function(){
                            //先校验参数是否正确
                            var tableData = $("#vmsTable").widget().getTableData();
                            var ipconfigArray = [];
                            var vaildFlag = true;
                            for (var i = 0; i < tableData.length; i++) {
                                var networkCardVal = tableData[i].netWorkCard;
                                if (_.isEmpty(networkCardVal)) {
                                    continue;
                                };
                                var errorFlag = true;
                                //先校验
                                for(var j = 0; j < networkCardVal.length; j++){
                                    if(networkCardVal[j].dhcpEnabled4 === false){
                                        if(!networkCardVal[j].ipv4.ipReg.test(networkCardVal[j].ipVal)){
                                            errorFlag = false;
                                            break;
                                        };
                                        if(!networkCardVal[j].netmask.maskReg.test(networkCardVal[j].netmaskVal)){
                                            errorFlag = false;
                                            break;
                                        };
                                        if(!networkCardVal[j].gateway.ipReg.test(networkCardVal[j].gatewayVal)){
                                            errorFlag = false;
                                            break;
                                        };
                                    };
                                    var obj = {
                                        ownerId: tableData[i].uuid,
                                        name: "IPV4:" + networkCardVal[j].macAddress,
                                        value: {
                                            nicMac: networkCardVal[j].macAddress,
                                            nicName: networkCardVal[j].nicName,
                                            openIp4: _.isUndefined(networkCardVal[j].openIp4) ? false : networkCardVal[j].openIp4,
                                            openIp6: _.isUndefined(networkCardVal[j].openIp6) ? false : networkCardVal[j].openIp6,
                                            dhcpEnabled4: _.isUndefined(networkCardVal[j].dhcpEnabled4) ? true : networkCardVal[j].dhcpEnabled4,
                                            dhcpEnabled6: _.isUndefined(networkCardVal[j].dhcpEnabled6) ? true : networkCardVal[j].dhcpEnabled6,
                                            ip: networkCardVal[j].dhcpEnabled4 === false ? networkCardVal[j].ipVal : "",
                                            ipv6List: [{
                                                address: networkCardVal[j].dhcpEnabled6 === false ? networkCardVal[j].ip6Val : "",
                                                prefix: networkCardVal[j].dhcpEnabled6 === false ? networkCardVal[j].prefixVal : ""
                                            }],
                                            netmask: networkCardVal[j].dhcpEnabled4 === false ? networkCardVal[j].netmaskVal : "",
                                            gateway: networkCardVal[j].dhcpEnabled4 === false ? networkCardVal[j].gatewayVal : "",
                                            gateway6: networkCardVal[j].dhcpEnabled6 === false ? networkCardVal[j].gateway6Val : ""
                                        }
                                    };
                                    //linux
                                    if(tableData[i].props.GUESTOSTYPE == "linuxGuest"){
                                        _.extend(obj.value, {
                                            autoDns4: _.isUndefined(tableData[i].autoDns4) ? true : tableData[i].autoDns4,
                                            autoDns6: _.isUndefined(tableData[i].autoDns6) ? true : tableData[i].autoDns6,
                                            preferredDns: tableData[i].autoDns4 === false ? tableData[i].preferredDns : "",
                                            preferredDns6: tableData[i].autoDns6 === false ? tableData[i].preferredDns6 : "",
                                            alternateDns: tableData[i].autoDns4 === false ? tableData[i].alternateDns : "",
                                            alternateDns6: tableData[i].autoDns6 === false ? tableData[i].alternateDns6 : ""
                                        })
                                    }else{
                                        _.extend(obj.value, {
                                            username: tableData[i].userNameVal,
                                            password: tableData[i].passwordVal,
                                            autoDns4: _.isUndefined(networkCardVal[j].autoDns4) ? true : networkCardVal[j].autoDns4,
                                            autoDns6: _.isUndefined(networkCardVal[j].autoDns6) ? true : networkCardVal[j].autoDns6,
                                            preferredDns: networkCardVal[j].autoDns4 === false ? networkCardVal[j].preferredDns : "",
                                            preferredDns6: networkCardVal[j].autoDns6 === false ? networkCardVal[j].preferredDns6 : "",
                                            alternateDns: networkCardVal[j].autoDns4 === false ? networkCardVal[j].alternateDns : "",
                                            alternateDns6: networkCardVal[j].autoDns6 === false ? networkCardVal[j].alternateDns6 : ""
                                        })
                                    };
                                    ipconfigArray.push(obj);
                                };
                                if(!errorFlag){
                                    vaildFlag = false;
                                    break;
                                };
                            };
                            if(!vaildFlag){
                                message.error(appUtils.getString("lego.err.856064"));
                                return;
                            };
                            that.values = angular.copy(ipconfigArray);
                            _.extend($("#" + constsService.SAN_CREATE_REPLICA_WIN.winId).widget().option("data"), {
                                netWorkConfigs: that.values
                            });
                            $scope.$apply();
                            $("#" + constsService.VMWARE_MOUNT_IP_CONFIG_WIN.winId).widget().destroy()
                        });
                    }
                },
                startVM: {
                    id: "startVMCheckBox",
                    text: appUtils.getString("protection_startVM_after_mount_label"),
                    disable: true,
                    checked: false
                }
            };
            setTimeout(function() {
                var linkDesc = appUtils.getString("protection_object_vmware_create_dp_prompt_label");
                $("#createReplicaDiv").html(linkDesc);
            }, 0)
        }
    ];
    var module = angular.module("recoverydirector.protection.config");
    module.tinyController("vm-create-replica-ctrl", ctrl);
    return module;
})
