define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrl = [
        "$scope",
        "message",
        "utilService",
        "mask",
        "appUtils",
        "constsService",
        "restService",
        "$compile",
        "widgetService",
        function($scope, message, utilService, mask, appUtils, constsService, restService, $compile, widgetService) {
            var winData = $("#" + constsService.VOLUME_MANAGE_WIN.winId).widget().option("data");
            $scope.protectedVolume = winData.protectedVolume;
            $scope.unProtectedVolume = winData.unProtectedVolume;
            $scope.removedVolume = winData.removedVolume;
            $scope.volumeManage = {
                isProtected: {
                    title: appUtils.getString("volume_manage_has_protected"),
                    label: appUtils.getString("volume_manage_protected_label"),
                    id: "protectedVolume",
                    data: [],
                    enablePagination: false,
                    renderRow: function(nRow, aData, iDataIndex) {
                        if (_.isUndefined(aData["servers"]) || _.isEmpty(aData["servers"][0].poName)) {
                            $("td:eq(2)", nRow).html("--");
                            return
                        }
                        var vms = "";
                        _.each(aData["servers"],function(obj){
                            vms+="<span>"+obj.poName+"&nbsp&nbsp"+"</span>"
                        });
                        $("td:eq(2)", nRow).html(vms);
                    },
                    columns: [{
                        "mData": "volumeId",
                        "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("rm_term_volumn_column_product_name"),
                        "mData": "volumeName",
                        "bSortable": false,
                    }, {
                        "sTitle": appUtils.getString("rm_term_volumn_column_product_volume"),
                        "mData": "volumeType",
                        "bSortable": false,
                    }, {
                        "sTitle": appUtils.getString("rm_term_volumn_column_virtual"),
                        "bSortable": false,
                    }, {
                        "sTitle": appUtils.getString("rm_term_volumn_column_dr_type"),
                        "mData": "drVolumeType",
                        "bSortable": false,
                    }]
                },
                unProtected: {
                    title: appUtils.getString("volume_manage_un_protected"),
                    label: appUtils.getString("volume_manage_unprotected_label"),
                    id: "unProtectedVolume",
                    data: [],
                    enablePagination: false,
                    renderRow: function(nRow, aData, iDataIndex) {
                        var vms = "";
                        _.each(aData["servers"],function(obj){
                            vms+="<span>"+obj.poName+"&nbsp&nbsp"+"</span>"
                        });
                        $("td:eq(2)", nRow).html(vms);
                        var optColumn = "<tiny-select id='id' default-selectid='defaultId' values='values' width='width' disable='disable' open-fn='openFn'></tiny-select>";
                        var optLink = $compile($(optColumn));
                        var optScope = $scope.$new();
                        optScope.id = aData.volumeId.replace(":", "-");
                        optScope.defaultId = aData['volumeStatus'] == "UNPROTECTED" ? "-1" : "dr_1";
                        optScope.disable = aData['volumeStatus'] == "UNPROTECTED" ? "false" : "true";
                        optScope.width = "150";
                        optScope.values = aData['volumeStatus'] == "UNPROTECTED" ? [{selectId: "-1",label: appUtils.getString("common_term_pleaseSelect_listbox")}] :[{selectId:"dr_1",label: aData['drVolumeType']}];
                        optScope.openFn = function(object) {
                            var that = this;
                            var params = {
                                openstackId: winData["poProviderSN"],
                                srcProjectId: winData.props.projectId,
                                srcRegionId: winData.props.regionId,
                                regionId: winData.props.drRegionId,
                                projectId: winData.props.drProjectId,
                                srcVolumeTypeName: aData["volumeType"]
                            };

                            restService.getOpenStackVolumeType(params, function(data){
                                if (!_.isEmpty(data)) {
                                    var array = [];

                                    _.each(data, function(v,index){
                                        array.push({
                                            "selectId": v.volumeTypeId,
                                            "label": v.volumeTypeName,
                                            "checked": index == 0
                                        });
                                    });

                                    array.push({selectId: "-1",label: appUtils.getString("common_term_pleaseSelect_listbox")});
                                    $("#" + that.id).widget().option("values", array);
                                };
                                object.open();
                            });
                        };
                        var setVolumeType = optLink(optScope);
                        $("td:eq(3)", nRow).html(setVolumeType);
                    },
                    columns: [{
                        "mData": "volumeId",
                        "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("rm_term_volumn_column_product_name"),
                        "mData": "volumeName",
                        "bSortable": false,
                    }, {
                        "sTitle": appUtils.getString("rm_term_volumn_column_product_volume"),
                        "mData": "volumeType",
                        "bSortable": false,
                    }, {
                        "sTitle": appUtils.getString("rm_term_volumn_column_virtual"),
                        "bSortable": false,
                    }, {
                        "sTitle": appUtils.getString("rm_term_volumn_column_dr_type"),
                        "mData": "drVolumeType",
                        "bSortable": false,
                    }]
                },
                removed: {
                    title: appUtils.getString("volume_manage_removed_protected"),
                    label: appUtils.getString("volume_manage_removed_label"),
                }
            };
            $scope.removed = {
                id: "removedVolume",
                data: [],
                enablePagination: false,
                checkbox: true,
                renderRow: function(nRow, aData, iDataIndex) {
                    var vms = "";
                    _.each(aData["servers"],function(obj){
                        vms+="<span>"+obj.poName+"&nbsp&nbsp"+"</span>"
                    });
                    $("td:eq(3)", nRow).html(vms);
                },
                columns: [{
                    "mData": "volumeId",
                    "bVisible": false
                }, {
                    "sTitle": appUtils.getString("rm_term_volumn_column_product_name"),
                    "mData": "volumeName",
                    "bSortable": false,
                    "sWidth": "146px"
                }, {
                    "sTitle": appUtils.getString("rm_term_volumn_column_product_volume"),
                    "mData": "volumeType",
                    "bSortable": false,
                    "sWidth": "146px"
                }, {
                    "sTitle": appUtils.getString("rm_term_volumn_column_virtual"),
                    "bSortable": false,
                    "sWidth": "146px"
                }, {
                    "sTitle": appUtils.getString("rm_term_volumn_column_dr_type"),
                    "mData": "drVolumeType",
                    "bSortable": false,
                    "sWidth": "146px"
                }]
            };

            $scope.isRemovedVolume = {
                id: "isRemovedChecked",
                checked: false,
                disable:false,
                text: appUtils.getString("volume_manage_removed_checked_confirm_label")
            };

            function init() {
                restService.getProtectedVolumeInfo({protectGroupId: winData["uuid"]}, {
                    success: function(result) {
                        var protectedArr = [],
                            unprotectedArr = [],
                            removedArr = [];
                        _.each(result, function(obj) {
                            if (obj.volumeStatus == "UNPROTECTED" || obj.volumeStatus == "CONFIGING") {
                                unprotectedArr.push(obj)
                            };
                            if (obj.volumeStatus == "PROTECTED") {
                                protectedArr.push(obj)
                            };
                            if (obj.volumeStatus == "REMOVED" || obj.volumeStatus == "RELEASING") {
                                if(obj.volumeStatus == "RELEASING"){
                                    obj.tinyChecked = true;
                                    obj.tinyCheckDisabled = true;
                                }else{
                                    obj.tinyChecked = false;
                                    obj.tinyCheckDisabled = false;
                                }
                                removedArr.push(obj)
                            };
                        });
                        if(_.contains([25,29],parseInt(winData.template.type,10)) && $scope.unProtectedVolume && unprotectedArr.length > 0){
                                $("#VOLUME_MANAGE_WIN").find("#ok").addClass("tiny-btn-disable")
                            }

                        if(_.contains([25,29],parseInt(winData.template.type,10)) && $scope.removedVolume && removedArr.length > 0){
                            $("#VOLUME_MANAGE_WIN").find("#ok").addClass("tiny-btn-disable")
                        }
                        $scope.volumeManage.isProtected.data = appUtils.encodeForHTML(protectedArr);
                        $scope.volumeManage.unProtected.data = appUtils.encodeForHTML(unprotectedArr);
                        $scope.removed.data = appUtils.encodeForHTML(removedArr);
                        $scope.$apply();
                    }
                })
            };
            var buttons = [{
                key: "ok",
                label: appUtils.getString('common_term_confirm_button'),
                focused: true,
                handler: function(event) {
                    var addedVolumes = [],
                        params = {},
                        removedVolumes = [];
                    _.each($scope.volumeManage.unProtected.data, function(obj) {
                        var volumeType = {};
                        var widget = $("#" + obj.volumeId.replace(":", "-")).widget();
                        var drVolumeTypeId = widget.getSelectedId();

                        if (drVolumeTypeId != "-1") {
                            volumeType.volumeId = obj.volumeId;
                            volumeType.drVolumeType = widget.getSelectedLabel();
                            volumeType.poUuid = obj.servers[0].poUuid;
                            addedVolumes.push(volumeType);
                        }
                    });

                    var remove = $("#removedVolume").widget().getTableCheckedItems();
                    _.each(remove, function(obj) {
                        var temp = _.pick(obj, "volumeId");
                        temp.poUuid = obj.servers[0].poUuid;
                        removedVolumes.push(temp);
                    });

                    params.addedVolumes = addedVolumes;
                    params.removedVolumes = removedVolumes;

                    if($scope.unProtectedVolume){
                        params.removedVolumes = [];
                    }
                    if($scope.removedVolume){
                        params.addedVolumes = [];
                    }
                    if(_.isEmpty(params.addedVolumes) && _.isEmpty(params.removedVolumes)){
                        var winInstance = $("#" + constsService.VOLUME_MANAGE_WIN.winId).widget();
                        winInstance.option("data", {close: true});
                        winInstance.destroy();
                        return;
                    };

                    if(_.contains([25,29],parseInt(winData.template.type,10)) && $("#VOLUME_MANAGE_WIN").find("#ok").hasClass("tiny-btn-disable")){
                        return;
                    }

                    restService.setProtectedVolumeInfo({protectGroupId: winData["uuid"]}, {
                        data: params,
                        success: function(result) {
                            message.success({
                                content: appUtils.getString("common_term_operation_success_label"),
                                ok: function() {
                                    $("#" + constsService.VOLUME_MANAGE_WIN.winId).widget().destroy();
                                }
                            });
                        }
                    })
                }
            }, {
                key: "cancel",
                label: appUtils.getString('common_term_cancel_button'),
                focused: false,
                handler: function(event) {
                    var winInstance = $("#" + constsService.VOLUME_MANAGE_WIN.winId).widget();
                    winInstance.option("data", {close: true});
                    winInstance.destroy();
                }
            }]

            !$scope.protectedVolume && $("#" + constsService.VOLUME_MANAGE_WIN.winId).widget().option("buttons", buttons);

            init();

        }
    ]
    var module = angular.module("recoverydirector.protection.config");
    module.tinyController("protect_volume_manage_ctrl", ctrl);
    return module;
})
