define([], function() {
    "use strict";
    var ctrl = [
        "$scope",
        "message",
        "constsService",
        "appUtils",
        "restService",
        function($scope, message, constsService, appUtils, restService) {
            var winObj = $("#" + constsService.PROTECTGROUP_EXECUTE_BACKUP_WIN.winId).widget().option("data");
            var parmsList = {}; // 存放所有下发请求时的正文参数{execute****SiteSelected:{ScheduleId,backupTypeAfterSync}}
            var copyScheduleId = ""; // 复制的ScheduleId

            // 点击确定后执行的方法
            $("#" + constsService.PROTECTGROUP_EXECUTE_BACKUP_WIN.winId).widget().options.changeOkHandler(function(callback) {
                var thisParms = {}; // 下发请求时的正文参数

                /*
                    获取单选按钮选中的值
                    $("#executeCopyBackup").widget().opChecked()
                    这种方式也可以，ID可以是三个中的任意一个
                */
                var radio = new tinyWidget.Radio($scope.execute);
                var backupType = radio.opChecked();

                /*
                    根据单选按钮中的值进行逻辑处理
                */
                // 如果单选按钮为复制
                if ("executeCopyBackup" == backupType) {
                    thisParms = parmsList[$("#copySiteSelect").widget().getSelectedId()]; // 拿到当前的参数列表
                };
                // 如果单选按钮为快速备份
                if ("executeQuickBackup" == backupType) {
                    thisParms = parmsList[$("#quickBackupSiteSelect").widget().getSelectedId()]; // 拿到当前的参数列表
                    // 如果参数中没有scheduleId，说明此时选择的是location为1的站点，scheduleId传复制的scheduleId
                    if (_.isUndefined(thisParms.scheduleId)) {
                        thisParms.scheduleId = copyScheduleId;
                    };
                };
                // 如果单选按钮为云备份
                if ("executeColudBackup" == backupType) {
                    thisParms = parmsList[$("#coludBackupSelect").widget().getSelectedId()]; // 拿到当前的参数列表
                    // 如果参数中没有scheduleId，说明此时选择的是location为1的站点，scheduleId传复制的scheduleId
                    if (_.isUndefined(thisParms.scheduleId)) {
                        thisParms.scheduleId = copyScheduleId;
                    };
                    var quickBackupType = $("#coludBackupTypeSelect").widget().getSelectedId(); // 拿到当前选择的是增量还是全量
                    thisParms.fullBackup = "executeCloudBackupTypeFull" == quickBackupType; // 给参数中的增量还是全量赋值
                };
                this.options.data.param = thisParms;
                callback(); // showWindows中的回调function()
            });

            $scope.execute = {
                name: "execute",
                // 复制
                copy: {
                    id: "executeCopyBackup",
                    name: appUtils.getString("pg_execute_copybackup_label"),
                    description: appUtils.getString("pg_execute_copybackuptips_label"),
                    value: "executeCopyBackup",
                    checked: false,
                    disable: true,
                    isShowSelect: false,
                    site: {
                        id: "copySiteSelect",
                        label: appUtils.getStringWithColon("site_objectName"),
                        require: false,
                        values: []
                    }
                },
                // 快速备份
                quickBackup: {
                    id: "executeQuickBackup",
                    name: appUtils.getString("pg_create_fastcloudback_label"),
                    description: appUtils.getString("pg_execute_quickbackuptips_label"),
                    value: "executeQuickBackup",
                    checked: false,
                    disable: true,
                    isShowSelect: false,
                    site: {
                        id: "quickBackupSiteSelect",
                        label: appUtils.getStringWithColon("site_objectName"),
                        require: false,
                        values: []
                    }
                },
                // 云备份
                coludBackup: {
                    id: "executeColudBackup",
                    name: appUtils.getString("pg_create_cloudback_label"),
                    description: appUtils.getString("pg_execute_cloudbacktips_label"),
                    value: "executeColudBackup",
                    checked: false,
                    disable: true,
                    isShowSelect: false,
                    site: {
                        id: "coludBackupSelect",
                        label: appUtils.getStringWithColon("site_objectName"),
                        require: false,
                        values: []
                    },
                    backupType: {
                        id: "coludBackupTypeSelect",
                        label: appUtils.getStringWithColon("pg_execute_backuptype_label"),
                        values: [{
                            selectId: 'executeCloudBackupTypeIncre',
                            label: appUtils.getString("pg_execute_increbackup_label"),
                            checked: true
                        }, {
                            selectId: 'executeCloudBackupTypeFull',
                            label: appUtils.getString("pg_execute_fullbackup_label"),
                        }]
                    }
                },
                // 点击按钮事件，控制各备份下的站点显示与隐藏
                "click": function(id) {
                    $scope.execute.copy.isShowSelect = "executeCopyBackup" == id;
                    $scope.execute.quickBackup.isShowSelect = "executeQuickBackup" == id;
                    $scope.execute.coludBackup.isShowSelect = "executeColudBackup" == id;
                    $scope.$apply();
                }
            };

            // 默认展示复制选项
            $scope.isShowCopy = true;

            // 初始化界面
            function init() {
                // 快照和双活+快照的没有复制
                if (2 == winObj.pg.template.type || 19 == winObj.pg.template.type) {
                    $scope.isShowCopy = false;
                };

                //快照、双活+快照、一体化备份、双活+一体化备份、一体化备份+双活
                $scope.isShowBackup = _.contains([2, 19, 30, 31, 32], parseInt(winObj.pg.template.type));

                restService.queryPgSchedules(winObj.pg.pgId, function(result) {
                    // 若结果为空
                    if (!_.size(result)) {
                        return;
                    };
                    //并联同步+异步 和 串联同步+异步 ，同步端不需要执行，过滤掉同步的schedule
                    if(_.contains([3,5], parseInt(winObj.pg.template.type))){
                        result = _.filter(result, function(item){
                            return item.protectLocation != 1
                        });
                    };
                    //将schedule未启用的过滤掉
                    result = _.filter(result, function(value) {
                        return value.enable !== false;
                    });
                    // 对结果进行遍历，找出适用的执行方式，并查出对应的站点名
                    _.each(result, function(value, key) {
                        // 快速备份
                        if (2 == value.protectedType || 100 == value.protectedType) {
                            $scope.execute.quickBackup.disable = false; // 按钮设置为可操作
                            // 查站点名并赋值
                            restService.getSiteDetails(value.targetSiteId, {
                                success: function(data) {
                                    var tempSelect = {
                                        selectId: 'executeQuickBackupSiteSelected' + key,
                                        label: data.name,
                                        checked: true
                                    };
                                    value.enable && ($scope.execute.quickBackup.site.values.push(tempSelect));
                                    $scope.$apply();
                                    /*
                                        快速备份：
                                            没有fullType
                                            如果选的是location为0的站点，scheduleId传当前选中的快速备份scheduleId。backupTypeAfterSync：可选可不选
                                            如果选的是location为1的站点，scheduleId传复制的scheduleId。backupTypeAfterSync：所选中的schedule的protectedType
                                    */
                                    if (value.protectLocation == 1) {
                                        parmsList["executeQuickBackupSiteSelected" + key] = {
                                            backupTypeAfterSync: value.protectedType
                                        };
                                    } else {
                                        parmsList["executeQuickBackupSiteSelected" + key] = {
                                            scheduleId: value.scheduleId,
                                            backupTypeAfterSync: value.protectedType
                                        };
                                    };
                                }
                            });
                        }
                        // 云备份
                        else if (101 == value.protectedType) {
                            $scope.execute.coludBackup.disable = false; // 按钮设置为可操作
                            // 查站点名并赋值
                            restService.getSiteDetails(value.targetSiteId, {
                                success: function(data) {
                                    var tempSelect = {
                                        selectId: 'executeCloudBackupSiteSelected' + key,
                                        label: data.name,
                                        checked: true
                                    };
                                    value.enable && ($scope.execute.coludBackup.site.values.push(tempSelect));
                                    $scope.$apply();
                                    /*
                                        云备份：
                                            fullType用户选什么就传什么。
                                            如果选的是location为0的站点，scheduleId传当前选中的快速备份scheduleId。backupTypeAfterSync：可选可不选
                                            如果选的是location为1的站点，scheduleId传复制的scheduleId。backupTypeAfterSync：所选中的schedule的protectedType
                                    */
                                    if (value.protectLocation == 1) {
                                        parmsList["executeCloudBackupSiteSelected" + key] = {
                                            backupTypeAfterSync: value.protectedType
                                        };
                                    } else {
                                        parmsList["executeCloudBackupSiteSelected" + key] = {
                                            scheduleId: value.scheduleId,
                                            backupTypeAfterSync: value.protectedType
                                        };
                                    };

                                }
                            });
                        }
                        //复制
                        else {
                            $scope.execute.copy.disable = false; // 按钮设置为可操作
                            //环形3dc有2个站点
                            if (!_.isUndefined(winObj.pg.props) && !_.isUndefined(winObj.pg.props["hyper-dr-ring-used-resources"])) {
                                restService.getSiteDetails(value.sourceSiteId.split(":")[0], {
                                    success: function(data) {
                                        if (value.sourceSiteId.split(":").length > 1) {
                                            restService.getSiteDetails(value.sourceSiteId.split(":")[1], {
                                                success: function(result) {
                                                    var tempName = data.name + "+" + result.name;
                                                    restService.getSiteDetails(value.targetSiteId, {
                                                        success: function(response) {
                                                            var tempSelect = {
                                                                selectId: 'executeCopySiteSelected' + key,
                                                                label: tempName + "-->" + response.name,
                                                                checked: true
                                                            };
                                                            $scope.execute.copy.site.values.push(tempSelect);
                                                            $scope.$apply();
                                                            copyScheduleId = value.scheduleId;
                                                            // 复制：backupTypeAfterSync：-1， scheduleId传复制的scheduleId
                                                            parmsList["executeCopySiteSelected" + key] = {
                                                                scheduleId: value.scheduleId,
                                                                backupTypeAfterSync: -1
                                                            };
                                                        }
                                                    });
                                                }
                                            })
                                        } else {
                                            //异步+双活的环形3dc
                                            if (value.targetSiteId.split(":").length > 1) {
                                                restService.getSiteDetails(value.targetSiteId.split(":")[0], {
                                                    success: function(result) {
                                                        restService.getSiteDetails(value.targetSiteId.split(":")[1], {
                                                            success: function(response) {
                                                                var tempSelect = {
                                                                    selectId: 'executeCopySiteSelected' + key,
                                                                    label: data.name + "-->" + result.name + "+" + response.name,
                                                                    checked: true
                                                                };
                                                                $scope.execute.copy.site.values.push(tempSelect);
                                                                $scope.$apply();
                                                                copyScheduleId = value.scheduleId;
                                                                // 复制：backupTypeAfterSync：-1， scheduleId传复制的scheduleId
                                                                parmsList["executeCopySiteSelected" + key] = {
                                                                    scheduleId: value.scheduleId,
                                                                    backupTypeAfterSync: -1
                                                                };
                                                            }
                                                        });
                                                    }
                                                })
                                            } else {
                                                restService.getSiteDetails(value.targetSiteId, {
                                                    success: function(result) {
                                                        var tempSelect = {
                                                            selectId: 'executeCopySiteSelected' + key,
                                                            label: data.name + "-->" + result.name,
                                                            checked: true
                                                        };
                                                        $scope.execute.copy.site.values.push(tempSelect);
                                                        $scope.$apply();
                                                        copyScheduleId = value.scheduleId;
                                                        // 复制：backupTypeAfterSync：-1， scheduleId传复制的scheduleId
                                                        parmsList["executeCopySiteSelected" + key] = {
                                                            scheduleId: value.scheduleId,
                                                            backupTypeAfterSync: -1
                                                        };
                                                    }
                                                });
                                            }
                                        }
                                    }
                                });
                            } else {
                                restService.getSiteDetails(value.sourceSiteId, {
                                    success: function(data) {
                                        restService.getSiteDetails(value.targetSiteId, {
                                            success: function(result) {
                                                var tempSelect = {
                                                    selectId: 'executeCopySiteSelected' + key,
                                                    label: data.name + "-->" + result.name,
                                                    checked: true
                                                };
                                                $scope.execute.copy.site.values.push(tempSelect);
                                                $scope.$apply();
                                                copyScheduleId = value.scheduleId;
                                                // 复制：backupTypeAfterSync：-1， scheduleId传复制的scheduleId
                                                parmsList["executeCopySiteSelected" + key] = {
                                                    scheduleId: value.scheduleId,
                                                    backupTypeAfterSync: -1
                                                };
                                            }
                                        });
                                    }
                                });
                            };
                        };
                    });

                    // 判断默认选中的按钮是哪一个并展示对应下方的站点
                    if (!$scope.execute.copy.disable) {
                        $scope.execute.copy.checked = true; // 默认选择当前按钮
                        $scope.execute.copy.isShowSelect = true; // 显示复制下方的站点
                    } else if (!$scope.execute.quickBackup.disable) {
                        $scope.execute.quickBackup.checked = true; // 默认选择当前按钮
                        $scope.execute.quickBackup.isShowSelect = true; // 显示快速备份下方的站点
                    } else {
                        $scope.execute.coludBackup.checked = true; // 默认选择当前按钮
                        $scope.execute.coludBackup.isShowSelect = true; // 显示云备份下方的站点
                    };
                    $scope.$apply();
                })
            };

            init();

        }
    ];

    var module = angular.module("recoverydirector.protection.config");
    module.tinyController("protectGroup.execute.backup.ctrl", ctrl);
    return module;
});
