define([], function() {
    "use strict";
    var ctrl = [
        "$scope",
        "$state",
        "$stateParams",
        "exception",
        "message",
        "communicationService",
        "utilService",
        "mask",
        "constsService", "appUtils", "cookieService", "restService",
        function($scope, $state, $stateParams, exception, message,
            communicationService, utilService, mask, constsService, appUtils, cookieService, Rest) {
            var winObj = $("#" + constsService.PROTECTGROUP_EXECUTE_17_WIN.winId).widget(),
                data = winObj.option("data"),
                labels = {
                    description: appUtils.getString("protection_exebackup_storage_snapshot_des_label"),
                },
                okCb = function(callback) {
                    var isLoacl = $("#localBackup").widget().options.checked,
                        requestParam = {
                            "executeProtectLocation_0": isLoacl,
                            "executeProtectLocation_4": !isLoacl
                        };
                    var schedule;
                    if (isLoacl) {
                        schedule = _.filter(schedules, function(item){
                            return item.protectLocation == 0
                        })[0];
                    } else {
                        schedule = _.filter(schedules, function(item){
                            return item.protectLocation == 4
                        })[0];
                    };
                    if(_.isEmpty(schedule)){
                        callback();
                        return;
                    };
                    Rest.excuteBackupAction([data.protectGroupId, schedule.scheduleId], {
                        data: requestParam,
                        success: function(){
                            message.success({
                                content: appUtils.getString("common_term_command_send_success_label"),
                                ok: function() {
                                    callback();
                                }
                            });
                        }
                    });
                };
            //查询scheudle
            var schedules = [];
            Rest.queryPgSchedules([data.protectGroupId], function(result) {
                if (_.isEmpty(result)) {
                    return;
                };
                schedules = angular.copy(result);
            });
            $scope.execute = {
                description: labels.description,
                backup: {
                    local: {
                        id: "localBackup",
                        name: "backupRadio",
                        text: appUtils.getString("protection_exebackup_storage_snapshot_des_localBackup_label"),
                        value: "0",
                        checked: true,
                        description: appUtils.getString("protection_exebackup_storage_snapshot_des_localBackup_des_label")
                    },
                    remote: {
                        id: "remoteBackup",
                        name: "backupRadio",
                        text: appUtils.getString("protection_exebackup_storage_snapshot_des_remoteBackup_label"),
                        value: "1",
                        checked: false,
                        description: appUtils.getString("protection_exebackup_storage_snapshot_des_remoteBackup_des_label")
                    }
                }
            };

            winObj.options.changeOkHandler(okCb)
        }
    ];

    var module = angular.module("recoverydirector.protection.config");
    module.tinyController("protectGroup.execute.backup.san.snapshot.ctrl", ctrl);
    return module;
});
