define([], function() {
    "use strict";
    var ctrl = [
        "$scope",
        "$state",
        "$stateParams",
        "exception",
        "message",
        "communicationService",
        "utilService",
        "mask",
        "constsService", "appUtils", "cookieService",
        function($scope, $state, $stateParams, exception, message,
            communicationService, utilService, mask, constsService, appUtils, cookieService) {
            var winObj = $("#" + constsService.PROTECTGROUP_EXECUTE_19_WIN.winId).widget(),
                data = winObj.option("data"),
                labels = {
                    description: appUtils.getString("protection_oracle_task_manualExecute_des_label"),
                },
                okCb = function(callback) {
                    var siteComBoxModel = $scope.execute.site,
                        siteComBoxDom = $("#" + siteComBoxModel.id).widget(),
                        selectId = siteComBoxDom.getSelectedId(),
                        label = siteComBoxDom.getSelectedLabel(),
                        boxVals = siteComBoxDom.option("values"),
                        requestParam = {},
                        url = "/protectgroups/{protectGroupId}/action/executeProtectGroup";

                    if (angular.isUndefined(selectId) || -1 === +selectId) {
                        message.error(appUtils.getString("common_term_pleaseSelect_listbox_validate",appUtils.getString("protection_oracle_task_manualExecute_para_executeSite_label")));
                        return;
                    }

                    _.each(boxVals, function(box) {
                        if (box.selectId == -1) {
                            return;
                        }
                        requestParam["executeProtectLocation_" + box.selectId] = box.selectId == selectId;
                    })


                    url = appUtils.fillUrl(url, {
                        protectGroupId: data.protectGroupId
                    });
                    mask.show();
                    communicationService.put(url, requestParam).promise().always(function(response) {
                        mask.hide();
                        if (!exception.check(response)) {
                            return;
                        }

                        message.success({
                            content: appUtils.getString("common_term_operation_success_label"),
                            ok: function() {
                                callback();
                            }
                        });
                    });
                };
            $scope.execute = {
                description: labels.description,
                site: {
                    id: "site",
                    label: appUtils.getStringWithColon("protection_oracle_task_manualExecute_para_executeSite_label"),
                    width: constsService.W3,
                    values: [appUtils.getDefaultOption()],
                    itemKey: {
                        key: "protectLocation",
                        value: "detail.recoverySiteName"
                    },
                    url: "/protectgroups/" + data.protectGroupId + "/protectLocations"
                }
            };

            appUtils.fillBox($scope.execute.site);

            winObj.options.changeOkHandler(okCb)
        }
    ];

    var module = angular.module("recoverydirector.protection.config");
    module.tinyController("protectGroup.execute.pt.san.snapshot.ctrl", ctrl);
    return module;
});
