define(["lazy-load/lazyLoad", "ui-router/angular-ui-router.min", "tiny-extra-directives/FloatingPanel", "tiny-extra-directives/DualSelectBox"],
    function(lazyLoadModule, router) {
        "use strict";
        var routerConfig = [{
            name: "dataUse",
            url: "/dataUse",
            breadcrumbs: {name: "menus_dataused_title"},
            templateUrl: "app/business/recoverydirector/recovery/views/main.html"
        }, {
            name: "dataUse.dataRecovery",
            url: "/dataRecovery",
            breadcrumbs: [{name: "menus_recovery_datarecovery_label"}],
            templateUrl: "app/business/recoverydirector/recovery/views/dataRecovery.html",
            controller: "recovery.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/recovery/controllers/recoveryCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "dataUse.dataMount",
            url: "/dataMount",
            breadcrumbs: [{name: "menus_recovery_datamount_label"}],
            templateUrl: "app/business/recoverydirector/recovery/views/dataMount.html",
            controller: "mount.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/recovery/controllers/dataMountCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "dataUse.createRecoveryPlan",
            url: "/createRecoveryPlan",
            breadcrumbs: [{name: "menus_create_recovery_title"}],
            templateUrl: "app/business/recoverydirector/recovery/views/operate/createRecovery.html",
            controller: "dataUse.createRecoveryPlan.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/recovery/controllers/operate/createRecoveryCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "dataUse.createDataMountPlan",
            url: "/createDataMountPlan",
            breadcrumbs: [{name: "recovery_create_datamount_label"}],
            templateUrl: "app/business/recoverydirector/recovery/views/operate/createDataMount.html",
            controller: "dataUse.createDataMount.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/recovery/controllers/operate/createDataMountCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "dataUse.dataRecovery.abstract",
            url: "/abstract",
            templateUrl: "app/business/recoverydirector/recovery/views/abstract/abstractInfo.html",
            controller: "recovery.abstract.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/recovery/controllers/abstract/abstractCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "dataUse.dataMount.abstract",
            url: "/abstract",
            templateUrl: "app/business/recoverydirector/recovery/views/abstract/abstractInfo.html",
            controller: "recovery.abstract.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/recovery/controllers/abstract/abstractCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "dataUse.dataRecovery.protected",
            url: "/protected",
            templateUrl: "app/business/recoverydirector/recovery/views/protected/protectedList.html",
            controller: "recovery.protected.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/recovery/controllers/protected/protectedCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "dataUse.dataMount.protected",
            url: "/protected",
            templateUrl: "app/business/recoverydirector/recovery/views/protected/protectedList.html",
            controller: "recovery.protected.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/recovery/controllers/protected/protectedCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "dataUse.dataRecovery.procedure",
            url: "/procedure",
            templateUrl: "app/business/recoverydirector/recovery/views/procedure/procedureList.html",
            controller: "recovery.procedure.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/recovery/controllers/procedure/procedureCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "dataUse.dataMount.procedure",
            url: "/procedure",
            templateUrl: "app/business/recoverydirector/recovery/views/procedure/procedureList.html",
            controller: "recovery.procedure.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/recovery/controllers/procedure/procedureCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "dataUse.dataRecovery.history",
            url: "/history",
            templateUrl: "app/business/recoverydirector/recovery/views/history/historyList.html",
            controller: "recovery.history.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/recovery/controllers/history/historyCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "dataUse.dataMount.history",
            url: "/history",
            templateUrl: "app/business/recoverydirector/recovery/views/history/historyList.html",
            controller: "recovery.history.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/recovery/controllers/history/historyCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }]

        var module = angular.module("recoverydirector.recovery.config", ["ui.router"]);
        module = lazyLoadModule.makeLazy(module);
        module.tinyStateConfig({ stateConfig: routerConfig });
        return module;

    });