define([], function() {
    "use strict";
    var ctrl = ["$scope", "$state", "restService", "constsService", "appUtils", "statusEnumService", function($scope, $state, restService, constsService, appUtils, statusEnumService) {

        //基本信息
        var _iterateInitBasicInfo = function(plan) {
            var createTimeKey = appUtils.getStringWithColon("recovery.term.test.replica.colum.replicaTime");
            if (_.isUndefined(_.findWhere($scope.basicInfos, {key: createTimeKey}))) {
                $scope.basicInfos.push({key: createTimeKey, value: plan.globalSettings.timeStamp})
            } else {
                _.find($scope.basicInfos, function(obj) {
                    if (obj.key == createTimeKey) {
                        if (!_.isUndefined(plan.globalSettings)) {
                            obj.value = plan.globalSettings.timeStamp;
                            obj.loading = null;
                        }
                    }
                    return obj.key == createTimeKey;
                });
            };

            var replicaIdKey = appUtils.getStringWithColon("dataMount_abstract_replicaid_lable");
            if (_.isUndefined(_.findWhere($scope.basicInfos, {key: replicaIdKey}))) {
                $scope.basicInfos.push({key: replicaIdKey, value:  plan.globalSettings.ReplicaId})
            } else {
                _.find($scope.basicInfos, function(obj) {
                    if (obj.key == replicaIdKey) {
                        if (!_.isUndefined(plan.globalSettings)) {
                            obj.value = plan.globalSettings.ReplicaId;
                            obj.loading = null;
                        }
                    }
                    return obj.key == replicaIdKey;
                });
            };

            var replicaTypeKey = appUtils.getStringWithColon("dataMount_abstract_replicatype_lable");
            if (_.isUndefined(_.findWhere($scope.basicInfos, {key: replicaTypeKey}))) {
                $scope.basicInfos.push({key: replicaTypeKey, value: statusEnumService.getStatus("REPLICA_TYPE", plan.globalSettings.ReplicaType)})
            } else {
                _.find($scope.basicInfos, function(obj) {
                    if (obj.key == replicaTypeKey) {
                        if (!_.isUndefined(plan.globalSettings)) {
                            obj.loading = null;
                            obj.value = statusEnumService.getStatus("REPLICA_TYPE", plan.globalSettings.ReplicaType);
                        }
                    }
                    return obj.key == replicaTypeKey;
                });
            };

            var mountSiteKey = appUtils.getStringWithColon("dataMount_list_mountsite_lable");
            if (_.isUndefined(_.findWhere($scope.basicInfos, {key: mountSiteKey}))) {
                $scope.basicInfos.push({key: mountSiteKey, value: plan.globalSettings.SiteName})
            } else {
                _.find($scope.basicInfos, function(obj) {
                    if (obj.key == mountSiteKey) {
                        if (!_.isUndefined(plan.globalSettings)) {
                            obj.value = plan.globalSettings.SiteName;
                            obj.loading = null;
                        }
                    }
                    return obj.key == mountSiteKey;
                });
            };

            var mountHostKey = appUtils.getStringWithColon("protection_object_column_hosts_label");
            if (_.isUndefined(_.findWhere($scope.basicInfos, {key: mountHostKey}))) {
                $scope.basicInfos.push({key: mountHostKey, value:  plan.globalSettings.MountHostName})
            } else {
                _.find($scope.basicInfos, function(obj) {
                    if (!_.isUndefined(plan.globalSettings)) {
                        if (obj.key == mountHostKey) {
                            obj.value = plan.globalSettings.MountHostName;
                            obj.loading = null;
                        }
                    }
                    return obj.key == mountHostKey;
                });
            };

            var mountMoumentKey = appUtils.getStringWithColon("dataMount_create_mountmoument_lable");
            if (_.isUndefined(_.findWhere($scope.basicInfos, {key: mountMoumentKey}))) {
                $scope.basicInfos.push({key: mountMoumentKey, value: plan.globalSettings.StartTime})
            } else {
                _.find($scope.basicInfos, function(obj) {
                    if (obj.key == mountMoumentKey) {
                        if (!_.isUndefined(plan.globalSettings)) {
                            obj.value = plan.globalSettings.StartTime;
                            obj.loading = null;
                        }
                    }
                    return obj.key == mountMoumentKey;
                });
            };

            var unmountPreviousKey = appUtils.getStringWithColon("protection_unmount_previous_copy_label");
            var unmountPreviousDisplay = "dataUse.dataMount.abstract" == $state.current.name && plan.globalSettings.isCloudSite != "true";
            if (_.isUndefined(_.findWhere($scope.basicInfos, {key: unmountPreviousKey}))) {
                var unmountPreviousValue = "--";
                if (!_.isUndefined(plan.globalSettings.UmountPreReplica)) {
                    unmountPreviousValue = _.isUndefined(plan.globalSettings)? "--" : plan.globalSettings.UmountPreReplica == "true" ? appUtils.getString("common_term_enabled_label"): appUtils.getString("common_term_disabled_label")
                }
                $scope.basicInfos.push({key: unmountPreviousKey, value: unmountPreviousValue, display: unmountPreviousDisplay})
            } else {
                _.find($scope.basicInfos, function(obj) {
                    if (obj.key == unmountPreviousKey) {
                        if (!_.isUndefined(plan.globalSettings)) {
                            if (_.isUndefined(plan.globalSettings.UmountPreReplica)) {
                                obj.value = "--"
                            } else {
                                obj.value = plan.globalSettings.UmountPreReplica == "true" ? appUtils.getString("common_term_enabled_label"): appUtils.getString("common_term_disabled_label");
                            }
                            obj.display = unmountPreviousDisplay;
                            obj.loading = null;
                        }
                    }
                    return obj.key == unmountPreviousKey;
                });
            };

            var deleteReplicaKey = appUtils.getStringWithColon("protection_delete_copy_postvious_unmount_label");
            var deleteReplicaDisplay = "dataUse.dataMount.abstract" == $state.current.name && plan.globalSettings.ReplicaType != 101 && plan.globalSettings.isCloudSite != "true";
            if (_.isUndefined(_.findWhere($scope.basicInfos, {key: deleteReplicaKey}))) {
                var deleteReplicaValue = "--";
                if (!_.isUndefined(plan.globalSettings.DeleteReplica)) {
                    deleteReplicaValue = plan.globalSettings.DeleteReplica == "true"? appUtils.getString("common_term_enabled_label"): appUtils.getString("common_term_disabled_label")
                }
                $scope.basicInfos.push({key: deleteReplicaKey, value: deleteReplicaValue, display: deleteReplicaDisplay})
            } else {
                _.find($scope.basicInfos, function(obj) {
                    if (obj.key == deleteReplicaKey) {
                        if (!_.isUndefined(plan.globalSettings)) {
                            if (_.isUndefined(plan.globalSettings.DeleteReplica)) {
                                obj.value = "--"
                            } else {
                                obj.value = plan.globalSettings.DeleteReplica == "true" ? appUtils.getString("common_term_enabled_label"): appUtils.getString("common_term_disabled_label");
                            }
                            obj.display = deleteReplicaDisplay;
                            obj.loading = null;
                        }
                    }
                    return obj.key == deleteReplicaKey;
                });
            };

            var startupDBKey = plan.poType == 10 ? appUtils.getStringWithColon("protection_VR_task_start_title_label") : appUtils.getStringWithColon("dataMount_abstract_startdatabase_label");
            var startupDBDisplay = "dataUse.dataMount.abstract" == $state.current.name && plan.globalSettings.isCloudSite != "true" && plan.poType != 11;
            if (_.isUndefined(_.findWhere($scope.basicInfos, {key: appUtils.getStringWithColon("protection_VR_task_start_title_label")})) && _.isUndefined(_.findWhere($scope.basicInfos, {key: appUtils.getStringWithColon("dataMount_abstract_startdatabase_label")}))) {
                var startupDBValue = "--";
                if (!_.isUndefined(plan.globalSettings.StartDB)) {
                    startupDBValue = plan.globalSettings.StartDB == "true" ? appUtils.getString("common_term_enabled_label"): appUtils.getString("common_term_disabled_label")
                }
                $scope.basicInfos.push({key: startupDBKey, value: startupDBValue, display: startupDBDisplay})
            } else {
                _.find($scope.basicInfos, function(obj) {
                    if (obj.key == appUtils.getStringWithColon("protection_VR_task_start_title_label") || obj.key == appUtils.getStringWithColon("dataMount_abstract_startdatabase_label")) {
                        if (!_.isUndefined(plan.globalSettings)) {
                            if (_.isUndefined(plan.globalSettings.StartDB)) {
                                obj.value = "--"
                            } else {
                                obj.value = plan.globalSettings.StartDB == "true" ? appUtils.getString("common_term_enabled_label"): appUtils.getString("common_term_disabled_label");
                            }
                            obj.key = startupDBKey;
                            obj.display = startupDBDisplay;
                            obj.loading = null;
                        }
                    }
                    return obj.key == startupDBKey;
                });
            };
        }

        var _queryPlanDetails = function(plan, _mask) {
            $scope.EXCUTE_SUCCEED_LABEL = appUtils.getString("recovery.term.abstact.success.label");
            $scope.EXCUTE_FAIL_LABEL = appUtils.getString("recovery.term.abstact.fail.label");
            $scope.basicInfoTitle = appUtils.getString("recovery.term.abstact.basicInfoLabel");
            $scope.statisticsTitle = appUtils.getString("recovery.term.abstact.statisticsLabel");
            $scope.recoveryAbstractInfoMask = _mask;
            $scope.$apply();
            restService.getRecoveryAbstractInfo(plan.uuid, {
                mask: false,
                success: function(result) {
                    var planNameKey = appUtils.getStringWithColon("recovery.term.abstact.planNameLabel");
                    _.find($scope.basicInfos, function(obj) {
                        if (obj.key == planNameKey) {
                            obj.value = result.planName;
                            obj.title = result.planName;
                            obj.loading = null;
                        }
                        return obj.key == planNameKey;
                    });

                    var descKey = appUtils.getStringWithColon("recovery.term.abstact.descriptionLabel");
                    _.find($scope.basicInfos, function(obj) {
                        if (obj.key == descKey) {
                            obj.value = result.planDesc;
                            obj.title = result.planDesc;
                            obj.loading = null;
                            try {
                                //挂载计划的描述
                                if ("dataUse.dataMount.abstract" == $state.current.name) {
                                    obj.value = plan.globalSettings.Description;
                                    obj.title = plan.globalSettings.Description;
                                };
                            } catch (err) {}
                        }
                        return obj.key == descKey;
                    });

                    var pgNameKey = appUtils.getStringWithColon("recovery_protected_plan_label");
                    _.find($scope.basicInfos, function(obj) {
                        if (obj.key == pgNameKey) {
                            obj.value = result.protectGroupName;
                            obj.title = result.protectGroupName;
                            obj.loading = null;
                        }
                        return obj.key == pgNameKey;
                    });
                    _iterateInitBasicInfo(plan);

                    //执行统计
                    $scope.excuteInfos = [{
                        "key": appUtils.getStringWithColon("recovery.term.abstact.lastExecuteDateLabel"),
                        "value": result.lastExecuteDate
                    }, {
                        "key": appUtils.getStringWithColon("recovery.term.abstact.lastExecuteTimeLabel"),
                        "value": result.lastExecuteTime != "--" ? appUtils.convertMilliSecondToTime(result.lastExecuteTime) : "--"
                    }, {
                        "key": appUtils.getStringWithColon("recovery.term.abstact.lastExecuteResultLabel"),
                        "value": appUtils.getString("recovery.term.abstact.excute.result." + constsService.RECOVERY_PLAN_EXECUTE_RESULT[result.lastExecuteResult])
                    }, {
                        "key": appUtils.getStringWithColon("recovery.term.abstact.lastExecuteTypeLabel"),
                        "value": appUtils.getString("recovery.term.abstact.excute.type." + constsService.RECOVERY_PLAN_EXECUTE_TYPE[result.lastExecuteType])
                    }, {
                        "key": appUtils.getStringWithColon("recovery.term.abstact.lastExecuteUserLabel"),
                        "value": result.lastExecuteUser
                    }]

                    var charDatas = [];
                    $("#testStatusChart").empty();
                    var success = result.testSuccessCount;
                    var failed = result.testFailureCount;
                    if (success <= 0 && failed <= 0) {
                        $("#legendContainer").addClass("hide");
                        charDatas.push({
                            value: 100,
                            name: appUtils.getString("recovery.term.abstact.test.nodata.label"),
                            color: constsService.COLOR_THIN_GREY,
                            tooltip: appUtils.getString("recovery.term.abstact.test.nodata.label")
                        });
                    } else {
                        $("#legendContainer").removeClass("hide");
                        charDatas.push({
                            value: success * 100 / (success + failed),
                            name: appUtils.getString("recovery.term.abstact.success.label"),
                            color: constsService.COLOR_GREEN,
                            tooltip: appUtils.getString("recovery.term.abstact.success.label") + ":" + success
                        });
                        charDatas.push({
                            value: failed * 100 / (success + failed),
                            name: appUtils.getString("recovery.term.abstact.fail.label"),
                            color: constsService.COLOR_RED,
                            tooltip: appUtils.getString("recovery.term.abstact.fail.label") + ":" + failed
                        });
                    }
                    if (!$("#testStatusChart").html()) {
                        var options = {
                            id: "testStatusChart",
                            r: 65,
                            height: 200,
                            width: 300,
                            strokeWidth: 12,
                            showLegend: false,
                            showClickEvent: true,
                            "data": charDatas
                        };
                        var testStatusChart = new tinyWidget.Cirquechart(options);
                        $("#succeed").eq(0).text(success);
                        $("#failed").eq(0).text(failed);
                    }
                    $scope.$apply();
                },
                callback: function() {
                    $scope.recoveryAbstractInfoMask = false;
                    $scope.$apply();
                }
            })
        };

        var _basicInfos = [{
                key: appUtils.getStringWithColon("recovery.term.abstact.planNameLabel"),
                loading: "iconbutton-loading",
                value: "--",
                display: true
            },
            {
                key: appUtils.getStringWithColon("recovery.term.abstact.descriptionLabel"),
                loading: "iconbutton-loading",
                value: "--",
                display: true
            },
            {
                key: appUtils.getStringWithColon("recovery_protected_plan_label"),
                loading: "iconbutton-loading",
                value: "--",
                display: true
            },
            {
                key: appUtils.getStringWithColon("recovery.term.test.replica.colum.replicaTime"),
                loading: "iconbutton-loading",
                value: "--",
                display: "dataUse.dataMount.abstract" == $state.current.name
            },
            {
                key: appUtils.getStringWithColon("dataMount_abstract_replicaid_lable"),
                loading: "iconbutton-loading",
                value: "--",
                display: "dataUse.dataMount.abstract" == $state.current.name
            },
            {
                key: appUtils.getStringWithColon("dataMount_abstract_replicatype_lable"),
                loading: "iconbutton-loading",
                value: "--",
                display: "dataUse.dataMount.abstract" == $state.current.name
            },
            {
                key: appUtils.getStringWithColon("dataMount_list_mountsite_lable"),
                loading: "iconbutton-loading",
                value: "--",
                display: "dataUse.dataMount.abstract" == $state.current.name
            },
            {
                key: appUtils.getStringWithColon("protection_object_column_hosts_label"),
                loading: "iconbutton-loading",
                value: "--",
                display: "dataUse.dataMount.abstract" == $state.current.name
            },
            {
                key: appUtils.getStringWithColon("dataMount_create_mountmoument_lable"),
                loading: "iconbutton-loading",
                value: "--",
                display: "dataUse.dataMount.abstract" == $state.current.name
            },
            {
                key: appUtils.getStringWithColon("protection_unmount_previous_copy_label"),
                loading: "iconbutton-loading",
                value: "--",
                display: "dataUse.dataMount.abstract" == $state.current.name
            },
            {
                key: appUtils.getStringWithColon("dataMount_abstract_startdatabase_label"),
                loading: "iconbutton-loading",
                value: "--",
                display: "dataUse.dataMount.abstract" == $state.current.name
            },
            {
                key: appUtils.getStringWithColon("protection_delete_copy_postvious_unmount_label"),
                loading: "iconbutton-loading",
                value: "--",
                display: "dataUse.dataMount.abstract" == $state.current.name
            }
        ];

        $scope.$on(constsService.RECOVERY_TAB, function(ev, plan) {
            _queryPlanDetails(plan, plan._mask);
        });

        $scope.$on(constsService.RECOVERY_BASIC_INFO_EVENT, function(ev, plan) {
            _iterateInitBasicInfo(plan);
        });

        $scope.basicInfos = _basicInfos;

        var checkPlan = $("#recoveryTable").widget().getTableCheckedItems();
        !_.isEmpty(checkPlan) && _queryPlanDetails(_.first(checkPlan), true);
    }];

    var module = angular.module('recoverydirector.recovery.config');
    module.tinyController('recovery.abstract.ctrl', ctrl);
    return module;

});