define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrl = ["$scope", "$state", "$compile", "$timeout", "appUtils", "constsService", "restService", "statusEnumService", "message", "model", "utilService" , "communicationService", function($scope, $state, $compile, $timeout, appUtils, constsService, restService, statusEnumService, message, Model, utilService, communicationService) {
        var _startPage = 0,
            _pageSize = 10,
            _orderBy,
            _orderType,
            _name,
            _appType,
            _planStatus,
            _productSiteId,
            _protectGroupId,
            _createStartTime,
            _createEndTime,
            _replicaId,
            _mountSiteId,
            _mountHostId;
        var _autoPromise;
        var mountPlanUuid;
        var ngdom = $("<div></div>");
        var pleaseSelectVal = [{
            "selectId": "-1",
            "label": appUtils.getString("common_term_pleaseSelect_listbox")
        }];
        //查询本地服务器信息,查询站点需要
        restService.queryLocalServer([], {
            mask: false,
            isShowMsgBox: false,
            success: function(data) {
                if (data) {
                    $scope.serverUuid = data.uuid;
                    _initTable()
                };
            }
        });
        //清空条件
        var resetConditions = function(){
            _name = "";
            _appType = ""
            _planStatus = "";
            _productSiteId = "";
            _protectGroupId = "";
            _createStartTime = "";
            _createEndTime = "";
            _replicaId  = "";
            _mountSiteId = "";
            _mountHostId = "";
        };
        //操作按钮
        var operationBtn = [{
            id: "mountBtn",
            authKey: "ism.drm.drp.auth.disaster.mountplan.mount",
            template: "<div class='iconbutton-mount' title='" + appUtils.getString("protection_object_action_mount_label") + "'></div>",
            clickActive: function() {
                if (!$("#mountBtn div").hasClass("iconbutton-mount")) {
                    return;
                };
                var hoverData = _.first($("#recoveryTable").widget().getHoverData());
                var poType = hoverData["protectGroups"][0].poType;
                restService.excuteMountAction([hoverData.uuid], {
                    success: function(result) {
                        message.success({
                            content: appUtils.getString("common_term_command_send_success_label"),
                            ok: function() {
                                $state.go("dataUse.dataMount.procedure");
                                _initTable();
                            }
                        });
                    }
                });
            }
        }, {
            id: "unMountBtn",
            authKey: "ism.drm.drp.auth.disaster.mountplan.unmount",
            template: "<div class='iconbutton-unmount' title='" + appUtils.getString("protection_object_action_umount_label") + "'></div>",
            clickActive: function() {
                if (!$("#unMountBtn div").hasClass("iconbutton-unmount")) {
                    return;
                };
                var hoverData = _.first($("#recoveryTable").widget().getHoverData());
                var poType = hoverData["protectGroups"][0].poType;
                var _MountHost = hoverData.globalSettings.MountHostName;
                var msg = hoverData.mountStatus == 2 ? appUtils.getString("protection_object_no_host_umount_warn_label") : poType == 10 ? appUtils.getString("protection_object_umount_cluster_warn_label", _MountHost) : appUtils.getString("protection_object_umount_warn_label", _MountHost);
                if(_.contains([1,2,3,8,15,16], parseInt(poType))){
                    msg = hoverData.mountStatus == 2 ? appUtils.getString("protection_object_no_host_database_umount_warn_label") : appUtils.getString("protection_object_database_umount_warn_label", _MountHost);
                };
                var win = angular.copy(constsService.SAN_UNMOUNT_REPLICA_WIN);
                var isCloudBackup = hoverData.globalSettings.ReplicaType == 101;
                //云副本单独的弹窗，避免页面有闪现
                if (isCloudBackup) {
                    hoverData.globalSettings.isCloudSite == "true" ? msg = appUtils.getString("protection_object_umount_cloudserver_warn_label", _MountHost) : ""
                    message.tipPrompt({
                        content: msg,
                        width: "400",
                        title: appUtils.getString("protection_object_unmount_win_label"),
                        ok: function() {
                            var isDelete = "";
                            restService.excuteUnmountAction([hoverData.uuid, isDelete], {
                                success: function(result) {
                                    message.prompt({
                                        content: appUtils.getString("common_term_command_send_success_label"),
                                        ok: function() {
                                            $state.go("dataUse.dataMount.procedure");
                                            _initTable();
                                        }
                                    });
                                }
                            })
                        }
                    });
                    return;
                };
                win.data = {
                    warnMsg: msg,
                    isCloudBackup: isCloudBackup
                };
                win.title = appUtils.getString("protection_object_unmount_win_label");
                if (appUtils.isEn()) {
                    win.height = 250;
                };
                appUtils.showWindow(win, function() {
                    var isDelete = isCloudBackup ? "" : $("#enableDelDuplicaCheck").widget().option("checked");
                    restService.excuteUnmountAction([hoverData.uuid, isDelete], {
                        success: function(result) {
                            message.prompt({
                                content: appUtils.getString("common_term_command_send_success_label"),
                                ok: function() {
                                    $("#" + constsService.SAN_UNMOUNT_REPLICA_WIN.winId).widget().destroy();
                                    $state.go("dataUse.dataMount.procedure");
                                    _initTable();
                                }
                            });
                        }
                    })
                });
            }
        }, {
            id: "iconBtnEdit",
            authKey: "ism.drm.drp.auth.modify",
            template: "<div class='iconbutton-edit' title='" + appUtils.getString("common_term_edit_button") + "'></div>",
            clickActive: function() {
                if (!$("#iconBtnEdit div").hasClass("iconbutton-edit")) {
                    return;
                };
                var hoverData = _.first($("#recoveryTable").widget().getHoverData());
                _.extend(hoverData, {
                    isModifyMountPlan: true
                });
                var win = angular.copy(constsService.EDIT_RECOVERY);
                _.extend(win, {
                    "title": appUtils.getString("recoveryPlan_modify_operateName"),
                    "data": hoverData,
                    "modal": true,
                    "content-type": "url",
                    "draggable": true,
                    "content": win.url,
                    "minimizable": false,
                    "maximizable": false
                });
                appUtils.showWindow(win, function() {
                    var param = {
                        name: $.trim($("#planName").widget().getValue()),
                        description: $.trim($("#description").widget().getValue()),
                        startTime: $("#mountTimeSelect").widget().getSelectedId() == "1" ? "" : $("#excuteDate").widget().getDateTime()
                    };
                    //指定时间执行而未选择时间需要校验提示
                    if ($("#mountTimeSelect").widget().getSelectedId() != "1" && _.isEmpty($("#excuteDate").widget().getDateTime())) {
                        message.error(appUtils.getString("validate_select_value_label", "dataMount_create_mountmoument_lable"));
                        return;
                    };
                    restService.modifyMountPlanPolicy([hoverData.uuid], {
                        data: param,
                        success: function(result) {
                            message.success({
                                content: appUtils.getString("common_term_operation_success_label"),
                                ok: function() {
                                    $("#" + constsService.EDIT_RECOVERY.winId).widget().destroy();
                                    _initTable();
                                }
                            })
                        }
                    });
                });
            }
        }, {
            id: "iconBtnDel",
            authKey: "ism.drm.drp.auth.delete",
            template: "<div class='iconbutton-delete' title='" + appUtils.getString("common_term_delete_button") + "'></div>",
            clickActive: function() {
                if (!$("#iconBtnDel div").hasClass("iconbutton-delete")) {
                    return;
                };
                var hoverData = _.first($("#recoveryTable").widget().getHoverData());
                message.warn({
                    content: appUtils.getString("dataMount_delete_tip_lable"),
                    ok: function() {
                        restService.deleteRecovery([hoverData.uuid], function(result) {
                            message.success({
                                content: appUtils.getString("common_term_operation_success_label"),
                                ok: function() {
                                    _startPage = 0;
                                    _initTable();
                                    $scope.dataMountScope.table.currPage = {
                                        "pageIndex": 1
                                    };
                                }
                            })
                        })
                    }
                })
            }
        }];
        //初始化表格
        var _initTable = function(autoRefresh) {
            var params = {
                startPage: _startPage,
                pageSize: _pageSize,
                orderBy: _orderBy,
                orderType: _orderType,
                planType: 1,
                "Rp.appType": _appType,
                "Rp.name": _name,
                "Rp.planStatus": _planStatus,
                "Rp.productSiteId": _productSiteId,
                "Rp.protectGroupId": _protectGroupId,
                "Rp.createStartTime": _createStartTime,
                "Rp.createEndTime": _createEndTime,
                "Rp.replicaId": _replicaId,
                "Rp.mountSiteId": _mountSiteId,
                "Rp.mountHostId": _mountHostId
            };
            _.each(params, function(value, key) {
                (_.isEmpty($.trim(value)) || _.isUndefined(value) || "-1" == value) && (delete params[key]);
            });
            var _mask = autoRefresh || _.isUndefined(autoRefresh);
            restService.getRecoveryListData(params, {
                mask: _mask,
                success: function(result) {
                    var arr = [];
                    _.each(result.records, function(obj) {
                        var protectGroups = !_.isEmpty(obj.protectGroups) && _.isArray(obj.protectGroups) && _.first(obj.protectGroups);
                        obj.productSiteName = protectGroups.productSiteName;
                        obj.productSiteId = protectGroups.productSiteId;
                        obj.protectGroupName = protectGroups.name;
                        obj.protectUuid = protectGroups.uuid;
                        if (!_.isUndefined(protectGroups.template) && !_.isEmpty(protectGroups.template)) {
                            obj.templateUuid = protectGroups.template.uuid;
                            obj.templateType = protectGroups.template.type;
                            obj.templateSubType = protectGroups.template.subType;
                        }
                        obj.poType = protectGroups.poType;
                        obj.PROVIDER_TYPE = _.isNull(protectGroups.props.PROVIDER_TYPE) ? "" : protectGroups.props.PROVIDER_TYPE;
                        obj.protectType = _.isNull(protectGroups.props.protectType) ? "" : protectGroups.props.protectType;
                        obj.operate = "";
                        arr.push(obj);
                    });
                    $scope.dataMountScope.table.data = appUtils.encodeForHTML(arr);
                    $scope.dataMountScope.table.enablePagination = result["totalCount"] > 10;
                    $scope.dataMountScope.table.totalRecords = result["totalCount"];
                    //tab页显示
                    $scope.dataMountScope.tabBox = _.size(result["records"]) > 0;
                    $scope.$apply();

                    $timeout.cancel(_autoPromise);
                    _autoPromise = $timeout(function() {
                        _initTable(false);
                    }, 15 * 1E3);
                },
                fail: function(err) {
                    $scope.dataMountScope.table.data = [];
                    $scope.dataMountScope.table.enablePagination = false;
                    $scope.dataMountScope.table.totalRecords = 0;
                    _autoPromise && $timeout.cancel(_autoPromise);
                },
                callback: function() {
                    setTimeout(function() {
                        var tabsMaxHeight = $(window).height() - ( 240 + $("#recoveryTable").outerHeight());
                        $(".tiny-tabs-content").css("max-height", tabsMaxHeight);
                    }, 0);
                    if (!_.isEmpty($("#recoveryTable").widget()) && !_.isEmpty($("#recoveryTable").widget().getTableData())) {
                        var recoveryTableWidget = $("#recoveryTable").widget();
                        var tableData = recoveryTableWidget.getTableData();
                        var findCheckObj = _.findWhere(tableData, {
                            "uuid": mountPlanUuid
                        });
                        if (!_.isEmpty(mountPlanUuid) && !_.isEmpty(findCheckObj)) {
                        } else {
                            mountPlanUuid = tableData[0].uuid;
                        };
                        recoveryTableWidget.setSelectedRow("uuid", mountPlanUuid);
                        var checkNode = _.first(recoveryTableWidget.getTableCheckedItems());
                        $scope.recoveryObj = checkNode;
                        (_mask || _.isUndefined(findCheckObj)) && $scope.$broadcast(constsService.RECOVERY_TAB, _.extend(checkNode, {
                            planId: checkNode.uuid,
                            _mask: _mask
                        }));
                    }
                }
            });
        };
        $scope.ADVANCED_LABEL = appUtils.getString("common_term_adgsearch_button");
        $scope.advanceSearchPop = {
            "id": "advanceSearchPopId",
            "elementId": "advanceSearchPopEleId",
            "template": ngdom,
            "popStyle": {
                "width": !appUtils.isEn() ? '410px' : "435px",
                "height": !appUtils.isEn() ? '340px' : "350px"
            }
        };
        $scope.showAdvanceSearch = function() {
            ngdom.load("app/business/recoverydirector/recovery/views/operate/advanceSearch.html", function() {
                $compile($("#advanceSearchDiv"))($scope);
                $scope.$apply();
                $("#advanceSearchPopId").widget().setPopShow(true);
            });
        };
        //高级搜索$scope
        $scope.FROM = appUtils.getString("common_term_from_label");
        $scope.TO = appUtils.getString("common_term_to_label");
        $scope.advance = {
            labels: {
                cls: "alarmAdvance a_td_label",
                productSite: appUtils.getStringWithColon("recovery.term.recovery.sites.product"),
                pgPlan: appUtils.getStringWithColon("site_backuprespo_protectplan_label"),
                duplica: appUtils.getStringWithColon("ism.drm.protect.group.tab.duplica"),
                mountSite: appUtils.getStringWithColon("dataMount_list_mountsite_lable"),
                mountHost: appUtils.getStringWithColon("recovery_rollback_hostgroup_label"),
                occurredTime: appUtils.getStringWithColon("recovery.term.test.replica.colum.replicaTime"),
                mountHostType: appUtils.getStringWithColon("datamount_advance_host_type_lable"),
                vCenter:appUtils.getStringWithColon("common.term.vCenter.tab")
            },
            productSite: {
                id: "productSite",
                key: "productSiteId",
                width: constsService.W3,
                values: pleaseSelectVal,
                defaultSelectid: "-1",
                openFn: function(object){
                    var that = this;
                    restService.querySites([$scope.serverUuid], function(data) {
                        if (!_.isEmpty(data)) {
                            appUtils.updateSelectValues(that.id, data, "siteId", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                            object.open();
                        } else {
                            object.open();
                        };
                        appUtils.resetSelectValues($scope.advance.duplica.id);
                        $scope.advance.duplica.defaultSelectid = "-1";
                    });
                },
                getVal: function(){
                    return $("#" + this.id).widget().getSelectedId()
                }
            },
            pgPlan: {
                id: "pgPlan",
                key: "protectGroupId",
                width: constsService.W3,
                values: pleaseSelectVal,
                defaultSelectid: "-1",
                openFn: function(object){
                    var that = this;
                    restService.queryProtectGroups({
                        _PAGE: appUtils.queryFilter(0, 10000)
                    }, function(result) {
                        if (!_.isEmpty(result) && !_.isEmpty(result.records)) {
                            appUtils.updateSelectValues(that.id, result.records, "uuid", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                        } else {
                            object.open();
                        };
                        appUtils.resetSelectValues($scope.advance.duplica.id);
                        $scope.advance.duplica.defaultSelectid = "-1";
                    });
                },
                getVal: function(){
                    return $("#" + this.id).widget().getSelectedId()
                }
            },
            duplica: {
                id: "duplicaSelect",
                key: "replicaId",
                width: constsService.W3,
                values: pleaseSelectVal,
                defaultSelectid: "-1",
                openFn: function(object){
                    var that = this;
                    if("-1" == $scope.advance.pgPlan.getVal() || "-1" == $scope.advance.productSite.getVal()){
                        appUtils.resetSelectValues($scope.advance.duplica.id);
                        $scope.advance.duplica.defaultSelectid = "-1";
                        return;
                    };
                    var params = {
                        protectGroupId: $scope.advance.pgPlan.getVal(),
                        startPage: 1,
                        siteId: $scope.advance.productSite.getVal()
                    };
                    restService.queryPageSizeReplicas(params, {
                        success: function(result) {
                            if (!_.isEmpty(result) && !_.isEmpty(result.replicas)) {
                                appUtils.updateSelectValues(that.id, result.replicas, "id", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                            } else {
                                object.open();
                            };
                        }
                    });
                },
                getVal: function(){
                    return $("#" + this.id).widget().getSelectedId()
                }
            },
            mountSite: {
                id: "mountSite",
                key: "mountSiteId",
                width: constsService.W3,
                values: pleaseSelectVal,
                defaultSelectid: "-1",
                openFn: function(object){
                    var that = this;
                    restService.querySites([$scope.serverUuid], function(data) {
                        if (!_.isEmpty(data)) {
                            appUtils.updateSelectValues(that.id, data, "siteId", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                            object.open();
                        } else {
                            object.open();
                        };
                        appUtils.resetSelectValues($scope.advance.mountHost.id);
                        appUtils.resetSelectValues($scope.advance.vCenter.id);
                        $scope.advance.mountHost.defaultSelectid = "-1";
                        $scope.advance.vCenter.defaultSelectid = "-1";
                        $scope.advance.btnOK.disable = false;
                        $scope.advance.vCenter.display = false;
                        $scope.advance.mountHost.display = false;
                        $scope.$apply();

                    });
                },
                closeFn: function(){},
                change:function(){
                    $("#mountHostType").widget().option("values", [{
                        "selectId": "-1",
                        "label": appUtils.getString("common_term_all_label")
                    }]);
                    $scope.advance.mountHostType.defaultSelectid = "-1";
                    $scope.$apply();
                },
                getVal: function(){
                    return $("#" + this.id).widget().getSelectedId()
                }
            },
            mountHost: {
                id: "mountHost",
                key: "mountHostId",
                width: constsService.W3,
                values: pleaseSelectVal,
                defaultSelectid: "-1",
                display: false,
                openFn: function(object){
                    var that = this;
                    var selectSiteId = $scope.advance.mountSite.getVal();
                    if (selectSiteId == "-1") {
                        object.open();
                        return;
                    };
                    var mountHostType = $scope.advance.mountHostType.getVal();
                    if(mountHostType=="1") {
                        restService.queryHostBySite([selectSiteId, 0], function(data) {
                            if (!_.isEmpty(data)) {
                                var hosts = Model.util.formatHosts(data);
                                appUtils.updateSelectValues(that.id, hosts, "deviceSn", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                                object.open();
                            } else {
                                object.open();
                            }
                        })
                    }
                    if(mountHostType=="2") {
                        var selectVcenterId = $scope.advance.vCenter.getVal();
                        if (selectVcenterId == "-1") {
                            object.open();
                            return;
                        };
                        restService.getvCenterTestCluster([selectVcenterId], function(data) {
                            if (!_.isEmpty(data)) {
                                appUtils.updateSelectValues(that.id, data, "uuid", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                                object.open();
                            } else {
                                object.open();
                            };
                        });
                    }
                   if(mountHostType=="3") {
                        restService.queryCloudServer(selectSiteId, function(data) {
                            if (!_.isEmpty(data)) {
                                appUtils.updateSelectValues(that.id, data.records, "id", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                                object.open();
                            } else {
                                object.open();
                            }
                        });
                    }
                },
                closeFn: function(){
                    $scope.advance.mountHost.getVal() == "-1" ? ($scope.advance.btnOK.disable = true) : ($scope.advance.btnOK.disable = false);
                    $scope.$apply();
                },
                getVal: function(){
                    return $("#" + this.id).widget().getSelectedId()
                }
            },
            startDate: {
                id: "startDate",
                key: "createStartTime",
                type: "datetime",
                dateFormat: 'yy-mm-dd',
                timeFormat: "h:mm:ss",
                "ampm": true,
                getVal: function(){
                    return $("#" + this.id).widget().getDateTime()
                }
            },
            endDate: {
                id: "endDate",
                key: "createEndTime",
                type: "datetime",
                dateFormat: 'yy-mm-dd',
                timeFormat: "h:mm:ss",
                disable: false,
                "ampm": true,
                getVal: function(){
                    return $("#" + this.id).widget().getDateTime()
                }
            },
            mountHostType: {
                id: "mountHostType",
                values: [{
                    "selectId": "-1",
                    "label": appUtils.getString("common_term_all_label")
                }],
                defaultSelectid: "-1",
                openFn: function() {
                    $("#" + this.id).widget().option("values", [{
                        "selectId": "-1",
                        "label": appUtils.getString("common_term_all_label")
                    }, {
                        "selectId": "1",
                        "label": appUtils.getString("host_title")
                    }, {
                        "selectId": "2",
                        "label": appUtils.getString("common.term.vCenter.tab")
                    }, {
                        "selectId": "3",
                        "label": appUtils.getString("recovery_rollback_cloudserver_label")
                    }]);
                },
                closeFn: function(){
                    var mountHostType = !_.isNull($("#" + this.id).widget()) && $("#" + this.id).widget().getSelectedId();
                    if (mountHostType == "1") {
                        $scope.advance.labels.mountHost = appUtils.getStringWithColon("recovery_rollback_hostgroup_label");
                    }
                    if (mountHostType == "2") {
                        $scope.advance.labels.mountHost = appUtils.getStringWithColon("resource_mapping_cluster");
                    }
                    if (mountHostType == "3") {
                        $scope.advance.labels.mountHost = appUtils.getStringWithColon("recovery_rollback_cloudserver_label");
                    }
                    mountHostType=="2" ? ($scope.advance.vCenter.display = true) :($scope.advance.vCenter.display = false);
                    mountHostType=="-1" ? ($scope.advance.mountHost.display = false) :($scope.advance.mountHost.display = true);
                    mountHostType=="-1" ? ($scope.advance.btnOK.disable = false) :($scope.advance.btnOK.disable = true);
                    appUtils.resetSelectValues($scope.advance.mountHost.id);
                    appUtils.resetSelectValues($scope.advance.vCenter.id);
                    $scope.$apply();
                },
                width: constsService.W3,
                getVal: function(){
                    return $("#" + this.id).widget().getSelectedId()
                }
            },
            vCenter: {
                id: "vCenter",
                label: appUtils.getStringWithColon("common.term.vCenter.tab"),
                width: constsService.W3,
                display: false,
                values: [{
                    "selectId": "-1",
                    "label": appUtils.getString("common_term_pleaseSelect_listbox")
                }],
                defaultSelectid: "-1",
                openFn: function(object) {
                    var that = this;
                    var selectSiteId = $scope.advance.mountSite.getVal();
                    if (selectSiteId == "-1") {
                        object.open();
                        return;
                    };
                    restService.queryVCenterBySite([selectSiteId], function(data) {
                        if (!_.isEmpty(data)) {
                            appUtils.updateSelectValues(that.id, data, "vCenterUuid", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                            object.open();
                        } else {
                            object.open();
                        };
                    });
                    appUtils.resetSelectValues($scope.advance.mountHost.id);
                    $scope.advance.btnOK.disable = true
                    $scope.$apply();
                },
                change: function (){
                    appUtils.resetSelectValues($scope.advance.mountHost.id);
                    $scope.advance.btnOK.disable = true
                    $scope.$apply();
                },
                getVal: function(){
                    return $("#" + this.id).widget().getSelectedId()
                }
            },
            btnOK: {
                id: "btnOK",
                disable: false,
                text: appUtils.getString("common_term_search_button"),
                click: function () {
                    resetConditions();
                    _productSiteId = $scope.advance.productSite.getVal();
                    _protectGroupId = $scope.advance.pgPlan.getVal();
                    _replicaId = $scope.advance.duplica.getVal();
                    _mountSiteId = $scope.advance.mountSite.getVal();
                    _mountHostId = $scope.advance.mountHost.getVal();
                    _createStartTime = $scope.advance.startDate.getVal();
                    _createEndTime = $scope.advance.endDate.getVal();
                    _startPage = 0;
                    _initTable();
                    $scope.dataMountScope.table.currPage = {
                        "pageIndex": 1
                    };
                }
            }
        };
        $scope.dataMountScope = {
            "tabBox": false,
            create: {
                id: "createBtn",
                hasRight: appUtils.checkRight("ism.drm.drp.auth.add"),
                text: appUtils.getString("common_term_create_button"),
                click: function() {
                    $state.go("dataUse.createDataMountPlan");
                }
            },
            refresh: {
                title: appUtils.getString("common_term_refresh_button"),
                action: function() {
                    $("#dataMountSearch").widget().setSearchboxValue("");
                    _startPage = 0;
                    _orderBy = "";
                    _orderType = "";
                    resetConditions();
                    _initTable();
                    $scope.dataMountScope.table.currPage = {
                        "pageIndex": 1
                    };
                }
            },
            search: {
                "id": "dataMountSearch",
                "values": [{
                    selectId: "0",
                    label: appUtils.getString("common_term_name_label")
                }, {
                    selectId: "1",
                    label: appUtils.getString("common_term_status_label")
                }],
                "display": true,
                "disable": false,
                "showTip": true,
                "isSearchbox": true,
                "defaultSelectid": "0",
                "textWidth": constsService.W2,
                "width": constsService.W2,
                "textOptions": {
                    "id": "choiseStatus",
                    "values": [{
                        selectId: "-1",
                        label: appUtils.getString("common_term_all_label")
                    }, {
                        selectId: "0",
                        label: appUtils.getString("recovery.term.recovery.plan.status.READY")
                    }, {
                        selectId: "23",
                        label: appUtils.getString("mountPlan_status_mounting_replica")
                    }, {
                        selectId: "24",
                        label: appUtils.getString("mountPlan_status_umounting_replica")
                    }, {
                        selectId: "25",
                        label: appUtils.getString("mountPlan_status_mount_failed_replica")
                    }, {
                        selectId: "26",
                        label: appUtils.getString("mountPlan_status_mount_completed_replica")
                    }, {
                        selectId: "27",
                        label: appUtils.getString("mountPlan_status_unmount_completed_replica")
                    }, {
                        selectId: "28",
                        label: appUtils.getString("mountPlan_status_unmount_failed_replica")
                    }],
                    "display": true,
                    "default-selectid": "-1",
                },
                "change": function() {
                    var widget = $("#dataMountSearch").widget(),
                        searchId = widget.getSelectedId();
                    if (searchId == "1") {
                        this.isSearchbox = false;
                        widget.changeTextBox(false, this.textOptions);
                    } else {
                        this.isSearchbox = true;
                        widget.changeTextBox(true);
                    }
                },
                "click": function() {
                    _startPage = 0, $scope.dataMountScope.table.currPage = {
                        "pageIndex": 1
                    };
                    if (this.isSearchbox) {
                        resetConditions();
                        _name = $.encoder.encodeForURL($.trim($("#dataMountSearch").widget().getSearchboxValue().inputValue));
                    } else {
                        resetConditions();
                        _planStatus = $("#choiseStatus").widget().getSelectedId() == "-1" ? "" : $("#choiseStatus").widget().getSelectedId();
                    }
                    _initTable();
                    $scope.dataMountScope.table.currPage = {
                        "pageIndex": 1
                    };
                }
            },
            table: {
                "id": "recoveryTable",
                "paginationStyle": "full_numbers",
                "enablePagination": false,
                "totalRecords": 0,
                "displayLength": 10,
                "currPage": {
                    "pageIndex": 1
                },
                "operateButtonCount": 1,
                "buttonContainerPosition": window.tinyWidget.util.browser.firefox || window.tinyWidget.util.browser.mozilla ? "left": "right",
                "opAreaConfig": appUtils.flilterOperRight(operationBtn),
                "data": [],
                "columns": [{
                    "mData": "name",
                    "bSortable": true,
                    "sTitle": appUtils.getString("recovery.term.colum.name.title"),
                }, {
                    "mData": "planStatus",
                    "bSortable": true,
                    "sTitle": appUtils.getString("recovery.term.colum.status.title"),
                }, {
                    "mData": "planProgress",
                    "bSortable": false,
                    "sTitle": appUtils.getString("recovery.term.colum.process.title"),
                }, {
                    "mData": "",
                    "bSortable": false,
                    "sTitle": appUtils.getString("recovery.term.colum.productionSite.title"),
                }, {
                    "mData": "",
                    "bSortable": false,
                    "sTitle": appUtils.getString("recovery_protected_plan_label"),
                }, {
                    "mData": "",
                    "bSortable": false,
                    "sTitle": appUtils.getString("pg_create_datatype_label"),
                }, {
                    "mData": "timeStamp",
                    "bSortable": false,
                    "sTitle": appUtils.getString("recovery.term.test.replica.colum.replicaTime"),
                }, {
                    "mData": "siteName",
                    "bSortable": false,
                    "sTitle": appUtils.getString("dataMount_list_mountsite_lable"),
                }, {
                    "mData": "",
                    "bSortable": false,
                    "sTitle": appUtils.getString("protection_object_column_hosts_label"),
                }],
                "callback": function(evtObj) {
                    _startPage = evtObj.currentPage - 1;
                    _pageSize = evtObj.displayLength;
                    _initTable();
                },
                "sortCallback": function(nNode, sortArr) {
                    $scope.dataMountScope.table.currPage = {
                        "pageIndex": 1
                    };
                    _orderBy = $scope.dataMountScope.table.columns[_.first(_.first(sortArr))].mData;
                    _orderType = _.first(sortArr)[1];
                    _startPage = 0;
                    _initTable();
                },
                "cellClickActive": function(e, param) {
                    mountPlanUuid = param.uuid;
                    $scope.recoveryObj = param;
                    $scope.$broadcast(constsService.RECOVERY_TAB, _.extend(param, {
                        planId: param.uuid,
                        _mask: true
                    }));
                },
                drawCallback: function(oSetting) {
                    if (!_.size(oSetting.aoData)) return;
                    var twidget = $("#recoveryTable").widget(), uuids = [];
                    _.each(oSetting.aoData, function(aoData) {
                        twidget.update(aoData._aData.globalSettings.timeStamp ? aoData._aData.globalSettings.timeStamp : "--", aoData.nTr, 6, false);
                        twidget.update(aoData._aData.globalSettings.MountHostName ? aoData._aData.globalSettings.MountHostName : "--", aoData.nTr, 8, false);
                        twidget.update(aoData._aData.globalSettings.SiteName ? aoData._aData.globalSettings.SiteName:"--", aoData.nTr, 7, false);
                    });

                    $scope.$watch('dataMountScope.table.data', function(datas, oldValue, scope) {
                        var twidget = $("#recoveryTable").widget();
                        if (!_.size(twidget.getTableCheckedItems())) return;
                        var checkedItem = _.first(twidget.getTableCheckedItems());
                        var plan = _.find(datas, function(data, key, list) {
                            return data.uuid == checkedItem.uuid && (!_.isUndefined(data.replicaDetails) || !_.isUndefined(data.siteDetails));
                        });
                        !_.isUndefined(plan) && $scope.$broadcast(constsService.RECOVERY_BASIC_INFO_EVENT, plan);
                    }, true);
                    setTimeout(function() {
                        var tabsMaxHeight = $(window).height() - ( 210 + $("#bricks-table").outerHeight());
                        $(".tiny-tabs-content").css("max-height", tabsMaxHeight);
                    }, 0);
                },
                "hoverActive": function(e, param){
                    //未挂载、可以执行挂载
                    if (_.contains([0,27], parseInt(param.planStatus, 10))) {
                        $("#mountBtn div").removeClass("iconbutton-mount-disabled").addClass("iconbutton-mount");
                    } else {
                        $("#mountBtn div").removeClass("iconbutton-mount").addClass("iconbutton-mount-disabled");
                    };
                    //已挂载、卸载失败可卸载
                    if (_.contains([25,26,28], parseInt(param.planStatus, 10))) {
                        $("#unMountBtn div").removeClass("iconbutton-unmount-disabled").addClass("iconbutton-unmount");
                    } else {
                        $("#unMountBtn div").removeClass("iconbutton-unmount").addClass("iconbutton-unmount-disabled");
                    };
                    //编辑
                    if (_.contains([0,27], parseInt(param.planStatus, 10))) {
                        $("#iconBtnEdit div").removeClass("iconbutton-edit-disabled").addClass("iconbutton-edit");
                    } else {
                        $("#iconBtnEdit div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                    };
                    //删除
                    if (_.contains([0,27,28], parseInt(param.planStatus, 10))) {
                        $("#iconBtnDel div").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
                    } else {
                        $("#iconBtnDel div").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                    };
                },
                "renderRow": function(nRow, aData, iDataIndex) {
                    $("td[tdtitle='" + appUtils.getString("recovery.term.colum.status.title") +"']", nRow)
                        .html(statusEnumService.getStatus("RECOVERY_STATUS", aData['planStatus']));
                    $("td[tdtitle='" + appUtils.getString("recovery.term.colum.productionSite.title") +"']", nRow)
                        .html(aData["protectGroups"][0]["productSiteName"]);
                    $("td[tdtitle='" + appUtils.getString("recovery_protected_plan_label") +"']", nRow)
                        .html(aData["protectGroups"][0]["name"]);
                    $("td[tdtitle='" + appUtils.getString("pg_create_datatype_label") +"']", nRow)
                        .html(statusEnumService.getStatus("PROTECT_OBJECT_TYPE", aData["protectGroups"][0]['poType']));
                    var progressColumn = "<div class='progressbar'><tiny-progressbar id='id' label-position='position' color='color' value='value' width='width' height='height'></tiny-progressbar></div>";
                    var progressLink = $compile(progressColumn);
                    var progressScope = $scope.$new();
                    progressScope.id = "progress_" + iDataIndex;
                    progressScope.value = aData['planProgress'];
                    progressScope.position = "right";
                    progressScope.width = "80px";
                    progressScope.height = "10px";
                    progressScope.color = _.contains([6, 3, 12, 16, 9, 18, 22, 25, 28], aData["planStatus"]) ? constsService.COLOR_RED : constsService.COLOR_GREEN;
                    var progressNode = progressLink(progressScope);
                    $("td[tdtitle='" + appUtils.getString("recovery.term.colum.process.title") +"']", nRow).html(progressNode);
                }
            }
        };
        //Tab
        $scope.plugins = [{
            "openState": "dataUse.dataMount.abstract",
            "id": "_abstract",
            "name": appUtils.getString("recovery.term.detailTitle.tab")
        }, {
            "openState": "dataUse.dataMount.protected",
            "id": "_protected",
            "name": appUtils.getString("recovery.term.protectedObjTitle.tab")
        }, {
            "openState": "dataUse.dataMount.procedure",
            "id": "_procedure",
            "name": appUtils.getString("recovery.term.procedureTitle.tab")
        }, {
            "openState": "dataUse.dataMount.history",
            "id": "_history",
            "name": appUtils.getString("recovery.term.excuteHistoryTitle.tab")
        }];
        $scope.$on("$stateChangeSuccess", function() {
            $('.table-container').width($('#service-content').width() * 0.98);
        });

        _initTable();

        $scope.$on("$destroy", function() {
            _autoPromise && $timeout.cancel(_autoPromise);
        });
    }];
    var module = angular.module('recoverydirector.recovery.config');
    module.tinyController('mount.ctrl', ctrl);
    return module;
})
