define(["tiny-widgets/Window"], function(Window) {
    "use strict";
    var ctrler = [
        "$scope",
        "$compile",
        "appUtils",
        "constsService",
        "statusEnumService",
        "restService",
        "recoveryService",
        function($scope, $compile, appUtils, constsService, statusEnumService, restService, recoveryService) {
            var _startPage = 0,
                _pageSize = 10,
                _orderBy = "startTime",
                _orderType = "desc",
                _recovery,
                planId;
            $scope.checkRight = appUtils.checkRight;

            function _toHistoryDetail(params) {
                var options = {
                    "winId": constsService.EXCUTE_HISTORY_DETAIL_WIN.winId,
                    "title": appUtils.getString(constsService.EXCUTE_HISTORY_DETAIL_WIN.title),
                    "params": params,
                    "height": constsService.EXCUTE_HISTORY_DETAIL_WIN.height,
                    "width": constsService.EXCUTE_HISTORY_DETAIL_WIN.width,
                    "modal": true,
                    "content-type": "url",
                    "draggable": true,
                    "minimizable": false,
                    "maximizable": false,
                    "content": constsService.EXCUTE_HISTORY_DETAIL_WIN.url,
                    "buttons": [{
                        key: "close",
                        label: appUtils.getString("common_term_close_button"),
                        focused: true,
                        handler: function(event) {
                            $("#" + constsService.EXCUTE_HISTORY_DETAIL_WIN.winId).widget().destroy();
                            _initPage();
                        }
                    }]
                };
                var win = new Window(options);
                win.show();
            }

            function _initPage() {
                !_.isEmpty($("#recoveryTable").widget()) && (_recovery = _.first($("#recoveryTable").widget().getTableCheckedItems()));
                if (_.isUndefined(_recovery) || _.isEmpty(_recovery)) {
                    return;
                }

                $scope.recoveryHistoryMask = true;
                $scope.$apply();
                var _params = {
                    uuid: _recovery.uuid,
                    startPage: _startPage,
                    pageSize: _pageSize,
                    orderBy: _orderBy,
                    orderType: _orderType
                };
                planId = _recovery.uuid;

                _.each(_params, function(value, key) {
                    (_.isUndefined(value) || _.isNull(value)) && delete _params[key];
                })

                restService.getRecoveryExcuteHistoryList(_params, {
                    mask: false,
                    success: function(data) {
                        var arr = [];
                        _.each(data.records, function(d) {
                            var tmo = _.pick(d, "logId", "planId", "logType", "logStatus", "startTime", "endTime", "executeTime", "excuteDetail");
                            tmo.supportConfirmReprotection = $scope.$parent.recoveryObj.supportConfirmReprotection;
                            arr.push(tmo);
                        });
                        $scope.historyScope.table.data = appUtils.encodeForHTML(arr);
                        if ($scope.historyScope.table.data.length == 0 || _recovery.templateType == 25 || _recovery.serviceInstanceType == "replication" || _.contains([34,37], +_recovery.templateType)) {
                            $scope.historyScope.exporte.disable = true;
                        }else{
                            $scope.historyScope.exporte.disable = false;
                        }
                        $scope.historyScope.table.totalRecords = data["totalCount"];
                        if (data["totalCount"] > 10) {
                            $scope.historyScope.table.enablePagination = true;
                            $('.table-container').css('margin', '0 22px');
                        } else {
                            $scope.historyScope.table.enablePagination = false;
                            $('.table-container').css('margin', '0 auto');
                        }
                        $scope.$apply();
                    },
                    fail: function() {
                        $scope.historyScope.table.data = [];
                        $scope.historyScope.table.enablePagination = false;
                        $scope.$apply();
                    },
                    callback: function() {
                        $scope.recoveryHistoryMask = false;
                        _startPage == 0 && ($scope.historyScope.table.currPage = {
                            "pageIndex": 1
                        });
                        $scope.$apply();
                    }
                })
            }

            $scope.historyScope = {
                table: {
                    "id": "recoveryHistory",
                    "paginationStyle":"full_numbers",
                    "enablePagination": false,
                    "currPage": {
                        "pageIndex": 1
                    },
                    data: [],
                    totalRecords: 0,
                    displayLength: constsService.TABLE_COUNT_PER_PAGE,
                    lengthMenu: constsService.TABLE_LENGTH_AUTO_MENU,
                    columns: [{
                        "mData": "logId",
                        "bVisible": false
                    }, {
                        "mData": "planId",
                        "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("recovery.term.history.colum.runType.title"),
                        "mData": "logType",
                        "bSortable": true
                    }, {
                        "sTitle": appUtils.getString("recovery.term.history.colum.runResult.title"),
                        "mData": "logStatus",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("recovery.term.history.colum.startTime.title"),
                        "mData": "startTime",
                        "bSortable": true
                    }, {
                        "sTitle": appUtils.getString("recovery.term.history.colum.endTime.title"),
                        "mData": "endTime",
                        "bSortable": true
                    }, {
                        "sTitle": appUtils.getString("recovery.term.history.colum.executeTime.title"),
                        "mData": "executeTime",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("recovery.term.history.colum.excuteDetail.title"),
                        "mData": "excuteDetail",
                        "bSortable": false
                    }],
                    callback: function(evtObj) {
                        _startPage = evtObj.currentPage - 1;
                        _pageSize = evtObj.displayLength;
                        _initPage();
                    },
                    sortCallback: function(nNode, sortArr) {
                        $scope.historyScope.table.currPage = {
                            "pageIndex": 1
                        };
                        _orderBy = $scope.historyScope.table.columns[_.first(_.first(sortArr))].mData;
                        _orderType = _.first(sortArr)[1];
                        _startPage = 0;
                        _initPage();
                    },
                    renderRow: function(nRow, aData, iDataIndex) {
                        $("td:eq(0)", nRow).html(statusEnumService.getStatus("HISTORY_LOG_TYPE", aData['logType']));
                        $("td:eq(1)", nRow).html(statusEnumService.getStatus("HISTORY_LOG_STATUS", aData['logStatus']));
                        var exportBtnCls = (_recovery.templateType == 25 || _recovery.serviceInstanceType == "replication" || _.contains([34,37], +_recovery.templateType)) ? "btn-link-disable" : "btn-link";
                        var optColumn = "<a href='javascript:void(0)' class='btn-link' ng-click='toDetail()'>" + appUtils.getString(constsService.HISTORY_EXCUTE_DETAIL) + "</a> " + "&nbsp;&nbsp;" + "<a href='javascript:void(0)' class='"+exportBtnCls+"' ng-click='exportDetail()' ng-if=\"checkRight('ism.drm.drp.auth.recoverymapping.export')\">" + appUtils.getString("common_term_export_button") + "</a> ";
                        var optLink = $compile($(optColumn));
                        var optScope = $scope.$new();
                        optScope.data = aData;
                        optScope.toDetail = function() {
                            _toHistoryDetail(aData);
                        };
                        optScope.exportDetail = function(){
                            if (aData.logId == -1 || _recovery.templateType == 25 || _recovery.serviceInstanceType == "replication" || _.contains([34,37], +_recovery.templateType)) {
                                return;
                            }
                            appUtils.export("/recoveryplans/" + planId + "/logs/" + aData.logId + "/action/export");
                        }
                        var optNode = optLink(optScope);
                        $("td:eq(5)", nRow).html(optNode);
                    }

                },
                exporte: {
                    "id":"recoveryHistoryExporte",
                    "text":appUtils.getString("common_term_exportall_button"),
                    disable:false,
                    click: function() {
                        appUtils.export("/recoveryplans/" + planId + "/logs/action/export");
                    }
                }
            }

            _initPage();

            $scope.$on(constsService.RECOVERY_TAB, function(ev, param) {
                _startPage = 0;
                _initPage(param)
            });

        }
    ]
    var module = angular.module('recoverydirector.recovery.config');
    module.tinyController('recovery.history.ctrl', ctrler);
    return module;
});
