define([], function () {
        "use strict";
        var excuteDetailCtrl = [
            "$scope",
            "$state",
            "$compile",
            "$timeout",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "treeTableRenderService",
            "mask",
            "appUtils",
            "restService",
            function ($scope, $state, $compile, $timeout, exception, message, communicationService, utilService, treeTableRenderService, mask, appUtils, restService) {

                var timer = null;

                function _initUI(hideMask) {
                    var planId = $("#excuteDetailWinId").widget().option("params").planId;
                    var logId = $("#excuteDetailWinId").widget().option("params").logId;
                    var notShowMsgWin = $("#excuteDetailWinId").widget().option("params")["notShowMsgWin"];
                    var url = utilService.getResouceUrl("/recoveryplans/" + planId + "/logs/" + logId + "/details");
                    if (!hideMask) {
                        mask.show();
                    }
                    communicationService.get(url).promise().always(function (response) {
                        mask.hide();
                        treeTableRenderService.treeTableBuf = "";
                        initTreeTabelHead();
                        if (exception.check(response, !notShowMsgWin)) {
                            if ($("#excuteDetailWinId").widget().option("params").supportConfirmReprotection) {
                                treeTableRenderService.initTreeTabContent(response, true, initHtml);
                                treeTableRenderService.initTableFinalTag();
                                treeTableRenderService.showDetails(treeTableRenderService.saveChildrenId(response), initHtml);
                                runClick();
                            } else {
                                treeTableRenderService.initTreeTabContent(response, true);
                                treeTableRenderService.initTableFinalTag();
                                treeTableRenderService.showDetails(treeTableRenderService.saveChildrenId(response));
                            }
                            treeTableRenderService.historyBindEvent();
                            var runninglog = _.find(response, function(item) {return item.processStatus === 3})
                            if (runninglog) {
                                $timeout(autoRefresh, 2500);
                            }
                            if (!runninglog && timer) {
                                $timeout.cancel(timer);
                            }
                        } else {
                            treeTableRenderService.initTableFinalTag();
                            timer && $timeout.cancel(timer);
                        }
                        $scope.$apply();
                    });
                }

                _initUI();

                function autoRefresh() {
                    if ($scope.$$destroyed) {
                        timer && $timeout.cancel(timer);
                    } else {
                        _initUI(true);
                    }

                }

                function initTreeTabelHead() {
                    var treeHead = "";
                    if ($("#excuteDetailWinId").widget().option("params").supportConfirmReprotection) {
                        treeHead = "<table class='x-grid3-table tbodytable' id='treeTable' style='margin-top:0px;margin-bottom:0px'><thead><tr class='x-grid3-hd-row'>"
                            + "<th class='cell-spliter' dragabled='true' width='20%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 11px;' class='ellipsis'>" + appUtils.getString("common_term_name_label") + "</div></th>"
                            + "<th class='cell-spliter' dragabled='true' width='14%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 3px;' class='ellipsis'>" + appUtils.getString("common_term_status_label") + "</div></th>"
                            + "<th class='cell-spliter' dragabled='true' width='19%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 3px;' class='ellipsis'>" + appUtils.getString("common_term_begintime_label") + "</div></th>"
                            + "<th class='cell-spliter' dragabled='true' width='19%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 3px;' class='ellipsis'>" + appUtils.getString("common_term_endtime_label") + "</div></th>"
                            + "<th class='cell-spliter' dragabled='true' width='10%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 3px;' class='ellipsis'>" + appUtils.getString("task_term_executeTime_label") + "</div></th>"
                            + "<th class='cell-spliter' dragabled='true' width='18%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 3px;' class='ellipsis'>" + appUtils.getString("common_term_description_column") + "</div></th>"
                            + "<th class='cell-spliter' dragabled='true' width='18%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 3px;' class='ellipsis'>" + appUtils.getString("recovery.term.colum.operate.title") + "</div></th>"
                            + "</tr></thead>"
                    }
                    treeTableRenderService.initTreeTabelHead(treeHead)
                }

                function initHtml(params) {
                    var html = "";
                    html += "<tr class='x-grid3-row treeTr " + params.classStyle + " id='suffex" + params.detailId + "'" + " value='" + params.processStatus + "' data-tt-id='" + params.detailId + "'" + params.parentIdSet + ">";
                    html += "<td class='x-grid3-table-cell' width='20%' style='text-align:left;' title='" + params.processName + "'><span class='" + params.spanClass + "' style='" + params.spanStyle + "'>" + params.processName + "</span></td>";
                    html += "<td class='x-grid3-table-cell td-left-align' width='14%' class='refHandle' title='" + params.processStatus + "'><div><label class='" + params.c + "'></label><label class='" + params.iconLabel + "'>" + params.processStatus + "</label><div></td>";
                    html += "<td class='x-grid3-table-cell td-left-align' width='19%' title='" + params.startTime + "'><label class='maxTime'>" + params.startTime + "</label></td>";
                    html += "<td class='x-grid3-table-cell td-left-align' width='19%' title='" + params.endTime + "'><label class='maxTime'>" + params.endTime + "</label></td>";
                    html += "<td class='x-grid3-table-cell td-left-align' width='10%' title='" + params.executeTime + "'><label class='maxTime'>" + params.executeTime + "</label></td>";
                    html += "<td class='x-grid3-table-cell td-left-align' width='18%' title='" + params.processDetail + "'><label class='maxDescContext'>" + params.processDetail + "</label></td>";
                    html += "<td class='x-grid3-table-cell td-left-align' width='18%'>";
                    if (params.logStatus == 4) {
                        html += "<span class='maxDescContext btn-link plan-run'>" + appUtils.getString("recovery_plan_excute_opt_run_label") + "</span></td>"
                    } else {
                        html += "&nbsp;</td>";
                    }
                    html += "</tr>"
                    return html;
                }
    
                function runClick() {
                    $("#recoveryDetailTreeDiv #treeTable").on("click", ".plan-run", function(){
                        message.warn({
                            content: appUtils.getString("recovery_plan_paused_run_warn_label"),
                            okLabel: appUtils.getString("recovery_plan_excute_opt_on_label"),
                            cancelLabel: appUtils.getString("recovery_plan_excute_opt_stop_label"),
                            ok: function() {
                                report(true);
                            },
                            cancel: function() {
                                report(false);
                            },
                            close: function() { }
                        })
                    });
                }

                function report(isContinue) {
                    var planId =  $("#excuteDetailWinId").widget().option("params").planId;
                    mask.show();
                    restService.pausedContinue([planId, "planedMotion"], {
                        data: { recovery_continue_key: isContinue },
                        success: function (res) {
                            mask.hide();
                            if (exception.check(res)) {
                                message.success({
                                    content: appUtils.getString("common_term_command_send_success_label"),
                                    ok: function () {
                                        _initUI();
                                    }
                                })
                            }
                        },
                        fail: function(err) {
                            mask.hide();
                        }
                    })
                }

                $scope.$on('$destroy', function () {
                    timer && $timeout.cancel(timer);
                });

            } ]
        var excuteDetailApp = angular.module("home.config");
        excuteDetailApp.tinyController("app.excute.detail.ctrl", excuteDetailCtrl);
        return excuteDetailApp;
    });