define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrl = ["$scope", "$state", "$stateParams", "$compile", "appUtils", "constsService", "restService", "message", "statusEnumService", "model", "infoTransferredService", function($scope, $state, $stateParams, $compile, appUtils, constsService, restService, message, statusEnumService, Model, infoTransferredService) {
        var pleaseSelectVal = [{
            "selectId": "-1",
            "label": appUtils.getString("common_term_pleaseSelect_listbox")
        }];
        setTimeout(function() {
            $("#createDataMountContainer").outerHeight($("body").outerHeight() - 130);
        }, 0);
        //查询本地服务器信息,查询站点需要
        restService.queryLocalServer([], {
            mask: false,
            isShowMsgBox: false,
            success: function(data) {
                if (data) {
                    $scope.serverUuid = data.uuid;
                    restService.querySites([$scope.serverUuid], {
                        mask: false,
                        success: function(data) {
                            if (!_.isEmpty(data)) {
                                appUtils.updateSelectValues("siteSelect", data, "siteId", "name");
                                $scope.model.siteSelect.defaultSelectid = data[0].siteId;
                                $scope.$apply();
                            };
                        }
                    });
                };
            }
        });
        //返回保护计划输入框数组
        var getProtectPlanList = function() {
            var params = {
                poType: "",
                _FILTER: "",
                _PAGE: appUtils.queryFilter(0, 520),
            };
            restService.queryProtectGroups(params, function(result){
                $scope.protectPlanDatas = result;
                $scope.model.protectedPlanCombobox.values = function() {
                    var records = [];
                    _.each(angular.copy(result.records), function(pg, key) {
                        if (!_.contains([2,19,30,31,32], parseInt(pg.template.type, 10)) || pg.poType == 12) {
                            return;
                        }
                        this.push(pg.name);
                    }, records);
                    return records;
                }();
            })
        }
        //查询副本信息
        var queryPgReplicas = function(pgId, startPage, siteId, startTime, endTime, replicaType) {
            var params = {
                protectGroupId: pgId,
                startPage: startPage,
                siteId: siteId,
                startTime: startTime,
                endTime: endTime,
                replicaType: replicaType
            };
            restService.queryPageSizeReplicas(params, {
                success: function(result) {
                    _.each(result.replicas, function(replica) {
                        replica.type = statusEnumService.getStatus("REPLICA_TYPE", replica.type);
                    });
                    $scope.model.duplicaListTable.data = appUtils.encodeForHTML(result.replicas);
                    $scope.model.duplicaListTable.totalRecords = result.totalCount;
                    $scope.model.duplicaListTable.enablePagination = result.totalCount > 10;
                    $scope.$apply();
                }
            });
        };
        //过滤
        var initByConditions = function(){
            var pg = _.first($scope.protectData);
            var pgId = !_.isEmpty(pg) ? pg.uuid : "";
            var _replicaType = $("#backupTypeSelect").widget().getSelectedId() == "-1" ? "" : $("#backupTypeSelect").widget().getSelectedId();
            var _site = $("#siteSelect").widget().getSelectedId() == "-1" ? "" : $("#siteSelect").widget().getSelectedId();
            var _startData = $("#startDate").widget().getDateTime();
            !_.isEmpty(_startData) && (_startData = appUtils.newDate(_startData).getTime());
            var _endData = $("#endDate").widget().getDateTime();
            !_.isEmpty(_endData) && (_endData = appUtils.newDate(_endData).getTime());
            $scope.model.duplicaListTable.curPage = {
                "pageIndex": 1
            };
            queryPgReplicas(pgId, 1, _site, _startData, _endData, _replicaType);
        };
        var resetConfig = function(trData) {
            appUtils.resetSelectValues("mountSiteSelect");
            appUtils.resetSelectValues("mountHostSelect");
            appUtils.resetSelectValues("vCenterSelect");
            appUtils.resetSelectValues("clusterSelect");
            $scope.model.netWork.values = [];
            $scope.model.vmIp.values = [];
            $scope.appType = _.contains([1, 2, 3, 16], parseInt(trData.poType, 10));
            $scope.vmwareType = trData.poType == 10;
            $scope.model.startDataBase.text = $scope.vmwareType ? appUtils.getString("protection_startVM_after_mount_label") : appUtils.getString("protection_startDb_after_mount_label");
            $scope.model.mountHostSelect.showVaild = !$scope.vmwareType;
            $scope.model.vCenter.showVaild = $scope.vmwareType;
            $scope.model.cluster.showVaild = $scope.vmwareType;
            $scope.model.netWork.showVaild = $scope.vmwareType;
            $scope.model.preScript.show = !$scope.vmwareType;
        };
        //校验是否选择了副本
        var vaildDuplica = function() {
            if (!$scope.model.duplicaListTable.vaildFn()) {
                message.error(appUtils.getString("recovery.term.test.replica.message.least"));
                return false;
            };
            return true;
        };
        //初始化为应用
        $scope.vmwareType = false;
        $scope.appType = false;
        //查询保护组副
        $scope.labels = {
            name: appUtils.getStringWithColon("common_term_name_label"),
            description: appUtils.getStringWithColon("common_term_description_label"),
            protectPlan: appUtils.getStringWithColon("site_backuprespo_protectplan_label"),
            duplica: appUtils.getStringWithColon("ism.drm.protect.group.tab.duplica"),
            mountTarget: appUtils.getStringWithColon("recovery_datamount_target_label"),
            mountConfigs: appUtils.getString("recovery_datamount_set_label"),
            configLabel: appUtils.getString("ism.drm.settings.menuname"),
            preScriptLabel: appUtils.getStringWithColon("protection_pre_script_label"),
            postScriptLabel: appUtils.getStringWithColon("protection_post_script_label"),
            SCRIPT_TIP: appUtils.getString("others_script_label"),
            info: appUtils.getString("current_alarm_term_win_abstract_label"),
            duplica_info: appUtils.getString("ism.drm.protect.group.tab.duplica"),
            selection: appUtils.getString("datamount_create_selete_label"),
            replicatype: appUtils.getStringWithColon("dataMount_create_replicatype_lable"),
            class: "labels-style",
            configformTitle: appUtils.getString("recovery_create_datamount_label"),
        };
        $scope.model = {
            tbName: {
                "id": "planName",
                "key": "name",
                "width": constsService.W4,
                "value": "",
                "require": true,
                "validate": constsService.VALID.NAME,
                getValue: function() {
                    return $("#" + this.id).widget().getValue();
                }
            },
            description: {
                "id": "description",
                "key": "description",
                "type": "multi",
                "height": constsService.DESCR_HEIGHT,
                "width": constsService.W4,
                "labelcls": "label-middle",
                "validate": constsService.VALID.DES_REMARK,
                getValue: function() {
                    return $("#" + this.id).widget().getValue();
                }
            },
            protectedPlanCombobox: {
                "id": "protectPlanSearch",
                "key": "protectGroupId",
                "width" :constsService.W4,
                "values" :getProtectPlanList(),
                selectPlan: function() {
                    var win = angular.copy(constsService.CREATE_DATAMOUNT_PROTECT_LIST_WIN);
                    win.title = appUtils.getString(win.title);
                    appUtils.showWindow(win, function() {
                        if (!UnifyValid.FormValid($("#create_datamount_protect_list_win"), {focusInvalid: true})) {
                            return;
                        };
                        var protectData = $("#protectedPlanList").widget().getTableCheckedItems();
                        $scope.protectData = protectData;
                        resetConfig(protectData[0]);
                        var _site = $("#siteSelect").widget().getSelectedId() == "-1" ? "" : $("#siteSelect").widget().getSelectedId();
                        var _replicaType =$("#backupTypeSelect").widget().getSelectedId();
                        var _startData = $("#startDate").widget().getDateTime();
                        !_.isEmpty(_startData) && (_startData = appUtils.newDate(_startData).getTime());
                        var _endData = $("#endDate").widget().getDateTime();
                        !_.isEmpty(_endData) && (_endData = appUtils.newDate(_endData).getTime());
                        $scope.model.duplicaListTable.curPage = {
                            "pageIndex": 1
                        };
                        queryPgReplicas(protectData[0].uuid, 1, _site, _startData, _endData, _replicaType);
                        $("#protectPlanSearch").widget().option("value",protectData[0].name);
                        $("#create_datamount_protect_list_win").widget().destroy();
                    });
                },
                blur:function(event, value){
                    if (!_.contains($scope.model.protectedPlanCombobox.values, value)){
                        $scope.model.duplicaListTable.data = [];
                        $scope.model.duplicaListTable.totalRecords = 0;
                        $scope.model.duplicaListTable.enablePagination = false;
                        appUtils.resetSelectValues("mountSiteSelect");
                        appUtils.resetSelectValues("mountHostSelect");
                        appUtils.resetSelectValues("vCenterSelect");
                        appUtils.resetSelectValues("clusterSelect");
                    } else {
                        var protectData = {};
                        for(var i=0;i<$scope.protectPlanDatas.records.length;i++) {
                            if(value == $scope.protectPlanDatas.records[i].name) {
                                protectData = $scope.protectPlanDatas.records[i];
                            }
                        }
                        if(!_.isEmpty($scope.protectData[0]) && protectData.uuid == $scope.protectData[0].uuid){
                            return;
                        };
                        $scope.protectData = [protectData];
                        resetConfig(protectData);
                        var _site = $("#siteSelect").widget().getSelectedId() == "-1" ? "" : $("#siteSelect").widget().getSelectedId();
                        var _replicaType =$("#backupTypeSelect").widget().getSelectedId();
                        var _startData = $("#startDate").widget().getDateTime();
                        !_.isEmpty(_startData) && (_startData = appUtils.newDate(_startData).getTime());
                        var _endData = $("#endDate").widget().getDateTime();
                        !_.isEmpty(_endData) && (_endData = appUtils.newDate(_endData).getTime());
                        queryPgReplicas(protectData.uuid, 1, _site, _startData, _endData, _replicaType);
                        $("#protectPlanSearch").widget().option("value",protectData.name);
                    }
                },
                select:function() {
                    var selectValue = $("#protectPlanSearch").widget().getValue();
                    var protectData = {};
                    for(var i=0;i<$scope.protectPlanDatas.records.length;i++) {
                        if(selectValue == $scope.protectPlanDatas.records[i].name) {
                            protectData = $scope.protectPlanDatas.records[i];
                            $scope.protectData = [protectData];
                        }
                    }
                    resetConfig(protectData);
                    var _site = $("#siteSelect").widget().getSelectedId() == "-1" ? "" : $("#siteSelect").widget().getSelectedId();
                    var _replicaType =$("#backupTypeSelect").widget().getSelectedId();
                    var _startData = $("#startDate").widget().getDateTime();
                    !_.isEmpty(_startData) && (_startData = appUtils.newDate(_startData).getTime());
                    var _endData = $("#endDate").widget().getDateTime();
                    !_.isEmpty(_endData) && (_endData = appUtils.newDate(_endData).getTime());
                    queryPgReplicas(protectData.uuid, 1, _site, _startData, _endData, _replicaType);
                    $("#protectPlanSearch").widget().option("value",protectData.name);
                },
                getValue: function() {
                    return $scope.protectData[0].pgId;
                },
                showVaild: true,
                vaildFn: function() {
                    return !_.isEmpty($scope.protectData) && !_.isEmpty($scope.protectData[0].pgId);
                },
                "errorMsg": appUtils.getString("validate_select_value_label", "recovery_protected_plan_label"),
            },
            backupTypeSelect: {
                "id": "backupTypeSelect",
                "values": [{
                    selectId: "3",
                    label: appUtils.getString("pg_copybackuptype_snapshot_label")
                },{
                    selectId: "4",
                    label: appUtils.getString("pg_copybackuptype_hypercdp_label")
                },{
                    selectId: "101",
                    label: appUtils.getString("pg_copybackuptype_cloudbackup_label")
                },{
                    selectId: "9",
                    label: appUtils.getString("pg_copybackuptype_cloneduplica_label")
                }],
                "defaultSelectid": "3",
                "closeFn": function() {
                    initByConditions();
                }
            },
            siteSelect: {
                "id": "siteSelect",
                "values": [{
                    selectId: "-1",
                    label: appUtils.getString("common_term_all_site_label")
                }],
                "defaultSelectid": "-1",
                "closeFn": function() {
                    initByConditions();
                }
            },
            startDate: {
                "id": "startDate",
                "label": appUtils.getString("common_term_from_label"),
                "type": "datetime",
                "dateFormat": 'yy-mm-dd',
                "timeFormat": "hh:mm:ss",
                "onClose": function() {
                    initByConditions();
                }
            },
            endDate: {
                "id": "endDate",
                "label": appUtils.getString("common_term_to_label"),
                "type": "datetime",
                "dateFormat": 'yy-mm-dd',
                "timeFormat": "hh:mm:ss",
                "onClose": function() {
                    initByConditions();
                }
            },
            refresh: {
                "title": appUtils.getString("common_term_refresh_button"),
                "action": function(){
                    if(!_.isEmpty($("#startDate").widget()) && !_.isEmpty($("#endDate").widget())){
                        $("#startDate").widget().empty();
                        $("#endDate").widget().empty();
                    };
                    initByConditions();
                }
            },
            duplicaListTable: {
                "id": "duplicaListTable",
                "key": "replicaId",
                "sScrollY": "240px",
                "columns": [{
                    "mData": "name",
                    "bSortable": false,
                    "sTitle": appUtils.getString("recovery.term.colum.name.title"),
                }, {
                    "sTitle": appUtils.getString("notify_alarm_term_status_column"),
                    "mData": "status",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("datamount_create_resource_id_label"),
                    "mData": "",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("recovery.term.test.replica.colum.replicaTime"),
                    "mData": "timeStamp",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("common_term_type_label"),
                    "mData": "type",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("site.term.resourceOwingSite.column"),
                    "mData": "",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("topo_term_quorumserverIp_label"),
                    "mData": "storageIp",
                    "bSortable": false
                },{
                    "sTitle": appUtils.getString("protection_object_column_level_label"),
                    "mData": "generation",
                    "bSortable": false
                }],
                enablePagination: false,
                "data": [],
                isCloudBackupDuplica: false,
                callback: function(evtObj) {
                    var trData = _.first($scope.protectData);
                    if (_.isEmpty(trData)) {
                        return;
                    };
                    var _replicaType = $("#backupTypeSelect").widget().getSelectedId() == "-1" ? "" : $("#backupTypeSelect").widget().getSelectedId();
                    var _site = $("#siteSelect").widget().getSelectedId() == "-1" ? "" : $("#siteSelect").widget().getSelectedId();
                    var _startData = $("#startDate").widget().getDateTime();
                    !_.isEmpty(_startData) && (_startData = appUtils.newDate(_startData).getTime());
                    var _endData = $("#endDate").widget().getDateTime();
                    !_.isEmpty(_endData) && (_endData = appUtils.newDate(_endData).getTime());
                    queryPgReplicas(trData.uuid, evtObj.currentPage, _site, _startData, _endData, _replicaType);
                },
                cellClickActive: function(event, trData) {
                    $scope.model.mountSiteSelect.isCLOUD_REPLICA = !_.isUndefined(trData.props.CLOUD_REPLICA_ID);
                    $scope.model.createDuplicaType.show = true;
                    if(trData.type == appUtils.getString("pg_copybackuptype_snapshot_label") || trData.type == appUtils.getString("pg_copybackuptype_hypercdp_label")) {
                        if(trData.generation == 1) {
                            //创建二级按钮显示
                            $scope.model.createDuplicaSecond.show = true;
                            //默认选择创建二级副本且不能取消
                            $scope.model.createDuplicaSecond.checked = true;
                            $scope.model.createDuplicaSecond.disable = true;
                            $scope.model.createDuplicaType.show = true;
                        } else if(trData.generation == 2) {
                            //创建二级按钮显示
                            $scope.model.createDuplicaSecond.show = true;
                            //默认不选择，
                            $scope.model.createDuplicaSecond.checked = false;
                            $scope.model.createDuplicaSecond.disable = false;
                            $scope.model.createDuplicaType.show = false;
                        }
                        $scope.model.umountSelect.show = true;
                        $scope.model.umountSelect.checked = true;
                        $scope.model.deleteSelect.show = true;
                        $scope.model.duplicaListTable.isCloudBackupDuplica = false;
                        restService.queryStorageLicense(trData.protectArray, function(result) {
                            //存储类型里含有10000两者均可选
                            var isSupportSnapshotDup = !_.isUndefined(_.find(result.LicenseFunction, function(license) {
                                return 10000 == license.FeatureId && !!license.FuncSwitch;
                            }));
                            //存储类型是FSB oracle的本地快照
                            var isSupportFsbDup = !_.isUndefined(_.find(result.LicenseFunction, function(license) {
                                return constsService.STORAGE_FEATURE_ENUM.CloneVol == license.FeatureId && !!license.FuncSwitch && !_.isEmpty($scope.protectData[0]) && $scope.protectData[0].poType == 1 && $scope.protectData[0].template.type == 2;
                            }));
                            if(isSupportSnapshotDup && trData.type != appUtils.getString("pg_copybackuptype_hypercdp_label")) {
                                $scope.model.createDuplicaType.defaultSelectid = "3";
                                $scope.model.createDuplicaType.values = [{
                                    "selectId": "10",
                                    "label": appUtils.getString("datamount_targetReplicaType_snapshot_label"),
                                }, {
                                    "selectId": "3",
                                    "label": appUtils.getString("dataMount_create_snapshot_mount_lable"),
                                }];
                                $scope.model.createDuplicaType.tipShow = true;
                                $scope.model.createDuplicaType.tips_snapsho_show = false;
                                $scope.model.createDuplicaType.tips_FSB_show = false;
                            } else if (isSupportFsbDup && trData.type == appUtils.getString("pg_copybackuptype_snapshot_label")) {
                                //FSB的快照副本
                                $scope.model.createDuplicaType.values = [{
                                    "selectId": "9",
                                    "label": appUtils.getString("datamount_create_clone_duplica_mount_label")
                                }];
                                $scope.model.createDuplicaType.defaultSelectid = "9";
                                $scope.model.createDuplicaType.tipShow = false;
                                $scope.model.createDuplicaType.tips_snapsho_show = false;
                                $scope.model.createDuplicaType.tips_FSB_show = true;
                            } else {
                                $scope.model.createDuplicaType.values = [{
                                    "selectId": "3",
                                    "label": appUtils.getString("dataMount_create_snapshot_mount_lable"),
                                }]
                                $scope.model.createDuplicaType.defaultSelectid = "3";
                                $scope.model.createDuplicaType.tipShow = false;
                                $scope.model.createDuplicaType.tips_snapsho_show = true;
                                $scope.model.createDuplicaType.tips_FSB_show = false;
                            }
                        })
                    } else if(trData.type == appUtils.getString("pg_copybackuptype_cloudbackup_label")) {
                        //二级副本类型不显示
                        $scope.model.createDuplicaType.show = false;
                        //创建二级按钮不显示
                        $scope.model.createDuplicaSecond.show = false;
                        $scope.model.umountSelect.show = true;
                        $scope.model.umountSelect.checked = true;
                        $scope.model.deleteSelect.show = false;
                        $scope.model.duplicaListTable.isCloudBackupDuplica = true;
                    } else if (trData.type == appUtils.getString("pg_copybackuptype_cloneduplica_label")) {
                        //FSB克隆链接卷
                        //二级副本类型显示
                        $scope.model.createDuplicaType.show = false;
                        //创建二级按钮不显示
                        $scope.model.createDuplicaSecond.show = true;
                        //不选择创建二级副本挂载
                        $scope.model.createDuplicaSecond.checked = false;
                        $scope.model.createDuplicaSecond.disable = true;
                        $scope.model.umountSelect.show = true;
                        $scope.model.umountSelect.checked = true;
                        $scope.model.deleteSelect.show = false;
                        $scope.model.duplicaListTable.isCloudBackupDuplica = false;
                        $scope.$apply();
                    }

                },
                renderRow: function(nRow, aData, iDataIndex) {
                    $("td[tdtitle='" + appUtils.getString("notify_alarm_term_status_column") + "']", nRow).html(statusEnumService.getStatus("DUPLICA_STATUS", aData.status));
                    $("td[tdtitle='" + appUtils.getString("datamount_create_resource_id_label") + "']", nRow).html(_.isEmpty(aData.props.StorageIds) ? "--" : aData.props.StorageIds);
                    if (!_.isEmpty(aData.props.CLOUD_SITE_ID)) {
                        restService.getSiteDetails(aData.props.CLOUD_SITE_ID,function(data) {
                            var span = data.isCloudSite ? '<span class="cloud_site_ico_docu"></span>' : '<span class="site_ico_docu"></span>';
                            var resourceOwingSite = span +data.name
                             $("td[tdtitle='" + appUtils.getString("site.term.resourceOwingSite.column") + "']", nRow).html(resourceOwingSite)
                        })
                    } else {
                        aData.recoverySiteId && restService.getSiteDetails({siteId:aData.recoverySiteId},function(data) {
                            var span = data.isCloudSite ? '<span class="cloud_site_ico_docu"></span>' : '<span class="site_ico_docu"></span>';
                            var resourceOwingSite = span + aData.recoverySite;
                            $("td[tdtitle='" + appUtils.getString("site.term.resourceOwingSite.column") + "']", nRow).html(resourceOwingSite);
                        })
                    }
                },
                showVaild: true,
                vaildFn: function() {
                    var checkedDuplica = _.first($("#" + this.id).widget().getTableCheckedItems());
                    return !_.isEmpty(checkedDuplica);
                },
                "errorMsg": appUtils.getString("validate_select_value_label", "ism.drm.protect.group.tab.duplica"),
                getValue: function() {
                    var checkedDuplica = _.first($("#" + this.id).widget().getTableCheckedItems());
                    return _.isEmpty(checkedDuplica) ? "" : checkedDuplica.id;
                }
            },
            mountSiteSelect: {
                id: "mountSiteSelect",
                key: "siteId",
                label: appUtils.getStringWithColon("rm_term_wizard_setting_site_title"),
                width: constsService.W4,
                values: pleaseSelectVal,
                defaultSelectid: "-1",
                isCloudSite:false,
                isCLOUD_REPLICA:false,
                openFn: function(object) {
                    if (!vaildDuplica()) {
                        return;
                    };
                    var that = this;
                    restService.querySites([$scope.serverUuid], function(data) {
                        if (!_.isEmpty(data)) {
                            if(!$scope.model.mountSiteSelect.isCLOUD_REPLICA || $scope.vmwareType) {
                                for(var i=0;i<data.length;i++) {
                                    data[i].isCloudSite && delete data[i];
                                }
                            }
                            appUtils.updateSelectValues(that.id, data, "siteId", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                            object.open();
                        } else {
                            object.open();
                        };
                    });
                },
                showVaild: true,
                closeFn:function(obj, evt){
                    var siteId = $("#" + this.id).widget().getSelectedId();
                    if (siteId == "-1") {
                        return;
                    };
                    restService.getSiteDetails(siteId, function(data){
                        $scope.model.mountSiteSelect.isCloudSite = data.isCloudSite;
                        $scope.model.createDuplicaType.show && ($scope.model.createDuplicaType.show = !data.isCloudSite);
                        $scope.model.umountSelect.show = !data.isCloudSite;
                        $scope.model.deleteSelect.show = $("#umountSelect").widget().option("checked") && ($scope.model.deleteSelect.show = !data.isCloudSite)
                        $scope.model.preScript.show = !data.isCloudSite && !$scope.vmwareType;
                        $scope.model.mountHostSelect.label = data.isCloudSite ? appUtils.getString("recovery_rollback_cloudserver_label"):appUtils.getString("recovery_rollback_hostgroup_label");
                        $scope.model.mountHostSelect.buyECSShow = data.isCloudSite;
                        $scope.model.senior.show = !data.isCloudSite;
                        $scope.model.createDuplicaSecond.show = !data.isCloudSite;
                    })
                },
                change: function(){
                    //重置相关参数
                    appUtils.resetSelectValues("mountHostSelect");
                    appUtils.resetSelectValues("vCenterSelect");
                    appUtils.resetSelectValues("clusterSelect");
                    $scope.model.netWork.values = [];
                    $scope.model.vmIp.values = [];
                },
                vaildFn: function() {
                    return $("#" + this.id).widget().getSelectedId() != "-1";
                },
                "errorMsg": appUtils.getString("validate_select_value_label", "ism.drm.protect.element.site"),
                getValue: function() {
                    return $("#" + this.id).widget().getSelectedId();
                }
            },
            mountHostSelect: {
                id: "mountHostSelect",
                key: "hostOrGroupSn",
                label: appUtils.getStringWithColon("recovery_rollback_hostgroup_label"),
                buyECS: appUtils.getString("recovery_rollback_buy_cloudserver_label"),
                buyECSShow: false,
                width: constsService.W4,
                values: pleaseSelectVal,
                defaultSelectid: "-1",
                openFn: function(object) {
                    var that = this;
                    var selectSiteId = $("#mountSiteSelect").widget().getSelectedId();
                    if (selectSiteId == "-1") {
                        object.open();
                        return;
                    };
                    if($scope.model.mountSiteSelect.isCloudSite) {
                        restService.queryCloudServer(selectSiteId, function(data) {
                            if (!_.isEmpty(data)) {
                                appUtils.updateSelectValues(that.id, data.records, "id", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                                object.open();
                            } else {
                                object.open();
                            }
                        });
                    } else {
                        restService.queryHostBySite([selectSiteId, 0], function(data) {
                            if (!_.isEmpty(data)) {
                                var hosts = Model.util.formatHosts(data);
                                if(!_.isEmpty($scope.protectData) && _.contains([1,2,3,16], parseInt($scope.protectData[0].poType, 10))){
                                    for (var i=0;i<hosts.length;i++) {
                                        if ($scope.protectData[0].poProviderSN == hosts[i].deviceSn) {
                                            delete hosts[i]
                                        }
                                    }
                                };
                                appUtils.updateSelectValues(that.id, hosts, "deviceSn", "name", appUtils.getString("protection_mount_hosts_select_label"));
                                object.open();
                            } else {
                                object.open();
                            }
                        });
                    }
                },
                create: function() {
                    window.open(constsService.WEBSITE.BUYECS, "_blank");
                },
                showVaild: true,
                vaildFn: function() {
                    return $("#" + this.id).widget().getSelectedId() != "-1";
                },
                "errorMsg": appUtils.getString("validate_select_value_label", "ism.drm.host"),
                getValue: function() {
                    return $("#" + this.id).widget().getSelectedId();
                }
            },
            vCenter: {
                id: "vCenterSelect",
                key: "vCenter",
                label: appUtils.getStringWithColon("common.term.vCenter.tab"),
                width: constsService.W4,
                require: true,
                values: [{
                    "selectId": "-1",
                    "label": appUtils.getString("common_term_pleaseSelect_listbox")
                }],
                defaultSelectid: "-1",
                openFn: function(object) {
                    var that = this;
                    var selectSiteId = $("#mountSiteSelect").widget().getSelectedId();
                    if (selectSiteId == "-1") {
                        object.open();
                        return;
                    };
                    restService.queryVCenterBySite([selectSiteId], function(data) {
                        if (!_.isEmpty(data)) {
                            appUtils.updateSelectValues(that.id, data, "vCenterUuid", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                            object.open();
                        } else {
                            object.open();
                        };
                    });
                },
                change: function() {
                    //将已设置好的数据清空
                    appUtils.resetSelectValues("clusterSelect");
                    $scope.model.cluster.defaultSelectid = "-1";
                    $scope.model.netWork.values = [];
                    _.extend($("#" + constsService.SAN_REPLICA_MOUNT_WIN.winId).widget().option("data"), {
                        mappingSets: []
                    });
                    $scope.$apply();
                },
                showVaild: false,
                vaildFn: function() {
                    return $("#" + this.id).widget().getSelectedId() != "-1";
                },
                "errorMsg": appUtils.getString("validate_select_value_label", "common.term.vCenter.tab"),
                getValue: function() {
                    var that = this;
                    return {
                        remoteVcenterId: $("#" + that.id).widget().getSelectedId(),
                        remoteVcenterName: $("#" + that.id).widget().getSelectedLabel()
                    };
                }
            },
            cluster: {
                id: "clusterSelect",
                key: "cluster",
                label: appUtils.getStringWithColon("resource_mapping_cluster"),
                width: constsService.W4,
                require: true,
                values: [{
                    "selectId": "-1",
                    "label": appUtils.getString("common_term_pleaseSelect_listbox")
                }],
                defaultSelectid: "-1",
                openFn: function(object) {
                    var that = this;
                    var selectVcenterId = $("#vCenterSelect").widget().getSelectedId();
                    if (selectVcenterId == "-1") {
                        object.open();
                        return;
                    };
                    restService.getvCenterTestCluster([selectVcenterId], function(data) {
                        if (!_.isEmpty(data)) {
                            appUtils.updateSelectValues(that.id, data, "uuid", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                            object.open();
                        } else {
                            object.open();
                        };
                    });
                },
                change: function() {
                    //将已设置好的数据清空
                    $scope.model.netWork.values = [];
                    _.extend($("#" + constsService.SAN_REPLICA_MOUNT_WIN.winId).widget().option("data"), {
                        mappingSets: []
                    });
                    $scope.$apply();
                },
                showVaild: false,
                vaildFn: function() {
                    return $("#" + this.id).widget().getSelectedId() != "-1";
                },
                "errorMsg": appUtils.getString("validate_select_value_label", "resource_mapping_cluster"),
                getValue: function() {
                    var that = this;
                    return {
                        remoteHostId: $("#" + that.id).widget().getSelectedId(),
                        remoteHostName: $("#" + that.id).widget().getSelectedLabel()
                    };
                }
            },
            netWork: {
                id: "netWorkBtn",
                key: "testNetwork",
                label: appUtils.getStringWithColon("resource_mapping_network"),
                require: true,
                disable: false,
                values: [],
                config: function() {
                    if (this.disable) {
                        return;
                    };
                    var that = this;
                    var win = angular.copy(constsService.VM_MOUNT_NETWORK_CONFIG_WIN);
                    win.title = appUtils.getString("protection_vmware_cdm_network_win_label");
                    _.extend(win.data, {
                        hostUuid: $("#clusterSelect").widget().getSelectedId(),
                        vcenterUuid: $("#vCenterSelect").widget().getSelectedId(),
                        pg: _.first($scope.protectData),
                        mappingDatas: that.values
                    });
                    appUtils.showWindow(win, function() {
                        var data = $("#mappingViewTable").widget().getTableData();
                        var _productionResData = !_.isEmpty($("#productionResTable").widget()) ? $("#productionResTable").widget().getTableData() : [];
                        if (_.isEmpty(data) || !_.isEmpty(_productionResData)) {
                            message.error(appUtils.getString("protection_vmware_cdm_network_mapping_error_label"));
                            return;
                        };
                        that.values = [];
                        _.each(data, function(obj) {
                            that.values.push({
                                "srcNetworkId": obj.id[0],
                                "srcNetworkName": obj.name[0],
                                "remoteNetworkId": obj.id[1],
                                "remoteNetworkName": obj.name[1]
                            });
                        });
                        $scope.$apply();
                        $("#" + constsService.VM_MOUNT_NETWORK_CONFIG_WIN.winId).widget().destroy()
                    });
                },
                showVaild: false,
                vaildFn: function() {
                    return this.values.length != 0;
                },
                "errorMsg": appUtils.getString("validate_select_value_label", "resource_mapping_network"),
                getValue: function() {
                    return this.values
                }
            },
            vmIp: {
                id: "vmIpBtn",
                key: "vmIp",
                label: appUtils.getStringWithColon("protection_mount_vm_ip_set_label"),
                disable: false,
                values: [],
                config: function() {
                    if (this.disable) {
                        return;
                    };
                    var that = this;
                    //设置虚拟机IP
                    var pgId = $scope.model.protectedPlanCombobox.getValue();
                    if (_.isEmpty(pgId)) {
                        return;
                    };
                    var win = angular.copy(constsService.VMWARE_MOUNT_IP_CONFIG_WIN);
                    _.extend(win.data, {
                        pgId: pgId,
                        vmIpConfigs: that.values
                    });
                    win.title = appUtils.getString("protection_mount_vm_ip_set_win_label");
                    appUtils.showWindow(win, function(){
                        //先校验参数是否正确
                        if (!UnifyValid.FormValid($("#vmware_mount_ip_config_win"), {
                                focusInvalid: true
                            })) {
                            return;
                        };
                        var tableData = $("#vmsTable").widget().getTableData();
                        var vaildFlag = true;
                        var ipconfigArray = [];
                        for (var i = 0; i < tableData.length; i++) {
                            var networkCardVal = tableData[i].netWorkCard;
                            if (_.isEmpty(networkCardVal)) {
                                continue;
                            };
                            var errorFlag = true;
                            //先校验
                            for(var j = 0; j < networkCardVal.length; j++){
                                if(networkCardVal[j].dhcpEnabled4 === false && networkCardVal[j].openIp4){
                                    if(!networkCardVal[j].ipv4.ipReg.test(networkCardVal[j].ipVal)){
                                        errorFlag = false;
                                        break;
                                    };
                                    if(!networkCardVal[j].netmask.maskReg.test(networkCardVal[j].netmaskVal)){
                                        errorFlag = false;
                                        break;
                                    };
                                    if(!networkCardVal[j].gateway.ipReg.test(networkCardVal[j].gatewayVal)){
                                        errorFlag = false;
                                        break;
                                    };
                                };
                                var obj = {
                                    ownerId: tableData[i].uuid,
                                    name: "IPV4:" + networkCardVal[j].macAddress,
                                    value: {
                                        nicMac: networkCardVal[j].macAddress,
                                        nicName: networkCardVal[j].nicName,
                                        openIp4: _.isUndefined(networkCardVal[j].openIp4) ? false : networkCardVal[j].openIp4,
                                        openIp6: _.isUndefined(networkCardVal[j].openIp6) ? false : networkCardVal[j].openIp6,
                                        dhcpEnabled4: _.isUndefined(networkCardVal[j].dhcpEnabled4) ? true : networkCardVal[j].dhcpEnabled4,
                                        dhcpEnabled6: _.isUndefined(networkCardVal[j].dhcpEnabled6) ? false : networkCardVal[j].dhcpEnabled6,
                                        ip: networkCardVal[j].dhcpEnabled4 === false ? networkCardVal[j].ipVal : "",
                                        ipv6List: (networkCardVal[j].dhcpEnabled6 !== true && networkCardVal[j].openIp6) ? networkCardVal[j].ipv6ListArrayValue() : [],
                                        netmask: networkCardVal[j].dhcpEnabled4 === false ? networkCardVal[j].netmaskVal : "",
                                        gateway: networkCardVal[j].dhcpEnabled4 === false ? networkCardVal[j].gatewayVal : "",
                                        gateway6: networkCardVal[j].dhcpEnabled6 !== true ? networkCardVal[j].gateway6Val : ""
                                    }
                                };
                                //linux
                                if(tableData[i].props.GUESTOSTYPE == "linuxGuest"){
                                    _.extend(obj.value, {
                                        autoDns4: _.isUndefined(tableData[i].autoDns4) ? true : tableData[i].autoDns4,
                                        autoDns6: _.isUndefined(tableData[i].autoDns6) ? true : tableData[i].autoDns6,
                                        preferredDns: tableData[i].autoDns4 === false ? tableData[i].preferredDns : "",
                                        preferredDns6: tableData[i].autoDns6 === false ? tableData[i].preferredDns6 : "",
                                        alternateDns: tableData[i].autoDns4 === false ? tableData[i].alternateDns : "",
                                        alternateDns6: tableData[i].autoDns6 === false ? tableData[i].alternateDns6 : ""
                                    })
                                }else{
                                    _.extend(obj.value, {
                                        autoDns4: _.isUndefined(networkCardVal[j].autoDns4) ? true : networkCardVal[j].autoDns4,
                                        autoDns6: _.isUndefined(networkCardVal[j].autoDns6) ? true : networkCardVal[j].autoDns6,
                                        preferredDns: networkCardVal[j].autoDns4 === false ? networkCardVal[j].preferredDns : "",
                                        preferredDns6: networkCardVal[j].autoDns6 === false ? networkCardVal[j].preferredDns6 : "",
                                        alternateDns: networkCardVal[j].autoDns4 === false ? networkCardVal[j].alternateDns : "",
                                        alternateDns6: networkCardVal[j].autoDns6 === false ? networkCardVal[j].alternateDns6 : ""
                                    })
                                };
                                ipconfigArray.push(obj);
                            };
                            if("windowsGuest" == tableData[i].props.GUESTOSTYPE){
                                var userObj = {
                                    ownerId: tableData[i].uuid,
                                    name: "PO_OS_NAMEPASSWORD",
                                    value: {
                                        username: tableData[i].userNameVal,
                                        password: tableData[i].passwordVal
                                    }
                                };
                                ipconfigArray.push(userObj);
                            };
                            if(!errorFlag){
                                vaildFlag = false;
                                break;
                            };
                        };
                        if(!vaildFlag){
                            message.error(appUtils.getString("lego.err.856064"));
                            return;
                        };
                        that.values = angular.copy(ipconfigArray);
                        $scope.$apply();
                        $("#" + constsService.VMWARE_MOUNT_IP_CONFIG_WIN.winId).widget().destroy();
                    });
                },
                getValue: function(){
                    return this.values;
                },
            },
            excuteTimeSelect: {
                id: "excuteTime",
                label: appUtils.getStringWithColon("dataMount_create_mountmoument_lable"),
                width: constsService.W4,
                values: [{
                    "selectId": "1",
                    "label": appUtils.getString("dataMount_create_executeimmediately_lable")
                }, {
                    "selectId": "2",
                    "label": appUtils.getString("dataMount_create_executeappointment_lable")
                }],
                defaultSelectid: "1",
                closeFn: function() {
                    $scope.model.excuteDate.show = $("#" + this.id).widget().getSelectedId() == "2";
                    $scope.$apply();
                },
                getValue: function() {
                    return $("#" + this.id).widget().getSelectedId();
                }
            },
            excuteDate: {
                "id": "excuteDate",
                "key": "startTime",
                "show": false,
                "type": "datetime",
                "dateFormat": 'yy-mm-dd',
                "timeFormat": "hh:mm:ss",
                getValue: function() {
                    //不下发或者为空为立即执行
                    return $scope.model.excuteTimeSelect.getValue() == "1" ? "" : $("#" + this.id).widget().getDateTime();
                },
                vaildFn: function() {
                    return !(this.show && $("#" + this.id).widget().getDateTime() == "");
                },
                showVaild: true,
                "errorMsg": appUtils.getString("validate_select_value_label", "dataMount_create_mountmoument_lable"),
            },
            createDuplicaSecond: {
                id: "createDuplicaSecond",
                text: appUtils.getString("dataMount_create_createduplicasecond_lable"),
                tips: appUtils.getString("dataMount_create_createduplicasecond_tip_lable"),
                show: true,
                checked: false,
                disable: false,
                click: function() {
                    $scope.model.createDuplicaType.show = $("#" + this.id).widget().option("checked");
                },
            },
            createDuplicaType: {
                id: "createDuplicaType",
                key: "targetReplicaType",
                tips: appUtils.getString("dataMount_create_createDuplicaType_lable"),
                tipShow: true,
                tips_snapsho: appUtils.getString("dataMount_createDuplicaType_snapshot_tip_lable"),
                tips_snapsho_show: false,
                tips_FSB: appUtils.getString("dataMount_createDuplicaType_fsb_tip_lable"),
                tips_FSB_show: false,
                defaultSelectid: "3",
                width: constsService.W4,
                show: false,
                values: [{
                    "selectId": "10",
                    "label": appUtils.getString("datamount_targetReplicaType_snapshot_label"),
                }, {
                    "selectId": "3",
                    "label": appUtils.getString("dataMount_create_snapshot_mount_lable"),
                }],
                showVaild: false,
                vaildFn: function() {
                    return $("#" + this.id).widget().getSelectedId() != "-1";
                },
                "errorMsg": appUtils.getString("validate_select_value_label", "dataMount_abstract_replicatype_lable"),
                closeFn: function() {},
                getValue: function() {
                    return this.show ? $("#" + this.id).widget().getSelectedId() : "-1"
                }
            },
            senior: {
                text: appUtils.getString("common_term_advance_button"),
                show: true,
                seniorShow: false,
                click: function() {
                    this.seniorShow = !this.seniorShow;
                }
            },
            umountSelect: {
                id: "umountSelect",
                key: "unmountPreviousCopy",
                text: appUtils.getString("protection_unmount_previous_copy_label"),
                tips: appUtils.getString("create_mount_umountselect_tip_label"),
                checked: true,
                show: true,
                click: function() {
                    var enabled = $("#" + this.id).widget().option("checked");
                    $scope.model.deleteSelect.show = enabled;
                    if(!enabled){
                            message.prompt({
                                content: appUtils.getString("dataMount_create_unmount_previous_copy_tip_lable"),
                                ok: function() {
                                    appUtils.closeWin(true);
                                }
                            });
                    }

                },
                getValue: function() {
                    return $("#" + this.id).widget().option("checked");
                }
            },
            deleteSelect: {
                id: "deleteSelect",
                key: "deleteReplica",
                text: appUtils.getString("protection_delete_copy_postvious_unmount_label"),
                tips: appUtils.getString("create_mount_deleteselect_tip_label"),
                checked: true,
                show: true,
                getValue: function() {
                    return $("#" + this.id).widget().option("checked");
                }
            },
            startDataBase: {
                id: "startDataBase",
                key: "startDB",
                text: appUtils.getString("protection_startDb_after_mount_label"),
                checked: false,
                show: true,
                getValue: function() {
                    return $("#" + this.id).widget().option("checked");
                }
            },
            scriptCheck: {
                text: appUtils.getString("protection_mount_script_label"),
                scriptShow: false,
                show: true,
                click: function() {
                    this.scriptShow = !this.scriptShow;
                }
            },
            preScript: {
                id: "preScript",
                width: constsService.W4,
                show: true,
                validate: [{
                    validFn: "minSize",
                    params: [4],
                    errorDetail: appUtils.getString("validate_term_script")
                }, {
                    validFn: "maxSize",
                    params: [32],
                    errorDetail: appUtils.getString("validate_term_script")
                }, {
                    validFn: "isScript",
                    errorDetail: appUtils.getString("validate_term_script")
                }],
                getValue: function() {
                    return $("#" + this.id).widget().getValue();
                }
            },
            postScript: {
                id: "postScript",
                width: constsService.W4,
                validate: [{
                    validFn: "minSize",
                    params: [4],
                    errorDetail: appUtils.getString("validate_term_script")
                }, {
                    validFn: "maxSize",
                    params: [32],
                    errorDetail: appUtils.getString("validate_term_script")
                }, {
                    validFn: "isScript",
                    errorDetail: appUtils.getString("validate_term_script")
                }],
                getValue: function() {
                    return $("#" + this.id).widget().getValue();
                }
            },
            volumeType: {
                id: "volumeType",
                width: constsService.W4,
                defaultSelectid:"SATA",
                show:false,
                text: appUtils.getStringWithColon("datamount_create_volumetype_label"),
                values: [{
                    "selectId": "SATA",
                    "label": appUtils.getString("datamount_create_sata_label")
                }, {
                    "selectId": "SAS",
                    "label": appUtils.getString("datamount_create_sas_label"),
                }, {
                    "selectId": "SSD",
                    "label": appUtils.getString("datamount_create_ssd_label"),
                }],
                getValue: function() {
                    return $scope.model.mountHostSelect.buyECSShow ? $("#" + this.id).widget().getSelectedId() : "-1";
                }
            },
            volumeTypeCheck: {
                id: "volumeTypeCheck",
                show:false,
                text: appUtils.getString("datamount_create_volumetype_tip_label"),
                checked: true,
                change: function() {
                    $("#btnOk").widget().option("disable", !$("#"+this.id).widget().option("checked"));
                },
            },
            btnOk: {
                id: "btnOk",
                text: appUtils.getString("common_term_confirm_button"),
                click: function() {
                    if (!UnifyValid.FormValid($("#createDataMountContainer"), {
                            focusInvalid: true
                        })) {
                        return;
                    };
                    var validateFlag = true;
                    var createParams = {};
                    //数据收集
                    $.each($scope.model, function(index, item) {
                        if (_.isFunction(item.vaildFn) && !item.vaildFn() && item.showVaild) {
                            !_.isEmpty(item.errorMsg) && message.error(item.errorMsg);
                            validateFlag = false;
                            return false;
                        };
                        if (!_.isEmpty(item.key) && _.isFunction(item.getValue)) {
                            createParams[item.key] = item.getValue();
                            if (item.key == "targetReplicaType" && !($scope.model.createDuplicaType.show && $scope.model.createDuplicaSecond.show && !$scope.model.duplicaListTable.isCloudBackupDuplica)) {
                                createParams[item.key] = "-1";
                            }
                            if (item.key == "unmountPreviousCopy" && !($scope.model.senior.show && $scope.model.umountSelect.show)) {
                                delete createParams[item.key];
                            }
                            if (item.key == "deleteReplica" && !($scope.model.senior.show && $scope.model.deleteSelect.show)) {
                                delete createParams[item.key];
                            }
                            if (item.key == "startDB" && !(($scope.vmwareType || $scope.appType) && !$scope.model.mountSiteSelect.isCloudSite)) {
                                delete createParams[item.key];
                            }
                        };
                    });
                    createParams.processors = [];
                    if (!_.isEmpty($scope.model.preScript.getValue())) {
                        createParams.processors.push({
                            procName: "mountPreProcessor",
                            isPreset: false,
                            props: {
                                scriptName: $scope.model.preScript.getValue()
                            }
                        })
                    };
                    if (!_.isEmpty($scope.model.postScript.getValue())) {
                        createParams.processors.push({
                            procName: "mountPostProcessor",
                            isPreset: false,
                            props: {
                                scriptName: $scope.model.postScript.getValue()
                            }
                        })
                    };
                    if(!_.isEmpty($scope.model.volumeType.getValue()) && $scope.model.mountHostSelect.buyECSShow) {
                        createParams.extParameters = {};
                        createParams.extParameters.volumeType = $scope.model.volumeType.getValue();
                    }
                    //vmware和应用区分开
                    if ($scope.vmwareType) {
                        createParams.hostOrGroupSn = createParams.cluster.remoteHostId;
                        var testHosts = [_.extend({}, createParams.vCenter, createParams.cluster)];
                        createParams.extParameters = {
                            testNetwork: angular.toJson(createParams.testNetwork),
                            testHosts: angular.toJson(testHosts)
                        };
                        if (!_.isEmpty(createParams.vmIp)) {
                            _.each(createParams.vmIp, function(vmItem){
                                !_.isString(vmItem.value) && (vmItem.value = angular.toJson(vmItem.value))
                            });
                            _.extend(createParams.extParameters, {
                                mountSettings: angular.toJson(createParams.vmIp)
                            })
                        };
                    };
                    delete createParams.cluster;
                    delete createParams.testNetwork;
                    delete createParams.vCenter;
                    delete createParams.vmIp;
                    if (!validateFlag) {
                        return;
                    };
                    //如果选择的是快照，需要给出高危提示！！！rkks
                    if ($scope.model.createDuplicaType.show && "10" == createParams.targetReplicaType) {
                        message.warn({
                            content: appUtils.getString("datamount_create_snap_duplica_warn_label"),
                            ok: function() {
                                restService.creatMountPlan([], {
                                    data: createParams,
                                    success: function() {
                                        message.success({
                                            content: appUtils.getString("recovery.messsage.operate.successd"),
                                            ok: function() {
                                                infoTransferredService.put("wizard", "isFinish", true);
                                                $state.go("dataUse.dataMount.abstract");
                                            }
                                        });
                                    }
                                });
                            }
                        });
                        return;
                    };
                    restService.creatMountPlan([], {
                        data: createParams,
                        success: function() {
                            message.success({
                                content: appUtils.getString("recovery.messsage.operate.successd"),
                                ok: function() {
                                    infoTransferredService.put("wizard", "isFinish", true);
                                    $state.go("dataUse.dataMount.abstract");
                                }
                            });
                        }
                    })
                }
            },
            btnCancel: {
                id: "btnCancel",
                text: appUtils.getString("common_term_cancel_button"),
                click: function() {
                    $state.go("dataUse.dataMount.abstract");
                }
            }
        }
        appUtils.exitWizardConfirm();
    }];
    var module = angular.module('recoverydirector.recovery.config');
    module.tinyController('dataUse.createDataMount.ctrl', ctrl);
    return module;
})
