define(["tiny-common/UnifyValid"], function(UnifyValid) {
    var ctrl = [
        "$scope",
        "constsService",
        "appUtils",
        "restService",
        "statusEnumService",
        "message",
        "restService",
        "$compile",
        "servicesPlugin",
        function($scope, constsService, appUtils, Rest, statusEnumService, message, restService, $compile, servicesPlugin) {
            var data = $("#" + constsService.CREATE_DATAMOUNT_PROTECT_LIST_WIN.winId).widget().option("data");
            $scope.datasTable = {
                id: "planlist",
                data: [],
                operateButtonCount: 2,
                buttonContainerPositions: "left",
                displayLength: constsService.TABLE_COUNT_PER_PAGE,
                totalRecords: 0,
                currPage: {
                    pageIndex: 1
                },
                pageSize: constsService.TABLE_COUNT_PER_PAGE,
                paginationStyle: "full_numbers",
                paging: "auto",
                columns:
                    [{
                    "mData": "uuid",
                    "bVisible": false
                    }, {
                        "sTitle":appUtils.getString("ism.drm.proetct.group.appdb.dbname.column"),
                        "mData": "name"
                    }, {
                        "sTitle": appUtils.getString("ism.drm.proetct.group.appdb.instance.column"),
                        "mData": "props.INSTANCENAME",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("ism.drm.site.host"),
                        "mData": "providerName",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("ism.drm.proetct.group.appdb.version.column"),
                        "mData": "props.VERSION",
                        "bSortable": false
                    }],

                callback: function(evtObj) {},
                sortCallback: function(th, sortObj) {},
                renderRow: function(nRow, aData, iDataIndex) {},
                cellClickActive: function(e, param) {},
                hoverActive: function(e, param) {},
            };
            $scope.model = {
                searchSelect: {
                    "id": "searchSelect",
                    "values": [{
                        selectId: "name",
                        label: appUtils.getString("site_backuprespo_protectplan_label")
                    }, {
                        selectId: "productSiteId",
                        label: appUtils.getString("site.term.localSite.label")
                    }],
                    "display": true,
                    "disable": false,
                    "showTip": true,
                    "isSearchbox": true,
                    "defaultSelectid": "name",
                    "textWidth": constsService.W2,
                    "width": constsService.W2,
                    "change": function() {
                        var widget = $("#searchSelect").widget(),
                            searchId = widget.getSelectedId();
                        if (searchId == "productSiteId") {
                            this.isSearchbox = false;
                            //查询站点信息
                            var textOptions = {
                                "id": "siteChoice",
                                "values": [{
                                    "selectId": "",
                                    "label": appUtils.getString("common_term_all_label")
                                }],
                                "default-selectid": ""
                            };
                            restService.queryLocalServer([], function(data) {
                                if (data) {
                                    restService.querySites([data.uuid], function(data) {
                                        if (!_.isEmpty(data)) {
                                            _.each(data, function(item) {
                                                textOptions.values.push({
                                                    "selectId": item.siteId,
                                                    "label": item.name
                                                });
                                            })
                                        };
                                        widget.changeTextBox(false, textOptions);
                                    });
                                }
                            });
                        } else {
                            this.isSearchbox = true;
                            widget.changeTextBox(true);
                        }
                    },
                    "click": function() {
                        var that = this;
                        var _filterName = $("#" + that.id).widget().getSelectedId(),
                            _filterValue;
                        if (that.isSearchbox) {
                            _filterValue = $.encoder.encodeForURL($.trim($("#" + that.id).widget().getSearchboxValue().inputValue));
                        } else {
                            _filterValue = $("#siteChoice").widget().getSelectedId();
                        }
                        queryProtectPlan(undefined, {
                            _filterName: _filterName,
                            _filterValue: _filterValue
                        });
                    }
                },
                protectedPlanList: {
                    "id": "protectedPlanList",
                    "key": "protectGroupId",
                    "columns": [{
                        "sTitle": appUtils.getString("site_backuprespo_protectplan_label"),
                        "mData": "name",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("recovery.term.colum.type.title"),
                        "mData": "poType",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("group_count_term_product_site_column"),
                        "mData": "productSiteName",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("group_count_term_poliy_templet_column"),
                        "mData": "template.type",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("group_count_term_protect_object_column"),
                        "mData": "poList",
                        "bSortable": false
                    }],
                    "data": [],
                    enablePagination: false,
                    renderRow: function(nRow, aData, iDataIndex) {
                        $("td[tdtitle='" + appUtils.getString("recovery.term.colum.type.title") + "']", nRow).html(statusEnumService.getStatus("PROTECT_OBJECT_TYPE", aData.poType));
                        $("td[tdtitle='" + appUtils.getString("group_count_term_poliy_templet_column") + "']", nRow).html(statusEnumService.getStatus("POLICY_TEMPLET_STATUS", aData.template.type));
                        var optColumn = "<a href='javascript:void(0)' class='btn-link' ng-click='showProtectObj()'>" + appUtils.getString('common_term_view_button') + "</a> ";
                        var optLink = $compile($(optColumn));
                        var optScope = $scope.$new();
                        optScope.showProtectObj = function() {
                            var win = angular.copy(constsService.DATAMOUNT_CTEATE_PRO_OBJ_WIN);
                            win.title = appUtils.getString(win.title);
                            win.data = aData;
                            win.buttons = [{
                                key: "cancel",
                                label: appUtils.getString('common_term_close_button'),
                                focused: true,
                                handler: function(event) {
                                    $("#" + win.winId).widget().destroy();
                                }
                            }];
                            appUtils.showWindow(win)
                        };
                        var optNode = optLink(optScope);
                        $("td[tdtitle='" + appUtils.getString("group_count_term_protect_object_column") + "']", nRow).html(optNode);
                    },
                    callback: function(evtObj) {
                    },
                    cellClickActive: function(event, trData) {

                    },
                    showVaild: true,
                    vaildFn: function() {
                        var checkedPg = _.first($("#" + this.id).widget().getTableCheckedItems());
                        return !_.isEmpty(checkedPg);
                    },
                    "errorMsg": appUtils.getString("validate_select_value_label", "site_backuprespo_protectplan_label"),
                    getValue: function() {
                        var checkedPg = _.first($("#" + this.id).widget().getTableCheckedItems());
                        return _.isEmpty(checkedPg) ? "" : checkedPg.pgId;
                    }
                },
            }
            var pleaseSelectVal = [{
                "selectId": "-1",
                "label": appUtils.getString("common_term_pleaseSelect_listbox")
            }];
            var queryProtectPlan = function(poType, queryCondition) {
                restService.queryProtectGroups({
                    poType: poType,
                    _PAGE: appUtils.queryFilter(0, 520),
                    _FILTER: !_.isEmpty(queryCondition) ? "filterName=" + encodeURIComponent(queryCondition._filterName) + "&filterValue=" + encodeURIComponent(queryCondition._filterValue) : ""
                }, function(result) {
                    if (!_.isEmpty(result) && !_.isEmpty(result.records)) {
                        var records = [];
                        _.each(angular.copy(result.records), function(pg, key) {
                            if (!_.contains([2,19,30,31,32], parseInt(pg.template.type, 10)) || pg.poType == 12) {
                                return;
                            }
                            this.push(pg);
                        }, records);
                        $scope.model.protectedPlanList.data = appUtils.encodeForHTML(records);
                        $scope.model.protectedPlanList.totalRecords = _.size(records);
                        $scope.model.protectedPlanList.enablePagination = _.size(records) > 10;
                    } else {
                        $scope.model.protectedPlanList.data = [];
                        $scope.model.protectedPlanList.totalRecords = 0;
                        $scope.model.protectedPlanList.enablePagination = false;
                    };
                    $scope.$apply();
                });
            };
            queryProtectPlan();
        }
    ]

    var module = angular.module("recoverydirector.recovery.config");
    module.tinyController("dataMount.ProtectListCtrl", ctrl);
    return module;
})