define(["tiny-common/UnifyValid"], function(UnifyValid) {
    var ctrl = [
        "$scope",
        "constsService",
        "appUtils",
        "restService",
        "statusEnumService",
        "message",
        "model",
        function($scope, constsService, appUtils, Rest, statusEnumService, message, Model) {
        	var data = $("#" + constsService.DATAMOUNT_CTEATE_PRO_OBJ_WIN.winId).widget().option("data");
            var lunColumn = [{
                "mData": "uuid",
                "bVisible": false
            },{
                "sTitle": appUtils.getString("common_term_name_label"),
                "mData": "name"
            },{
                "sTitle" : "WWN",
                "mData" : "props.lunWwn",
                "bSortable" : false
            },{
                "sTitle": appUtils.getString("ism.drm.drp.instance.storage"),
                "mData": "providerName",
                "bSortable": false
            },{
                "sTitle": appUtils.getString("ism.drm.host.fs.capacity"),
                "mData": "props.totalCapacityAndUnit",
                "bSortable": false
            }];
            var vmwareColumn = [{
                "mData": "uuid",
                "bVisible": false
            },{
                "sTitle": appUtils.getString("common_term_name_label"),
                "mData": "name"
            },{
                "sTitle": appUtils.getString("common.term.vCenter.tab"),
                "mData": "providerName",
                "bSortable": false
            },{
                "sTitle": appUtils.getString("common_term_system_label"),
                "mData": "props.GUSTOS",
                "bSortable": false
            },{
                "sTitle": appUtils.getString("ism.drm.proetct.group.appdb.status.column"),
                "mData": "poStatus",
                "bSortable": false
            }];
            $scope.datasTable = {
                id: "datasTable",
                data: [],
                operateButtonCount: 2,
                buttonContainerPositions: "left",
                displayLength: constsService.TABLE_COUNT_PER_PAGE,
                totalRecords: 0,
                currPage: {
                    pageIndex: 1
                },
                pageSize: constsService.TABLE_COUNT_PER_PAGE,
                paginationStyle: "full_numbers",
                paging: "auto",
                columns:
                    [{
                    "mData": "uuid",
                    "bVisible": false
                    }, {
                        "sTitle":appUtils.getString("ism.drm.proetct.group.appdb.dbname.column"),
                        "mData": "name"
                    }, {
                        "sTitle": appUtils.getString("ism.drm.proetct.group.appdb.instance.column"),
                        "mData": "props.INSTANCENAME",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("ism.drm.site.host"),
                        "mData": "providerName",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("ism.drm.proetct.group.appdb.version.column"),
                        "mData": "props.VERSION",
                        "bSortable": false
                    }],

                callback: function(evtObj) {},
                sortCallback: function(th, sortObj) {},
                renderRow: function(nRow, aData, iDataIndex) {
                    //oracle显示实例名称
                    if (aData.poType == 1) {
                        try {
                            var instancename = aData.props && aData.props.INSTANCENAME;
                            $("td[tdtitle='" + appUtils.getString("ism.drm.proetct.group.appdb.instance.column") + "']", nRow).text(Model.util.formatIstName(instancename));
                        } catch (err) {
                            $("td[tdtitle='" + appUtils.getString("ism.drm.proetct.group.appdb.instance.column") + "']", nRow).text("");
                        }
                    };
                    //vmware相关参数
                    if (aData.poType == 10) {
                        try {
                            var status = "--";
                            if (aData.poStatus == 98) {
                                status = "ism.drm.protect.group.replica.status.error";
                            } else if (aData.poStatus == 99) {
                                status = "VMware_status_value_notSupport_value";
                            } else {
                                status = "common_term_status_normal_label";

                            };
                            $("td[tdtitle='" + appUtils.getString("ism.drm.proetct.group.appdb.status.column") + "']", nRow).text(appUtils.getString(status));
                            $("td[tdtitle='" + appUtils.getString("common_term_system_label") + "']", nRow).html("UNKNOWN" == aData.props.GUSTOS ? appUtils.getString("common_term_unknow_label") : aData.props.GUSTOS);
                        } catch (err) {
                            $("td[tdtitle='" + appUtils.getString("ism.drm.proetct.group.appdb.status.column") + "']", nRow).text("");
                            $("td[tdtitle='" + appUtils.getString("common_term_system_label") + "']", nRow).html("");
                        };
                    };
                },
                cellClickActive: function(e, param) {},
                hoverActive: function(e, param) {},
            };
            data.poType == 11 && ($scope.datasTable.columns = lunColumn);
            data.poType == 10 && ($scope.datasTable.columns = vmwareColumn);
            var _queryProtectObj = function(){
                var page=1,orderBy,orderType;
                var oQuery = {
                    protectgroupId : data.pgId,
                    _PAGE : appUtils.queryFilter(page-1,10,orderBy,orderType),
                    poType: data.poType
                };
                Rest.queryProtectObjectsByPage(oQuery, {
                    mask: true,
                    callback: function() {
                    },
                    success: function(data) {
                        $scope.datasTable.data = data.records;
                        $scope.$apply();
                    }
                })
            };
            _queryProtectObj();
        }
    ]

    var module = angular.module("recoverydirector.recovery.config");
    module.tinyController("dataMount.ProtectObjectsCtrl", ctrl);
    return module;
})