define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrler = [
        "$scope",
        "$compile",
        "$state",
        "message",
        "mask",
        "constsService",
        "statusEnumService",
        "appUtils",
        "restService",
        function($scope, $compile, $state, message, mask, constsService, statusEnumService, appUtils, restService) {
            $scope.configformTitle = appUtils.getString("menus_create_recovery_title");
            $scope.configformInstruction = appUtils.getString("recoveryPlan_create_instruction");
            $scope.btnOk = {
                id: "btnCreateOk",
                text: appUtils.getString("common_term_confirm_button"),
                click: function() {
                    if (!UnifyValid.FormValid($("#createRecoveryPlanBaseInfo"), {focusInvalid: true})) {
                        return;
                    }
                    var params = {};
                    params.name = $.trim($("#planName").widget().getValue());
                    params.description = $.trim($("#description").widget().getValue());

                    var checkItem = $("#unusedProtectedTable").widget().getTableCheckedItems();
                    if (_.isEmpty(checkItem)) {
                        message.error(appUtils.getString("recovery.term.recovery.protectGroup.message.least"));
                        return;
                    }
                    var protectedSets = [];
                    protectedSets.push({
                        uuid: _.first(checkItem).uuid
                    });
                    params.protectGroups = protectedSets;
                    restService.createRecovery([], {
                        data: params,
                        success: function(data) {
                            message.success({
                                content: appUtils.getString("recovery.messsage.operate.successd"),
                                ok: function() {
                                    $state.go("dataUse.dataRecovery.abstract");
                                }
                            });
                        }
                    });
                }
            };

            $scope.btnCancel = {
                id: "btnCreateCancel",
                text: appUtils.getString("common_term_cancel_button"),
                click: function() {
                    $state.go("dataUse.dataRecovery.abstract");
                }
            };

            $scope.model = {
                labels: {
                    name: appUtils.getStringWithColon("recovery.term.createPlan.name.label"),
                    description: appUtils.getStringWithColon("recovery.term.createPlan.description.label"),
                    unusedProtected: appUtils.getStringWithColon("recovery_protected_plan_label")
                },
                tbName: {
                    id: "planName",
                    width: constsService.W4,
                    value: "",
                    "require": true,
                    "validate": constsService.VALID.NAME
                },
                tbDescription: {
                    id: "description",
                    type: "multi",
                    height: constsService.DESCR_HEIGHT,
                    width: constsService.W4,
                    labelcls: "label-middle",
                    "validate": constsService.VALID.DES_REMARK
                }
            };

            $scope.unusedProtectedTable = {
                "id": "unusedProtectedTable",
                "columns": [{
                    "mData": "uuid",
                    "bVisible": false
                }, {
                    "sTitle": appUtils.getString("recovery.term.colum.name.title"),
                    "mData": "name",
                    "bSortable": true
                }, {
                    "sTitle": appUtils.getString("recovery.term.colum.type.title"),
                    "mData": "poType",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("recovery.term.colum.productionSite.title"),
                    "mData": "productSiteName",
                    "bSortable": true
                }, {
                    "sTitle": appUtils.getString("ism.drm.protect.group.template"),
                    "mData": "templateName",
                    "bSortable": false
                }],
                data: [],
                renderRow: function(nRow, aData, iDataIndex) {
                    $("td[tdtitle='" + appUtils.getString("recovery.term.colum.type.title") +
                        "']", nRow).html(statusEnumService.getStatus("PROTECT_OBJECT_TYPE", aData['poType']));
                }
            }

            restService.getProtectGroups([], function(data) {
                var arr = [];
                _.each(data, function(d) {
                    var tmo = _.pick(d, "uuid", "name", "poType", "productSiteName");
                    !_.isUndefined(d.template) && (tmo.templateName = appUtils.getString(d.template.name));
                    arr.push(tmo);
                });
                $scope.unusedProtectedTable.data = appUtils.encodeForHTML(arr);
                $scope.$apply();
            });

            setTimeout(function() {
                $("#tiny-menu .recovery").closest("h1").addClass("menu_active");
            });

        }
    ];
    var module = angular.module('recoverydirector.recovery.config');
    module.tinyController('dataUse.createRecoveryPlan.ctrl', ctrler);
    return module;
})
