define([], function() {
    "use strict";
    var editCtrl = [
        "$scope",
        "constsService",
        "appUtils",
        "utilService",
        function($scope, constsService, appUtils, utilService) {
            var widget = $("#" + constsService.EDIT_RECOVERY.winId).widget().option("data");
            var startTime = _.isEmpty(widget.globalSettings) ? "": !_.isEmpty(widget.globalSettings.StartTime) ? widget.globalSettings.StartTime : "";

            if (Object.prototype.toString.call(widget.name) === "[object Null]") {
                widget.name = "null";
            }

            if (Object.prototype.toString.call(widget.description) === "[object Null]") {
                widget.description = "null";
            }

            $scope.model = {
                labels: {
                    name: appUtils.getStringWithColon("recovery.term.createPlan.name.label"),
                    description: appUtils.getStringWithColon("recovery.term.createPlan.description.label"),
                    mountTime: appUtils.getStringWithColon("dataMount_create_mountmoument_lable")
                },
                name: {
                    id: "planName",
                    value: widget.name,
                    require: true,
                    width: constsService.W4,
                    validate: constsService.VALID.NAME
                },
                description: {
                    id: "description",
                    value: widget.description,
                    type: "multi",
                    height: constsService.DESCR_HEIGHT,
                    width: constsService.W4,
                    labelcls: "label-middle",
                    validate: constsService.VALID.DES_REMARK
                },
                mountTimeSelect: {
                    id: "mountTimeSelect",
                    display: !_.isUndefined(widget.isModifyMountPlan) && widget.isModifyMountPlan,
                    width: constsService.W2,
                    values: [{
                        "selectId": "1",
                        "label": appUtils.getString("dataMount_create_executeimmediately_lable")
                    }, {
                        "selectId": "2",
                        "label": appUtils.getString("dataMount_create_executeappointment_lable")
                    }],
                    defaultSelectid:_.isEmpty(startTime) ? "1" : "2",
                    closeFn: function() {
                        $scope.model.excuteDate.show = $("#" + this.id).widget().getSelectedId() == "2";
                        $scope.model.excuteDate.show && _.isEmpty(startTime) && $("#excuteDate").widget().empty();
                        $scope.$apply();
                    },
                },
                excuteDate: {
                    "id": "excuteDate",
                    "show": false,
                    "width": constsService.W2 + 3,
                    "type": "datetime",
                    "dateFormat": 'yy-mm-dd',
                    "timeFormat": "hh:mm:ss",
                    "defaultDate": startTime,
                    "defaultTime": startTime
                }
            };

             $scope.model.excuteDate.show =  !_.isEmpty(startTime);


        }]
    var editRecoveryPlanApp = angular.module("recoverydirector.recovery.config");
    editRecoveryPlanApp.tinyController("app.edit.recovery.plan.ctrl", editCtrl);
    return editRecoveryPlanApp;
})