define(["tiny-extra-lib/jquery.base64"], function() {
    "use strict";
    var fcSansnapshotCtrl = [
        "$scope",
        "restService",
        "cookieService",
        "communicationService",
        "utilService",
        "exception",
        "constsService",
        "mask",
        "message",
        "appUtils",
        "infoTransferredService",
        function($scope, restService, cookieService, communicationService, utilService, exception, constsService, mask, message, appUtils, infoTransferredService) {
            var winData = $("#" + constsService.FUSIONSPHERE_LOCAL_EXECUTE.winId).widget().option("data"),
                pleaseSelect_label = appUtils.getString("common_term_pleaseSelect_listbox"),
                selectDefaultVal = [{
                    "selectId": "-1",
                    "label": pleaseSelect_label,
                    checked: true
                }],
                summerys = [{
                    valueId: "srcSiteId",
                    value: "",
                    nameId: "srcSiteName",
                    name: "--",
                    key: appUtils.getStringWithColon("recovery.term.abstact.productionSiteLabel")
                }, {
                    valueId: "srcCloudId",
                    value: "",
                    nameId: "srcCloudName",
                    name: "--",
                    key: appUtils.getStringWithColon("recovery.term.productFusionsphere.label")
                }, {
                    valueId: "srcHostId",
                    nameId: "srcHostName",
                    name: "--",
                    key: appUtils.getStringWithColon("recovery.term.productionCluster.label")
                }],
                commonUtils = {
                    formatDataToSelect: function(domId, data, idKey, labelKey, defaultVal) {
                        if (_.isEmpty(data) || !_.isArray(data) || (data.length == 1 && _.isEmpty(data[0][idKey]) && _.isEmpty(data[0][labelKey]))) {
                            $("#" + domId).widget().option("values", [{
                                "selectId": "-1",
                                "checked": true,
                                "label": defaultVal
                            }]);
                            return;
                        }

                        var vals = [];
                        _.each(data, function(item, index) {
                            if (Object.prototype.toString.call(item[labelKey]) === "[object Null]") {
                                vals.push({
                                    selectId: item[idKey],
                                    label: "null",
                                    checked: index == 0
                                });
                            } else {
                                vals.push({
                                    selectId: item[idKey],
                                    label: item[labelKey],
                                    checked: index == 0
                                });
                            }
                        });
                        $("#" + domId).widget().option("values", vals);
                    },
                    networkMapping: {
                        tableData: [],
                        tableId: "",
                        updateTable: function(tableId, searchVal) {
                            if (_.isEmpty(this.tableData)) {
                                this.tableData = _.clone($("#" + tableId).widget().getTableData());
                                this.tableId = tableId;
                            }

                            if (tableId != this.tableId) {
                                this.tableData = [];
                                this.tableId = "";
                                this.tableData = _.clone($("#" + tableId).widget().getTableData());
                                this.tableId = tableId;
                            }

                            var result = [];
                            _.each(this.tableData, function(obj) {
                                if (obj.name.toUpperCase().indexOf(searchVal.toUpperCase()) != -1) {
                                    result.push(obj);
                                }
                            });
                            $("#" + tableId).widget().option("data", result);
                        },
                        changePairStatus : function(){
                            var selectCount = 0,statusClass = {
                                0: "resource-unpaired png",
                                1: "resource-unselect-all-paired png",
                                2: "resource-paired png"
                            },
                            statusSpan = {
                                0: appUtils.getString("common_term_add_mapping_unmapped"),
                                1: appUtils.getString("common_term_add_mapping_mapping"),
                                2: appUtils.getString("common_term_add_mapping_mapped")
                            };

                            var hasEmptyTable = false;
                            $.each(tableViewSites, function(index) {
                                    var tableId = this.table.id;
                                    var tableData = $("#" + tableId).widget().getTableData();
                                    if(_.isEmpty(tableData)) {
                                        hasEmptyTable = true;
                                        return false;
                                    }

                                    var select = $("#" + tableId).widget().getTableCheckedItems();
                                    if (!angular.isArray(select) || 0 == select.length) {
                                        return;
                                    }
                                    selectCount ++;
                            });

                            if(hasEmptyTable) {
                                $scope.fcExecuteScope.networkMapping.pairStatusSpan = statusSpan[0];
                                if($("#fusionCom_pairStatusId").hasClass(statusClass[1])){
                                    $("#fusionCom_pairStatusId").removeClass(statusClass[1]).addClass(statusClass[0]);
                                }
                                $("#fusionCom_pairStatusId").removeClass(statusClass[2]).addClass(statusClass[0]);
                            } else {
                                $scope.fcExecuteScope.networkMapping.pairStatusSpan = statusSpan[selectCount];
                                if(selectCount==1){
                                    if($("#fusionCom_pairStatusId").hasClass(statusClass[2])){
                                        $("#fusionCom_pairStatusId").removeClass(statusClass[2]).addClass(statusClass[1]);
                                    }
                                    $("#fusionCom_pairStatusId").removeClass(statusClass[0]).addClass(statusClass[1]);
                                };
                                if(selectCount==2){
                                    if($("#fusionCom_pairStatusId").hasClass(statusClass[1])){
                                        $("#fusionCom_pairStatusId").removeClass(statusClass[1]).addClass(statusClass[2]);
                                    }
                                    $("#fusionCom_pairStatusId").removeClass(statusClass[0]).addClass(statusClass[2]);
                                }
                            };
                            if(selectCount == 2) {
                                $scope.fcExecuteScope.networkMapping.addBtn.disable = false;
                                $("#addBtn").css("border", "1px solid #53B8EB");
                            } else {
                                $scope.fcExecuteScope.networkMapping.addBtn.disable = true;
                                $("#addBtn").css("border", "1px solid #c3c3c3");
                            };
                            $scope.$apply();
                        },
                        addRow: function() {
                            var errorMsg;
                            var addObj = {
                                id: [],
                                name: []
                            };
                            $.each(tableViewSites, function(index) {
                                var tableId = this.table.id;
                                var select = $("#" + tableId).widget().getTableCheckedItems();
                                if (!_.isArray(select) || 0 == select.length) {
                                    if (appUtils.isEn()) {
                                        errorMsg = pleaseSelect_label + " " + angular.lowercase(this.title.replace(":", "")) + ".";
                                        return false;
                                    }
                                    errorMsg = pleaseSelect_label + this.title.replace(":", "") + "。";
                                    return false;
                                }
                                addObj.name.push(select[0].name);
                                addObj.id.push(select[0].id);
                            });

                            if (!_.isUndefined(errorMsg)) {
                                message.error(errorMsg);
                                return;
                            }

                            $("#mappingViewTable").widget().addTableRows(addObj);

                            var prowidget = $("#productionResTable").widget(),
                                drwidget = $("#drResTable").widget();

                            prowidget.option("data", _.filter(prowidget.getTableData(), function(value, key) {
                                return value.id !== _.first(prowidget.getTableCheckedItems()).id;
                            }));

                            drwidget.option("data", _.filter(drwidget.getTableData(), function(value, key) {
                                return value.id !== _.first(drwidget.getTableCheckedItems()).id;
                            }));
                        },
                        operation: appUtils.newOpAreaAction("mappingViewTable", {
                            remove: function(row) {
                                if (_.isUndefined(row)) {
                                    return;
                                }
                                $.each(tableViewSites, function(index) {
                                    var rowObj = {
                                        id: row.id[index],
                                        name: row.name[index]
                                    };
                                    $("#" + this.table.id).widget().addTableRows(rowObj);
                                });

                                var mappingViewTable = $("#mappingViewTable").widget();
                                var sourceDatas = mappingViewTable.getTableData();
                                appUtils.removeFromArray(sourceDatas, [row], "id");
                                mappingViewTable.option("data", sourceDatas);
                                $("#mappingViewTable .OpButton_main").hide();
                                commonUtils.networkMapping.changePairStatus();
                            }
                        })
                    }
                };
            $scope.protectObjectsLabel = appUtils.getString("show_copy_time_protected_objects_tips");
            $scope.showdifferenceObj = function(){
                var copyId = $("#testCopy").widget().getSelectedId();
                var win = angular.copy(constsService.COPY_PROTECTOBJ_DETAIL_WIN);
                win.helpId = "localTestExcuteWinId";
                win.data = {
                    copyId:copyId,
                    currentId:winData.uuid,
                    protectUuid: winData.protectUuid
                };
                win.buttons = [{
                    key: "ok",
                    label: appUtils.getString('common_term_close_button'),
                    focused: true,
                    handler: function(event){
                        $("#" + win.winId).widget().destroy();
                    }
                }];
                appUtils.showWindow(win);
            };

            var productionResTable = {
                title: appUtils.getStringWithColon("common.term.productionResource.label"),
                table: {
                    "checkbox": false,
                    "currPage": 1,
                    "id": "productionResTable",
                    "displayLength": constsService.TABLE_COUNT_MAX_PAGE,
                    "totalRecords": 0,
                    "enablePagination": false,
                    "columns": [{
                        "mData": "id",
                        "bSortable": false,
                        "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("notify_alarm_term_name_column"),
                        "mData": "name"
                    }],
                    "data": [],
                    "cellClickActive": commonUtils.networkMapping.changePairStatus
                },
                initTable: function(deviceSn, _replicaId) {
                    restService.getFusionSphereMappingGroup({
                        planId: winData.planId,
                        queryType: "test",
                        replicaId: _replicaId
                    }, {
                        mask: true,
                        success: function(result) {
                            var mappingData = [],
                                productData = [];

                            _.each(result, function(obj) {
                                var addObj = {
                                    id: [],
                                    name: []
                                };
                                if (!$scope.fcExecuteScope.clusterMapping.testFusionsphere.changeId && !_.isEmpty(obj.remotePortGroupId)) {
                                    addObj.id.push(obj.srcPortGroupId);
                                    addObj.name.push(obj.srcPortGroupName);
                                    addObj.id.push(obj.remotePortGroupId);
                                    addObj.name.push(obj.remotePortGroupName);
                                    mappingData.push(addObj);
                                } else {
                                    obj.id = obj.srcPortGroupId;
                                    obj.name = obj.srcPortGroupName;
                                    productData.push(_.pick(obj, "id", "name"));
                                }
                            });
                            $("#productionResTable").widget().option("data", appUtils.encodeForHTML(productData));
                            $("#mappingViewTable").widget().option("data", appUtils.encodeForHTML(mappingData));
                            $scope.fcExecuteScope.networkMapping.tableViewSites[1].initTable(deviceSn);
                            $scope.$apply();
                        },
                        fail: function() {
                            $scope.fcExecuteScope.networkMapping.tableViewSites[0].table.data = [];
                            $scope.fcExecuteScope.networkMapping.mappingViewTable.data = [];
                            $scope.$apply();
                        }
                    });
                }
            };
            var drResTable = {
                title: appUtils.getStringWithColon("common.term.drResource.label"),
                table: {
                    "checkbox": false,
                    "currPage": 1,
                    "id": "drResTable",
                    "displayLength": constsService.TABLE_COUNT_MAX_PAGE,
                    "totalRecords": 0,
                    "enablePagination": false,
                    "columns": [{
                        "mData": "id",
                        "bSortable": false,
                        "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("notify_alarm_term_name_column"),
                        "mData": "name"
                    }],
                    data: [],
                    "cellClickActive": commonUtils.networkMapping.changePairStatus
                },
                initTable: function(cloudSn) {
                    restService.getFusionSphereDisaterGroup({
                        cloudSn: $.base64.encode(cloudSn)
                    }, {
                        mask: true,
                        success: function(result) {
                            var drResData = [],
                                data = $("#mappingViewTable").widget().getTableData();

                            !_.isEmpty(data) && _.each(data, function(data) {
                                var remotePortGroupId = data.id[1];
                                result = _.filter(result, function(obj, key) {
                                    return obj.remotePortGroupId != remotePortGroupId;
                                });
                            });

                            _.isArray(result) && _.each(result, function(obj) {
                                obj.id = obj.remotePortGroupId;
                                obj.name = obj.remotePortGroupName;
                                drResData.push(_.pick(obj, "id", "name"));
                            });
                            $("#drResTable").widget().option("data", appUtils.encodeForHTML(drResData));
                            $scope.$apply();
                        },
                        fail: function() {
                            $scope.fcExecuteScope.networkMapping.tableViewSites[1].table.data = [];
                            $scope.$apply();
                        }
                    });

                }
            }, tableViewSites = [productionResTable, drResTable];
            $scope.summerys = summerys;
            $scope.fcExecuteScope = {
                copySite: {
                    "id": "copySite",
                    "display": true,
                    "width": constsService.W5,
                    "autoOpen": false,
                    "require": true,
                    "defaultSelectId": "-1",
                    "values": selectDefaultVal,
                    "label": appUtils.getStringWithColon("recovery.term.snapshotBelongingSite.label"),
                    "openFn": function(object) {
                        restService.getReplicasList({
                            protectUuid: winData.protectUuid
                        }, {
                            mask: false,
                            callback: function(result) {
                                $scope.oldResouce = result;
                                var newResouce = [];
                                _.each(result, function(copyInfo) {
                                    _.isEmpty(_.findWhere(newResouce, {
                                        recoverySiteId: copyInfo.recoverySiteId
                                    })) && newResouce.push(copyInfo);
                                })
                                commonUtils.formatDataToSelect("copySite", newResouce, "recoverySiteId", "recoverySite", pleaseSelect_label);
                            }
                        });
                        object.open();
                    },
                    "closeFn": function() {
                        var recoverySiteId = $("#copySite").widget().getSelectedId();
                        if (recoverySiteId == -1 || _.isEmpty($scope.oldResouce)) {
                            return;
                        }
                        var testCopys = [];
                        _.each($scope.oldResouce, function(resouce, key) {
                            resouce.recoverySiteId == recoverySiteId && testCopys.push({
                                selectId: resouce.id,
                                label: resouce.timeStamp,
                                checked: _.isEmpty(testCopys)
                            });
                        });
                        $("#testCopy").widget().option("values", testCopys);
                        $scope.isCheckCopy = true;
                        //副本变化也需要重新查询端口组
                        var testCopyId = $("#testCopy").widget().getSelectedId();
                        if($scope.fcExecuteScope.testCopy.oldSelectId != testCopyId){
                            $scope.fcExecuteScope.networkMapping.isInit = true;
                            $scope.fcExecuteScope.networkMapping.initPage();
                            $scope.fcExecuteScope.testCopy.oldSelectId = testCopyId;
                        };
                        $scope.$apply();
                    },
                    "getValue": function() {
                        return {};
                    },
                    validate: function() {
                        var copySite = $("#copySite").widget().getSelectedId();
                        if (copySite == "-1") {
                            message.error(appUtils.getString("recovery_vm_clusterMapping_copySite_validate"));
                            return false;
                        }
                        return true;
                    }
                },
                testCopy: {
                    "id": "testCopy",
                    "tips": appUtils.getString("recovery.vm.task.testBasedOnSANSnapshot.des.label"),
                    "width": constsService.W5,
                    "autoOpen": false,
                    "require": true,
                    "defaultSelectId": "-1",
                    "oldSelectId": "-1",
                    "values": selectDefaultVal,
                    "label": appUtils.getStringWithColon("recovery.term.testCopy.label"),
                    "getValue": function() {
                        return {};
                    },
                    "openFn": function(object){
                        object.open();
                    },
                    "closeFn":function(){
                        var testCopyId = $("#testCopy").widget().getSelectedId();
                        if(testCopyId != "-1"){
                            $scope.isCheckCopy = true;
                            if($scope.fcExecuteScope.testCopy.oldSelectId != testCopyId){
                                $scope.fcExecuteScope.networkMapping.isInit = true;
                                $scope.fcExecuteScope.networkMapping.initPage();
                                $scope.fcExecuteScope.testCopy.oldSelectId = testCopyId;
                            };
                            $scope.$apply();
                        }
                    },
                    "validate": function() {
                        if ($("#testCopy").widget().getSelectedId() == -1) {
                            message.error(appUtils.getString("recovery_vm_clusterMapping_testCopy_validate"));
                            return false;
                        }
                        return true;
                    }
                },
                clusterMapping: {
                    isInit: true,
                    tabTitle: appUtils.getString("recovery.term.vCenterandClusterMapping.tab"),
                    tips: appUtils.getString("recovery.vm.task.test.selvCenterAndCluster.label"),
                    networkbackgroudimage: "../theme/recoverydirector/images/resourceMapping/cluster_mapping.png",
                    testSite: {
                        "label": appUtils.getStringWithColon("recovery.term.testSite.label"),
                        "id": "testSite",
                        "width": "180px",
                        "autoOpen": false,
                        "require": true,
                        "oldSelectId": "-1",
                        "defaultSelectId": "-1",
                        "values": selectDefaultVal,
                        "openFn": function(object) {
                            restService.queryLocalServer([], {
                                mask: false,
                                success: function(data) {
                                    !_.isUndefined(data.uuid) && restService.querySites({
                                        serverUuid: data.uuid
                                    }, {
                                        mask: false,
                                        callback: function(result) {
                                            commonUtils.formatDataToSelect("testSite", result, "siteId", "name", pleaseSelect_label);
                                        }
                                    });
                                    object.open();
                                }
                            });
                        },
                        "closeFn": function() {
                            var newId = $scope.fcExecuteScope.clusterMapping.testSite.getValue().id,
                                oldId = $scope.fcExecuteScope.clusterMapping.testSite.oldSelectId;
                            if (newId != oldId) {
                                $("#testFusionsphere").widget().option("values", selectDefaultVal);
                                $("#testCluster").widget().option("values", selectDefaultVal);
                            }
                            $scope.fcExecuteScope.clusterMapping.testSite.oldSelectId = newId;
                        },
                        "getValue": function() {
                            return {
                                id: $("#testSite").widget().getSelectedId(),
                                label: $("#testSite").widget().getSelectedLabel()
                            };
                        },
                        "validate": function() {
                            return -1 != $scope.fcExecuteScope.clusterMapping.testSite.getValue().id;
                        }
                    },
                    testFusionsphere: {
                        "id": "testFusionsphere",
                        "width": "180px",
                        "autoOpen": false,
                        "require": true,
                        "oldSelectId": "-1",
                        "originalId": "-1",
                        "changeId": false,
                        "defaultSelectId": "-1",
                        "values": selectDefaultVal,
                        "label": appUtils.getStringWithColon("recovery.term.testFusionsphere.label"),
                        "openFn": function(object) {
                            var siteId = $scope.fcExecuteScope.clusterMapping.testSite.getValue().id;
                            if(-1 == siteId) {
                                object.open();
                                return;
                            }
                            restService.queryCloudBySite({
                                siteId: siteId,
                                cloudType: "FusionCompute"
                            }, {
                                mask: false,
                                callback: function(result) {
                                    commonUtils.formatDataToSelect("testFusionsphere", _.filter(result, function(obj, key){
                                        return $("#srcCloudId").text() != obj.deviceSn;
                                    }), "deviceSn", "cloudName", pleaseSelect_label);
                                    object.open();
                                }
                            });

                        },
                        "closeFn": function() {
                            var newId = $scope.fcExecuteScope.clusterMapping.testFusionsphere.getValue().id,
                                oldId = $scope.fcExecuteScope.clusterMapping.testFusionsphere.oldSelectId,
                                idChangeFlag = (newId != oldId && newId != -1);

                            if (idChangeFlag) {
                                $scope.fcExecuteScope.clusterMapping.testFusionsphere.changeId = newId != $scope.fcExecuteScope.clusterMapping.testFusionsphere.originalId;
                                $scope.fcExecuteScope.networkMapping.isInit = true;
                                $scope.fcExecuteScope.networkMapping.initPage();
                                $("#testCluster").widget().option("values", selectDefaultVal)
                            };
                            $scope.fcExecuteScope.clusterMapping.testFusionsphere.oldSelectId = newId;
                            $scope.$apply();
                        },
                        "getValue": function() {
                            return {
                                id: $("#testFusionsphere").widget().getSelectedId(),
                                label: $("#testFusionsphere").widget().getSelectedLabel()
                            };
                        },

                        "validate": function() {
                            return -1 != $scope.fcExecuteScope.clusterMapping.testFusionsphere.getValue().id;
                        }
                    },
                    testCluster: {
                        "id": "testCluster",
                        "width": "180px",
                        "autoOpen": false,
                        "require": true,
                        "oldSelectId": "-1",
                        "changeId": false,
                        "defaultSelectId": "-1",
                        "values": selectDefaultVal,
                        "label": appUtils.getStringWithColon("recovery.term.testCluster.label"),
                        "openFn": function(object) {
                            var deviceSn =$scope.fcExecuteScope.clusterMapping.testFusionsphere.getValue().id;
                            if(deviceSn == -1) {
                                object.open();
                                return;
                            }
                            restService.getFusionSphereClusterHost({
                                cloudSn: $.base64.encode(deviceSn)
                            }, {
                                mask: false,
                                callback: function(result) {
                                    commonUtils.formatDataToSelect("testCluster", result, "remoteHostClusterId", "remoteHostClusterName", pleaseSelect_label);
                                    object.open();
                                }
                            })
                        },
                        "getValue": function() {
                            return {
                                id: $("#testCluster").widget().getSelectedId(),
                                label: $("#testCluster").widget().getSelectedLabel()
                            };
                        },
                        "validate": function() {
                            return -1 != $scope.fcExecuteScope.clusterMapping.testCluster.getValue().id;;
                        }
                    },
                    initPage: function() {
                        this.isInit && restService.getFusionSphereClusterMapping({
                            planId: winData.planId,
                            queryType: "test"
                        }, {
                            mask: true,
                            success: function(response) {
                                if(_.isEmpty(response)) {
                                    $scope.fcExecuteScope.clusterMapping.isInit = false;
                                    $scope.$apply();
                                    return;
                                }
                                function dealEmptyResult(val) {
                                    if (Object.prototype.toString.call(val) === "[object Null]") {
                                        return "null";
                                    }
                                    if (_.isUndefined($.trim(val)) || _.isEmpty($.trim(val))) {
                                        return "--";
                                    }
                                    return $.trim(val);
                                };

                                var result = response[0];
                                _.each(summerys, function(data, index) {
                                    if (index == 0) {
                                        _.extend(data, {
                                            name: winData.productSiteName,
                                            value: winData.productSiteId
                                        });
                                    } else if (index == 1) {
                                        _.extend(data, {
                                            name: dealEmptyResult(result.srcCloudName),
                                            value: result.srcCloudId
                                        });
                                    } else {
                                        _.extend(data, {
                                            name: dealEmptyResult(result.srcHostClusterName),
                                            value: result.srcHostClusterId
                                        });
                                    }
                                });
                                $scope.$apply(function() {
                                    $scope.summerys = summerys;
                                    $scope.fcExecuteScope.clusterMapping.isInit = false;
                                    !_.isUndefined(result.remoteSiteId) && ($scope.fcExecuteScope.clusterMapping.testSite.oldSelectId = result.remoteSiteId);
                                    if(!_.isUndefined(result.remoteCloudId)) {
                                        $scope.fcExecuteScope.clusterMapping.testFusionsphere.oldSelectId = result.remoteCloudId;
                                        $scope.fcExecuteScope.clusterMapping.testFusionsphere.originalId = result.remoteCloudId;
                                    };
                                });
                                !_.isUndefined(result.remoteSiteId) && commonUtils.formatDataToSelect("testSite", [{
                                        siteId: result.remoteSiteId,
                                        name: result.remoteSiteName
                                    }],
                                    "siteId", "name", pleaseSelect_label);

                                if (!_.isUndefined(result.remoteCloudId)) {
                                    commonUtils.formatDataToSelect("testFusionsphere", [{
                                            deviceSn: result.remoteCloudId,
                                            cloudName: result.remoteCloudName
                                        }],
                                        "deviceSn", "cloudName", pleaseSelect_label);
                                };

                                !_.isUndefined(result.remoteHostClusterId) && commonUtils.formatDataToSelect("testCluster", [{
                                    remoteHostClusterId: result.remoteHostClusterId,
                                    remoteHostClusterName: result.remoteHostClusterName
                                }], "remoteHostClusterId", "remoteHostClusterName", pleaseSelect_label);

                            },
                            fail: function() {
                                $scope.fcExecuteScope.clusterMapping.isInit = false;
                                $scope.$apply();
                            }
                        });

                    },
                    getValue: function() {
                        var hostSet = [],
                            testSiteObj = $scope.fcExecuteScope.clusterMapping.testSite.getValue(),
                            testFusionsphereObj = $scope.fcExecuteScope.clusterMapping.testFusionsphere.getValue(),
                            testClusterObj = $scope.fcExecuteScope.clusterMapping.testCluster.getValue();

                        hostSet.push({
                            "remoteCloudId": testFusionsphereObj.id,
                            "remoteCloudName": testFusionsphereObj.label,
                            "remoteHostClusterId": testClusterObj.id,
                            "remoteHostClusterName": testClusterObj.label,
                            "remoteSiteId": testSiteObj.id,
                            "remoteSiteName": testSiteObj.label,
                            "srcCloudId": $("#srcCloudId").text(),
                            "srcCloudName": $("#srcCloudName").text(),
                            "srcHostClusterId": $("#srcHostId").text(),
                            "srcHostClusterName": $("#srcHostName").text()
                        });

                        return {
                            "testHostCluster": JSON.stringify(hostSet)
                        };
                    },
                    validate: function() {
                        if (!$scope.fcExecuteScope.clusterMapping.testSite.validate()) {
                            message.error(appUtils.getString("recovery_vm_clusterMapping_testSite_validate"));
                            return false;
                        }

                        if (!$scope.fcExecuteScope.clusterMapping.testFusionsphere.validate()) {
                            message.error(appUtils.getString("recovery_vm_clusterMapping_testfusionsphere_validate"));
                            return false;
                        }

                        if (!$scope.fcExecuteScope.clusterMapping.testCluster.validate()) {
                            message.error(appUtils.getString("recovery_vm_clusterMapping_testCluster_validate"));
                            return false;
                        }
                        return true;
                    }
                },
                networkMapping: {
                    tabTitle: appUtils.getString("recovery_fc_task_test_para_portGroup_tab"),
                    tips: appUtils.getString("recovery_fc_task_test_para_portGroup_des_tab"),
                    isInit: true,
                    title: appUtils.getString("rm_term_wizard_mapping_view_title"),
                    addBtn: {
                        id: "addBtn",
                        text: appUtils.getString("common_term_add_mapping_button"),
                        disable: true,
                        click: function() {
                            commonUtils.networkMapping.addRow();
                            commonUtils.networkMapping.changePairStatus();
                        }
                    },
                    pairStatusSpan: appUtils.getString("common_term_add_mapping_unmapped"),
                    mappingViewTable: {
                        "checkbox": false,
                        "currPage": 1,
                        "id": "mappingViewTable",
                        "displayLength": constsService.TABLE_COUNT_PER_PAGE,
                        "totalRecords": 0,
                        "data": [],
                        "enablePagination": false,
                        "columns": [{
                            "mData": "id",
                            "bSortable": false,
                            "bVisible": false
                        }, {
                            "sTitle": appUtils.getString("notify_alarm_term_name_column"),
                            "mData": "name",
                            "sWidth": "90%",
                            "bSortable": false
                        }],
                        "renderRow": function(nRow, aData, iDataIndex) {
                            var nameDiv = "<span class='ellipsisTooltip inlineTrDiv' title='value' style='width:120px!important'>value</span>";
                            var arrow = "<img src='../theme/recoverydirector/images/resourceMapping/arrow_line.png' class='arrow'>";
                            var mappingTypeImg = "<img src='../theme/recoverydirector/images/resourceMapping/network.png' class='network'>";
                            var nameHTML = [];
                            nameHTML.push(mappingTypeImg);
                            nameHTML.push(nameDiv.replace(/value/g, aData.name[0]));
                            nameHTML.push(arrow);
                            nameHTML.push(mappingTypeImg);
                            nameHTML.push(nameDiv.replace(/value/g, aData.name[1]));
                            $('td:eq(0)', nRow).html(nameHTML);
                            $('td:eq(0)', nRow).html("<div style='margin-left:36px'>" + $('td:eq(0)', nRow).html() + "</div>");
                            $('td:eq(0)', nRow).css({"text-align": "center"});
                        },
                        opAreaConfig: [{
                            id: "iconBtnDel",
                            template: "<div class='iconbutton-delete' title='" + appUtils.getString("common_term_delete_button") + "'></div>",
                            clickActive: commonUtils.networkMapping.operation.remove
                        }]
                    },
                    tableViewSites: tableViewSites,
                    getValue: function() {
                        var mappingSet = [];
                        var data = $("#mappingViewTable").widget().getTableData();
                        _.each(data, function(obj) {
                            mappingSet.push({
                                'srcPortGroupId': obj.id[0],
                                'srcPortGroupName': obj.name[0],
                                'remotePortGroupId': obj.id[1],
                                'remotePortGroupName': obj.name[1]
                            });
                        });

                        return {
                            "testPortGroup": JSON.stringify(mappingSet)
                        };
                    },
                    initPage: function() {
                        var deviceSn = $("#testFusionsphere").widget().getSelectedId();
                        //副本ID
                        var _replicaId = $("#testCopy").widget().getSelectedId();
                        if(-1 == _replicaId){
                            $scope.fcExecuteScope.networkMapping.tableViewSites[0].table.data = [];
                            $scope.fcExecuteScope.networkMapping.tableViewSites[1].table.data = [];
                            $scope.fcExecuteScope.networkMapping.mappingViewTable.data = [];
                            $scope.$apply();
                            message.error(appUtils.getString("recovery.term.test.replica.message.least"));
                            return;
                        };
                        if (-1 == deviceSn) {
                            $scope.fcExecuteScope.networkMapping.tableViewSites[0].table.data = [];
                            $scope.fcExecuteScope.networkMapping.tableViewSites[1].table.data = [];
                            $scope.fcExecuteScope.networkMapping.mappingViewTable.data = [];
                            $scope.$apply();
                            message.error(appUtils.getString("recovery_vm_clusterMapping_testfusionsphere_validate"));
                            return;
                        }

                        if (this.isInit) {
                            this.isInit = false;
                            $scope.fcExecuteScope.networkMapping.tableViewSites[0].initTable(deviceSn, _replicaId);
                        }
                    },
                    validate: function() {
                        var _mappingTableData = $("#mappingViewTable").widget().getTableData();
                        var _productionResTableData = $("#productionResTable").widget().getTableData();

                        if (_.isEmpty(_mappingTableData) || !_.isEmpty(_productionResTableData)) {
                            message.error(appUtils.getString("recovery_vm_clusterMapping_portGroup_mapping_validate"));
                            return false;
                        }
                        return true;
                    }
                }
            }
            //点击副本恢复时调用该方法对比保护对象是否一致
            var compareProtectedObject = function(copyId,currentId,protectUuid,callback1){
                var differenceObj = [];
                function copyInit(response){
                    restService.getCopyProtectgroups({protectgroupId:protectUuid,replicaId:copyId},{
                        success:function(result){
                           showDifference(result.records,response);
                           callback1(differenceObj);
                        }
                    })
                };
                function currentInit(callback){
                    var params = {
                        uuid:currentId,
                        startPage:0,
                        pageSize:512,
                        orderBy:"name",
                        orderType:"asc"
                    };
                    restService.getRecoveryProtectObject(params,{
                        success:function(result){
                            callback(result.records);
                        }
                    })
                };
                function showDifference(copyObj,currentObj){
                    var currentUuid = [],
                        copyUuid = [],
                        addUuid = [],
                        reduceUuid = [];
                    _.each(copyObj,function(obj){
                        copyUuid.push(obj.uuid);
                    });
                    _.each(currentObj,function(obj){
                        currentUuid.push(obj.uuid);
                    });
                    _.each(copyUuid,function(val){
                        if(!_.contains(currentUuid,val)){
                            reduceUuid.push(val);
                        }
                    });
                    _.each(currentUuid,function(val){
                        if(!_.contains(copyUuid,val)){
                            addUuid.push(val);
                        }
                    });
                    _.each(copyObj,function(val){
                        if(_.contains(reduceUuid,val.uuid)){
                            _.extend(val,{
                                differenceStatus:"-1"
                            });
                            differenceObj.push(val);
                        }
                    });
                    _.each(currentObj,function(val){
                        if(_.contains(addUuid,val.uuid)){
                            _.extend(val,{
                                differenceStatus:"1"
                            });
                            differenceObj.push(val);
                        }
                    });
                }
                currentInit(copyInit);
            };
            var confirmExcute = function(diff) {
                var contextParams = {},
                    validateResult = [];
                $.each($scope.fcExecuteScope, function(index, config) {
                    if (_.isFunction(config.validate) && !config.validate()) {
                        validateResult.push(false);
                        return false;
                    }!_.isEmpty(config.getValue()) && _.extend(contextParams, config.getValue());
                });

                if (_.indexOf(validateResult, false) != -1) {
                    return;
                };
                if(diff.length > 0) {
                    message.warn({
                        content:appUtils.getString("test_protectedObj_not_same_tips"),
                        ok:function(){
                            restService.localRecoveryTest({
                                uuid: winData.uuid,
                                replicaId: $("#testCopy").widget().getSelectedId(),
                                productSiteId: winData.productSiteId,
                                disasterHostSn: $("#testFusionsphere").widget().getSelectedId()
                            }, {
                                data: contextParams,
                                success: function() {
                                    !_.isEmpty(infoTransferredService.get("tipModule", "obj")) && delete infoTransferredService.get("tipModule", "obj")[winData.uuid];
                                    winData.$scope.exec = true;
                                    winData.$scope.$emit("recoveryExecute", winData.uuid);
                                    message.success({
                                        content: appUtils.getString("common_term_command_send_success_label"),
                                        ok: function() {
                                            $("#" + constsService.FUSIONSPHERE_LOCAL_EXECUTE.winId).widget().destroy();
                                            winData.$state.go("dataUse.dataRecovery.procedure");
                                        }
                                    });
                                }
                            });
                        }
                    })
                    return;
                };
                message.warn({
                    content: appUtils.getString("recovery_messsage_remote_test_confirm_tips", winData.name, $("#testSite").widget().getSelectedLabel()),
                    ok: function() {
                        restService.localRecoveryTest({
                            uuid: winData.uuid,
                            replicaId: $("#testCopy").widget().getSelectedId(),
                            productSiteId: winData.productSiteId,
                            disasterHostSn: $("#testFusionsphere").widget().getSelectedId()
                        }, {
                            data: contextParams,
                            success: function() {
                                !_.isEmpty(infoTransferredService.get("tipModule", "obj")) && delete infoTransferredService.get("tipModule", "obj")[winData.uuid];
                                winData.$scope.exec = true;
                                winData.$scope.$emit("recoveryExecute", winData.uuid);
                                message.success({
                                    content: appUtils.getString("common_term_command_send_success_label"),
                                    ok: function() {
                                        $("#" + constsService.FUSIONSPHERE_LOCAL_EXECUTE.winId).widget().destroy();
                                        winData.$state.go("dataUse.dataRecovery.procedure");
                                    }
                                });
                            }
                        });
                    }
                });
            }
            $("#" + constsService.FUSIONSPHERE_LOCAL_EXECUTE.winId).widget().option("buttons", [{
                key: "ok",
                label: appUtils.getString("common_term_test_button"),
                focused: true,
                handler: function(event) {
                    var contextParams = {},
                        validateResult = [],
                        copyId = $("#testCopy").widget().getSelectedId();
                    $.each($scope.fcExecuteScope, function(index, config) {
                        if (_.isFunction(config.validate) && !config.validate()) {
                            validateResult.push(false);
                            return false;
                        }
                        !_.isEmpty(config.getValue()) && _.extend(contextParams, config.getValue());
                    });

                    if (_.indexOf(validateResult, false) != -1) {
                        return;
                    }
                    compareProtectedObject(copyId,winData.uuid,winData.protectUuid,confirmExcute);
                }
            }, {
                key: "cancel",
                label: appUtils.getString('common_term_cancel_button'),
                focused: false,
                handler: function(event) {
                    $("#" + constsService.FUSIONSPHERE_LOCAL_EXECUTE.winId).widget().destroy();
                }
            }]);


            (function($scope) {
                $scope.fcExecuteScope.clusterMapping.initPage();
            })($scope)

            appUtils.addWinOkBtnCls(constsService.FUSIONSPHERE_LOCAL_EXECUTE.winId);
        }
    ];

    var fcSansnapshot = angular.module("recoverydirector.recovery.config");
    fcSansnapshot.tinyController("recovery.fcSansnapshot.execute.ctrl", fcSansnapshotCtrl);
    return fcSansnapshot;
});
