define(["tiny-extra-lib/jquery.base64"], function() {
    "use strict";
    var fusionManagerCtrl = [
        "$scope",
        "restService",
        "cookieService",
        "communicationService",
        "utilService",
        "exception",
        "constsService",
        "mask",
        "message",
        "appUtils",
        "infoTransferredService",
        function($scope, restService, cookieService, communicationService, utilService, exception, constsService, mask, message, appUtils, infoTransferredService) {
            var winData = $("#" + constsService.FUSIONSPHERE_LOCAL_EXECUTE.winId).widget().option("data"),
                pleaseSelect_label = appUtils.getString("common_term_pleaseSelect_listbox"),
                selectDefaultVal = [{
                    "selectId": "-1",
                    "label": pleaseSelect_label,
                    checked: true
                }],
                summerys = [{
                    valueId: "srcSiteId",
                    value: "",
                    nameId: "srcSiteName",
                    name: "--",
                    key: appUtils.getStringWithColon("recovery.term.abstact.productionSiteLabel")
                }, {
                    valueId: "srcCloudId",
                    value: "",
                    nameId: "srcCloudName",
                    name: "--",
                    key: appUtils.getStringWithColon("recovery.term.productFusionsphere.label")
                }, {
                    valueId: "srcHostId",
                    value: "",
                    nameId: "srcHostName",
                    name: "--",
                    key: appUtils.getStringWithColon("recovery.term.productionCluster.label")
                }],
                commonUtils = {
                    formatDataToSelect: function(domId, data, idKey, labelKey, defaultVal) {
                        if (_.isEmpty(data) || !_.isArray(data) || (data.length == 1 && _.isEmpty(data[0][idKey]) && _.isEmpty(data[0][labelKey]))) {
                            $("#" + domId).widget().option("values", [{
                                "selectId": "-1",
                                "checked": true,
                                "label": defaultVal
                            }]);
                            return;
                        }

                        var vals = [];
                        _.each(data, function(item, index) {
                            if (Object.prototype.toString.call(item[labelKey]) === "[object Null]") {
                                vals.push({
                                    selectId: item[idKey],
                                    label: "null",
                                    checked: index == 0
                                });
                            } else {
                                vals.push({
                                    selectId: item[idKey],
                                    label: item[labelKey],
                                    checked: index == 0
                                });
                            }
                        });
                        $("#" + domId).widget().option("values", vals);
                    },
                    testNetwork: {
                        tableData: [],
                        tableId: "",
                        updateTable: function(tableId, searchVal) {
                            if (_.isEmpty(this.tableData)) {
                                this.tableData = _.clone($("#" + tableId).widget().getTableData());
                                this.tableId = tableId;
                            }

                            if (tableId != this.tableId) {
                                this.tableData = [];
                                this.tableId = "";
                                this.tableData = _.clone($("#" + tableId).widget().getTableData());
                                this.tableId = tableId;
                            }

                            var result = [];
                            _.each(this.tableData, function(obj) {
                                if (obj.name.toUpperCase().indexOf(searchVal.toUpperCase()) != -1) {
                                    result.push(obj);
                                }
                            });
                            $("#" + tableId).widget().option("data", result);
                        },
                        changePairStatus : function(){
                            var selectCount = 0,statusClass = {
                                0: "resource-unpaired png",
                                1: "resource-unselect-all-paired png",
                                2: "resource-paired png"
                            },
                            statusSpan = {
                                0: appUtils.getString("common_term_add_mapping_unmapped"),
                                1: appUtils.getString("common_term_add_mapping_mapping"),
                                2: appUtils.getString("common_term_add_mapping_mapped")
                            };
                            var hasEmptyTable = false;
                            $.each(tableViewSites, function(index) {
                                    var tableId = this.table.id;
                                    var tableData = $("#" + tableId).widget().getTableData();
                                    if(_.isEmpty(tableData)) {
                                        hasEmptyTable = true;
                                        return false;
                                    }
                                    var select = $("#" + tableId).widget().getTableCheckedItems();
                                    if (!angular.isArray(select) || 0 == select.length) {
                                        return;
                                    }
                                    selectCount ++;
                            });

                            if(hasEmptyTable) {
                                $scope.fmExecuteScope.testNetwork.pairStatusSpan = statusSpan[0];
                                if($("#fusionManTest_pairStatusId").hasClass(statusClass[1])){
                                    $("#fusionManTest_pairStatusId").removeClass(statusClass[1]).addClass(statusClass[0]);
                                }
                                $("#fusionManTest_pairStatusId").removeClass(statusClass[2]).addClass(statusClass[0]);
                            } else {
                                $scope.fmExecuteScope.testNetwork.pairStatusSpan = statusSpan[selectCount];
                                if(selectCount==1){
                                    if($("#fusionManTest_pairStatusId").hasClass(statusClass[2])){
                                        $("#fusionManTest_pairStatusId").removeClass(statusClass[2]).addClass(statusClass[1]);
                                    }
                                    $("#fusionManTest_pairStatusId").removeClass(statusClass[0]).addClass(statusClass[1]);
                                };
                                if(selectCount==2){
                                    if($("#fusionManTest_pairStatusId").hasClass(statusClass[1])){
                                        $("#fusionManTest_pairStatusId").removeClass(statusClass[1]).addClass(statusClass[2]);
                                    }
                                    $("#fusionManTest_pairStatusId").removeClass(statusClass[0]).addClass(statusClass[2]);
                                }
                            }
                            if(selectCount == 2) {
                                $scope.fmExecuteScope.testNetwork.addBtn.disable = false;
                                $("#addBtn").css("border", "1px solid #53B8EB");
                            } else {
                                $scope.fmExecuteScope.testNetwork.addBtn.disable = true;
                                $("#addBtn").css("border", "1px solid #c3c3c3");
                            };
                            $scope.$apply();
                        },
                        addRow: function() {
                            var errorMsg;
                            var addObj = {
                                id: [],
                                name: []
                            };
                            $.each(tableViewSites, function(index) {
                                var tableId = this.table.id;
                                var select = $("#" + tableId).widget().getTableCheckedItems();
                                if (!_.isArray(select) || 0 == select.length) {
                                    if (appUtils.isEn()) {
                                        errorMsg = pleaseSelect_label + " " + angular.lowercase(this.title.replace(":", "")) + ".";
                                        return false;
                                    }
                                    errorMsg = pleaseSelect_label + this.title.replace(":", "") + "。";
                                    return false;
                                }
                                addObj.name.push(select[0].name);
                                addObj.id.push(select[0].id);
                            });

                            if (!_.isUndefined(errorMsg)) {
                                message.error(errorMsg);
                                return;
                            }

                            $("#mappingViewTable").widget().addTableRows(addObj);

                            var prowidget = $("#productionResTable").widget(),
                                drwidget = $("#drResTable").widget();

                            prowidget.option("data", _.filter(prowidget.getTableData(), function(value, key) {
                                return value.id !== _.first(prowidget.getTableCheckedItems()).id;
                            }));

                            drwidget.option("data", _.filter(drwidget.getTableData(), function(value, key) {
                                return value.id !== _.first(drwidget.getTableCheckedItems()).id;
                            }));
                        },
                        operation: appUtils.newOpAreaAction("mappingViewTable", {
                            remove: function(row) {
                                if (_.isUndefined(row)) {
                                    return;
                                }
                                $.each(tableViewSites, function(index) {
                                    var rowObj = {
                                        id: row.id[index],
                                        name: row.name[index]
                                    };
                                    $("#" + this.table.id).widget().addTableRows(rowObj);
                                });

                                var mappingViewTable = $("#mappingViewTable").widget();
                                var sourceDatas = mappingViewTable.getTableData();
                                appUtils.removeFromArray(sourceDatas, [row], "id");
                                mappingViewTable.option("data", sourceDatas);
                                $("#mappingViewTable .OpButton_main").hide();
                                commonUtils.testNetwork.changePairStatus();
                            }
                        })
                    },
                    testSecurityGroup: {
                        tableData: [],
                        tableId: "",
                        updateTable: function(tableId, searchVal) {
                            if (_.isEmpty(this.tableData)) {
                                this.tableData = _.clone($("#" + tableId).widget().getTableData());
                                this.tableId = tableId;
                            }

                            if (tableId != this.tableId) {
                                this.tableData = [];
                                this.tableId = "";
                                this.tableData = _.clone($("#" + tableId).widget().getTableData());
                                this.tableId = tableId;
                            }

                            var result = [];
                            _.each(this.tableData, function(obj) {
                                if (obj.name.toUpperCase().indexOf(searchVal.toUpperCase()) != -1) {
                                    result.push(obj);
                                }
                            });
                            $("#" + tableId).widget().option("data", result);
                        },
                        changePairStatus : function(){
                            var selectCount = 0,statusClass = {
                                0: "resource-unpaired png",
                                1: "resource-unselect-all-paired png",
                                2: "resource-paired png"
                            },
                            statusSpan = {
                                0: appUtils.getString("common_term_add_mapping_unmapped"),
                                1: appUtils.getString("common_term_add_mapping_mapping"),
                                2: appUtils.getString("common_term_add_mapping_mapped")
                            };
                            var hasEmptyTable = false;
                            $.each(security_group_tableViewSites, function(index) {
                                    var tableId = this.table.id;
                                    var tableData = $("#" + tableId).widget().getTableData();
                                    if(_.isEmpty(tableData)) {
                                        hasEmptyTable = true;
                                        return false;
                                    }

                                    var select = $("#" + tableId).widget().getTableCheckedItems();
                                    if (!angular.isArray(select) || 0 == select.length) {
                                        return;
                                    }
                                    selectCount ++;
                            });

                            if(hasEmptyTable) {
                                $scope.fmExecuteScope.testSecurityGroup.pairStatusSpan = statusSpan[0];
                                if($("#fusionManTestSecurity_pairStatusId").hasClass(statusClass[1])){
                                    $("#fusionManTestSecurity_pairStatusId").removeClass(statusClass[1]).addClass(statusClass[0]);
                                }
                                $("#fusionManTestSecurity_pairStatusId").removeClass(statusClass[2]).addClass(statusClass[0]);
                            } else {
                                $scope.fmExecuteScope.testSecurityGroup.pairStatusSpan = statusSpan[selectCount];
                                if(selectCount==1){
                                    if($("#fusionManTestSecurity_pairStatusId").hasClass(statusClass[2])){
                                        $("#fusionManTestSecurity_pairStatusId").removeClass(statusClass[2]).addClass(statusClass[1]);
                                    }
                                    $("#fusionManTestSecurity_pairStatusId").removeClass(statusClass[0]).addClass(statusClass[1]);
                                };
                                if(selectCount==2){
                                    if($("#fusionManTestSecurity_pairStatusId").hasClass(statusClass[1])){
                                        $("#fusionManTestSecurity_pairStatusId").removeClass(statusClass[1]).addClass(statusClass[2]);
                                    }
                                    $("#fusionManTestSecurity_pairStatusId").removeClass(statusClass[0]).addClass(statusClass[2]);
                                }
                            }
                            if(selectCount == 2) {
                                $scope.fmExecuteScope.testSecurityGroup.addBtn.disable = false;
                                $("#addBtn").css("border", "1px solid #53B8EB");
                            } else {
                                $scope.fmExecuteScope.testSecurityGroup.addBtn.disable = true;
                                $("#addBtn").css("border", "1px solid #c3c3c3");
                            };
                            $scope.$apply();
                        },
                        addRow: function() {
                            var errorMsg;
                            var addObj = {
                                id: [],
                                name: []
                            };
                            $.each(security_group_tableViewSites, function(index) {
                                var tableId = this.table.id;
                                var select = $("#" + tableId).widget().getTableCheckedItems();
                                if (!_.isArray(select) || 0 == select.length) {
                                    if (appUtils.isEn()) {
                                        errorMsg = pleaseSelect_label + " " + angular.lowercase(this.title.replace(":", "")) + ".";
                                        return false;
                                    }
                                    errorMsg = pleaseSelect_label + this.title.replace(":", "") + "。";
                                    return false;
                                }
                                addObj.name.push(select[0].name);
                                addObj.id.push(select[0].id);
                            });

                            if (!_.isUndefined(errorMsg)) {
                                message.error(errorMsg);
                                return;
                            }

                            $("#security_group_mappingViewTable").widget().addTableRows(addObj);

                            var prowidget = $("#security_group_productionResTable").widget(),
                                drwidget = $("#security_group_drResTable").widget();

                            prowidget.option("data", _.filter(prowidget.getTableData(), function(value, key) {
                                return value.id !== _.first(prowidget.getTableCheckedItems()).id;
                            }));

                            drwidget.option("data", _.filter(drwidget.getTableData(), function(value, key) {
                                return value.id !== _.first(drwidget.getTableCheckedItems()).id;
                            }));
                        },
                        operation: appUtils.newOpAreaAction("security_group_mappingViewTable", {
                            remove: function(row) {
                                if (_.isUndefined(row)) {
                                    return;
                                }
                                $.each(security_group_tableViewSites, function(index) {
                                    var rowObj = {
                                        id: row.id[index],
                                        name: row.name[index]
                                    };
                                    $("#" + this.table.id).widget().addTableRows(rowObj);
                                });

                                var mappingViewTable = $("#security_group_mappingViewTable").widget();
                                var sourceDatas = mappingViewTable.getTableData();
                                appUtils.removeFromArray(sourceDatas, [row], "id");
                                mappingViewTable.option("data", sourceDatas);
                                $("#security_group_mappingViewTable .OpButton_main").hide();
                                commonUtils.testSecurityGroup.changePairStatus();
                            }
                        })
                    }
                };
            $scope.protectObjectsLabel = appUtils.getString("show_copy_time_protected_objects_tips");
            var productionResTable = {
                title: appUtils.getStringWithColon("common.term.productionResource.label"),
                table: {
                    "checkbox": false,
                    "currPage": 1,
                    "id": "productionResTable",
                    "displayLength": constsService.TABLE_COUNT_MAX_PAGE,
                    "totalRecords": 0,
                    "enablePagination": false,
                    "columns": [{
                        "mData": "id",
                        "bSortable": false,
                        "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("recovery_fm_task_test_para_testNetwork_title"),
                        "mData": "name"
                    }],
                    "data": [],
                    "cellClickActive": commonUtils.testNetwork.changePairStatus
                },
                initTable: function(deviceSn) {
                    restService.getFusionSphereNetworkMapping({
                        planId: winData.planId,
                        queryType: "test"
                    }, {
                        mask: true,
                        success: function(result) {
                            var mappingData = [],
                                productData = [];
                            _.each(result, function(obj) {
                                var addObj = {
                                    id: [],
                                    name: []
                                };
                                if (!$scope.fmExecuteScope.clusterMapping.testFusionsphere.changeId && !_.isEmpty(obj.remoteNetworkId)) {
                                    addObj.id.push(obj.srcNetworkId + "@" + obj.srcVPCId);
                                    addObj.name.push(obj.srcNetworkName + "@" + obj.srcVPCName);
                                    addObj.id.push(obj.remoteNetworkId + "@" + obj.remoteVPCId);
                                    addObj.name.push(obj.remoteNetworkName + "@" + obj.remoteVPCName);
                                    mappingData.push(addObj);
                                } else {
                                    obj.id = obj.srcNetworkId + "@" + obj.srcVPCId;
                                    obj.name = obj.srcNetworkName + "@" + obj.srcVPCName;
                                    productData.push(_.pick(obj, "id", "name"));
                                }
                            });

                            $scope.fmExecuteScope.testNetwork.tableViewSites[0].table.data = appUtils.encodeForHTML(productData);
                            $scope.fmExecuteScope.testNetwork.mappingViewTable.data = appUtils.encodeForHTML(mappingData);
                            $scope.fmExecuteScope.testNetwork.tableViewSites[1].initTable(deviceSn);
                            $scope.$apply();
                        },
                        fail: function() {
                            $scope.fmExecuteScope.testNetwork.tableViewSites[0].table.data = [];
                            $scope.fmExecuteScope.testNetwork.mappingViewTable.data = [];
                        }
                    });
                }
            };
            var drResTable = {
                title: appUtils.getStringWithColon("common.term.drResource.label"),
                table: {
                    "checkbox": false,
                    "currPage": 1,
                    "id": "drResTable",
                    "displayLength": constsService.TABLE_COUNT_MAX_PAGE,
                    "totalRecords": 0,
                    "enablePagination": false,
                    "columns": [{
                        "mData": "id",
                        "bSortable": false,
                        "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("recovery_fm_task_test_para_testNetwork_title"),
                        "mData": "name"
                    }],
                    data: [],
                    "cellClickActive": commonUtils.testNetwork.changePairStatus
                },
                initTable: function(cloudSn) {
                    restService.getFusionSphereDisaterNetwork({
                        cloudSn: cloudSn
                    }, {
                        mask: true,
                        success: function(result) {
                            var drResData = [],
                                data = $("#mappingViewTable").widget().getTableData();

                            !_.isEmpty(data) && _.each(data, function(data) {
                                var remoteNetworkId = data.id[1].split("@")[0];
                                result = _.filter(result, function(obj, key){
                                    return remoteNetworkId != obj.remoteNetworkId;
                                });
                            });
                            _.isArray(result) && _.each(result, function(obj) {
                                obj.id = obj.remoteNetworkId + "@" + obj.remoteVPCId;
                                obj.name = obj.remoteNetworkName + "@" + obj.remoteVPCName;
                                drResData.push(_.pick(obj, "id", "name"));
                            });
                            $scope.fmExecuteScope.testNetwork.tableViewSites[1].table.data = appUtils.encodeForHTML(drResData);
                            $scope.$apply();
                        },
                        fail: function() {
                            $scope.fmExecuteScope.testNetwork.tableViewSites[1].table.data = [];
                            $scope.$apply();
                        }
                    });

                }
            };

            var security_group_productionResTable = {
                title: appUtils.getStringWithColon("common.term.productionResource.label"),
                filter: {
                    "id": "security_group_productSearchId",
                    "display": true,
                    "width": "180px",
                    "placeholder": appUtils.getString("recovery.term.abstact.planNameLabel"),
                    "search": commonUtils.testSecurityGroup.productionResTableSearch
                },
                table: {
                    "checkbox": false,
                    "currPage": 1,
                    "id": "security_group_productionResTable",
                    "displayLength": constsService.TABLE_COUNT_MAX_PAGE,
                    "totalRecords": 0,
                    "enablePagination": false,
                    "columns": [{
                        "mData": "id",
                        "bSortable": false,
                        "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("recovery_fm_task_test_para_securityGroup_title"),
                        "mData": "name"
                    }],
                    "data": [],
                    "cellClickActive": commonUtils.testSecurityGroup.changePairStatus
                },
                initTable: function(deviceSn) {
                    restService.getFusionSphereSecurityGroupMapping({
                        planId: winData.planId,
                        queryType: "test"
                    }, {
                        mask: true,
                        success: function(result) {
                            var mappingData = [],
                                productData = [];

                            _.each(result, function(obj) {
                                var addObj = {
                                    id: [],
                                    name: []
                                };
                                if (!$scope.fmExecuteScope.clusterMapping.testFusionsphere.changeId && !_.isEmpty(obj.remoteSecurityGroupId)) {
                                    addObj.id.push(obj.srcSecurityGroupId + "@" + obj.srcVPCId);
                                    addObj.name.push(obj.srcSecurityGroupName + "@" + obj.srcVPCName);
                                    addObj.id.push(obj.remoteSecurityGroupId + "@" + obj.remoteVPCId);
                                    addObj.name.push(obj.remoteSecurityGroupName + "@" + obj.remoteVPCName);
                                    mappingData.push(addObj);
                                } else {
                                    obj.id = obj.srcSecurityGroupId + "@" + obj.srcVPCId;
                                    obj.name = obj.srcSecurityGroupName + "@" + obj.srcVPCName;
                                    productData.push(_.pick(obj, "id", "name"));
                                }
                            });
                            var _productData = appUtils.encodeForHTML(productData);
                            $scope.security_group_productionResTable = _productData;
                            $scope.fmExecuteScope.testSecurityGroup.tableViewSites[0].table.data = _productData;
                            $scope.fmExecuteScope.testSecurityGroup.mappingViewTable.data = appUtils.encodeForHTML(mappingData);
                            $scope.fmExecuteScope.testSecurityGroup.tableViewSites[1].initTable(deviceSn);
                            $scope.$apply();
                        },
                        fail: function() {
                            $scope.fmExecuteScope.testSecurityGroup.tableViewSites[0].table.data = [];
                            $scope.fmExecuteScope.testSecurityGroup.mappingViewTable.data = [];
                            $scope.$apply();
                        }
                    });
                }
            };
            var security_group_drResTable = {
                title: appUtils.getStringWithColon("common.term.drResource.label"),
                filter: {
                    "id": "security_group_drResSearchId",
                    "display": true,
                    "width": "180px",
                    "placeholder": appUtils.getString("recovery.term.abstact.planNameLabel"),
                    "search": commonUtils.testSecurityGroup.drResTableSearch
                },
                table: {
                    "checkbox": false,
                    "currPage": 1,
                    "id": "security_group_drResTable",
                    "displayLength": constsService.TABLE_COUNT_MAX_PAGE,
                    "totalRecords": 0,
                    "enablePagination": false,
                    "columns": [{
                        "mData": "id",
                        "bSortable": false,
                        "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("recovery_fm_task_test_para_securityGroup_title"),
                        "mData": "name"
                    }],
                    data: [],
                    "cellClickActive": commonUtils.testSecurityGroup.changePairStatus
                },
                initTable: function(cloudSn) {
                    restService.getFusionSphereDisaterSecurityGroup({
                        cloudSn: cloudSn
                    }, {
                        mask: true,
                        success: function(result) {
                            var drResData = [],
                                data = $("#security_group_mappingViewTable").widget().getTableData();
                            !_.isEmpty(data) && _.each(data, function(data) {
                                var remoteSecurityGroupId = data.id[1].split("@")[0];
                                result = _.filter(result, function(obj, key){
                                    return obj.remoteSecurityGroupId != remoteSecurityGroupId;
                                });
                            });

                            _.isArray(result) && _.each(result, function(obj) {
                                obj.id = obj.remoteSecurityGroupId + "@" + obj.remoteVPCId;
                                obj.name = obj.remoteSecurityGroupName + "@" + obj.remoteVPCName;
                                drResData.push(_.pick(obj, "id", "name"));
                            });
                            $scope.fmExecuteScope.testSecurityGroup.tableViewSites[1].table.data = appUtils.encodeForHTML(drResData);
                            $scope.$apply();
                        },
                        fail: function() {
                            $scope.fmExecuteScope.testSecurityGroup.tableViewSites[1].table.data = [];
                            $scope.$apply();
                        }
                    });
                }
            };
            var tableViewSites = [productionResTable, drResTable];
            var security_group_tableViewSites = [security_group_productionResTable, security_group_drResTable];

            $scope.showdifferenceObj = function(){
                var copyId = $("#testCopy").widget().getSelectedId();
                var win = angular.copy(constsService.COPY_PROTECTOBJ_DETAIL_WIN);
                win.helpId = "localTestExcuteWinId";
                win.data = {
                    copyId:copyId,
                    currentId:winData.uuid,
                    protectUuid: winData.protectUuid
                };
                win.buttons = [{
                    key: "ok",
                    label: appUtils.getString('common_term_close_button'),
                    focused: true,
                    handler: function(event){
                        $("#" + win.winId).widget().destroy();
                    }
                }];
                appUtils.showWindow(win);
            };

            $scope.summerys = summerys;
            $scope.fmExecuteScope = {
                copySite: {
                    "id": "copySite",
                    "display": true,
                    "width": constsService.W5,
                    "autoOpen": false,
                    "require": true,
                    "defaultSelectId": "-1",
                    "values": selectDefaultVal,
                    "label": appUtils.getStringWithColon("recovery.term.snapshotBelongingSite.label"),
                    "openFn": function(object) {
                        restService.getReplicasList({
                            protectUuid: winData.protectUuid
                        }, {
                            mask: false,
                            callback: function(result) {
                                $scope.oldResouce = result;
                                var newResouce = [];
                                _.each(result, function(copyInfo) {
                                    _.isEmpty(_.findWhere(newResouce, {
                                        recoverySiteId: copyInfo.recoverySiteId
                                    })) && newResouce.push(copyInfo);
                                })
                                commonUtils.formatDataToSelect("copySite", newResouce, "recoverySiteId", "recoverySite", pleaseSelect_label);
                                object.open();
                            }
                        });
                    },
                    "closeFn": function() {
                        var recoverySiteId = $("#copySite").widget().getSelectedId();
                        if (recoverySiteId == -1 || _.isEmpty($scope.oldResouce)) {
                            return;
                        }
                        var testCopys = [];
                        _.each($scope.oldResouce, function(resouce, key) {
                            resouce.recoverySiteId == recoverySiteId && testCopys.push({
                                selectId: resouce.id,
                                label: resouce.timeStamp,
                                checked: _.isEmpty(testCopys)
                            });
                        });
                        $("#testCopy").widget().option("values", testCopys);
                        $scope.isCheckCopy = true;
                        $scope.$apply();
                    },
                    "getValue": function() {
                        return {};
                    },
                    validate: function() {
                        var copySite = $("#copySite").widget().getSelectedId();
                        if (copySite == "-1") {
                            message.error(appUtils.getString("recovery_vm_clusterMapping_copySite_validate"));
                            return false;
                        }
                        return true;
                    }
                },
                testCopy: {
                    "id": "testCopy",
                    "tips": appUtils.getString("recovery.vm.task.testBasedOnSANSnapshot.des.label"),
                    "width": constsService.W5,
                    "autoOpen": false,
                    "require": true,
                    "defaultSelectId": "-1",
                    "values": selectDefaultVal,
                    "label": appUtils.getStringWithColon("recovery.term.testCopy.label"),
                    "getValue": function() {
                        return {};
                    },
                    "openFn": function(object){
                        object.open();
                    },
                    "closeFn":function(){
                        if($("#testCopy").widget().getSelectedId() != "-1"){
                            $scope.isCheckCopy = true;
                            $scope.$apply();
                        }
                    },
                    "validate": function() {
                        if ($("#testCopy").widget().getSelectedId() == -1) {
                            message.error(appUtils.getString("recovery_vm_clusterMapping_testCopy_validate"));
                            return false;
                        }
                        return true;
                    }
                },
                clusterMapping: {
                    isInit: true,
                    tabTitle: appUtils.getString("recovery.term.vCenterandClusterMapping.tab"),
                    tips: appUtils.getString("recovery.vm.task.test.selvCenterAndCluster.label"),
                    networkbackgroudimage: "../theme/recoverydirector/images/resourceMapping/cluster_mapping.png",
                    testSite: {
                        "label": appUtils.getStringWithColon("recovery.term.testSite.label"),
                        "id": "testSite",
                        "width": "180px",
                        "autoOpen": false,
                        "require": true,
                        "oldSelectId": "-1",
                        "defaultSelectId": "-1",
                        "values": selectDefaultVal,
                        "openFn": function(object) {
                             restService.queryLocalServer([], {
                                mask: false,
                                success: function(data) {
                                    !_.isUndefined(data.uuid) && restService.querySites({
                                        serverUuid: data.uuid
                                    }, {
                                        mask: false,
                                        callback: function(result) {
                                            commonUtils.formatDataToSelect("testSite", result, "siteId", "name", pleaseSelect_label);
                                        }
                                    });
                                    object.open();
                                }
                            });
                        },
                        "closeFn": function() {
                            var newId = $scope.fmExecuteScope.clusterMapping.testSite.getValue().id,
                                oldId = $scope.fmExecuteScope.clusterMapping.testSite.oldSelectId;
                            if (newId != oldId) {
                                $("#testFusionsphere").widget().option("values", selectDefaultVal);
                                $("#testCluster").widget().option("values", selectDefaultVal);
                            }
                            $scope.fmExecuteScope.clusterMapping.testSite.oldSelectId = newId;
                        },
                        "getValue": function() {
                            return {
                                id: $("#testSite").widget().getSelectedId(),
                                label: $("#testSite").widget().getSelectedLabel()
                            };
                        },
                        "validate": function() {
                            return -1 != $scope.fmExecuteScope.clusterMapping.testSite.getValue().id;
                        }
                    },
                    testFusionsphere: {
                        "id": "testFusionsphere",
                        "width": "180px",
                        "autoOpen": false,
                        "require": true,
                        "oldSelectId": "-1",
                        "originalId": "-1",
                        "changeId": false,
                        "defaultSelectId": "-1",
                        "values": selectDefaultVal,
                        "label": appUtils.getStringWithColon("recovery.term.testFusionsphere.label"),
                        "openFn": function(object) {
                            var siteId = $scope.fmExecuteScope.clusterMapping.testSite.getValue().id;
                            if(-1 == siteId) {
                                object.open();
                                return;
                            }
                            restService.queryCloudBySite({
                                siteId: siteId,
                                cloudType: "FusionManager"
                            }, {
                                mask: false,
                                callback: function(result) {
                                    commonUtils.formatDataToSelect("testFusionsphere", _.filter(result, function(obj, key){
                                        return $("#srcCloudId").text() != obj.deviceSn;
                                    }), "deviceSn", "cloudName", pleaseSelect_label);
                                    object.open();
                                }
                            });
                        },
                        "closeFn": function() {
                            var newId = $scope.fmExecuteScope.clusterMapping.testFusionsphere.getValue().id,
                                oldId = $scope.fmExecuteScope.clusterMapping.testFusionsphere.oldSelectId,
                                idChangeFlag = (newId != oldId && newId != -1);

                            if(idChangeFlag) {
                                $scope.fmExecuteScope.clusterMapping.testFusionsphere.changeId = newId != $scope.fmExecuteScope.clusterMapping.testFusionsphere.originalId;
                                $scope.fmExecuteScope.testNetwork.isInit = true;
                                $scope.fmExecuteScope.testSecurityGroup.isInit = true;
                                $scope.fmExecuteScope.testNetwork.initPage();
                                $scope.fmExecuteScope.testSecurityGroup.initPage();
                                $("#testCluster").widget().option("values", selectDefaultVal);
                            }
                            $scope.fmExecuteScope.clusterMapping.testFusionsphere.oldSelectId = newId;
                            $scope.$apply();
                        },
                        "getValue": function() {
                            return {
                                id: $("#testFusionsphere").widget().getSelectedId(),
                                label: $("#testFusionsphere").widget().getSelectedLabel()
                            };
                        },
                        "validate": function() {
                            return -1 != $scope.fmExecuteScope.clusterMapping.testFusionsphere.getValue().id;
                        }
                    },
                    testCluster: {
                        "id": "testCluster",
                        "width": "180px",
                        "autoOpen": false,
                        "require": true,
                        "oldSelectId": "-1",
                        "changeId": false,
                        "defaultSelectId": "-1",
                        "cacheId": "-1",
                        "values": selectDefaultVal,
                        "label": appUtils.getStringWithColon("recovery.term.testCluster.label"),
                        "openFn": function(object) {
                            var deviceSn =$scope.fmExecuteScope.clusterMapping.testFusionsphere.getValue().id;
                             if(-1 == deviceSn) {
                                object.open();
                                return;
                            }
                            restService.getFusionSphereClusterHost({
                                cloudSn: $.base64.encode(deviceSn)
                            }, {
                                mask: false,
                                callback: function(result) {
                                    commonUtils.formatDataToSelect("testCluster", result, "remoteHostClusterId", "remoteHostClusterName", pleaseSelect_label);
                                    object.open();
                                }
                            });
                        },
                        "getValue": function() {
                            return {
                                id: $("#testCluster").widget().getSelectedId(),
                                label: $("#testCluster").widget().getSelectedLabel()
                            };
                        },
                        "validate": function() {
                            return -1 != $scope.fmExecuteScope.clusterMapping.testCluster.getValue().id;
                        }
                    },
                    initPage: function() {
                        this.isInit && restService.getFusionSphereClusterMapping({
                            planId: winData.planId,
                            queryType: "test"
                        }, {
                            mask: true,
                            success: function(response) {
                                if(_.isEmpty(response)) {
                                    $scope.fmExecuteScope.clusterMapping.isInit = false;
                                    $scope.$apply();
                                    return;
                                }

                                function dealEmptyResult(val) {
                                    if (Object.prototype.toString.call(val) === "[object Null]") {
                                        return "null";
                                    }
                                    if (_.isUndefined($.trim(val)) || _.isEmpty($.trim(val))) {
                                        return "--";
                                    }
                                    return $.trim(val);
                                };

                                var result = response[0];
                                _.each(summerys, function(data, index) {
                                    if (index == 0) {
                                        _.extend(data, {
                                            name: winData.productSiteName,
                                            value: winData.productSiteId
                                        });
                                    } else if (index == 1) {
                                        _.extend(data, {
                                            name: dealEmptyResult(result.srcCloudName),
                                            value: result.srcCloudId
                                        });
                                    } else {
                                        _.extend(data, {
                                            name: dealEmptyResult(result.srcHostClusterName),
                                            value: result.srcHostClusterId
                                        });
                                    }
                                });

                                $scope.$apply(function(){
                                    $scope.summerys = summerys;
                                    $scope.fmExecuteScope.clusterMapping.isInit = false;
                                    !_.isUndefined(result.remoteSiteId) && ($scope.fmExecuteScope.clusterMapping.testSite.oldSelectId = result.remoteSiteId);
                                    if(!_.isUndefined(result.remoteCloudId)) {
                                        $scope.fmExecuteScope.clusterMapping.testFusionsphere.oldSelectId = result.remoteCloudId;
                                        $scope.fmExecuteScope.clusterMapping.testFusionsphere.originalId = result.remoteCloudId;
                                    }
                                });
                                commonUtils.formatDataToSelect("testSite", [{
                                        siteId: result.remoteSiteId,
                                        name: result.remoteSiteName
                                    }],
                                    "siteId", "name", pleaseSelect_label);

                                if(!_.isUndefined(result.remoteCloudId)) {
                                    commonUtils.formatDataToSelect("testFusionsphere", [{
                                            deviceSn: result.remoteCloudId,
                                            cloudName: result.remoteCloudName
                                        }],
                                        "deviceSn", "cloudName", pleaseSelect_label);
                                    $scope.fmExecuteScope.testNetwork.isInit && $scope.fmExecuteScope.testNetwork.initPage();
                                    $scope.fmExecuteScope.testSecurityGroup.isInit && $scope.fmExecuteScope.testSecurityGroup.initPage();
                                }

                                commonUtils.formatDataToSelect("testCluster", [{
                                    remoteHostClusterId: result.remoteHostClusterId,
                                    remoteHostClusterName: result.remoteHostClusterName
                                }], "remoteHostClusterId", "remoteHostClusterName", pleaseSelect_label);

                            },
                            fail: function() {
                                $scope.fmExecuteScope.clusterMapping.isInit = false;
                                $scope.$apply();
                            }
                        });

                    },
                    getValue: function() {
                        var hostSet = [],
                            testSiteObj = $scope.fmExecuteScope.clusterMapping.testSite.getValue(),
                            testFusionsphereObj = $scope.fmExecuteScope.clusterMapping.testFusionsphere.getValue(),
                            testClusterObj = $scope.fmExecuteScope.clusterMapping.testCluster.getValue();

                        hostSet.push({
                            "remoteCloudId": testFusionsphereObj.id,
                            "remoteCloudName": testFusionsphereObj.label,
                            "remoteHostClusterId": testClusterObj.id,
                            "remoteHostClusterName": testClusterObj.label,
                            "remoteSiteId": testSiteObj.id,
                            "remoteSiteName": testSiteObj.label,
                            "srcCloudId": $("#srcCloudId").text(),
                            "srcCloudName": $("#srcCloudName").text(),
                            "srcHostClusterId": $("#srcHostId").text(),
                            "srcHostClusterName": $("#srcHostName").text()
                        });

                        return {
                            "testHostCluster": JSON.stringify(hostSet)
                        };
                    },
                    validate: function() {
                        if (!$scope.fmExecuteScope.clusterMapping.testSite.validate()) {
                            message.error(appUtils.getString("recovery_vm_clusterMapping_testSite_validate"));
                            return false;
                        }

                        if (!$scope.fmExecuteScope.clusterMapping.testFusionsphere.validate()) {
                            message.error(appUtils.getString("recovery_vm_clusterMapping_testfusionsphere_validate"));
                            return false;
                        }

                        if (!$scope.fmExecuteScope.clusterMapping.testCluster.validate()) {
                            message.error(appUtils.getString("recovery_vm_clusterMapping_testCluster_validate"));
                            return false;
                        }
                        return true;
                    }
                },
                testNetwork: {
                    tabTitle: appUtils.getString("recovery.term.networkMapping.tab"),
                    tips: appUtils.getString("recovery.vm.task.test.addNetworkMapping.des.label"),
                    isInit: true,
                    title: appUtils.getString("rm_term_wizard_mapping_view_title"),
                    addBtn: {
                        id: "addBtn",
                        disable: true,
                        text: appUtils.getString("common_term_add_mapping_button"),
                        click: function() {
                            commonUtils.testNetwork.addRow();
                            commonUtils.testNetwork.changePairStatus();
                        }
                    },
                    pairStatusSpan: appUtils.getString("common_term_add_mapping_unmapped"),
                    mappingViewTable: {
                        "checkbox": false,
                        "currPage": 1,
                        "id": "mappingViewTable",
                        "displayLength": constsService.TABLE_COUNT_PER_PAGE,
                        "totalRecords": 0,
                        "data": [],
                        "enablePagination": false,
                        "columns": [{
                            "mData": "id",
                            "bSortable": false,
                            "bVisible": false
                        }, {
                            "sTitle": appUtils.getString("recovery_fm_task_test_para_testNetwork_title"),
                            "mData": "name",
                            "sWidth": "90%",
                            "bSortable": false
                        }],
                        "renderRow": function(nRow, aData, iDataIndex) {
                            var nameDiv = "<span class='ellipsisTooltip inlineTrDiv' title='value' style='width:120px!important'>value</span>";
                            var arrow = "<img src='../theme/recoverydirector/images/resourceMapping/arrow_line.png' class='arrow'>";
                            var mappingTypeImg = "<img src='../theme/recoverydirector/images/resourceMapping/network.png' class='network'>";
                            var nameHTML = [];
                            nameHTML.push(mappingTypeImg);
                            nameHTML.push(nameDiv.replace(/value/g, aData.name[0]));
                            nameHTML.push(arrow);
                            nameHTML.push(mappingTypeImg);
                            nameHTML.push(nameDiv.replace(/value/g, aData.name[1]));
                            $('td:eq(0)', nRow).html(nameHTML);
                            $('td:eq(0)', nRow).html("<div style='margin-left:36px'>" + $('td:eq(0)', nRow).html() + "</div>");
                            $('td:eq(0)', nRow).css({"text-align": "center"});
                        },
                        opAreaConfig: [{
                            id: "iconBtnDel",
                            template: "<div class='iconbutton-delete' title='" + appUtils.getString("common_term_delete_button") + "'></div>",
                            clickActive: commonUtils.testNetwork.operation.remove
                        }]
                    },
                    tableViewSites: tableViewSites,
                    getValue: function() {
                        var mappingSet = [];
                        var data = $("#mappingViewTable").widget().getTableData();

                        if (_.isEmpty(data)) {
                            message.error(appUtils.getString("recovery_vm_clusterMapping_network_mapping_validate"));
                            return;
                        }

                        _.each(data, function(obj) {
                            var srcIds = obj.id[0].split("@");
                            var remoteIds = obj.id[1].split("@");
                            var srcNames = obj.name[0].split("@");
                            var remoteNames = obj.name[1].split("@")
                            mappingSet.push({
                                'remoteNetworkId': remoteIds[0],
                                'remoteNetworkName': remoteNames[0],
                                'remoteVPCId': remoteIds[1],
                                'remoteVPCName': remoteNames[1],
                                'srcNetworkId': srcIds[0],
                                'srcVPCId': srcIds[1],
                                'srcNetworkName': srcNames[0],
                                'srcVPCName': srcNames[1]
                            });
                        });

                        return {
                            "testNetwork": JSON.stringify(mappingSet)
                        };
                    },
                    initPage: function() {
                        var deviceSn = $("#testFusionsphere").widget().getSelectedId();
                        if (-1 == deviceSn) {
                            $scope.fmExecuteScope.testNetwork.tableViewSites[0].table.data = [];
                            $scope.fmExecuteScope.testNetwork.tableViewSites[1].table.data = [];
                            $scope.fmExecuteScope.testNetwork.mappingViewTable.data = [];
                            $scope.$apply();
                            message.error(appUtils.getString("recovery_vm_clusterMapping_testfusionsphere_validate"));
                            return;
                        }

                        if (this.isInit) {
                            this.isInit = false;
                            $scope.fmExecuteScope.testNetwork.tableViewSites[0].initTable(deviceSn);
                        }
                    },
                    validate: function() {
                        var _mappingTableData = $("#mappingViewTable").widget().getTableData();
                        var _productionResTableData = $("#productionResTable").widget().getTableData();

                        if (_.isEmpty(_mappingTableData) || !_.isEmpty(_productionResTableData)) {
                            message.error(appUtils.getString("recovery_vm_clusterMapping_network_mapping_validate"));
                            return false;
                        }
                        return true;
                    }
                },
                testSecurityGroup: {
                    tabTitle: appUtils.getString("recovery_fm_task_test_para_securityGroup_tab"),
                    tips: appUtils.getString("recovery_fm_task_test_para_securityGroup_des_tab"),
                    isInit: true,
                    title: appUtils.getString("rm_term_wizard_mapping_view_title"),
                    addBtn: {
                        id: "security_addBtn",
                        text: appUtils.getString("common_term_add_mapping_button"),
                        disable: true,
                        click: function() {
                            commonUtils.testSecurityGroup.addRow();
                            commonUtils.testSecurityGroup.changePairStatus();
                        }
                    },
                    pairStatusSpan: appUtils.getString("common_term_add_mapping_unmapped"),
                    mappingViewTable: {
                        "checkbox": false,
                        "currPage": 1,
                        "id": "security_group_mappingViewTable",
                        "displayLength": constsService.TABLE_COUNT_PER_PAGE,
                        "totalRecords": 0,
                        "data": [],
                        "enablePagination": false,
                        "columns": [{
                            "mData": "id",
                            "bSortable": false,
                            "bVisible": false
                        }, {
                            "sTitle": appUtils.getString("recovery_fm_task_test_para_securityGroup_title"),
                            "mData": "name",
                            "sWidth": "90%",
                            "bSortable": false
                        }],
                        "renderRow": function(nRow, aData, iDataIndex) {
                            var nameDiv = "<span class='ellipsisTooltip inlineTrDiv' title='value' style='width:120px!important'>value</span>";
                            var arrow = "<img src='../theme/recoverydirector/images/resourceMapping/arrow_line.png' class='arrow'>";
                            var mappingTypeImg = "<img src='../theme/recoverydirector/images/resourceMapping/network.png' class='network'>";
                            var nameHTML = [];
                            nameHTML.push(mappingTypeImg);
                            nameHTML.push(nameDiv.replace(/value/g, aData.name[0]));
                            nameHTML.push(arrow);
                            nameHTML.push(mappingTypeImg);
                            nameHTML.push(nameDiv.replace(/value/g, aData.name[1]));
                            $('td:eq(0)', nRow).html(nameHTML);
                            $('td:eq(0)', nRow).html("<div style='margin-left:36px'>" + $('td:eq(0)', nRow).html() + "</div>");
                            $('td:eq(0)', nRow).css({"text-align": "center"});
                        },
                        opAreaConfig: [{
                            id: "iconBtnDel",
                            template: "<div class='iconbutton-delete' title='" + appUtils.getString("common_term_delete_button") + "'></div>",
                            clickActive: commonUtils.testSecurityGroup.operation.remove
                        }]
                    },
                    tableViewSites: security_group_tableViewSites,
                    getValue: function() {
                        var mappingSet = [];
                        var data = $("#security_group_mappingViewTable").widget().getTableData();
                        _.each(data, function(obj) {
                            var srcIds = obj.id[0].split("@");
                            var remoteIds = obj.id[1].split("@");
                            var srcNames = obj.name[0].split("@");
                            var remoteNames = obj.name[1].split("@")
                            mappingSet.push({
                                'remoteSecurityGroupId': remoteIds[0],
                                'remoteSecurityGroupName': remoteNames[0],
                                'remoteVPCId': remoteIds[1],
                                'remoteVPCName': remoteNames[1],
                                'srcSecurityGroupId': srcIds[0],
                                'srcVPCId': srcIds[1],
                                'srcSecurityGroupName': srcNames[0],
                                'srcVPCName': srcNames[1]
                            });
                        });

                        return {
                            "testSecurityGroup": JSON.stringify(mappingSet)
                        };
                    },
                    initPage: function() {
                        var deviceSn = $("#testFusionsphere").widget().getSelectedId();
                        if (-1 == deviceSn) {
                            $scope.fmExecuteScope.testSecurityGroup.tableViewSites[0].table.data = [];
                            $scope.fmExecuteScope.testSecurityGroup.tableViewSites[1].table.data = [];
                            $scope.fmExecuteScope.testSecurityGroup.mappingViewTable.data = [];
                            $scope.$apply();
                            message.error(appUtils.getString("recovery_vm_clusterMapping_testfusionsphere_validate"));
                            return;
                        }

                        if (this.isInit) {
                            this.isInit = false;
                            $scope.fmExecuteScope.testSecurityGroup.tableViewSites[0].initTable(deviceSn);
                        }
                    },
                    validate: function() {
                        var _security_group_mappingViewTable = $("#security_group_mappingViewTable").widget().getTableData();
                        var _security_group_productionResTableData = $("#security_group_productionResTable").widget().getTableData();

                        if (_.isEmpty(_security_group_productionResTableData)) {
                            return true;
                        }

                        if (!_.isEmpty(_security_group_productionResTableData) || _.isEmpty(_security_group_mappingViewTable) ) {
                            message.error(appUtils.getString("recovery_vm_clusterMapping_security_mapping_validate"));
                            return false;
                        }

                        return true;
                    }
                }
            }

            //点击副本恢复时调用该方法对比保护对象是否一致
            var compareProtectedObject = function(copyId,currentId,protectUuid,callback1){
                var differenceObj = [];
                function copyInit(response){
                    restService.getCopyProtectgroups({protectgroupId:protectUuid,replicaId:copyId},{
                        success:function(result){
                           showDifference(result.records,response);
                           callback1(differenceObj);
                        }
                    })
                };
                function currentInit(callback){
                    var params = {
                        uuid:currentId,
                        startPage:0,
                        pageSize:512,
                        orderBy:"name",
                        orderType:"asc"
                    };
                    restService.getRecoveryProtectObject(params,{
                        success:function(result){
                            callback(result.records);
                        }
                    })
                };
                function showDifference(copyObj,currentObj){
                    var currentUuid = [],
                        copyUuid = [],
                        addUuid = [],
                        reduceUuid = [];
                    _.each(copyObj,function(obj){
                        copyUuid.push(obj.uuid);
                    });
                    _.each(currentObj,function(obj){
                        currentUuid.push(obj.uuid);
                    });
                    _.each(copyUuid,function(val){
                        if(!_.contains(currentUuid,val)){
                            reduceUuid.push(val);
                        }
                    });
                    _.each(currentUuid,function(val){
                        if(!_.contains(copyUuid,val)){
                            addUuid.push(val);
                        }
                    });
                    _.each(copyObj,function(val){
                        if(_.contains(reduceUuid,val.uuid)){
                            _.extend(val,{
                                differenceStatus:"-1"
                            });
                            differenceObj.push(val);
                        }
                    });
                    _.each(currentObj,function(val){
                        if(_.contains(addUuid,val.uuid)){
                            _.extend(val,{
                                differenceStatus:"1"
                            });
                            differenceObj.push(val);
                        }
                    });
                }
                currentInit(copyInit);
            };
            var confirmExcute = function(diff) {
                var contextParams = {},
                    validateResult = [];
                $.each($scope.fmExecuteScope, function(index, config) {
                    if (_.isFunction(config.validate) && !config.validate()) {
                        validateResult.push(false);
                        return false;
                    }
                    !_.isEmpty(config.getValue()) && _.extend(contextParams, config.getValue());
                });

                if (_.indexOf(validateResult, false) != -1) {
                    return;
                };
                if(diff.length > 0) {
                    message.warn({
                        content:appUtils.getString("test_protectedObj_not_same_tips"),
                        ok:function(){
                            restService.localRecoveryTest({
                                uuid: winData.uuid,
                                replicaId: $("#testCopy").widget().getSelectedId(),
                                productSiteId: winData.productSiteId,
                                disasterHostSn: $("#testFusionsphere").widget().getSelectedId()
                            }, {
                                data: contextParams,
                                success: function() {
                                    !_.isEmpty(infoTransferredService.get("tipModule", "obj")) && delete infoTransferredService.get("tipModule", "obj")[winData.uuid];
                                    winData.$scope.exec = true;
                                    winData.$scope.$emit("recoveryExecute", winData.uuid);
                                    message.success({
                                        content: appUtils.getString("common_term_command_send_success_label"),
                                        ok: function() {
                                            $("#" + constsService.FUSIONSPHERE_LOCAL_EXECUTE.winId).widget().destroy();
                                            winData.$state.go("dataUse.dataRecovery.procedure");
                                        }
                                    });
                                }
                            });
                        }
                    })
                    return;
                };
                message.warn({
                    content: appUtils.getString("recovery_messsage_remote_test_confirm_tips", winData.name, $("#testSite").widget().getSelectedLabel()),
                    ok: function() {
                        restService.localRecoveryTest({
                            uuid: winData.uuid,
                            replicaId: $("#testCopy").widget().getSelectedId(),
                            productSiteId: winData.productSiteId,
                            disasterHostSn: $("#testFusionsphere").widget().getSelectedId()
                        }, {
                            data: contextParams,
                            success: function() {
                                !_.isEmpty(infoTransferredService.get("tipModule", "obj")) && delete infoTransferredService.get("tipModule", "obj")[winData.uuid];
                                winData.$scope.exec = true;
                                winData.$scope.$emit("recoveryExecute", winData.uuid);
                                message.success({
                                    content: appUtils.getString("common_term_command_send_success_label"),
                                    ok: function() {
                                        $("#" + constsService.FUSIONSPHERE_LOCAL_EXECUTE.winId).widget().destroy();
                                        winData.$state.go("dataUse.dataRecovery.procedure");
                                    }
                                });
                            }
                        });
                    }
                });
            }

            $("#" + constsService.FUSIONSPHERE_LOCAL_EXECUTE.winId).widget().option("buttons", [{
                key: "ok",
                label: appUtils.getString("common_term_test_button"),
                focused: true,
                handler: function(event) {
                    var contextParams = {},
                        validateResult = [],
                        copyId = $("#testCopy").widget().getSelectedId();
                    $.each($scope.fmExecuteScope, function(index, config) {
                        if (_.isFunction(config.validate) && !config.validate()) {
                            validateResult.push(false);
                            return false;
                        }!_.isEmpty(config.getValue()) && _.extend(contextParams, config.getValue());
                    });

                    if (_.indexOf(validateResult, false) != -1) {
                        return;
                    }
                    compareProtectedObject(copyId,winData.uuid,winData.protectUuid,confirmExcute);
                }
            }, {
                key: "cancel",
                label: appUtils.getString('common_term_cancel_button'),
                focused: false,
                handler: function(event) {
                    $("#" + constsService.FUSIONSPHERE_LOCAL_EXECUTE.winId).widget().destroy();
                }
            }]);


            (function($scope) {
                $scope.fmExecuteScope.clusterMapping.initPage();
            })($scope)

            appUtils.addWinOkBtnCls(constsService.FUSIONSPHERE_LOCAL_EXECUTE.winId);
        }
    ];

    var fusionManager = angular.module("recoverydirector.recovery.config");
    fusionManager.tinyController("recovery.fmSansnapshot.execute.ctrl", fusionManagerCtrl);
    return fusionManager;
});
