define([], function() {
    "use strict";
    var fusionSphere3dcExcuteCtrl = [
        "$scope",
        "$sce",
        "restService",
        "cookieService",
        "communicationService",
        "utilService",
        "exception",
        "constsService",
        "mask",
        "message",
        "appUtils",
        "infoTransferredService",
        "$compile",
        function($scope, $sce, restService, cookieService, communicationService, utilService, exception, constsService, mask, message, appUtils, infoTransferredService,$compile) {
            var _winData = $("#fusionSphere3dcExcuteWin").widget().option("data");
            var _pleaseSelect_label = appUtils.getString("common_term_pleaseSelect_listbox");
            var _btnText = appUtils.getString("common_term_confirm_button");
            var _testSiteLabel = appUtils.getStringWithColon("recovery.term.testSite.label");
            var recoveryType = "2";
            //查询FC集群信息
            var queryResourcemapping = function(callback) {
                var fcSn;
                try {
                    fcSn = JSON.parse(_winData.props.pgMgrInfo).pgFcSn;
                } catch (err) {
                    fcSn = "";
                };
                if (_.isEmpty(fcSn)) {
                    return;
                };
                mask.show();
                var paramObj = {
                        filterName: "resourceProviderId",
                        filterValue: fcSn,
                        resourceType: 0,
                        startPage: 0,
                        pageSize: 10000
                    },
                    url = appUtils.fillUrl(constsService.RM_URL.mappingURL, paramObj),
                    promise = communicationService.get(url, null, null, 3600000).promise();
                promise.always(callback);
            };
            $scope.clusterMappingLabel = appUtils.getStringWithColon("recovery.term.testCluster.label");
            $scope.clusterMappingShow = (_winData.PROVIDER_TYPE == "FusionCompute" || _winData.PROVIDER_TYPE == "FusionManager") && _winData.templateType != 11;
            $scope.clusterMappingShow && queryResourcemapping(function(result){
                mask.hide();
                if(!_.isEmpty(result.records)){
                    var recoveryMapping = _.filter(result.records, function(val){
                        return val.recoverySiteId == _winData.productSiteId
                    });
                    var productMapping = _.filter(result.records, function(val){
                        return val.productSiteId == _winData.productSiteId
                    });
                    var mappingArr = [],
                        mapping = "";
                    if (!_.isEmpty(recoveryMapping)) {
                        _.each(recoveryMapping, function(item) {
                            mappingArr.push(item.recoveryResourceName)
                        });
                        mapping = mappingArr.join("<br>");
                    } else if (!_.isEmpty(productMapping)) {
                        _.each(productMapping, function(item) {
                            mappingArr.push(item.productResourceName)
                        });
                        mapping = mappingArr.join("<br>");
                    } else {
                        mapping = "--";
                    };
                    $scope.summerys.push({
                        valueId: "srcMapping",
                        value: "",
                        nameId: "srcMappingName",
                        name: mapping,
                        key: appUtils.getStringWithColon("recovery.term.productionCluster.label")
                    });
                    setTimeout(function() {
                        $("#srcMappingName").html(mapping)
                    }, 10);
                    $scope.$apply();
                };
            });
            $scope.isFusionSphereTest = false
            $scope.isRemote = _winData["operateType"] != "test";

            $scope.isRecovery = false;
            $scope.isHostReplication = _winData["protectType"] == "HostReplication";
            $scope.actionScope = {
                title: appUtils.getString("recovery_fault_method_label"),
                titleWithcolon: appUtils.getStringWithColon("recovery_fault_method_label"),
                label: appUtils.getString("recovery.term.fault.recoveryType.tips"),
                actionRadio: {
                    id: "recoveryRdaio",
                    values: [{
                        "key": "one",
                        "text": appUtils.getString("recovery.term.fault.recoveryType.lastestData"),
                        "checked": true
                    }, {
                        "key": "two",
                        "text": appUtils.getString("recovery.term.fault.recoveryType.lastestLun")
                    }],
                    spacing: {"width": "30px"}
                }
            };

            $scope.isNasHyperMetro = _winData["isNasHyperCopy"] && _.contains([18,20],parseInt(_winData['templateType'],10));
            $scope.accessSettingInfo = $sce.trustAsHtml(appUtils.getString("recovery_excute_accessSetting_tab_label"));
            $scope.uncriticalVMInfo = $sce.trustAsHtml(appUtils.getString("recovery_excute_uncriticalvm_tab_label"));
            $scope.isExistMapping = false;

            //修改窗口按钮的文字
            switch (_winData["operateType"])
            {
                case "move" :
                    _btnText = appUtils.getString("common_term_plan_move_button");
                    _testSiteLabel = appUtils.getStringWithColon("recovery.term.vrg.recovery_site.title");
                    recoveryType = "1";
                    $scope.isFusionSphereTest = false;
                    break;
                case "fault":
                    _btnText = appUtils.getString("ism.drm.protect.group.fault.recovery.label");
                    _testSiteLabel = appUtils.getStringWithColon("recovery.term.vrg.recovery_site.title");
                    recoveryType = "0";
                    $scope.isFusionSphereTest = false;
                    $scope.isRecovery = true;
                    break;
                case "test":
                    _btnText = appUtils.getString("common_term_test_button");
                    _testSiteLabel = appUtils.getStringWithColon("recovery.term.testSite.label");
                    recoveryType = "2";
                    $scope.isFusionSphereTest = true;
                    break;
                default:
                    _btnText = appUtils.getString("common_term_confirm_button");
            }
            $("#fusionSphere3dcExcuteWin").widget().option("buttons", [{
                key: "ok",
                label: _btnText,
                focused: true,
                handler: function(event) {
                    __sendAjax()
                }
            }, {
                key: "cancel",
                label: appUtils.getString('common_term_cancel_button'),
                focused: false,
                handler: function(event) {
                    $("#fusionSphere3dcExcuteWin").widget().destroy();
                }
            }]);

            var _executeSettingModel = {
                formatDataToSelect: function(domId, data, idKey, labelKey, defaultVal) {
                	if( _.isEmpty(data) || !_.isArray(data) || (data.length == 1 && _.isEmpty(data[0][idKey]) && _.isEmpty(data[0][labelKey])) ) {
                		$("#" + domId).widget().option("values", [{ "selectId": "-1", "checked": true, "label": defaultVal}]);
                		return;
                	}

                    var vals = [];
                    _.each(data, function(item, index) {
                        if(Object.prototype.toString.call(item[labelKey]) === "[object Null]") {
                            vals.push({selectId: item[idKey], label: "null", checked: index == 0});
                        } else{
                            vals.push({selectId: item[idKey], label: item[labelKey], checked: index == 0});
                        }
                    });
                    $("#" + domId).widget().option("values", vals);
                },
                setClusterMapping: {
                    queryTestSite: function(object) {
                        restService.getRemoteDisasterSite({uuid: _winData.planId}, {
                            mask: false,
                            callback: function(result) {
                                _winData.operateType == "fault" && (result = _.filter(result, function(data){
                                    return data.siteType != 1;
                                }));
                                _executeSettingModel.formatDataToSelect("testSite", result, "siteId", "name", _pleaseSelect_label);
                                object.open();
                            }
                        });
                    }
                }
            };
            var _summerys = [
                {
                    valueId: "srcSiteId",
                    value: "",
                    nameId: "srcSiteName",
                    name: "--",
                    key: appUtils.getStringWithColon("recovery.term.abstact.productionSiteLabel")
                }
            ];

            var __getRequestInfo = function() {
                var reqInfo = {};
                if (_winData.operateType == "test") {
                    var remoteSite = $scope.fusionSphere3dcScope.clusterMapping.testSite.getValue();
                    var netWorkSetting = $scope.fusionSphere3dcScope.networkMapping.getValue();
                    var siteName = appUtils.encodeForHTML($.trim(remoteSite.label));
                    reqInfo.tips = appUtils.getString("recovery_messsage_remote_test_confirm_tips", _winData.name, siteName);
                    reqInfo.url = utilService.getResouceUrl("/recoveryplans/" + _winData.planId + "/action/test");
                    reqInfo.params = {
                        "TestNetwork": JSON.stringify(netWorkSetting),
                        "DISASTER_SITE_ID" : remoteSite.id
                    }

                }

                if (_winData.operateType == "move") {
                    var remoteSite = $scope.fusionSphere3dcScope.clusterMapping.testSite.getValue();
                    reqInfo.tips = appUtils.getString("recovery_messsage_plan_move_confirm_tips", _winData.name);
                    reqInfo.url = utilService.getResouceUrl("/recoveryplans/" + _winData.planId + "/action/plannedMigration");
                    reqInfo.params = {
                        "DISASTER_SITE_ID" : remoteSite.id
                    }
                    //NAS双活+复制
                    if($scope.isNasHyperMetro){
                        _.extend(reqInfo.params,$scope.fusionSphere3dcScope.accessNasHyerSetting.getValue())
                    }
                }

                if (_winData.operateType == "fault") {
                    var remoteSite = $scope.fusionSphere3dcScope.clusterMapping.testSite.getValue();
                    reqInfo.tips = appUtils.getString("recovery_messsage_fault_recovery_confirm_tips", _winData.name);
                    reqInfo.url = utilService.getResouceUrl("/recoveryplans/" + _winData.planId + "/action/diasterRecovery");
                    reqInfo.params = {
                        "DISASTER_SITE_ID" : remoteSite.id
                    }
                    if($scope.isHostReplication && !_.isEmpty($("#recoveryRdaio"))){
                        reqInfo.params.RecoveryType = $("#recoveryRdaio").widget().opChecked("checked") == "one" ? "1" : "2";
                    }
                    //NAS双活+复制
                    if($scope.isNasHyperMetro){
                        _.extend(reqInfo.params,$scope.fusionSphere3dcScope.accessNasHyerSetting.getValue())
                    }
                }
                return reqInfo;
            };

            function setParams(callbackTest){
                var uncriticalvms = $scope.fusionSphere3dcScope.uncriticalVM.getValue();
                var powerHosts = $scope.fusionSphere3dcScope.accessSetting.getValue();
                var vmUuids = [],hostsUuids = [];
                var remoteSiteId = $scope.fusionSphere3dcScope.clusterMapping.testSite.getValue();
                _.each(uncriticalvms,function(val){
                    vmUuids.push(val.uuid)
                });
                _.each(powerHosts,function(data){
                    hostsUuids.push(data.uuid)
                });
                var paramVms = {
                    planId: _winData.planId,
                    type: recoveryType,
                    recoverySiteId: remoteSiteId.id,
                    uuids: vmUuids
                },
                paramHosts = {
                    planId: _winData.planId,
                    type: recoveryType,
                    recoverySiteId: remoteSiteId.id,
                    uuids:hostsUuids
                }
                restService.saveNonCriticalvms({},{
                    data: paramVms,
                    success:function(result){
                        restService.savefusionSphereHosts({},{
                            data: paramHosts,
                            success:function(result){
                                _.isFunction(callbackTest) && callbackTest()
                            },
                            mask:false
                        });
                    },
                    mask:false
                });
            }

            var __sendAjax = function() {
                var __reqInfo = __getRequestInfo();
                if(!$scope.fusionSphere3dcScope.clusterMapping.validate() || !$scope.fusionSphere3dcScope.networkMapping.validate()){
                    return;
                }
                if($scope.isNasHyperMetro && !$scope.fusionSphere3dcScope.accessNasHyerSetting.validate()){
                    return;
                }
            	message.warn({
                    content: __reqInfo.tips, ok: function () {
                        mask.show();
                        function synctest(){
                            communicationService.put(__reqInfo.url, __reqInfo.params).promise().always(function (result) {
                                mask.hide();
                                if (exception.check(result)) {
                                    //发广播更新当前选中行的数据
                                    !_.isEmpty(infoTransferredService.get("tipModule", "obj")) && delete infoTransferredService.get("tipModule", "obj")[_winData.uuid];
                                    _winData.$scope.exec = true;
                                    _winData.$scope.$emit("recoveryExecute", _winData.planId);
                                    message.success({content: appUtils.getString("common_term_command_send_success_label"), ok: function () {
                                            $("#fusionSphere3dcExcuteWin").widget().destroy();
                                            _winData.$state.go("dataUse.dataRecovery.procedure");
                                        }
                                    });
                                }
                            });
                        }
                        setParams(synctest);
                    }
                });
            };

            $scope.summerys = _summerys;
            $scope.fusionSphere3dcScope = {
                constant: {
                    label: {
                        selvCenterAndCluster: appUtils.getString(constsService.VMWARE_EXECUTE._clusterMappingDesc[_winData.operateType]),
                        addNetworkMapping: appUtils.getString(constsService.VMWARE_EXECUTE._networkMappingDesc[_winData.operateType]),
                        accessSetting: appUtils.getString("com.huawei.ism.drm.galax.storage.recovery.process.PowerOnHostRecoveryProcessor.des"),
                        selUncriticalVM: appUtils.getString(constsService.VMWARE_EXECUTE._uncriticalVMDesc[_winData.operateType]),
                        setAccess: appUtils.getString(constsService.VMWARE_EXECUTE._accessSettingDesc[_winData.operateType]),
                        faultFailedLabel: _winData.operateType == "fault" ? appUtils.getString("recovery_vm_task_recovery_fault_fail_label") : "",
                        beforeFaultLabel: _winData.operateType == "fault" ? appUtils.getString("recovery_vm_task_recovery_fault_before_label") : ""
                    },
                    title: {
                        clusterMapping: appUtils.getString(constsService.VMWARE_EXECUTE._tabTitle[_winData.operateType].clusterMapping),
                        networkMapping: appUtils.getString(constsService.VMWARE_EXECUTE._tabTitle[_winData.operateType].networkMapping),
                        accessSetting: appUtils.getString("recovery_host_unusered_label"),
                        uncriticalVM: appUtils.getString("recovery.term.uncriticalVM.tab"),
                        setAccess: appUtils.getString("recovery.term.accessSetting.tab")
                    }
                },
                clusterMapping: {
                    isInit: true,
                    networkbackgroudimage: "/theme/recoverydirector/images/recovery/cluster_mapping.png",
                    testSite: {
                        "id": "testSite",
                        "width": "200px",
                        "autoOpen": false,
                        "require": true,
                        "oldSelectId": "-1",
                        "defaultSelectId": "-1",
                        "values": [{"selectId": "-1","label": _pleaseSelect_label}],
                        "label": _testSiteLabel,
                        "openFn": _executeSettingModel.setClusterMapping.queryTestSite,
                        "change":function(){
                            $scope.fusionSphere3dcScope.networkMapping.isInit = true;
                            $scope.fusionSphere3dcScope.accessSetting.isInit = true;
                            $scope.fusionSphere3dcScope.uncriticalVM.isInit = true;
                            $scope.$apply();
                        },
                        "closeFn": function() {
                            var newSite = $("#testSite").widget().getSelectedId();
                            if(newSite != $scope.fusionSphere3dcScope.clusterMapping.testSite.oldSelectId) {
                                $scope.fusionSphere3dcScope.networkMapping.isInit = true;
                                $scope.fusionSphere3dcScope.accessSetting.isInit = true;
                                $scope.fusionSphere3dcScope.uncriticalVM.isInit = true;
                            }
                            $scope.fusionSphere3dcScope.clusterMapping.testSite.oldSelectId = newSite;
                            $scope.clusterMappingShow && queryResourcemapping(function(result){
                                mask.hide();
                                if(!_.isEmpty(result.records)){
                                    var recoveryMapping = _.filter(result.records, function(val){
                                        return val.recoverySiteId == newSite
                                    });
                                    var productMapping = _.filter(result.records, function(val){
                                        return val.productSiteId == newSite
                                    });
                                    var mappingArr = [],
                                        drMapingArr = [],
                                        mapping = "";
                                    if (!_.isEmpty(recoveryMapping)) {
                                        _.each(recoveryMapping, function(item) {
                                            mappingArr.push(item.recoveryResourceName);
                                            drMapingArr.push(item.productResourceName);
                                        });
                                        mapping = mappingArr.join("<br>");
                                    } else if (!_.isEmpty(productMapping)) {
                                        _.each(productMapping, function(item) {
                                            mappingArr.push(item.productResourceName);
                                            drMapingArr.push(item.recoveryResourceName);
                                        });
                                        mapping = mappingArr.join("<br>");
                                    } else {
                                        mapping = "--";
                                    };
                                    $scope.clusterMappingValue = mapping;
                                    $("#clusterMappingValueSpan").html(mapping);
                                    $scope.isExistMapping = true;
                                    if (!_.isEmpty($scope.summerys[1]) && $scope.summerys[1].name == "--") {
                                        var drMapping = !_.isEmpty(drMapingArr) ? drMapingArr.join("<br>") : "--";
                                        $scope.summerys[1].name = drMapping;
                                        setTimeout(function() {
                                            $("#srcMappingName").html(drMapping)
                                        }, 10);
                                    };
                                    $scope.$apply();
                                };
                            });
                            $scope.$apply();
                        },
                        "getValue": function() {
                            return {
                                id: $("#testSite").widget().getSelectedId(),
                                label: $("#testSite").widget().getSelectedLabel()
                            };
                        },
                        warnTips: _winData.operateType == "fault" ? appUtils.getString("recovery_site_task_recover_fault_info_message") : appUtils.getString("recovery_site_task_recover_info_message")
                    },
                    initPage: function() {
                        var _queryType = _.contains(["move", "fault"], _winData.operateType) ? "recovery" : "test";
                        this.isInit && restService.getfusionSphere3dcSite({planId: _winData.planId}, {
                            mask: false,
                            callback: function(result) {
                                if(!_.isEmpty(result[0].recoverySiteId) && _winData.operateType != "fault"){
                                    _executeSettingModel.formatDataToSelect("testSite", result, "recoverySiteId", "recoverySiteName", _pleaseSelect_label);
                                    //如果已经测试初始化测试网络等信息
                                    $scope.isFusionSphereTest && $scope.fusionSphere3dcScope.networkMapping.display && $scope.fusionSphere3dcScope.networkMapping.isInit && $scope.fusionSphere3dcScope.networkMapping.initPage();
                                    $scope.fusionSphere3dcScope.accessSetting.display && $scope.fusionSphere3dcScope.accessSetting.isInit && $scope.fusionSphere3dcScope.accessSetting.initPage();
                                    $scope.fusionSphere3dcScope.uncriticalVM.display && $scope.fusionSphere3dcScope.uncriticalVM.isInit && $scope.fusionSphere3dcScope.uncriticalVM.initPage();
                               }
                                if(!_.isEmpty(result)){
                                    $scope.summerys[0].name = result[0].productSiteName;
                                    $scope.summerys[0].value = result[0].productSiteId;
                                }
                                $scope.fusionSphere3dcScope.clusterMapping.isInit = false;
                                if("-1" != $("#testSite").widget().getSelectedId()){
                                    var newSite = $("#testSite").widget().getSelectedId();
                                    $scope.clusterMappingShow && queryResourcemapping(function(result){
                                        mask.hide();
                                        if(!_.isEmpty(result.records)){
                                            var recoveryMapping = _.filter(result.records, function(val){
                                                return val.recoverySiteId == newSite
                                            });
                                            var productMapping = _.filter(result.records, function(val){
                                                return val.productSiteId == newSite
                                            });
                                            var mappingArr = [],
                                                drMapingArr = [],
                                                mapping = "";
                                            if (!_.isEmpty(recoveryMapping)) {
                                                _.each(recoveryMapping, function(item) {
                                                    mappingArr.push(item.recoveryResourceName);
                                                    drMapingArr.push(item.productResourceName);
                                                });
                                                mapping = mappingArr.join("<br>");
                                            } else if (!_.isEmpty(productMapping)) {
                                                _.each(productMapping, function(item) {
                                                    mappingArr.push(item.productResourceName);
                                                    drMapingArr.push(item.recoveryResourceName);
                                                });
                                                mapping = mappingArr.join("<br>");
                                            } else {
                                                mapping = "--";
                                            };
                                            $scope.clusterMappingValue = mapping;
                                            $("#clusterMappingValueSpan").html(mapping);
                                            $scope.isExistMapping = true;
                                            if (!_.isEmpty($scope.summerys[1]) && $scope.summerys[1].name == "--") {
                                                var drMapping = !_.isEmpty(drMapingArr) ? drMapingArr.join("<br>") : "--";
                                                $scope.summerys[1].name = drMapping;
                                                setTimeout(function() {
                                                    $("#srcMappingName").html(drMapping)
                                                }, 10);
                                            };
                                            $scope.$apply();
                                        };
                                    });
                                };
                                $scope.$apply();
                            }
                        });
                    },
                    validate: function() {
                        if (-1 == $("#testSite").widget().getSelectedId()) {
                            message.error(_winData["operateType"] == "test" ? appUtils.getString("recovery_vm_clusterMapping_testSite_validate")
                                : appUtils.getString("recovery_vm_clusterMapping_recoverySite_validate"));
                            return false;
                        }
                        return true;
                    }
                },
                networkMapping: {
                    isInit: true,
                    display: true,
                    title: appUtils.getString("recovery_network_test_tip"),
                    table: {
                        id: "fusionSphere3dcNetwork",
                        data: [],
                        columns: [
                            {"mData": "proUrn", "bVisible": false},
                            {"mData": "drUrn", "bVisible": false},
                            {"mData": "testUrn", "bVisible": false},
                            {"mData": "recSiteName", "bVisible": false},
                            {"sTitle": appUtils.getString("recovery_network_product_label"), "sWidth":"218px", "mData": "proName", "bSortable": false},
                            {"sTitle": appUtils.getString("recovery_network_daster_label"), "sWidth":"218px", "mData": "drName", "bSortable": false},
                            {"sTitle": appUtils.getString("recovery_network_test_label"), "sWidth":"218px", "mData": "testName", "bSortable": false}],
                        renderRow: function(nRow, aData, iDataIndex) {
                            var testNetworkColumn = "<tiny-select id='id' values='values' width='width' auto-open='autoOpen' open-fn='openFn' default-selectid='defaultSelectId'></tiny-select>";
                            var testLink = $compile(testNetworkColumn);
                            var testScope = $scope.$new();
                            testScope.id = "remoteNetwork_" + iDataIndex;
                            testScope.width = constsService.W2;
                            testScope.autoOpen = false;
                            testScope.openFn = function(object) {
                                restService.getFusionshpereByUrn({planId: _winData.planId, recNetworkUrn :aData['drUrn']} , function(result){
                                    if(!_.isEmpty(result)) {
                                        var array = [];
                                        _.each(result, function (d, k) {
                                            var opt = {
                                                "checked": 0 == k,
                                                "selectId": d.testUrn,
                                                "label": d.testName
                                            };
                                            array.push(opt);
                                        });
                                        $("#" + testScope.id).widget().option("values", array);
                                    }
                                    object.open();
                                })
                            };

                            if (!_.isEmpty(aData['testUrn']) && !_.isEmpty(aData['testName'])) {
                                testScope.defaultSelectId = aData['testUrn'];
                                testScope.values = [
                                    {
                                        "selectId": aData['testUrn'],
                                        "label": aData['testName']
                                    }
                                ];
                            } else {
                                testScope.defaultSelectId = "default";
                                testScope.values = [
                                    {
                                        "selectId": "default",
                                        "label": appUtils.getString("common_term_pleaseSelect_listbox")
                                    }
                                ];
                            }

                            var testNode = testLink(testScope);
                            $("td:eq(2)", nRow).html(testNode);
                        }

                    },
                    initPage: function(){
                        var querySiteId = $("#testSite").widget().getSelectedId();
                        if(querySiteId == "-1"){
                            $scope.fusionSphere3dcScope.networkMapping.table.data = [];
                            $scope.$apply();
                            message.error(appUtils.getString("recovery_vm_clusterMapping_recoverySite_validate"))
                            return;
                        }
                        //FC选择的站点没有集群的话也需要提示
                        if($scope.isExistMapping && $scope.clusterMappingShow && (_.isEmpty($scope.clusterMappingValue) || $scope.clusterMappingValue == "--")){
                            message.error(appUtils.getString("recovery_excute_no_cluster_label", $("#testSite").widget().getSelectedLabel()));
                            $scope.fusionSphere3dcScope.networkMapping.table.data = [];
                            $scope.$apply();
                            return;
                        };
                        this.isInit && restService.getFusionsphere3dcNetworkmappings({planId: _winData.planId,recoverySiteId:querySiteId}, function(result) {
                            var array = [];
                            _.each(result.testNetworkList, function (d) {
                                d.recSiteName = result.recSiteName;
                                var tmo = _.pick(d, "proUrn", "drUrn", "drUrn", "proName", "drName", "testName", "testUrn", "recSiteName");
                                array.push(tmo);
                            });
                            $scope.fusionSphere3dcScope.networkMapping.table.data = appUtils.encodeForHTML(array);
                            $scope.fusionSphere3dcScope.networkMapping.isInit = false;
                            $scope.$apply();
                        })
                    },
                    getValue: function() {
                        var data = $("#fusionSphere3dcNetwork").widget().getTableData();
                        var array = [];
                        _.each(data, function(value, key){
                            var obj = {};
                            obj.proNetworkUrn = value.proUrn;
                            obj.testNetworkUrn = $("#remoteNetwork_" + key).widget().getSelectedId();
                            array.push(obj);
                        });
                        return array;
                    },
                    validate: function() {
                        if(!$scope.isFusionSphereTest){
                            return true;
                        }
                        var data = $("#fusionSphere3dcNetwork").widget().getTableData();
                        if (_.isEmpty(data)) {
                            message.error(appUtils.getString('recovery.term.recovery.testNetwork.message.least'));
                            return false;
                        }
                        var array = [];
                        _.each(data, function(value, key){
                            var obj = {};
                            obj.proNetworkUrn = value.proUrn;
                            obj.testNetworkUrn = $("#remoteNetwork_" + key).widget().getSelectedId();
                            array.push(obj);
                        });

                        var uncheckTestNetArray = _.where(array, {"testNetworkUrn": "default"});
                        if (!_.isEmpty(uncheckTestNetArray)) {
                            message.error(appUtils.getString("recovery.term.recovery.testNetwork.message.least"));
                            return false;
                        }
                        return true;
                    }
                },
                accessNasHyerSetting: {
                    isInit: true,
                    display: $scope.isNasHyperMetro,
                    logicPort:{
                        labels: appUtils.getStringWithColon("recovery.vm.task.test.setAccess.para_logicIP.label"),
                        tips: appUtils.getString("recovery.vm.task.test.setAccess.para_logicIP.des_label"),
                        id: "ipAddress",
                        value: "",
                        require: true,
                        width: "300px",
                        validate: constsService.VALID.IP_STANDARD
                    },
                    getValue: function(){
                        return {
                            "nasSharePortIp": $.trim($("#ipAddress").widget().getValue())
                        };
                    },
                    initPage: function() {
                        this.isInit && restService.getNasSharePortIp({"planId": _winData.planId}, {
                            mask: true,
                            success: function(result) {
                                $scope.fusionSphere3dcScope.accessNasHyerSetting.logicPort.value = result.ipAddress;
                                $scope.fusionSphere3dcScope.accessNasHyerSetting.isInit = false;
                                $scope.$apply();
                            },
                            fail: function() {
                                $scope.fusionSphere3dcScope.accessNasHyerSetting.logicPort.value = "";
                                $scope.fusionSphere3dcScope.accessNasHyerSetting.isInit = false;
                                $scope.$apply();
                            }
                        });
                    },
                    validate: function(){
                        var portAddr = $.trim($("#ipAddress").widget().getValue());
                        var regExp = /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/;

                        if (_.isEmpty(portAddr)) {
                            message.error(appUtils.getString("validate_term_common_ip_standard_rule_label"));
                            return false;
                        }

                        var ipArray = portAddr.split(".");
                        if (ipArray.length == 4) {
                            if (ipArray[0] == "0" || ipArray[0] == "127" || ipArray[3] == "0") {
                                message.error({content: appUtils.getString("validate_term_common_ip_standard_rule_label"), ok: function() {
                                        $("#ipAddress").find("input:eq(1)").focus();
                                    }
                                });
                                return false;
                            }
                        }

                        if (!regExp.test(portAddr)) {
                            message.error({content: appUtils.getString("validate_term_common_ip_standard_rule_label"), ok: function() {
                                    $("#ipAddress").find("input:eq(1)").focus();
                                }
                            });
                            return false;
                        }
                        return true;
                    }
                },
                accessSetting: {
                    isInit: true,
                    display: true,
                    availableTable: {
                        "checkbox": true,
                        "currPage": 1,
                        "columnsDraggable":false,
                        "data": [],
                        "id": "powerOnHostTable",
                        "title": appUtils.getString("recovery_host_unusered_label"),
                        "displayLength": constsService.TABLE_COUNT_PER_PAGE,
                        "totalRecords": 0,
                        "enablePagination": false,
                        "columns": [{"mData": "uuid", "bSortable": false, "bVisible": false},
                                    {"mData": "name", "sWidth": "100%", "sTitle": appUtils.getString("recovery.term.abstact.planNameLabel")}],
                        "tHeadCheckboxFn": function(param, evt) {}
                    },
                    getValue: function() {
                        var selectHostSet = [];
                        var selectRow = $("#powerOnHostTable").widget().getTableCheckedItems();

                        _.each(selectRow, function(row) {
                            selectHostSet.push(_.pick(row, "uuid", "name"));
                        });

                        return selectHostSet
                    },
                    initPage: function(hostId) {
                        if($("#testSite").widget().getSelectedId() == "-1"){
                            message.error(appUtils.getString("recovery_vm_clusterMapping_recoverySite_validate"))
                            return;
                        };
                        //FC选择的站点没有集群的话也需要提示
                        if($scope.isExistMapping && $scope.clusterMappingShow && (_.isEmpty($scope.clusterMappingValue) || $scope.clusterMappingValue == "--")){
                            message.error(appUtils.getString("recovery_excute_no_cluster_label", $("#testSite").widget().getSelectedLabel()));
                            !_.isEmpty($("#powerOnHostTable").widget()) && $("#powerOnHostTable").widget().option("data",[]);
                            return;
                        };
                        var recoverySiteId = $("#testSite").widget().getSelectedId();
                        this.isInit && mask.show();
                        this.isInit && communicationService.get(utilService.getResouceUrl("/fusionsphere/hosts/action/getAvailableHost?planId=" + _winData.planId + "&&recoverySiteId=" + recoverySiteId)).promise().always(function(result){
                            mask.hide();
                            if (exception.check(result)) {
                                var arr = [];
                                _.each(result, function (d) {
                                    var tmo = _.pick(d, "uuid", "name");
                                    arr.push(tmo);
                                });
                                communicationService.get(utilService.getResouceUrl("/fusionsphere/hosts/action/getSelectedHost?planId=" + _winData.planId + "&&recoverySiteId=" + recoverySiteId)).promise().always(function(respose){
                                    if(exception.check(respose)){
                                        _.each(respose,function(k){
                                            var choose = _.pick(k,"uuid","name")
                                            arr.push(choose);
                                        });
                                        _.isArray(respose) && _.each(respose, function(row) {
                                            (function(uuid) {
                                                setTimeout(function() {
                                                    $("#powerOnHostTable").widget().setSelectedRow("uuid", uuid);
                                                }, 100);
                                            })(row.uuid);
                                        });
                                        $("#powerOnHostTable").widget().option("data",appUtils.encodeForHTML(arr));
                                        $scope.$apply();
                                    }
                                });
                                $scope.fusionSphere3dcScope.accessSetting.isInit = false;
                            }
                        });
                    },
                    validate: function(){
                        return true;
                    }
                },
                uncriticalVM: {
                    isInit: true,
                    display: true,
                    availableTable: {
                        "checkbox": true,
                        "currPage": 1,
                        "columnsDraggable":false,
                        "data": [],
                        "id": "uncriticalVM",
                        "title": appUtils.getStringWithColon("resMapping.term.availableVM.tab"),
                        "displayLength": constsService.TABLE_COUNT_PER_PAGE,
                        "totalRecords": 0,
                        "enablePagination": false,
                        "columns": [{"mData": "uuid", "bSortable": false, "bVisible": false},
                                    {"mData": "name", "sWidth": "100%", "sTitle": appUtils.getString("recovery.term.abstact.planNameLabel")}],
                        "tHeadCheckboxFn": function(param, evt) {}
                    },
                    getValue: function() {
                        var selectVmSet = [];
                        var selectRow = $("#uncriticalVM").widget().getTableCheckedItems();

                        _.each(selectRow, function(row) {
                            selectVmSet.push(_.pick(row, "uuid", "name"));
                        });

                        return selectVmSet
                    },
                    initPage: function(hostId) {
                        if($("#testSite").widget().getSelectedId() == "-1"){
                            message.error(appUtils.getString("recovery_vm_clusterMapping_recoverySite_validate"))
                            return;
                        };
                        //FC选择的站点没有集群的话也需要提示
                        if($scope.isExistMapping && $scope.clusterMappingShow && (_.isEmpty($scope.clusterMappingValue) || $scope.clusterMappingValue == "--")){
                            message.error(appUtils.getString("recovery_excute_no_cluster_label", $("#testSite").widget().getSelectedLabel()));
                            !_.isEmpty($("#uncriticalVM").widget()) && $("#uncriticalVM").widget().option("data", []);
                            return;
                        };
                        var recoverySiteId = $("#testSite").widget().getSelectedId();
                        this.isInit && mask.show();
                        this.isInit && communicationService.get(utilService.getResouceUrl("/fusionsphere/vms/action/getAvailableNonCirticalVm?planId=" + _winData.planId + "&&recoverySiteId=" + recoverySiteId)).promise().always(function(result){
                            mask.hide();
                            if (exception.check(result)) {
                                var arr = [];
                                _.each(result, function (d) {
                                    var tmo = _.pick(d, "uuid", "name");
                                    arr.push(tmo);
                                });
                                communicationService.get(utilService.getResouceUrl("/fusionsphere/vms/action/getSelectedNonCriticalVm?planId=" + _winData.planId + "&&recoverySiteId=" + recoverySiteId)).promise().always(function(respose){
                                    if(exception.check(respose)){
                                        _.each(respose,function(k){
                                            var choose = _.pick(k,"uuid","name")
                                            arr.push(choose);
                                        });
                                        _.isArray(respose) && _.each(respose, function(row) {
                                            (function(uuid) {
                                                setTimeout(function() {
                                                    $("#uncriticalVM").widget().setSelectedRow("uuid", uuid);
                                                }, 100);
                                            })(row.uuid);
                                        });
                                        !_.isEmpty($("#uncriticalVM").widget()) && $("#uncriticalVM").widget().option("data",appUtils.encodeForHTML(arr));
                                        $scope.$apply();
                                    }
                                });
                                $scope.fusionSphere3dcScope.uncriticalVM.isInit = false;
                            }
                        });
                    },
                    validate: function(){
                    	return true;
                    }
                }
            };
            $scope.fusionSphere3dcScope.clusterMapping.isInit && $scope.fusionSphere3dcScope.clusterMapping.initPage();
        }];
    var fusionSphere3dcExcute = angular.module("recoverydirector.recovery.config");
    fusionSphere3dcExcute.tinyController("recovery.fusionSpere3dc.execute.ctrl", fusionSphere3dcExcuteCtrl);
    return fusionSphere3dcExcute;
});
