define([], function() {
    "use strict";
    var fusionsphereCtrl = [
        "$scope",
        "$compile",
        "constsService",
        "appUtils",
        "restService",
        function($scope, $compile, constsService, appUtils, restService) {

            var _tips,
                _winData = $("#" + constsService.REMOTE_TEST_RECOVERY.winId).widget().option("data");

            switch (_winData.operateType) {
                case "test" :
                    _tips = appUtils.getString("recovery_network_test_tip");
                    break;
                case "move" :
                    _tips = appUtils.getString("recovery_network_move_tip", _winData.name);
                    break;
                case "fault" :
                    _tips = appUtils.getString("recovery_network_fault_tip", _winData.name);
                    break;
            }

            $scope.fusionVmwareScope = {
                label: _tips,
                view: "app/business/recoverydirector/recovery/views/operate/fusionVmwareCommon.html",
                table: {
                    id: "fusionspere",
                    columns: [
                        {"mData": "proUrn", "bVisible": false},
                        {"mData": "drUrn", "bVisible": false},
                        {"mData": "testUrn", "bVisible": false},
                        {"mData": "recSiteName", "bVisible": false},
                        {"sTitle": appUtils.getString("recovery_network_product_label"), "mData": "proName", "bSortable": false},
                        {"sTitle": appUtils.getString("recovery_network_daster_label"), "mData": "drName", "bSortable": false},
                        {"sTitle": appUtils.getString(constsService.remoteNetworkTitle[_winData.operateType]), "mData": "testName", "bSortable": false}],
                    data: [],
                    renderRow: function(nRow, aData, iDataIndex) {
                        var testNetworkColumn = "<tiny-select id='id' values='values' width='width' auto-open='autoOpen' open-fn='openFn' default-selectid='defaultSelectId'></tiny-select>";
                        var testLink = $compile(testNetworkColumn);
                        var testScope = $scope.$new();
                        testScope.id = "remoteNetwork_" + iDataIndex;
                        testScope.width = constsService.W2;
                        testScope.autoOpen = false;
                        testScope.openFn = function(object) {
                            restService.getFusionshpereByUrn({planId: _winData.planId, recNetworkUrn :aData['drUrn']} , function(result){
                                if(!_.isEmpty(result)) {
                                    var array = [];
                                    _.each(result, function (d, k) {
                                        var opt = {
                                            "checked": 0 == k,
                                            "selectId": d.testUrn,
                                            "label": d.testName
                                        };
                                        array.push(opt);
                                    });
                                    $("#" + testScope.id).widget().option("values", array);
                                }
                                object.open();
                            })
                        };

                        if (!_.isEmpty(aData['testUrn']) && !_.isEmpty(aData['testName'])) {
                            testScope.defaultSelectId = aData['testUrn'];
                            testScope.values = [
                                {
                                    "selectId": aData['testUrn'],
                                    "label": aData['testName']
                                }
                            ];
                        } else {
                            testScope.defaultSelectId = "default";
                            testScope.values = [
                                {
                                    "selectId": "default",
                                    "label": appUtils.getString("common_term_pleaseSelect_listbox")
                                }
                            ];
                        }

                        var testNode = testLink(testScope);
                        $("td:eq(2)", nRow).html(testNode);
                    }
                }
            };

            restService.getFusionsphereNetworkmappings({planId: _winData.planId}, function(result) {
                var array = [];
                _.each(result.testNetworkList, function (d) {
                    d.recSiteName = result.recSiteName;
                    var tmo = _.pick(d, "proUrn", "drUrn", "drUrn", "proName", "drName", "testName", "testUrn", "recSiteName");
                    array.push(tmo);
                });
                $scope.fusionVmwareScope.table.data = appUtils.encodeForHTML(array);
                $scope.$apply();
            })

            appUtils.addWinOkBtnCls(constsService.REMOTE_TEST_RECOVERY.winId);
        }]

    var fusionsphereApp = angular.module("recoverydirector.recovery.config");
    fusionsphereApp.tinyController("app.fusionsphere.ctrl", fusionsphereCtrl);
    return fusionsphereApp;
});