define([], function() {
    "use strict";
    var testCtrl = [
        "$scope",
        "message",
        "$compile",
        "constsService",
        "statusEnumService",
        "appUtils",
        "restService",
        function($scope, message, $compile, constsService, statusEnumService, appUtils, restService) {
            var _tips = "",
                _winData = $("#" + constsService.LOCAL_TEST_EXCUTE_RECOVERY.winId).widget().option("data");

            switch(_winData.operateType) {
                case "running":
                    _tips = (_winData["poType"] == 10 && _.contains([2, 14, 17, 19], _winData["templateType"])) ? appUtils.getString("recovery.term.excute.VMreplica.tips.label") : appUtils.getString("recovery.term.excute.replica.tips.label");
                    break;
                case "localTest":
                    _tips = appUtils.getString("recovery.term.test.replica.tips.label");
                    $scope.replicaLabelWidth = 40;
                    appUtils.isEn() && ($scope.hostGroupLabelWidth = 64);
                    break;
                default:
                    _tips = "--";
            }
            function showProtectObjWin(){
                var copyId = _.first($("#replicaTable").widget().getHoverData()).id;
                var win = angular.copy(constsService.COPY_PROTECTOBJ_DETAIL_WIN);
                win.helpId = "localTestExcuteWinId";
                win.data = {
                    copyId:copyId,
                    currentId:_winData.uuid,
                    protectUuid: _winData.protectUuid
                };
                win.buttons = [{
                    key: "ok",
                    label: appUtils.getString('common_term_close_button'),
                    focused: true,
                    handler: function(event){
                        $("#" + win.winId).widget().destroy();
                    }
                }];
                appUtils.showWindow(win);
            }
            //SAN一体化备份
            //起始页
            var _startPage = 1;
            var _siteLocation = _winData.productSiteId;
            var _startTime = "";
            var _endTime = "";
            var _replicaType = "";
            //转换数据模式,后台分页
            var transformData = function(data){
                if(_.isEmpty(data)){
                    return {
                        records: [],
                        totalCount: 0
                    };
                };
                return {
                    records: data.replicas,
                    totalCount: data.totalCount
                };
            };
            var firstTime = 0;
            var initByTime = function(isRefresh){

                _startTime = isRefresh || _.isEmpty($("#startTime").widget()) ? "" : $("#startTime").widget().getDateTime();
                _endTime = isRefresh || _.isEmpty($("#endTime").widget()) ? "" : $("#endTime").widget().getDateTime();
                _replicaType = firstTime == 0 ? "3" : (_.isEmpty($("#replicaType").widget()) ? "" : $("#replicaType").widget().getSelectedId());
                firstTime += 1;
                if(!_.isEmpty(_startTime) && _.isEmpty(_endTime)){
                    _startTime = appUtils.newDate(_startTime).getTime();
                    //未选择结束时间默认至2099年
                    _endTime = new Date().setFullYear(2099);
                };
                if(!_.isEmpty(_endTime) && _.isEmpty(_startTime)){
                    _endTime = appUtils.newDate(_endTime).getTime();
                    _startTime = 0;
                };
                if(!_.isEmpty(_endTime) && !_.isEmpty(_startTime)){
                    _startTime = appUtils.newDate(_startTime).getTime();
                    _endTime = appUtils.newDate(_endTime).getTime();
                };
                var params = {
                    protectGroupId: _winData.protectUuid,
                    startTime: _startTime,
                    endTime: _endTime,
                    startPage: _startPage,
                    siteId: _siteLocation,
                    replicaType: _replicaType
                };
                restService.queryPageSizeReplicas(params, function(result){
                    result = transformData(result);
                    var arr = [];
                    _.each(result.records, function(d) {
                        !_.isEmpty(d.props) && (d.StorageIds = d.props.StorageIds);
                        var mo = _.pick(d, "name", "id", "recoverySiteId", "timeStamp", "status", "index", "recoverySite", "protectLocation", "generation", "type", "protectArray", "StorageIds", "props");
                        arr.push(mo);
                    });
                    //快照克隆卷副本不能进行测试、回滚
                    if(_.contains([2], parseInt(_winData["templateType"], 10))){
                        arr = _.filter(arr, function(val){
                            return val.type != 9
                        });
                    };
                    $scope.replica.table.data = appUtils.encodeForHTML(arr);
                    $scope.replica.table.length = arr.length;
                    $scope.replica.table.enablePagination = result.totalCount > 10;
                    $scope.replica.table.totalRecords = result.totalCount;
                    $scope.$apply();
                });
            };
            var arr = [];
            if(_winData["operateType"] == "localTest") {
                arr = [{
                    selectId: "3",
                    label: appUtils.getString("pg_copybackuptype_snapshot_label")
                },{
                    selectId: "4",
                    label: appUtils.getString("pg_copybackuptype_hypercdp_label")
                }]
            } else {
                arr = [{
                    selectId: "3",
                    label: appUtils.getString("pg_copybackuptype_snapshot_label")
                },{
                    selectId: "4",
                    label: appUtils.getString("pg_copybackuptype_hypercdp_label")
                },{
                    selectId: "101",
                    label: appUtils.getString("pg_copybackuptype_cloudbackup_label")
                }]
            }

            function isSupportSpeed(trData) {
                restService.queryStorageLicense(trData.protectArray, {
                    mask: true,
                    success: function(result) {
                        $scope.rollbackSpeed.supportSpeed = !_.isUndefined(_.find(result.LicenseFunction, function(license) {
                            return (constsService.STORAGE_FEATURE_ENUM.HyperCDP == license.FeatureId || constsService.STORAGE_FEATURE_ENUM.HyperSnap == license.FeatureId) && !!license.FuncSwitch;
                        })) && $("#replicaType").widget().getSelectedId() != constsService.STORAGE_FEATURE_ENUM.CloudBackup;
                        $scope.$apply();
                    }
                });
            }

            $scope.isSanHyperVault = _.contains([30,31,32,19,2], parseInt(_winData.templateType, 10));
            $scope.rollbackSpeed = {
                tips: appUtils.getString("datarecovery_rollbackSpeed_tips_label"),
                title: appUtils.getStringWithColon("datarecovery_localrecovery_rollbackSpeed_label"),
                id: "rollbackSpeed",
                supportSpeed: false,
                width: constsService.W2,
                values: [{
                    selectId: "1",
                    label: appUtils.getString("datarecovery_rollbackSpeed_low_label")
                },{
                    selectId: "2",
                    label: appUtils.getString("datarecovery_rollbackSpeed_medium_label")
                },{
                    selectId: "3",
                    label: appUtils.getString("datarecovery_rollbackSpeed_high_label")
                },{
                    selectId: "4",
                    label: appUtils.getString("datarecovery_rollbackSpeed_highest_label")
                }],
                defaultSelectId: "2",
                closeFn: function() {}
            };
            $scope.refresh = {
                title: appUtils.getString("common_term_refresh_button"),
                init: function(){
                    if(!_.isEmpty($("#startTime").widget()) && !_.isEmpty($("#endTime").widget())){
                        $("#startTime").widget().empty();
                        $("#endTime").widget().empty();
                    };
                    _startPage = 1;
                    $scope.replica.table.curPage = {
                        "pageIndex": 1
                    };
                    initByTime(true);
                },
                startTime: {
                    id: "startTime",
                    label: appUtils.getString("common_term_from_label"),
                    type: "datetime",
                    dateFormat: "yy-mm-dd",
                    timeFormat: "hh:mm:ss",
                    width: constsService.W2,
                    onClose: function(){
                        _startPage = 1;
                        $scope.replica.table.curPage = {
                            "pageIndex": 1
                        };
                        initByTime();
                    }
                },
                endTime: {
                    id: "endTime",
                    label: appUtils.getString("common_term_to_label"),
                    type : "datetime",
                    dateFormat : 'yy-mm-dd',
                    timeFormat : "hh:mm:ss",
                    width: constsService.W2,
                    onClose: function() {
                        _startPage = 1;
                        $scope.replica.table.curPage = {
                            "pageIndex": 1
                        };
                        initByTime();
                    }
                },
                siteName: {
                    id: "siteName",
                    label: appUtils.getStringWithColon("recovery_test_replica_site_label"),
                    width: constsService.W2,
                    values: [{
                        selectId: "-1",
                        label: appUtils.getString("common_term_pleaseSelect_listbox")
                    }],
                    defaultSelectid: "-1",
                    closeFn: function(){
                        var siteId = $("#" + this.id).widget().getSelectedId();
                        _siteLocation = siteId;
                        _startPage = 1;
                        $scope.replica.table.curPage = {
                            "pageIndex": 1
                        };
                        initByTime();
                    }
                }
            };

            (function($scope, appUtils, restService) {
                $scope.replica = {
                    tips : _tips,
                    labelwidth: "80px",
                    title: appUtils.getStringWithColon("ism.drm.protect.group.tab.duplica"),
                    hostGroup: {
                        id: "hostGroup",
                        defaultSelectid: "-1",
                        autoOpen: false,
                        display: _winData["operateType"] == "localTest",
                        width: constsService.W3,
                        label: appUtils.getStringWithColon("recovery.term.test.replica.hosts.label"),
                        values: [
                            {
                                selectId: "-1",
                                label: appUtils.getString("common_term_pleaseSelect_listbox"),
                                checked: true
                            }
                        ],
                        openFn: function(object) {
                            restService.getAvailableDrHost({planId: _winData.planId}, function(data) {
                                if (!_.isEmpty(data)) {
                                    var array = [];

                                    if(_winData["poType"] == 9) {
                                        _.each(data, function(host, index) {
                                            if(Object.prototype.toString.call(host.name) === "[object Null]") {
                                                host.name = "null";
                                            }
                                            if(_.isEmpty(host.ipAddress)) {
                                                _.each(host.childResources, function(host, key){
                                                    array.push({
                                                        "selectId": host.deviceSn,
                                                        "label": host.name,
                                                        "checked": key == 0
                                                    });
                                                });
                                            } else {
                                                array.push({
                                                    "selectId": host.deviceSn,
                                                    "label": host.name,
                                                    "checked": index == 0
                                                });
                                            }
                                        })
                                    } else {
                                        _.each(data, function(host, index) {
                                            if(Object.prototype.toString.call(host.name) === "[object Null]") {
                                                host.name = "null";
                                            }
                                            array.push({
                                                "selectId": host.deviceSn,
                                                "label": host.name,
                                                "checked": index == 0
                                            });
                                        })
                                    }
                                    $("#hostGroup").widget().option("values", array);
                                }
                                object.open();
                            })
                        }
                    },
                    type: {
                        id: "replicaType",
                        label: appUtils.getStringWithColon("dataMount_abstract_replicatype_lable"),
                        width: constsService.W2,
                        values: arr,
                        closeFn:function() {
                            _replicaType = $("#" + this.id).widget().getSelectedId();
                            _startPage = 1;
                            $scope.replica.table.curPage = {
                                "pageIndex": 1
                            };
                            initByTime();
                        },
                        defaultSelectid: "3",
                        change: function() {}
                    },
                    table: {
                        id: "replicaTable",
                        data: [],
                        columns: [
                            {"mData": "id", "bVisible": false},
                            {"mData": "recoverySiteId", "bVisible": false},
                            {"mData": "index", "bVisible": false},
                            {"sTitle": appUtils.getString("recovery.term.colum.name.title"),"mData": "name"},
                            {"sTitle": appUtils.getString("recovery.term.test.replica.colum.replicaTime"), "mData": "timeStamp"}
                        ],
                        ownerEmptyDataMsg: appUtils.getString("recovery_test_ownerEmptyDataMsg"),
                        renderRow: function(nRow, aData, iDataIndex) {},
                        enablePagination: false,
                        callback: function(oPage) {},
                        cellClickActive: function(event, trData) {}
                    },
                    recoveryGoal:{
                        id: "hostType",
                        disabled: false,
                        spacing: { "width": "200px" },
                        isNewHost: false,
                        width: constsService.W4,
                        values: [{
                            "key": "physical",
                            "text": appUtils.getString("recovery_rollback_oldhost_label"),
                            "checked": true,
                            "disable": false
                        }, {
                            "key": "newHost",
                            "text": appUtils.getString("recovery_rollback_newhost_label"),
                            "checked": false,
                            "disable": false
                        }],
                        change: function() {
                            var isNewHost = $("#hostType").widget().opChecked("newHost");
                            $scope.replica.recoveryGoal.display = isNewHost;
                            $scope.$apply();
                        }
                    },
                    customTable: function() {
                        //snapshot 后台分页
                        if($scope.isSanHyperVault){
                            _.extend($scope.replica.table, {
                                callback: function(oPage) {
                                    _startPage = oPage.currentPage;
                                    initByTime();
                                }
                            })
                        };
                        if(_winData["operateType"] == "localTest"){
                            //快照和双活+快照
                            if(_.contains([2, 19], parseInt(_winData["templateType"], 10))){
                                $scope.replica.table.columns = $scope.replica.table.columns.concat([
                                    {"sTitle": appUtils.getString("datamount_create_resource_id_label"), "mData": "StorageIds", "bSortable": false},
                                    {"sTitle": appUtils.getString("recovery.term.test.replica.colum.status"), "mData": "status", "bSortable": false},
                                    {"sTitle": appUtils.getString("recovery.term.test.replica.colum.site"), "mData": "recoverySite", "bSortable": false},
                                    {"sTitle": appUtils.getString("protection_object_column_level_label"), "mData": "generation", "bSortable": false},
                                    {"sTitle": appUtils.getString("ism.drm.protect.group.tab.protectedObject"), "bSortable": false}
                                ])
                            }else{
                                $scope.replica.table.columns = $scope.replica.table.columns.concat([
                                    {"sTitle": appUtils.getString("recovery.term.test.replica.colum.status"), "mData": "status", "bSortable": false},
                                    {"sTitle": appUtils.getString("recovery.term.test.replica.colum.site"), "mData": "recoverySite", "bSortable": false},
                                    {"sTitle": appUtils.getString("ism.drm.protect.group.tab.protectedObject"), "bSortable": false}
                                ])
                            };
                            _.extend($scope.replica.table, {
                                renderRow: function(nRow, aData, iDataIndex) {
                                    $("td[tdtitle='" + appUtils.getString("recovery.term.test.replica.colum.status") +
                                        "']", nRow).html(statusEnumService.getStatus("LOCAL_TEST_REPLICAS_STATUS", aData["status"]));
                                    var optColumn = "<a href='javascript:void(0)' class='btn-link' ng-click='showProtectObj()'>" + appUtils.getString('common_term_view_button') + "</a> ";
                                    var optLink = $compile($(optColumn));
                                    var optScope = $scope.$new();
                                    optScope.showProtectObj = function() {
                                        showProtectObjWin();
                                    };
                                    var optNode = optLink(optScope);
                                    $("td[tdtitle='" + appUtils.getString("ism.drm.protect.group.tab.protectedObject") +
                                        "']", nRow).html(optNode);
                                }
                            });
                        }

                        if(_winData["operateType"] == "running") {
                            if(_.contains([18], parseInt(_winData["templateType"], 10))) {
                                $scope.replica.table.columns = $scope.replica.table.columns.concat([
                                    {"sTitle": appUtils.getString("recovery.term.test.replica.colum.status"), "mData": "status", "bSortable": false},
                                    {"sTitle": appUtils.getString("recovery.term.test.replica.colum.site"), "mData": "recoverySite", "bSortable": false},
                                    {"sTitle": appUtils.getString("ism.drm.protect.group.tab.protectedObject"), "bSortable": false}
                                ])
                            }
                            else if(_.contains([2], parseInt(_winData["templateType"], 10))){
                                $scope.replica.table.columns = $scope.replica.table.columns.concat([
                                    {"sTitle": appUtils.getString("datamount_create_resource_id_label"), "mData": "StorageIds", "bSortable": false},
                                    {"sTitle": appUtils.getString("recovery.term.test.replica.colum.status"), "mData": "status", "bSortable": false},
                                    {"sTitle": appUtils.getString("protection_object_column_level_label"), "mData": "generation", "bSortable": false},
                                    {"sTitle": appUtils.getString("datarecovery_localrecovery_rollbackSpeed_label"), "sWidth":"130px", "bSortable": false},
                                    {"sTitle": appUtils.getString("ism.drm.protect.group.tab.protectedObject"), "bSortable": false}
                                ])
                            }
                            else if(_.contains([19], parseInt(_winData["templateType"], 10))){
                                $scope.replica.table.columns = $scope.replica.table.columns.concat([
                                    {"sTitle": appUtils.getString("datamount_create_resource_id_label"), "mData": "StorageIds", "bSortable": false},
                                    {"sTitle": appUtils.getString("recovery.term.test.replica.colum.status"), "mData": "status", "bSortable": false},
                                    {"sTitle": appUtils.getString("recovery.term.test.replica.colum.site"), "mData": "recoverySite", "bSortable": false},
                                    {"sTitle": appUtils.getString("protection_object_column_level_label"), "mData": "generation", "bSortable": false},
                                    {"sTitle": appUtils.getString("datarecovery_localrecovery_rollbackSpeed_label"), "sWidth":"130px", "bSortable": false},
                                    {"sTitle": appUtils.getString("ism.drm.protect.group.tab.protectedObject"), "bSortable": false}
                                ])
                            }
                            else if(17 == parseInt(_winData["templateType"], 10) && _winData["poType"] == 10) {
                                $scope.replica.table.columns = $scope.replica.table.columns.concat([
                                    {"sTitle": appUtils.getString("recovery.term.test.replica.colum.status"), "mData": "status", "bSortable": false},
                                    {"sTitle": appUtils.getString("ism.drm.protect.group.tab.protectedObject"), "bSortable": false}
                                ])
                            }
                            else if (_.contains([30,31,32], parseInt(_winData["templateType"], 10))) {
                                $scope.replica.table.columns = $scope.replica.table.columns.concat([
                                    {"sTitle": appUtils.getString("datamount_create_resource_id_label"), "mData": "StorageIds", "bSortable": false},
                                    {"sTitle": appUtils.getString("recovery.term.test.replica.colum.status"), "mData": "status", "bSortable": false},
                                    {"sTitle": appUtils.getString("protection_object_column_level_label"), "mData": "generation", "bSortable": false},
                                    {"sTitle": appUtils.getString("datarecovery_localrecovery_rollbackSpeed_label"), "sWidth":"130px", "bSortable": false},
                                    {"sTitle": appUtils.getString("ism.drm.protect.group.tab.protectedObject"), "bSortable": false}
                                ])
                            }
                            else {
                                $scope.replica.table.columns = $scope.replica.table.columns.concat([
                                    {"sTitle": appUtils.getString("recovery.term.test.replica.colum.status"), "mData": "status", "bSortable": false},
                                    {"sTitle": appUtils.getString("ism.drm.protect.group.tab.protectedObject"), "bSortable": false}
                                ])
                            }
                            _.extend($scope.replica.table, {
                                renderRow: function(nRow, aData, iDataIndex) {
                                    $("td[tdtitle='" + appUtils.getString("recovery.term.test.replica.colum.status") +
                                        "']", nRow).html(statusEnumService.getStatus("LOCAL_TEST_REPLICAS_STATUS", aData["status"]));
                                    var optColumn = "<a href='javascript:void(0)' class='btn-link' ng-click='showProtectObj($event)'>" + appUtils.getString('common_term_view_button') + "</a> ";
                                    var optLink = $compile($(optColumn));
                                    var optScope = $scope.$new();
                                    optScope.showProtectObj = function($event) {
                                        if(!_.isEmpty($event)){
                                            $event.stopPropagation ? $event.stopPropagation() : window.event.cancelBubble = true;
                                        };
                                        showProtectObjWin();
                                    };
                                    var optNode = optLink(optScope);
                                    $("td[tdtitle='" + appUtils.getString("ism.drm.protect.group.tab.protectedObject") +
                                        "']", nRow).html(optNode);
                                    var speedInput = '<tiny-select id="speedInput.id" values="speedInput.values" width="speedInput.width" default-selectid="speedInput.defaultSelectid"></tiny-select>';
                                    var newScope = $scope.$new();
                                    newScope.speedInput = {
                                        id: "input_" + aData.id,
                                        values: [{
                                            selectId: "1",
                                            label: appUtils.getString("datarecovery_rollbackSpeed_low_label")
                                        },{
                                            selectId: "2",
                                            label: appUtils.getString("datarecovery_rollbackSpeed_medium_label")
                                        },{
                                            selectId: "3",
                                            label: appUtils.getString("datarecovery_rollbackSpeed_high_label")
                                        },{
                                            selectId: "4",
                                            label: appUtils.getString("datarecovery_rollbackSpeed_highest_label")
                                        }],
                                        defaultSelectid: "2",
                                        width: 120
                                    };
                                    var speedNode = $compile($(speedInput))(newScope);
                                    aData.type != 101 && $("td[tdtitle='" + appUtils.getString("datarecovery_localrecovery_rollbackSpeed_label") +
                                        "']", nRow).html(speedNode);
                                },
                                drawCallback: function(){
                                    var tipNode = '<div style="display:inline-block;position: relative;top:-3px;" id="rollbackSpeedTip"><tiny-icontip tip="rollbackSpeed.tips"></tiny-icontip></div>';
                                    var tipScope = $scope.$new();
                                    tipScope.rollbackSpeed = {
                                        tips: appUtils.getString("datarecovery_rollbackSpeed_tips_label")
                                    };
                                    var tipHtml = $compile($(tipNode))(tipScope);
                                    var typeWidget = $("#replicaType").widget();
                                    if (!_.isEmpty(typeWidget) && typeWidget.getSelectedId() != 101 && _.size($("#rollbackSpeedTip")) == 0) {
                                        $("th[aria-label='" + appUtils.getString("datarecovery_localrecovery_rollbackSpeed_label") + "'] .tiny-table-title-label").after(tipHtml);
                                    };
                                    if (!_.isEmpty(typeWidget) && typeWidget.getSelectedId() == 101) {
                                        $("th[aria-label='" + appUtils.getString("datarecovery_localrecovery_rollbackSpeed_label") + "']").hide();
                                        $("td[tdtitle='" + appUtils.getString("datarecovery_localrecovery_rollbackSpeed_label") + "']").hide();
                                    } else {
                                        $("th[aria-label='" + appUtils.getString("datarecovery_localrecovery_rollbackSpeed_label") + "']").show();
                                        $("td[tdtitle='" + appUtils.getString("datarecovery_localrecovery_rollbackSpeed_label") + "']").show();
                                    }
                                    if (!_.isEmpty($scope.replica.table.data) && !_.isEmpty(_.first($scope.replica.table.data).props) && _.first($scope.replica.table.data).props.isSecond == "true") {
                                        $("th[aria-label='" + appUtils.getString("ism.drm.protect.group.tab.protectedObject") + "']").hide();
                                        $("td[tdtitle='" + appUtils.getString("ism.drm.protect.group.tab.protectedObject") + "']").hide();
                                    } else {
                                        $("th[aria-label='" + appUtils.getString("ism.drm.protect.group.tab.protectedObject") + "']").show();
                                        $("td[tdtitle='" + appUtils.getString("ism.drm.protect.group.tab.protectedObject") + "']").show();
                                    }
                                }
                            });
                            return;
                        }
                    }
                }
                $scope.replica.customTable();

            })($scope, appUtils, restService);

            if($scope.isSanHyperVault){
                restService.queryLocalServer([], function(data) {
                    if (data) {
                        restService.querySites([data.uuid], function(data) {
                            appUtils.updateSelectValues("siteName", data, "siteId", "name");
                            $scope.refresh.siteName.defaultSelectid = _winData.productSiteId;
                            $scope.$apply();
                        });
                    };
                });
                initByTime();
            } else {
                restService.getReplicasList({protectUuid: _winData.protectUuid}, function(data) {
                    var arr = [];
                    _.each(data, function(d) {
                        var mo;
                        if (_.contains([2], parseInt(_winData["templateType"], 10))) {
                            mo = _.pick(d, "name", "id", "recoverySiteId", "timeStamp", "status", "index", "recoverySite", "protectLocation", "generation", "type", "protectArray");
                        } else {
                            mo = _.pick(d,"name", "id", "recoverySiteId", "timeStamp", "status", "index", "recoverySite", "protectLocation", "generation", "protectArray");
                        };
                        arr.push(mo);
                    });
                    //快照克隆卷副本不能进行测试、回滚
                    if(_.contains([2], parseInt(_winData["templateType"], 10))){
                        arr = _.filter(arr, function(val){
                            return val.type != 9
                        });
                    };
                    $scope.replica.table.data = appUtils.encodeForHTML(arr);
                    $scope.replica.table.length = arr.length;
                    $scope.$apply();
                })
            }

            appUtils.addWinOkBtnCls(constsService.LOCAL_TEST_EXCUTE_RECOVERY.winId);
        }]
    var testRecoveryPlanApp = angular.module("recoverydirector.recovery.config");
    testRecoveryPlanApp.tinyController("app.local.test.recovery.plan.ctrl", testCtrl);
    return testRecoveryPlanApp;
})