define([], function() {
        "use strict";
        var msgWindowCtrl = [
            "$scope",
            "constsService",
            "appUtils",
            "$sce",
            "cookieService",
            function($scope, constsService, appUtils, $sce, cookieService) {
                var obj = $("#" + constsService.REMOTE_TEST_RECOVERY.winId).widget().option("data");
                $scope.model = {
                    type: {
                        id: "recoveryType",
                        values: [
                            {
                                "key": "1",
                                "text": appUtils.getString("recovery.term.fault.recoveryType.lastestData"),
                                "checked": true
                            },
                            {
                                "key": "2",
                                "text": appUtils.getString("recovery.term.fault.recoveryType.lastestLun")
                            }
                        ],
                        spacing: {"width": "30px"}
                    },
                    warnMsg: obj.operateType == "move" ? $sce.trustAsHtml(appUtils.getString("recovery_messsage_plan_move_confirm_tips", $.encoder.encodeForHTML(obj.name)))
                        : $sce.trustAsHtml(appUtils.getString("recovery_messsage_fault_recovery_confirm_tips", $.encoder.encodeForHTML(obj.name))),
                    container: "HostReplication" == $.trim(obj.protectType) && obj.operateType == "fault" ? true : false,
                    typeLabel: appUtils.getStringWithColon("recovery.term.fault.recoveryType.lable"),
                    wayTip: appUtils.getString("recovery.term.fault.recoveryType.tips")
                }
            }
        ]
        var msgWindowApp = angular.module("recoverydirector.recovery.config");
        msgWindowApp.tinyController("app.msgWindow.ctrl", msgWindowCtrl);
        return msgWindowApp;
    }
)