define([], function() {
    "use strict";
    var ctrl = [
        "$scope",
        "utilService",
        "constsService",
        "appUtils",
        "restService",
        function($scope, utilService, constsService, appUtils, restService) {
            var winData = $("#" + constsService.NAS_HYPERMETRO_SWITCH_WIN.winId).widget().option("data");
            $scope.messageContent1 = appUtils.getString("recovery_nas_hypermetro_switch_excute_label1", winData.name);
            $scope.messageContent2 = appUtils.getString("recovery_nas_hypermetro_switch_excute_label2");
            $scope.suggestionContent = appUtils.getString("recovery_nas_hypermetro_switch_suggestion_label");
            //查询保护组使用的存储
            function init(){
                restService.getRecoveryStorageInfo([winData["protectUuid"]],function(response){
                    if(!_.isEmpty(response)){
                        if(response[0].priorityStationType == "0"){
                            $scope.localSiteName = response[0].name;
                            $scope.remoteSiteName = response[1].name;
                            $scope.isLocalPriorSite = appUtils.getString("recovery_nas_hypermetro_test_excute_site");
                            $scope.isRemotePriorSite = "";
                        }else{
                            $scope.localSiteName = response[1].name;
                            $scope.remoteSiteName = response[0].name;
                            $scope.isLocalPriorSite = appUtils.getString("recovery_nas_hypermetro_test_excute_site");
                            $scope.isRemotePriorSite = "";
                        }
                        $scope.$apply();
                    }
                })
            }

            init()
        }
    ];
    var reprotectRecoveryApp = angular.module("recoverydirector.recovery.config");
    reprotectRecoveryApp.tinyController("nas-hypermetro-switch-ctrl", ctrl);
    return reprotectRecoveryApp;
})

