define([], function() {
    "use strict";
    var ctrl = [
        "$scope",
        "utilService",
        "constsService",
        "appUtils",
        "restService",
        "statusEnumService",
        function($scope, utilService, constsService, appUtils,restService,statusEnumService) {
            var data = $("#"+constsService.COPY_PROTECTOBJ_DETAIL_WIN.winId).widget().option("data");
            $scope.table = {
                copy:{
                    id:"copy",
                    label:appUtils.getString("copy_time_protected_objects"),
                    enablePagination:false,
                    totalRecords:"",
                    data:[],
                    sScrollY: "230px",
                    renderRow:function(nRow, aData, iDataIndex){
                        $("td:eq(2)", nRow).html(statusEnumService.getStatus("PROTECT_OBJECT_TYPE", aData['poType']));
                        if(_.isEmpty(aData['pgName'])){
                            $("td:eq(1)", nRow).html("--")
                        }
                    }
                },
                current:{
                    id:"current",
                    label:appUtils.getString("current_time_protected_objects"),
                    enablePagination:false,
                    data:[],
                    totalRecords:"",
                    sScrollY: "230px",
                    renderRow:function(nRow, aData, iDataIndex){
                        $("td:eq(2)", nRow).html(statusEnumService.getStatus("PROTECT_OBJECT_TYPE", aData['poType']));
                    }
                },
                difference:{
                    id:"difference",
                    label:appUtils.getString("copy_vs_current_protected_objects"),
                    enablePagination:false,
                    data:[],
                    renderRow:function(nRow, aData, iDataIndex){
                        $("td:eq(3)", nRow).html(statusEnumService.getStatus("PROTECT_OBJECT_TYPE", aData['poType']));
                        if(_.isEmpty(aData['pgName'])){
                            $("td:eq(2)", nRow).html("--")
                        };
                        if(aData['differenceStatus'] == "-1"){
                            $("td:eq(0)", nRow).html(appUtils.getString("protected_objects_remove_label"));
                        }
                        if(aData['differenceStatus'] == "1"){
                            $("td:eq(0)", nRow).html(appUtils.getString("protected_objects_add_label"));
                        }
                    },
                    columns:[{
                        "mData": "uuid",
                        "bVisible": false
                    },{
                        "sTitle": appUtils.getString("protected_objects_change_type_label"),
                        "mData":"differenceStatus",
                        "bSortable": false
                    },{
                        "sTitle": appUtils.getString("recovery.term.protected.colum.name.title"),
                        "mData": "name",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("recovery.term.protected.colum.owernerGroup.title"),
                        "mData": "pgName",
                        "bSortable": false
                    },{
                        "sTitle": appUtils.getString("recovery.term.protected.colum.type.title"),
                        "mData": "poType",
                        "bSortable": false
                    }]
                },
                columns: [{
                    "mData": "uuid",
                    "bVisible": false
                }, {
                    "sTitle": appUtils.getString("recovery.term.protected.colum.name.title"),
                    "mData": "name",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("recovery.term.protected.colum.owernerGroup.title"),
                    "mData": "pgName",
                    "bSortable": false
                },{
                    "sTitle": appUtils.getString("recovery.term.protected.colum.type.title"),
                    "mData": "poType",
                    "bSortable": false
                }],
                isSameLabel:appUtils.getString("protected_objects_no_difference")
            };
            $scope.showDetails = false;
            $scope.isSame = true;
            function copyInit(response){
                restService.getCopyProtectgroups({protectgroupId:data.protectUuid,replicaId:data.copyId},{
                    success:function(result){
                       $scope.table.copy.data = appUtils.encodeForHTML(result.records);
                       $scope.table.copy.totalRecords = result.records.length;
                       $scope.table.copy.enablePagination = result.records.length > 10;
                       _.each($scope.table.copy.data,function(obj){
                            obj.pgName = response[0].pgName
                       });
                       $scope.$apply();
                       showDifference($scope.table.copy.data,response);
                    }
                })
            };
            function currentInit(callback){
                var params = {
                    uuid:data.currentId,
                    startPage:0,
                    pageSize:512,
                    orderBy:"name",
                    orderType:"asc"
                };
                restService.getRecoveryProtectObject(params,{
                    success:function(result){
                        $scope.table.current.data = appUtils.encodeForHTML(result.records);
                        $scope.table.current.totalRecords = result["totalCount"];
                        $scope.table.current.enablePagination = result["totalCount"] > 10;
                        $scope.$apply();
                        callback(result.records);
                    }
                })
            };
            function showDifference(copyObj,currentObj){
                var currentUuid = [],
                    copyUuid = [],
                    addUuid = [],
                    reduceUuid = [],
                    differenceObj = [];
                _.each(copyObj,function(obj){
                    copyUuid.push(obj.uuid);
                });
                _.each(currentObj,function(obj){
                    currentUuid.push(obj.uuid);
                });
                _.each(copyUuid,function(val){
                    if(!_.contains(currentUuid,val)){
                        reduceUuid.push(val);
                    }
                });
                _.each(currentUuid,function(val){
                    if(!_.contains(copyUuid,val)){
                        addUuid.push(val);
                    }
                });
                _.each(copyObj,function(val){
                    if(_.contains(reduceUuid,val.uuid)){
                        _.extend(val,{
                            differenceStatus:"-1"
                        });
                        differenceObj.push(val);
                    }
                });
                _.each(currentObj,function(val){
                    if(_.contains(addUuid,val.uuid)){
                        _.extend(val,{
                            differenceStatus:"1"
                        });
                         differenceObj.push(val);
                    }
                });
                $scope.table.difference.data = appUtils.encodeForHTML(differenceObj);
                $scope.table.difference.enablePagination = differenceObj.length > 10;
                $scope.table.difference.totalRecords = differenceObj.length;
                $scope.showDetails = true;
                if(differenceObj.length == 0){
                    $scope.isSame = true;
                }else{
                    $scope.isSame = false;
                }
                $scope.$apply();
            }
            currentInit(copyInit);
        }
    ];
    var protectionObjectApp = angular.module("recoverydirector.recovery.config");
    protectionObjectApp.tinyController("recovery_protection_object_ctrl", ctrl);
    return protectionObjectApp;
})