define([], function () {
    var ctrl = ["$scope", "$state", "constsService", "appUtils", "$sce", "message", "restService", function ($scope, $state, constsService, appUtils, $sce, message, restService) {
        var data = $("#" + constsService.RECOVERY_REGION_AZ_WIN.winId).widget().option("data");
        $scope.model = {
            labels: {
                currentRegion: appUtils.getStringWithColon("recovery_migration_csha_csdr_currentregion_label"),
                targetRegion: appUtils.getStringWithColon("recovery_migration_csha_csdr_targetregion_label"),
                targetAz: appUtils.getStringWithColon("recovery_migration_csha_csdr_targetaz_label"),
                migrationType: appUtils.getStringWithColon("recovery_migration_csha_csdr_migrationtype_label"),
                interRegional: appUtils.getString("recovery_migration_csha_csdr_interregional_label"),
                currentRegionName: data.$scope.regionName[data.uuid]
            },
            targetRegion: {
                id: "targetRegion",
                defaultId: "-1",
                cloneValues: [],
                values: [{
                    selectId: "-1",
                    label: appUtils.getString("common_term_pleaseSelect_listbox")
                }],
                width: constsService.W3,
                change: function () {
                    var regionId = $("#targetRegion").widget().getSelectedId();
                    var object = _.findWhere($scope.model.targetRegion.cloneValues, { "recovery_region_id": regionId });
                    var azone = _.findWhere(_.findWhere(data.$scope.regionInfo, { regionId: regionId })['availableZones'], { azId: object["recovery_az_id"] });
                    $scope.targetAzId = azone["azId"] ;
                    $scope.targetAzName = azone["azName"];
                },
                closeFn: function () {
                    if ("-1" == $("#targetRegion").widget().getSelectedId()) {
                        $scope.targetAzId = "";
                        $scope.targetAzName = "";
                        $scope.interRegional = "";
                    } else {
                        $scope.interRegional = _.isEqual($.trim($("#targetRegion").widget().getSelectedLabel()), $.trim($scope.model.labels.currentRegionName)) ? appUtils.getString("recovery_migration_csha_csdr_Intraregional_label") : appUtils.getString("recovery_migration_csha_csdr_interregional_label");
                    }
                    $scope.$apply();
                },
                openFn: function (object) {
                    restService.queryRecoveryRegionAz([data.planId], {
                        isShowMsgBox: false,
                        success: function (datas) {
                            if (!_.size(datas)) {
                                return;
                            }

                            var values = [{
                                selectId: "-1",
                                label: appUtils.getString("common_term_pleaseSelect_listbox")
                            }];

                            _.each(datas, function (v, k) {
                                var region = _.findWhere(data.$scope.regionInfo, { regionId: v.recovery_region_id });
                                values.push({ selectId: v.recovery_region_id, label: region.regionName });
                            });

                            $("#targetRegion").widget().option("values", values);
                            $scope.model.targetRegion.cloneValues = angular.copy(datas);
                            object.open();
                        }
                    });
                }
            }
        }
    }]

    var module = angular.module("recoverydirector.recovery.config");
    module.tinyController("recovery.regionAzCtrl", ctrl);
    return module;
})