define([],
    function () {
        "use strict";
        var testCtrl = [
            "$scope",
            "message",
            "mask",
            "constsService",
            "appUtils",
            "restService",
            "utilService",
            "communicationService",
            function ($scope, message, mask, constsService, appUtils, restService, utilService, communicationService) {
                var _globalSetKey;

                var _winData = $("#" + constsService.REMOTE_TEST_RECOVERY.winId).widget().option("data");

                var _initPage = function(siteId) {
                    restService.getRemoteAvailableDrHost({planId: _winData.planId, siteId: siteId}, function(result) {
                        var array = [];
                        if(_winData["poType"] == 9) {
                            _.each(result, function(host) {
                                if (_.isEmpty(host.ipAddress)) {
                                    _.each(host.childResources, function(host){
                                        host.isCluster = false;
                                        array.push(_.pick(host, "deviceSn", "name", "ipAddress", "isCluster", "childResources", "isMounted"));
                                    });
                                } else {
                                    array.push(_.pick(host, "deviceSn", "name", "ipAddress", "isCluster", "childResources", "isMounted"));
                                }
                            });
                        } else {
                            _.each(result, function(host) {
                                array.push(_.pick(host, "deviceSn", "name", "ipAddress", "isCluster", "childResources", "isMounted"));
                            });
                        }
                        $scope.remoteScope.table.data = appUtils.encodeForHTML(array);
                        $scope.$apply();
                    });
                };

                /**
                 * 查询一下是否已经测试执行过
                 */
                var _queryHavingTestHostSn = function () {
                    mask.show();
                    var _url = utilService.getResouceUrl("/recoveryplans/" + _winData.planId + "/globalSettings?key=" + _globalSetKey);
                    communicationService.get(_url).promise().always(function (result) {
                        mask.hide();
                        if (!_.isEmpty(result)) {
                            var status = $.trim(_.property(_globalSetKey)(JSON.parse(result)));
                            if ("" == status || "6" == status) {
                                if (_winData.operateType == "move") {
                                    message.prompt(appUtils.getString("recovery.term.recovery.host.change.move.msg"));
                                } else {
                                    message.prompt(appUtils.getString("recovery.term.recovery.host.change.fault.msg"));
                                }
                            }
                        }
                    });
                }

                $scope.remoteScope = {
                    label: appUtils.getString("recovery.term.recovery.sites.label"),
                    title : appUtils.getString("recovery.term.recovery.unusedHost.table.title"),
                    sites : {
                        "id": "recoverySites",
                        "width": constsService.W2,
                        "autoOpen": false,
                        "defaultSelectId": "default",
                        "values": [{"selectId": "default", "label": appUtils.getString("common_term_pleaseSelect_listbox")}],
                        "change": function () {
                            var siteId = $("#recoverySites").widget().getSelectedId();
                            siteId !== "default" && _initPage(siteId);
                        },
                        "closeFn": function (object, evt) {
                            var siteId = $("#recoverySites").widget().getSelectedId();
                            siteId !== "default" && _initPage(siteId);
                        },
                        "openFn": function (object) {
                            restService.getRemoteDisasterSite({uuid: _winData.planId}, function(data) {
                                if (!_.isEmpty(data)) {
                                    var array = [];
                                    _winData.operateType == "fault" && (data = _.filter(data, function(d){
                                        return d.siteType != 1;
                                    }));
                                    _.each(data, function (site, index) {
                                        if(Object.prototype.toString.call(site.name) === "[object Null]") {
                                            site.name = "null";
                                        }
                                        array.push({
                                            "selectId": site.siteId,
                                            "label": site.name,
                                            "checked": index == 0
                                        });
                                    })
                                    !_.isEmpty(array) && $("#recoverySites").widget().option("values", array);
                                }
                                object.open();
                            })
                        }
                    },
                    table: {
                        "id": "hostTable",
                        "columns": [
                            {"mData": "deviceSn", "bVisible": false},
                            {"mData": "childResources", "bVisible": false},
                            {"sTitle": appUtils.getString("recovery.term.recovery.unusedHost.colum.name.title"), "mData": "name", "bSortable": false},
                            {"sTitle": appUtils.getString("recovery.term.recovery.unusedHost.colum.ip.title"), "mData": "ipAddress", "bSortable": false},
                            {"sTitle": appUtils.getString("recovery.term.recovery.unusedHost.colum.type.title"), "mData": "isCluster", "bSortable": false}],
                        data: [],
                        cellClickActive: function (e, param) {
                            _globalSetKey = param.deviceSn && param.deviceSn + "_TestResult";
                            if (_winData.operateType == "move" || "fault" == _winData.operateType) {
                                _queryHavingTestHostSn();
                            }
                        },
                        renderRow: function (nRow, aData, iDataIndex) {
                            if (aData["isCluster"]) {
                                $("td:eq(2)", nRow).html(appUtils.getString("recovery.term.recovery.unusedHost.colum.type.hostGroup"))
                            } else {
                                $("td:eq(2)", nRow).html(appUtils.getString("recovery.term.recovery.unusedHost.colum.type.host"))
                            }
                        }
                    }
                }
                appUtils.addWinOkBtnCls(constsService.REMOTE_TEST_RECOVERY.winId);
            } ]
        var testRecoveryPlanApp = angular.module("recoverydirector.recovery.config");
        testRecoveryPlanApp.tinyController("app.remote.test.recovery.plan.ctrl", testCtrl);
        return testRecoveryPlanApp;
    })