define([], function() {
    "use strict";
    var ctrl = [
        "$scope",
        "utilService",
        "constsService",
        "appUtils",
        "restService",
        function($scope, utilService, constsService, appUtils, restService) {
            var winData = $("#" + constsService.SAN_HYPERMETRO_TEST_WIN.winId).widget().option("data");
            $scope.sanTestTitle = appUtils.getStringWithColon("recovery_san_hypermetro_test_excute_label");
            $scope.model = {
                local: {
                    id: "localRadio",
                    name: "santestRadio",
                    text: "",
                    value: "0",
                    checked: true
                },
                remote: {
                    id: "remoteRadio",
                    name: "santestRadio",
                    text: "",
                    value: "1",
                    checked: false
                }
            };
            //查询保护组使用的存储
            function init(){
                restService.getRecoveryStorageInfo([winData["protectUuid"]],{
                    mask: true,
                    success: function(response){
                        if(!_.isEmpty(response)){
                            if(response[0]["priorityStationType"] == 0){
                                $scope.isLocalPriorSite = appUtils.getString("recovery_san_hypermetro_test_excute_site");
                                $scope.isRemotePriorSite = "";
                                $("#localRadio").widget().option("text", "<span title='"+response[0]["name"]+"'>"+response[0]["name"]+"</span>");
                                $("#localRadio").widget().option("value", response[0]["priorityStationType"]);
                                $("#remoteRadio").widget().option("text", "<span title='"+response[1]["name"]+"'>"+response[1]["name"]+"</span>");
                                $("#remoteRadio").widget().option("value", response[1]["priorityStationType"]);
                            }else{
                                $scope.isLocalPriorSite = appUtils.getString("recovery_san_hypermetro_test_excute_site");
                                $scope.isRemotePriorSite = "";
                                $("#localRadio").widget().option("text", "<span title='"+response[1]["name"]+"'>"+response[1]["name"]+"</span>");
                                $("#localRadio").widget().option("value", response[1]["priorityStationType"]);
                                $("#remoteRadio").widget().option("text", "<span title='"+response[0]["name"]+"'>"+response[0]["name"]+"</span>");
                                $("#remoteRadio").widget().option("value", response[0]["priorityStationType"]);
                            }
                            $scope.$apply()
                        }
                    },
                    callback: function(){}
                })
            }

            init()
        }
    ];
    var reprotectRecoveryApp = angular.module("recoverydirector.recovery.config");
    reprotectRecoveryApp.tinyController("san-hypermetro-test-ctrl", ctrl);
    return reprotectRecoveryApp;
})

