define([], function() {
    "use strict";
    var sansnapshotExcuteCtrl = [
        "$scope",
        "$compile",
        "restService",
        "cookieService",
        "communicationService",
        "utilService",
        "exception",
        "constsService",
        "mask",
        "message",
        "appUtils",
        "infoTransferredService",
        "statusEnumService",
        function($scope, $compile, restService, cookieService, communicationService, utilService, exception, constsService, mask, message, appUtils, infoTransferredService, statusEnumService) {
            $scope.isEn = appUtils.isEn();
            var _winData = $("#vmwareIncrementTypeExecute").widget().option("data");
            var _pleaseSelect_label = appUtils.getString("common_term_pleaseSelect_listbox");
            var _btnText = appUtils.getString("common_term_confirm_button");
            var _testSiteLabel = appUtils.getStringWithColon("recovery.term.testSite.label");
            var _testvCenterLabel = appUtils.getStringWithColon("recovery.term.testvCenter.label");
            var _testClusterLabel = appUtils.getStringWithColon("recovery.term.testCluster.label");
            //修改窗口按钮的文字
            switch (_winData["operateType"])
            {
                case "move" :
                    _btnText = appUtils.getString("common_term_plan_move_button");
                    _testSiteLabel = appUtils.getStringWithColon("recovery.term.vrg.recovery_site.title");
                    _testvCenterLabel = appUtils.getStringWithColon("recovery.term.vrg.recovery_vCenter.title");
                    _testClusterLabel = appUtils.getStringWithColon("recovery.term.vrg.recovery_cluster.title");
                    break;
                case "fault":
                    _btnText = appUtils.getString("ism.drm.protect.group.fault.recovery.label");
                    _testSiteLabel = appUtils.getStringWithColon("recovery.term.vrg.recovery_site.title");
                    _testvCenterLabel = appUtils.getStringWithColon("recovery.term.vrg.recovery_vCenter.title");
                    _testClusterLabel = appUtils.getStringWithColon("recovery.term.vrg.recovery_cluster.title");
                    break;
                case "test":
                    _btnText = appUtils.getString("common_term_test_button");
                    _testSiteLabel = appUtils.getStringWithColon("recovery.term.testSite.label");
                    _testvCenterLabel = appUtils.getStringWithColon("recovery.term.testvCenter.label");
                    _testClusterLabel = appUtils.getStringWithColon("recovery.term.testCluster.label");
                    break;
                default:
                    _btnText = appUtils.getString("common_term_confirm_button");
            }
            //点击副本恢复时调用该方法对比保护对象是否一致
            var compareProtectedObject = function(copyId,currentId,protectUuid,callback1){
                var differenceObj = [];
                function copyInit(response){
                    restService.getCopyProtectgroups({protectgroupId:protectUuid,replicaId:copyId},{
                        success:function(result){
                           showDifference(result.records,response);
                           callback1(differenceObj);
                        }
                    })
                };
                function currentInit(callback){
                    var params = {
                        uuid:currentId,
                        startPage:0,
                        pageSize:512,
                        orderBy:"name",
                        orderType:"asc"
                    };
                    restService.getRecoveryProtectObject(params,{
                        success:function(result){
                            callback(result.records);
                        }
                    })
                };
                function showDifference(copyObj,currentObj){
                    var currentUuid = [],
                        copyUuid = [],
                        addUuid = [],
                        reduceUuid = [];
                    _.each(copyObj,function(obj){
                        copyUuid.push(obj.uuid);
                    });
                    _.each(currentObj,function(obj){
                        currentUuid.push(obj.uuid);
                    });
                    _.each(copyUuid,function(val){
                        if(!_.contains(currentUuid,val)){
                            reduceUuid.push(val);
                        }
                    });
                    _.each(currentUuid,function(val){
                        if(!_.contains(copyUuid,val)){
                            addUuid.push(val);
                        }
                    });
                    _.each(copyObj,function(val){
                        if(_.contains(reduceUuid,val.uuid)){
                            _.extend(val,{
                                differenceStatus:"-1"
                            });
                            differenceObj.push(val);
                        }
                    });
                    _.each(currentObj,function(val){
                        if(_.contains(addUuid,val.uuid)){
                            _.extend(val,{
                                differenceStatus:"1"
                            });
                            differenceObj.push(val);
                        }
                    });
                }
                currentInit(copyInit);
            };
            var confirmExcute = function(diff) {
                if(diff.length > 0) {
                    message.warn({
                        content:appUtils.getString("test_protectedObj_not_same_tips"),
                        ok:function(){
                            __sendAjax();
                        }
                    })
                    return;
                };
                __sendAjax()
            }
            $("#vmwareIncrementTypeExecute").widget().option("buttons", [{
                key: "ok",
                label: _btnText,
                focused: true,
                handler: function(event) {
                    if ($scope.copyInfoDisplay) {
                        var replica = _.first($("#replicaTable").widget().getTableCheckedItems());
                        if (_.isEmpty(replica) || _.isUndefined(replica)) {
                            message.error(appUtils.getString("recovery.term.test.replica.message.least"));
                            return;
                        }

                        compareProtectedObject(replica.id ,_winData.uuid,_winData.protectUuid, confirmExcute);
                        return;
                    }
                    __sendAjax()
                }
            }, {
                key: "cancel",
                label: appUtils.getString('common_term_cancel_button'),
                focused: false,
                handler: function(event) {
                    $("#vmwareIncrementTypeExecute").widget().destroy();
                }
            }]);

            $scope.protectObjectsLabel = appUtils.getString("show_copy_time_protected_objects_tips");
            var _executeSettingModel = {
                formatDataToSelect: function(domId, data, idKey, labelKey, defaultVal) {
                	if( _.isEmpty(data) || !_.isArray(data) || (data.length == 1 && _.isEmpty(data[0][idKey]) && _.isEmpty(data[0][labelKey])) ) {
                		$("#" + domId).widget().option("values", [{ "selectId": "-1", "checked": true, "label": defaultVal}]);
                		return;
                	}

                    var vals = [];
                    _.each(data, function(item, index) {
                        if(Object.prototype.toString.call(item[labelKey]) === "[object Null]") {
                            vals.push({selectId: item[idKey], label: "null", checked: index == 0});
                        } else{
                            vals.push({selectId: item[idKey], label: item[labelKey], checked: index == 0});
                        }
                    });
                    $("#" + domId).widget().option("values", vals);
                },
                setClusterMapping: {
                    queryTestSite: function(object) {
                        //[SAN快照范畴]
                        if (_.contains([2, 19], _winData.templateType)) {
                            restService.queryLocalServer([], {
                                mask: false,
                                success: function (data) {
                                    if (!_.isEmpty(data)) {
                                        restService.querySites({serverUuid: data.uuid}, {
                                            mask: false,
                                            callback: function (result) {
                                                _executeSettingModel.formatDataToSelect("testSite", result, "siteId", "name", _pleaseSelect_label);
                                                object.open();
                                            }
                                        });
                                    }
                                }
                            });
                            return;
                        }

                        restService.getRemoteDisasterSite({uuid: _winData.planId}, {
                            mask: false,
                            callback: function(result) {
                                _winData.operateType == "fault" && (result = _.filter(result, function(data){
                                    return data.siteType != 1;
                                }));
                                _executeSettingModel.formatDataToSelect("testSite", result, "siteId", "name", _pleaseSelect_label);
                                object.open();
                            }
                        });
                    },
                    queryTestvCenter: function(object) {
                    	var siteId = $("#testSite").widget().getSelectedId();
                    	if( siteId == -1) {
                            _executeSettingModel.formatDataToSelect("testvCenter", [], "vCenterUuid", "name", _pleaseSelect_label);
                    		object.open();
                    		return;
                    	}
                        restService.queryVCenterBySite({siteId: siteId}, {
                            mask: false,
                            callback: function(result) {
                                _executeSettingModel.formatDataToSelect("testvCenter", result, "vCenterUuid", "name", _pleaseSelect_label);
                                object.open();
                            }
                        });
                    },
                    queryTestCluster: function(object) {
                    	var vcenterUuid = $("#testvCenter").widget().getSelectedId();
                    	if( vcenterUuid == -1) {
                            _executeSettingModel.formatDataToSelect("testCluster", [], "uuid", "name", _pleaseSelect_label);
                    		object.open();
                    		return;
                    	}
                        restService.getvCenterTestCluster({vcenterUuid: vcenterUuid}, {
                            mask: false,
                            callback: function(result) {
                                //过滤San快照生产集群和测试集群相同的数据
                                _.contains([2, 19], _winData.templateType) && !_.isEmpty($.trim($("#srcHostId").text())) && (
                                    result = _.filter(result, function (obj) {
                                        return obj.uuid != $.trim($("#srcHostId").text());
                                    })
                                )
                                _executeSettingModel.formatDataToSelect("testCluster", result, "uuid", "name", _pleaseSelect_label);
                                object.open();
                            }
                        });
                    }

                },
                networkMapping: {
                    tableData: [],
                    updateTable: function(tableId, searchVal) {
                        if (_.isUndefined(this.tableData) || _.isEmpty(this.tableData)) {
                            this.tableData = _.clone($("#" + tableId).widget().getTableData());
                        }

                        var result = [];
                        _.each(this.tableData, function(obj) {
                            if (obj.name.toUpperCase().indexOf(searchVal.toUpperCase()) != -1) {
                                result.push(obj);
                            }
                        });
                        $("#" + tableId).widget().option("data", result);
                    },
                    changePairStatus : function(){
                        var selectCount = 0,statusClass = {
                            0: "resource-unpaired png",
                            1: "resource-unselect-all-paired png",
                            2: "resource-paired png"
                        },
                        statusSpan = {
                            0: appUtils.getString("common_term_add_mapping_unmapped"),
                            1: appUtils.getString("common_term_add_mapping_mapping"),
                            2: appUtils.getString("common_term_add_mapping_mapped")
                        };

                        var hasEmptyTable = false;
                        $.each(tableViewSites, function(index) {
                                var tableId = this.table.id;
                                var tableData = $("#" + tableId).widget().getTableData();
                                if(_.isEmpty(tableData)) {
                                    hasEmptyTable = true;
                                    return false;
                                }
                                var select = $("#" + tableId).widget().getTableCheckedItems();

                                if (!angular.isArray(select) || 0 == select.length) {
                                    return;
                                }
                                selectCount ++;
                        });

                        if(hasEmptyTable) {
                            $scope.vmSanSnapshotScope.networkMapping.pairStatusSpan = statusSpan[0];
                            if($("#pairStatusId").hasClass(statusClass[2])){
                                $("#pairStatusId").removeClass(statusClass[2]).addClass(statusClass[0]);
                            }
                                $("#pairStatusId").removeClass(statusClass[1]).addClass(statusClass[0]);
                        } else {
                            $scope.vmSanSnapshotScope.networkMapping.pairStatusSpan = statusSpan[selectCount];
                            if(selectCount==1){
                                if($("#pairStatusId").hasClass(statusClass[2])){
                                    $("#pairStatusId").removeClass(statusClass[2]).addClass(statusClass[1]);
                                }
                                $("#pairStatusId").removeClass(statusClass[0]).addClass(statusClass[1]);
                            };
                            if(selectCount==2){
                                if($("#pairStatusId").hasClass(statusClass[1])){
                                    $("#pairStatusId").removeClass(statusClass[1]).addClass(statusClass[2]);
                                }
                                $("#pairStatusId").removeClass(statusClass[0]).addClass(statusClass[2]);
                            }
                        }
                        if(selectCount == 2) {
                            $scope.vmSanSnapshotScope.networkMapping.addBtn.disable = false;
                            $("#addBtn").css("border", "1px solid #53B8EB");
                        } else {
                            $scope.vmSanSnapshotScope.networkMapping.addBtn.disable = true;
                            $("#addBtn").css("border", "1px solid #c3c3c3");
                        };
                        $scope.$apply();
                    },
                    addRow: function() {
                        var errorMsg;
                        var addObj = {id: [], name: []};
                        $.each(tableViewSites, function(index) {
                            var tableId = this.table.id;
                            var select = $("#" + tableId).widget().getTableCheckedItems();
                            if (!_.isArray(select) || 0 == select.length) {
                                if(appUtils.isEn()) {
                                    errorMsg = _pleaseSelect_label + " " + angular.lowercase(this.title.replace(":", "")) + ".";
                                    return false;
                                }
                                errorMsg = _pleaseSelect_label + this.title.replace(":", "") + "。";
                                return false;
                            }
                            addObj.name.push(select[0].name);
                            addObj.id.push(select[0].id);
                        });

                        if (!_.isUndefined(errorMsg)) {
                            message.error(errorMsg);
                            return;
                        }

                        $("#mappingViewTable").widget().addTableRows(addObj);

                        var widget = $("#productionResTable").widget();
                        widget.option("data", _.filter(widget.getTableData(), function(value, key) {
                            return value.id !== _.first(widget.getTableCheckedItems()).id;
                        }));
                    },
                    operation: appUtils.newOpAreaAction("mappingViewTable", {
                        remove: function(row) {
                            if (_.isUndefined(row)) {
                                return;
                            }
                            $.each(tableViewSites, function(index) {
                                var rowObj = {id: row.id[index], name: row.name[index]};
                                this.table.id == "productionResTable" && $("#" + this.table.id).widget().addTableRows(rowObj);
                            });

                            var mappingViewTable = $("#mappingViewTable").widget();
                            var sourceDatas = mappingViewTable.getTableData();
                            appUtils.removeFromArray(sourceDatas, [row], "id");
                            mappingViewTable.option("data", sourceDatas);
                            $("#mappingViewTable .OpButton_main").hide();
                            _executeSettingModel.networkMapping.changePairStatus();
                        }
                    })
                }
            };
            var productionResTable = {
                title: appUtils.getStringWithColon("common.term.productionResource.label"),
                filter: {
                    "id": "productSearchId",
                    "display": true,
                    "width": "180px",
                    "placeholder": appUtils.getString("recovery.term.abstact.planNameLabel"),
                    "search": _executeSettingModel.networkMapping.productionResTableSearch
                },
                table: {
                    "checkbox": false,
                    "columnsDraggable":false,
                    "currPage": 1,
                    "id": "productionResTable",
                    "displayLength": constsService.TABLE_COUNT_MAX_PAGE,
                    "totalRecords": 0,
                    "enablePagination": false,
                    "columns" : [ { "mData" : "id", "bSortable" : false, "bVisible" : false },
                                  {"sTitle" : appUtils.getString("notify_alarm_term_name_column"),"mData" : "name"}],
                    "data": [],
                    "cellClickActive": _executeSettingModel.networkMapping.changePairStatus
                },
                initTable: function() {
                    if ($scope.copyInfoDisplay) {
                        var selectedReplica = !_.isEmpty($("#replicaTable").widget()) ? _.first($("#replicaTable").widget().getTableCheckedItems()) : {};
                        if (_.isEmpty(selectedReplica)) {
                            return;
                        };
                        $scope.vmSanSnapshotScope.networkMapping.tableViewSites[0].table.data = [];
                        !_.isEmpty($("#mappingViewTable").widget()) && $("#mappingViewTable").widget().option("data", []);
                        $scope.$apply();
                        restService.getCopyProtectgroups({
                            protectgroupId: _winData.protectUuid,
                            replicaId: selectedReplica.id
                        }, {
                            success: function(result){
                                var productData = [];
                                if (!_.isEmpty(result) && !_.isEmpty(result.records)) {
                                    _.isArray(result.records) && _.each(result.records, function(po) {
                                        var netWorks = po.props.VirtualEthernetCard;
                                        _.isString(netWorks) && (netWorks = JSON.parse(netWorks));
                                        !_.isEmpty(netWorks) && _.each(netWorks, function(card) {
                                            card.id = card.netWorkUuid;
                                            card.name = card.netWorkName;
                                            productData.push(_.pick(card, "id", "name"));
                                        });
                                    });
                                    productData = _.uniq(productData, false, function(val) {
                                        return val.id
                                    });
                                    $scope.vmSanSnapshotScope.networkMapping.tableViewSites[0].table.data = appUtils.encodeForHTML(productData);
                                    $scope.$apply();
                                } else {
                                    $scope.vmSanSnapshotScope.networkMapping.tableViewSites[0].table.data = [];
                                    $scope.vmSanSnapshotScope.networkMapping.mappingViewTable.data = [];
                                    $scope.$apply();
                                }
                            },
                            fail: function(){
                                $scope.vmSanSnapshotScope.networkMapping.tableViewSites[0].table.data = [];
                                $scope.vmSanSnapshotScope.networkMapping.mappingViewTable.data = [];
                                $scope.$apply();
                            }
                        });
                    } else {
                        restService.getVmwareNetworkmappings({
                            planId: _winData.planId,
                            networkType: _winData.networkType
                        }, {
                            mask: true,
                            success: function(result) {
                                var mappingData = [];
                                var productData = [];
                                _.isArray(result) && _.each(result, function(obj) {
                                    var addObj = {
                                        id: [],
                                        name: []
                                    };
                                    if (!$scope.vmSanSnapshotScope.clusterMapping.testCluster.changeId && (!_.isEmpty(obj.remoteNetworkId) || !_.isEmpty(obj.remoteNetworkName))) {
                                        addObj.id.push(obj.srcNetworkId);
                                        addObj.name.push(obj.srcNetworkName);
                                        addObj.id.push(obj.remoteNetworkId);
                                        addObj.name.push(obj.remoteNetworkName);
                                        mappingData.push(addObj);
                                    } else {
                                        obj.id = obj.srcNetworkId;
                                        obj.name = obj.srcNetworkName;
                                        productData.push(_.pick(obj, "id", "name"));
                                    }
                                });
                                $scope.vmSanSnapshotScope.networkMapping.tableViewSites[0].table.data = appUtils.encodeForHTML(productData);
                                $scope.vmSanSnapshotScope.networkMapping.mappingViewTable.data = appUtils.encodeForHTML(mappingData);
                                $scope.$apply();
                            },
                            fail: function() {
                                $scope.vmSanSnapshotScope.networkMapping.tableViewSites[0].table.data = [];
                                $scope.vmSanSnapshotScope.networkMapping.mappingViewTable.data = [];
                                $scope.$apply();
                            }
                        });
                    }
                }
            };
            var drResTable = {
                title: appUtils.getStringWithColon("common.term.drResource.label"),
                filter: {
                    "id": "drResSearchId",
                    "display": true,
                    "width": "180px",
                    "placeholder": appUtils.getString("recovery.term.abstact.planNameLabel"),
                    "search": _executeSettingModel.networkMapping.drResTableSearch
                },
                table: {
                    "checkbox": false,
                    "columnsDraggable":false,
                    "currPage": 1,
                    "id": "drResTable",
                    "displayLength": constsService.TABLE_COUNT_MAX_PAGE,
                    "totalRecords": 0,
                    "enablePagination": false,
                    "columns" : [ { "mData" : "id", "bSortable" : false, "bVisible" : false },
                                  {"sTitle" : appUtils.getString("notify_alarm_term_name_column"),"mData" : "name"}],
                    "data": [],
                    "cellClickActive": _executeSettingModel.networkMapping.changePairStatus
                },
                initTable: function(hostUuid) {
                    var vcenterUuid = $("#testvCenter").widget().getSelectedId();
                    if(vcenterUuid == -1) {
                        message.error(appUtils.getString("recovery_vm_clusterMapping_testvCenter_validate"));
                        return;
                    }
                    restService.getRecoveryHostNetwork({hostOrClusterId: hostUuid, vcenterUuid: vcenterUuid}, {
                        mask: true,
                    	success: function(result){
                    		var drResData = [];

                            _.isArray(result) && _.each(result, function(obj) {
                                obj.id = obj.remoteNetworkId;
                                obj.name = obj.remoteNetworkName;
                                drResData.push(_.pick(obj, "id", "name"));
                            });
                            $scope.vmSanSnapshotScope.networkMapping.tableViewSites[1].table.data = appUtils.encodeForHTML(drResData);
                            $scope.$apply();
                    	},
                        fail: function() {
                            $scope.vmSanSnapshotScope.networkMapping.tableViewSites[1].table.data = [];
                            $scope.$apply();
                        }
                    });

                }
            };
            var tableViewSites = [productionResTable,drResTable];
            var _summerys = [
                {
                    valueId: "srcSiteId",
                    value: "",
                    nameId: "srcSiteName",
                    name: "--",
                    key: appUtils.getStringWithColon("recovery.term.abstact.productionSiteLabel")
                },
                {
                    valueId: "srcVcenterId",
                    value: "",
                    nameId: "srcVcenterName",
                    name: "--",
                    key: appUtils.getStringWithColon("recovery.term.productionvCenter.label")
                },
                {
                    valueId: "srcHostId",
                    value: "",
                    nameId: "srcHostName",
                    name: "--",
                    key: appUtils.getStringWithColon("recovery.term.productionCluster.label")
                }
            ];

            var __getRequestInfo = function() {
                var reqInfo = {};
                if (_winData.operateType == "test") {
                    var siteName = appUtils.encodeForHTML($.trim($("#testSite").widget().getSelectedLabel()));
                    reqInfo.tips = appUtils.getString("recovery_wmware_remoteTestwarn_label", _winData.name, siteName);
                    if(_winData.planType == 2)
                    {
                        reqInfo.url = utilService.getResouceUrl("/recoveryplans/" + _winData.planId + "/action/test");
                    }
                    else  //vmware的SAN快照测试
                    {
                        var _id = _.first($("#replicaTable").widget().getTableCheckedItems())["id"];
                        var _disasterHostSn = $("#testvCenter").widget().getSelectedId();
                        reqInfo.url = utilService.getResouceUrl("/recoveryplans/" + _winData.planId + "/action/testLocalDrp?replicaId=" + _id + "&productSiteId=" + _winData.productSiteId + "&disasterHostSn=" + _disasterHostSn);
                    }
                }

                if (_winData.operateType == "move") {
                    reqInfo.tips = appUtils.getString("recovery_wmware_movewarn_label", _winData.name);
                    if((_winData.templateType == 1 && _winData.templateSubType == 2) || _winData.isNasHyperCopy){
                        //NAS异步复制没有测试，提示语中不应包含测试字样
                        reqInfo.tips = appUtils.getString("recovery_messsage_nasHyper_plan_move_confirm_tips", _winData.name);
                    };
                    reqInfo.url = utilService.getResouceUrl("/recoveryplans/" + _winData.planId + "/action/plannedMigration");
                }

                if (_winData.operateType == "fault") {
                    reqInfo.tips = appUtils.getString("recovery_wmware_faultwarn_label", _winData.name);
                    if((_winData.templateType == 1 && _winData.templateSubType == 2) || _winData.isNasHyperCopy){
                        reqInfo.tips = appUtils.getString("recovery_messsage_nasHyper_fault_recovery_confirm_tips", _winData.name);
                    };
                    reqInfo.url = utilService.getResouceUrl("/recoveryplans/" + _winData.planId + "/action/diasterRecovery");
                }
                return reqInfo;
            };

            var __sendAjax = function() {
                var __reqInfo = __getRequestInfo();
                var _contextParams = {};
                var _validateResult = [];
                $.each($scope.vmSanSnapshotScope, function(index, config) {
                    if (!_.isUndefined(config.display) && config.display) {
                        if (_.isFunction(config.validate) && !config.validate()) {
                            _validateResult.push(false);
                            return false;
                        }
                        !_.isEmpty(config.getValue()) && _.extend(_contextParams, config.getValue());
                    }
                });

                if(_.indexOf(_validateResult, false) != -1) {
                    return;
                }
            	message.warn({
                    content: __reqInfo.tips, ok: function () {
                        mask.show();
                        communicationService.put(__reqInfo.url, _contextParams).promise().always(function (result) {
                            mask.hide();
                            if (exception.check(result)) {
                            	//发广播更新当前选中行的数据
                                !_.isEmpty(infoTransferredService.get("tipModule", "obj")) && delete infoTransferredService.get("tipModule", "obj")[_winData.uuid];
                                _winData.$scope.exec = true;
                                _winData.$scope.$emit("recoveryExecute", _winData.planId);
                                message.success({content: appUtils.getString("common_term_command_send_success_label"), ok: function () {
                                    	$("#vmwareIncrementTypeExecute").widget().destroy();
                                        _winData.$state.go("dataUse.dataRecovery.procedure");
                                    }
                                });
                            }
                        });
                    }
                });
            };

            $scope.copyInfoDisplay = false;
            $scope.summerys = _summerys;
            $scope.vmSanSnapshotScope = {
                constant: {
                    label: {
                        selvCenterAndCluster: appUtils.getString(constsService.VMWARE_EXECUTE._clusterMappingDesc[_winData.operateType]),
                        addNetworkMapping: appUtils.getString(constsService.VMWARE_EXECUTE._networkMappingDesc[_winData.operateType]),
                        setAccess: appUtils.getString(constsService.VMWARE_EXECUTE._accessSettingDesc[_winData.operateType]),
                        selUncriticalVM: appUtils.getString(constsService.VMWARE_EXECUTE._uncriticalVMDesc[_winData.operateType])
                    },
                    title: {
                        clusterMapping: appUtils.getString(constsService.VMWARE_EXECUTE._tabTitle[_winData.operateType].clusterMapping),
                        networkMapping: appUtils.getString(constsService.VMWARE_EXECUTE._tabTitle[_winData.operateType].networkMapping),
                        accessSetting: appUtils.getString("recovery.term.accessSetting.tab"),
                        uncriticalVM: appUtils.getString("recovery.term.uncriticalVM.tab")
                    }
                },
                datasTable: {
                    id: "replicaTable",
                    data: [],
                    columns: [
                        {"mData": "id", "bVisible": false},
                        {"mData": "recoverySiteId", "bVisible": false},
                        {"mData": "index", "bVisible": false},
                        {"sTitle": appUtils.getString("recovery.term.colum.name.title"),"mData": "name"},
                        {"sTitle": appUtils.getString("recovery.term.test.replica.colum.replicaTime"), "mData": "timeStamp"},
                        {"sTitle": appUtils.getString("recovery.term.test.replica.colum.status"), "mData": "status", "bSortable": false},
                        {"sTitle": appUtils.getString("recovery.term.test.replica.colum.site"), "mData": "recoverySite", "bSortable": false},
                        {"sTitle": appUtils.getString("protection_object_column_level_label"), "mData": "generation", "bSortable": false},
                        {"sTitle": appUtils.getString("ism.drm.protect.group.tab.protectedObject"), "bSortable": false}
                    ],
                    currPage: {
                        pageIndex: 1
                    },
                    queryParams: {
                        startPage: 1,
                        pageSize: 10
                    },
                    paging: "auto",
                    totalRecords: 0,
                    displayLength: 10,
                    renderRow: function(nRow, aData, iDataIndex) {
                        $("td[tdtitle='" + appUtils.getString("recovery.term.test.replica.colum.status") +
                            "']", nRow).html(statusEnumService.getStatus("LOCAL_TEST_REPLICAS_STATUS", aData["status"]));
                        var optColumn = "<a href='javascript:void(0)' class='btn-link' ng-click='showProtectObj()'>" + appUtils.getString('common_term_view_button') + "</a> ";
                        var optLink = $compile($(optColumn));
                        var optScope = $scope.$new();
                        optScope.showProtectObj = function() {
                            var win = angular.copy(constsService.COPY_PROTECTOBJ_DETAIL_WIN);
                            win.helpId = "localTestExcuteWinId";
                            win.data = {
                                copyId: _.first($("#replicaTable").widget().getHoverData()).id,
                                currentId:_winData.uuid,
                                protectUuid: _winData.protectUuid
                            };
                            win.buttons = [{
                                key: "ok",
                                label: appUtils.getString('common_term_close_button'),
                                focused: true,
                                handler: function(event){
                                    $("#" + win.winId).widget().destroy();
                                }
                            }];
                            appUtils.showWindow(win);
                        };
                        var optNode = optLink(optScope);
                        $("td[tdtitle='" + appUtils.getString("ism.drm.protect.group.tab.protectedObject") + "']", nRow).html(optNode);
                    },
                    enablePagination: false,
                    cellClickActive: function(e, param) {
                        var widgetTable = $("#replicaTable").widget();
                        var currentReplica = _.first(widgetTable.getTableCheckedItems()).id;
                        if(!_.isEmpty($scope.oldReplica) && currentReplica == $scope.oldReplica) {
                            return;
                        };
                        $scope.vmSanSnapshotScope.networkMapping.tableViewSites[0].initTable();
                        $scope.oldReplica = currentReplica;
                    },
                    hoverActive: function(e, param) {},
                    callback: function(evtObj) {
                        $scope.vmSanSnapshotScope.datasTable.queryData({startPage: evtObj.currentPage});
                    },
                    queryData: function(queryParams) {
                        var startTime = _.isEmpty($("#startTime").widget()) ? "" : $("#startTime").widget().getDateTime();
                        var endTime = _.isEmpty($("#endTime").widget()) ? "": $("#endTime").widget().getDateTime();
                        var replicaType = _.isEmpty($("#replicaType").widget()) ? "": $("#replicaType").widget().getSelectedId();
                        var siteId = _.isEmpty($("#siteName").widget()) ? _winData.productSiteId:  $("#siteName").widget().getSelectedId();
                        var replicaType = _.isEmpty($("#replicaType").widget()) ? 3 : $("#replicaType").widget().getSelectedId();

                        if (!_.isEmpty(startTime) && _.isEmpty(endTime)){
                            startTime = appUtils.newDate(startTime).getTime();
                            //未选择结束时间默认至2099年
                            endTime = new Date().setFullYear(2099);
                        }

                        if (!_.isEmpty(endTime) && _.isEmpty(startTime)){
                            endTime = appUtils.newDate(endTime).getTime();
                        }

                        if (!_.isEmpty(startTime) && !_.isEmpty(endTime)){
                            startTime = appUtils.newDate(startTime).getTime();
                            endTime = appUtils.newDate(endTime).getTime();
                        }

                        var params = {
                            protectGroupId: _winData.protectUuid,
                            startTime: startTime,
                            endTime: endTime,
                            startPage: 1,
                            siteId: siteId,
                            replicaType: replicaType
                        };

                        if (!_.isEmpty(queryParams)) {
                            _.extend(params, queryParams);
                        }
                        restService.queryPageSizeReplicas(params, function(result) {
                            var arr = [];
                            _.each(result.replicas, function(d) {
                                var mo = _.pick(d, "name", "id", "recoverySiteId", "timeStamp", "status", "index", "recoverySite", "protectLocation", "generation", "type");
                                arr.push(mo);
                            });
                            $scope.vmSanSnapshotScope.datasTable.data = appUtils.encodeForHTML(arr);
                            $scope.vmSanSnapshotScope.datasTable.totalRecords = result.totalCount;
                            $scope.$apply();
                        });
                    }
                },
                refresh: {
                    label: appUtils.getStringWithColon("ism.drm.protect.group.tab.duplica"),
                    title: appUtils.getString("common_term_refresh_button"),
                    click: function() {
                        $("#endTime").widget().empty();
                        $("#startTime").widget().empty();
                        $scope.vmSanSnapshotScope.datasTable.queryData();
                    },
                    startTime: {
                        id: "startTime",
                        label: appUtils.getString("common_term_from_label"),
                        type: "datetime",
                        dateFormat: "yy-mm-dd",
                        timeFormat: "hh:mm:ss",
                        width: constsService.W2,
                        onClose: function() {
                            $scope.vmSanSnapshotScope.datasTable.queryData();
                        }
                    },
                    endTime: {
                        id: "endTime",
                        label: appUtils.getString("common_term_to_label"),
                        type: "datetime",
                        dateFormat: 'yy-mm-dd',
                        timeFormat: "hh:mm:ss",
                        width: constsService.W2,
                        onClose: function() {
                            $scope.vmSanSnapshotScope.datasTable.queryData();
                        }
                    },
                    siteName: {
                        id: "siteName",
                        label: appUtils.getStringWithColon("recovery_test_replica_site_label"),
                        width: constsService.W2,
                        values: function() {
                            if (_.isEmpty(_winData.productSiteId)) {
                                return [{
                                    selectId: "-1",
                                    label: appUtils.getString("common_term_pleaseSelect_listbox")
                                }]
                            }
                            return [{
                                selectId: _winData.productSiteId,
                                label: _winData.productSiteName
                            }]
                        }(),
                        defaultSelectid: _.isEmpty(_winData.productSiteId) ? "-1" : _winData.productSiteId,
                        closeFn: function() {
                            $scope.vmSanSnapshotScope.datasTable.queryData();
                        },
                        openFn: function(object) {
                            restService.queryLocalServer([], function(data) {
                                restService.querySites([data.uuid], function(data) {
                                    appUtils.updateSelectValues("siteName", data, "siteId", "name");
                                    $scope.vmSanSnapshotScope.refresh.siteName.defaultSelectid = _winData.productSiteId;
                                    $scope.$apply();
                                });
                            });
                        }
                    },
                    type: {
                        id: "replicaType",
                        label: appUtils.getStringWithColon("dataMount_abstract_replicatype_lable"),
                        width: constsService.W2,
                        defaultSelectid: "3",
                        values: [{
                            selectId: "3",
                            label: appUtils.getString("pg_copybackuptype_snapshot_label")
                        },{
                            selectId: "4",
                            label: appUtils.getString("pg_copybackuptype_hypercdp_label")
                        }],
                        closeFn: function() {
                            $scope.vmSanSnapshotScope.datasTable.queryData();
                        },
                    }
                },
                clusterMapping: {
                    isInit: true,
                    display: true,
                    networkbackgroudimage: "/theme/recoverydirector/images/recovery/cluster_mapping.png",
                    testSite: {
                        "id": "testSite",
                        "width": "200px",
                        "autoOpen": false,
                        "require": true,
                        "oldSelectId": "-1",
                        "defaultSelectId": "-1",
                        "values": [{"selectId": "-1","label": _pleaseSelect_label}],
                        "label": _testSiteLabel,
                        "openFn": _executeSettingModel.setClusterMapping.queryTestSite,
                        "change":function(){
                             $("#testvCenter").widget().option('values',[{"selectId": "-1","label": _pleaseSelect_label}]);
                             $("#testCluster").widget().option('values',[{"selectId": "-1","label": _pleaseSelect_label}]);
                             $scope.$apply();
                        },
                        "closeFn": function() {
                            var newSelectedId = $("#testSite").widget().getSelectedId()
                            if(newSelectedId != $scope.vmSanSnapshotScope.clusterMapping.testSite.oldSelectId) {
                                $("#testvCenter").widget().option('values',[{"selectId": "-1","label": _pleaseSelect_label}]);
                                $("#testCluster").widget().option('values',[{"selectId": "-1","label": _pleaseSelect_label}]);
                            }
                            $scope.vmSanSnapshotScope.clusterMapping.testSite.oldSelectId =newSelectedId;
                            $scope.$apply();
                        },
                        "getValue": function() {
                            return {
                                id: $("#testSite").widget().getSelectedId(),
                                label: $("#testSite").widget().getSelectedLabel()
                            };
                        }
                    },
                    testvCenter: {
                        "id": "testvCenter",
                        "width": "200px",
                        "autoOpen": false,
                        "require": true,
                        "oldSelectId": "-1",
                        "changeId": false,
                        "defaultSelectId": "-1",
                        "values": [{"selectId": "-1","label": _pleaseSelect_label}],
                        "label": _testvCenterLabel,
                        "openFn": _executeSettingModel.setClusterMapping.queryTestvCenter,
                        "change":function(){
                            $scope.vmSanSnapshotScope.uncriticalVM.isInit = true;
                            $scope.vmSanSnapshotScope.networkMapping.isInit = true;
                            $("#testCluster").widget().option('values',[{"selectId": "-1","label": _pleaseSelect_label}]);
                            $scope.$apply();
                        },
                        "closeFn": function() {
                            var newSelectedId = $("#testvCenter").widget().getSelectedId();
                            if( newSelectedId != $scope.vmSanSnapshotScope.clusterMapping.testvCenter.oldSelectId) {
                                $scope.vmSanSnapshotScope.uncriticalVM.isInit = true;
                                $scope.vmSanSnapshotScope.networkMapping.isInit = true;
                                $scope.vmSanSnapshotScope.clusterMapping.testvCenter.changeId = true;
                                $("#testCluster").widget().option('values',[{"selectId": "-1","label": _pleaseSelect_label}]);
                            }
                            $scope.vmSanSnapshotScope.clusterMapping.testvCenter.oldSelectId = newSelectedId;
                            $scope.$apply();
                        },
                        "getValue": function() {
                            return {
                                id: $("#testvCenter").widget().getSelectedId(),
                                label: $("#testvCenter").widget().getSelectedLabel()
                            };
                        }
                    },
                    testCluster: {
                        "id": "testCluster",
                        "width": "200px",
                        "autoOpen": false,
                        "require": true,
                        "oldSelectId": "-1",
                        "changeId": false,
                        "defaultSelectId": "-1",
                        "tipshow": _winData.operateType != "test",
                        "values": [{"selectId": "-1","label": _pleaseSelect_label}],
                        "label": _testClusterLabel,
                        "openFn": _executeSettingModel.setClusterMapping.queryTestCluster,
                        "warnTips": appUtils.getString("recovery_cluster_task_recover_info_message"),
                        "closeFn": function() {
                            var newSelectedId = $("#testCluster").widget().getSelectedId();
                            if(-1 == newSelectedId) {
                                return;
                            }
                            $scope.vmSanSnapshotScope.clusterMapping.testCluster.changeId = newSelectedId != $scope.vmSanSnapshotScope.clusterMapping.testCluster.oldSelectId;
                            //重置测试网络和非重要虚拟机的数据
                            $scope.vmSanSnapshotScope.networkMapping.isInit = true;
                            $scope.vmSanSnapshotScope.networkMapping.initPage(newSelectedId);
                            if($scope.vmSanSnapshotScope.uncriticalVM.display) {
                                $scope.vmSanSnapshotScope.uncriticalVM.isInit = true;
                                $scope.vmSanSnapshotScope.uncriticalVM.initPage(newSelectedId);
                            };
                            $scope.$apply();
                        },
                        "getValue": function() {
                            return {
                                id: $("#testCluster").widget().getSelectedId(),
                                label: $("#testCluster").widget().getSelectedLabel()
                            };
                        }
                    },
                    initPage: function() {
                        var _queryType = _.contains(["move", "fault"], _winData.operateType) ? "recovery" : "test";
                        this.isInit && restService.getRecoveryClusterMapping({planId: _winData.planId, queryType: _queryType}, {
                            mask: true,
                            success: function(response) {
                                if(_.isEmpty(response)) {
                                    $scope.vmSanSnapshotScope.clusterMapping.isInit = false;
                                    $scope.$apply();
                                    return;
                                }
                                var result;
                                if(_.isArray(response)) {
                                    result = response[0];
                                } else {
                                    result = response;
                                }
                                var _dealEmptyResult = function(value) {
                                    if(Object.prototype.toString.call(value) === "[object Null]") {
                                        return "null";
                                    }
                                    if (_.isUndefined($.trim(value)) || _.isEmpty($.trim(value))) {
                                        return "--";
                                    }
                                    return $.trim(value);
                                };

                                _.each(_summerys, function(data, index) {
                                    if (index == 0) {
                                        _.extend(data, {name: _winData.productSiteName, value: _winData.productSiteId});
                                    } else if (index == 1) {
                                        _.extend(data, {name: _dealEmptyResult(result.srcVcenterName), value: result.srcVcenterId});
                                    }
                                    else {
                                        _.extend(data, {name: _dealEmptyResult(result.srcHostName), value: result.srcHostId});
                                    }
                                });
                                $scope.summerys = _summerys;

                                _executeSettingModel.formatDataToSelect("testSite", [{
                                        siteId: result.remoteSiteId,
                                        name: result.remoteSiteName
                                    }],
                                    "siteId", "name", _pleaseSelect_label);

                                _executeSettingModel.formatDataToSelect("testvCenter", [{
                                        vCenterUuid: result.remoteVcenterId,
                                        name: result.remoteVcenterName
                                    }],
                                    "vCenterUuid", "name", _pleaseSelect_label);

                                _executeSettingModel.formatDataToSelect("testCluster", [{
                                    uuid: result.remoteHostId,
                                    name: result.remoteHostName
                                }], "uuid", "name", _pleaseSelect_label);

                                $scope.vmSanSnapshotScope.clusterMapping.isInit = false;

                                if (!_.isEmpty(result.remoteHostId) && !_.isUndefined(result.remoteHostId)) {
                                    $scope.vmSanSnapshotScope.networkMapping.display && $scope.vmSanSnapshotScope.networkMapping.initPage(result.remoteHostId);
                                    $scope.vmSanSnapshotScope.uncriticalVM.display && $scope.vmSanSnapshotScope.uncriticalVM.initPage(result.remoteHostId);
                                }
                                $scope.vmSanSnapshotScope.clusterMapping.testSite.oldSelectId = result.remoteSiteId;
                                $scope.vmSanSnapshotScope.clusterMapping.testvCenter.oldSelectId = result.remoteVcenterId;
                                $scope.vmSanSnapshotScope.clusterMapping.testCluster.oldSelectId = result.remoteHostId;
                                $scope.vmSanSnapshotScope.accessSetting.display && $scope.vmSanSnapshotScope.accessSetting.initPage();
                                $scope.$apply();
                            },
                            fail: function() {
                                $scope.vmSanSnapshotScope.clusterMapping.isInit = false;
                                $scope.$apply();
                            }
                        });
                    },
                    getValue: function() {
                        var hostSet = [];
                        var testSiteObj = $scope.vmSanSnapshotScope.clusterMapping.testSite.getValue();
                        var testvCenterObj = $scope.vmSanSnapshotScope.clusterMapping.testvCenter.getValue();
                        var testClusterObj = $scope.vmSanSnapshotScope.clusterMapping.testCluster.getValue();

                        hostSet.push({
                            "remoteSiteId": testSiteObj.id,
                            "remoteSiteName": testSiteObj.label,
                            "remoteVcenterId": testvCenterObj.id,
                            "remoteVcenterName": testvCenterObj.label,
                            "remoteHostId": testClusterObj.id,
                            "remoteHostName": testClusterObj.label,
                            "srcVcenterId": $("#srcVcenterId").text(),
                            "srcVcenterName": $("#srcVcenterName").text(),
                            "srcHostId": $("#srcHostId").text(),
                            "srcHostName": $("#srcHostName").text()
                        });

                        if( "test" == _winData.operateType){
                        	return {
                        		testHosts : JSON.stringify(hostSet)
                        	};
                        }

                        return {
                        	recoveryHosts: JSON.stringify(hostSet)
                        };
                    },
                    validate: function() {
                        if (-1 == $("#testSite").widget().getSelectedId()) {
                            message.error(_winData["operateType"] == "test" ? appUtils.getString("recovery_vm_clusterMapping_testSite_validate")
                                : appUtils.getString("recovery_vm_clusterMapping_recoverySite_validate"));
                            return false;
                        }

                        if (-1 == $("#testvCenter").widget().getSelectedId()) {
                            message.error(_winData["operateType"] == "test" ? appUtils.getString("recovery_vm_clusterMapping_testvCenter_validate")
                                : appUtils.getString("recovery_vm_clusterMapping_recoveryvCenter_validate"));
                            return false;
                        }

                        if (-1 == $("#testCluster").widget().getSelectedId()) {
                            message.error(_winData["operateType"] == "test" ? appUtils.getString("recovery_vm_clusterMapping_testCluster_validate")
                                : appUtils.getString("recovery_vm_clusterMapping_recoveryCluster_validate"));
                            return false;
                        }
                        return true;
                    }
                },
                networkMapping: {
                    isInit: true,
                    display: true,
                    title: appUtils.getString("rm_term_wizard_mapping_view_title"),
                    addBtn: {
                        id: "addBtn",
                        text: appUtils.getString("common_term_add_mapping_button"),
                        disable: true,
                        click: function() {
                            _executeSettingModel.networkMapping.addRow();
                            _executeSettingModel.networkMapping.changePairStatus();
                        }
                    },
                    pairStatusSpan: appUtils.getString("common_term_add_mapping_unmapped"),
                    mappingViewTable: {
                        "checkbox": false,
                        "currPage": 1,
                        "columnsDraggable":false,
                        "id": "mappingViewTable",
                        "displayLength": constsService.TABLE_COUNT_PER_PAGE,
                        "totalRecords": 0,
                        "data": [],
                        "enablePagination": false,
                        "columns" : [ { "mData" : "id", "bSortable" : false, "bVisible" : false },
                                      { "sTitle" : appUtils.getString("notify_alarm_term_name_column"),"mData" : "name","sWidth" : "90%","bSortable" : false}],
                        "renderRow": function(nRow, aData, iDataIndex) {
                            var nameDiv = "<span class='ellipsisTooltip inlineTrDiv' title='value' style='width:120px!important'>value</span>";
                            var arrow = "<img src='../theme/recoverydirector/images/resourceMapping/arrow_line.png' class='arrow'>";
                            var mappingTypeImg = "<img src='../theme/recoverydirector/images/resourceMapping/network.png' class='network'>";
                            var nameHTML = [];
                            nameHTML.push(mappingTypeImg);
                            nameHTML.push(nameDiv.replace(/value/g, aData.name[0]));
                            nameHTML.push(arrow);
                            nameHTML.push(mappingTypeImg);
                            nameHTML.push(nameDiv.replace(/value/g, aData.name[1]));
                            $('td:eq(0)', nRow).html(nameHTML);
                            $('td:eq(0)', nRow).html("<div style='margin-left:36px'>" + $('td:eq(0)', nRow).html() + "</div>");
                            $('td:eq(0)', nRow).css({"text-align": "center"});
                        },
                        opAreaConfig: [
                            {
                                id: "iconBtnDel",
                                template: "<div class='iconbutton-delete' title='" + appUtils.getString("common_term_delete_button") + "'></div>",
                                clickActive: _executeSettingModel.networkMapping.operation.remove
                            }
                        ]
                    },
                    tableViewSites: tableViewSites,
                    getValue: function() {
                        var mappingSet = [];
                        var data = $("#mappingViewTable").widget().getTableData();
                        _.each(data, function(obj) {
                            mappingSet.push({
                                "srcNetworkId": obj.id[0],
                                "srcNetworkName": obj.name[0],
                                "remoteNetworkId": obj.id[1],
                                "remoteNetworkName": obj.name[1]
                            });
                        });

                        if( "test" == _winData.operateType){
                        	return {
                        		testNetwork : JSON.stringify(mappingSet)
                        	};
                        }

                        return {
                        	recoveryNetwork: JSON.stringify(mappingSet)
                        };
                    },
                    initPage: function(hostId) {
                        if (_.isEmpty(hostId)) {
                            hostId = $("#testCluster").widget().getSelectedId();
                        }

                        if( hostId == -1 ) {
                            $scope.vmSanSnapshotScope.networkMapping.tableViewSites[0].table.data = [];
                            $scope.vmSanSnapshotScope.networkMapping.tableViewSites[1].table.data = [];
                            $scope.vmSanSnapshotScope.networkMapping.mappingViewTable.data = [];
                            message.error(_winData["operateType"] == "test" ? appUtils.getString("recovery_vm_clusterMapping_testCluster_validate")
                                : appUtils.getString("recovery_vm_clusterMapping_recoveryCluster_validate"));
                            $scope.$apply();
                        	return;
                        }

                        if (this.isInit) {
                            this.isInit = false;
                            $scope.vmSanSnapshotScope.networkMapping.tableViewSites[0].initTable();
                            $scope.vmSanSnapshotScope.networkMapping.tableViewSites[1].initTable(hostId);
                        }
                    },
                    validate: function() {
                        var _mappingTableData = $("#mappingViewTable").widget().getTableData();
                        var _productionResTableData = $("#productionResTable").widget().getTableData();

                        if (_.isEmpty(_mappingTableData) || !_.isEmpty(_productionResTableData)) {
                            message.error(appUtils.getString("recovery_vm_clusterMapping_network_mapping_validate"));
                            return false;
                        }
                        return true;
                    }
                },
                accessSetting: {
                    isInit: true,
                    display: false,
                    logicPort: {
                        id: "ipAddress",
                        value: "",
                        require: true,
                        width: "300px",
                        validate: constsService.VALID.IP_STANDARD,
                        labels: appUtils.getStringWithColon("recovery.vm.task.test.setAccess.para_logicIP.label"),
                        tips: appUtils.getString("recovery.vm.task.test.setAccess.para_logicIP.des_label")
                    },
                    getValue: function(){
                        return {
                            "nasSharePortIp": $.trim($("#ipAddress").widget().getValue())
                        };
                    },
                    initPage: function() {
                        this.isInit && restService.getNasSharePortIp({"planId": _winData.planId}, {
                            mask: true,
                            success: function(result) {
                                $scope.vmSanSnapshotScope.accessSetting.logicPort.value = result.ipAddress;
                                $scope.vmSanSnapshotScope.accessSetting.isInit = false;
                                $scope.$apply();
                            },
                            fail: function() {
                                $scope.vmSanSnapshotScope.accessSetting.logicPort.value = "";
                                $scope.vmSanSnapshotScope.accessSetting.isInit = false;
                                $scope.$apply();
                            }
                        });
                    },
                    validate: function(){
                    	var portAddr = $.trim($("#ipAddress").widget().getValue());
                        var regExp = /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/;

                        if (_.isEmpty(portAddr)) {
                            message.error(appUtils.getString("validate_term_common_ip_standard_rule_label"));
                            return false;
                        }

                        var ipArray = portAddr.split(".");
                        if (ipArray.length == 4) {
                            if (ipArray[0] == "0" || ipArray[0] == "127" || ipArray[3] == "0") {
                                message.error({content: appUtils.getString("validate_term_common_ip_standard_rule_label"), ok: function() {
                                        $("#ipAddress").find("input:eq(1)").focus();
                                    }
                                });
                                return false;
                            }
                        }

                        if (!regExp.test(portAddr)) {
                            message.error({content: appUtils.getString("validate_term_common_ip_standard_rule_label"), ok: function() {
                            		$("#ipAddress").find("input:eq(1)").focus();
                                }
                            });
                            return false;
                        }
                        return true;
                    }
                },
                uncriticalVM: {
                    isInit: true,
                    display: false,
                    availableTable: {
                        "checkbox": true,
                        "currPage": 1,
                        "columnsDraggable":false,
                        "data": [],
                        "id": "uncriticalVM",
                        "title": appUtils.getStringWithColon("resMapping.term.availableVM.tab"),
                        "displayLength": constsService.TABLE_COUNT_PER_PAGE,
                        "totalRecords": 0,
                        "enablePagination": false,
                        "columns": [{"mData": "uuid", "bSortable": false, "bVisible": false},
                                    {"mData": "name", "sWidth": "100%", "sTitle": appUtils.getString("recovery.term.abstact.planNameLabel")}],
                        "tHeadCheckboxFn": function(param, evt) {}
                    },
                    getValue: function() {
                        var selectVmSet = [];
                        var selectRow = $("#uncriticalVM").widget().getTableCheckedItems();

                        _.each(selectRow, function(row) {
                            selectVmSet.push(_.pick(row, "uuid", "name"));
                        });

                        return {
                            NoncritialVM: JSON.stringify(selectVmSet)
                        };
                    },
                    initPage: function(hostId) {
                        if (_.isEmpty(hostId)) {
                            hostId = $("#testCluster").widget().getSelectedId();
                        }

                        if ( -1 == hostId ) {
                            $scope.vmSanSnapshotScope.uncriticalVM.availableTable.data = [];
                            $scope.$apply();
                    		message.error(_winData["operateType"] == "test" ? appUtils.getString("recovery_vm_clusterMapping_testCluster_validate")
                                : appUtils.getString("recovery_vm_clusterMapping_recoveryCluster_validate"));
                    		return;
                    	}

                        var vcenterUuid = $("#testvCenter").widget().getSelectedId();
                        if(vcenterUuid == -1) {
                            message.error(appUtils.getString("recovery_vm_clusterMapping_testvCenter_validate"));
                            return;
                        }

                        this.isInit && restService.getCriticalVm({hostOrClusterId: hostId, vcenterUuid: vcenterUuid}, {
                        	mask: true,
                            success: function(result) {
                                var _ncriticalVMList = [];
                                _.isArray(result) && _.each(result, function(criticalVmObj) {
                                    _ncriticalVMList.push(_.pick(criticalVmObj, "uuid", "name"));
                                });

                                restService.getNoncriticalVm({planId: _winData.planId}, {
                                    mask: false,
                                    success: function(result) {
                                        _.isArray(result) && _.each(result, function(row) {
                                            (function(uuid) {
                                                setTimeout(function() {
                                                    $("#uncriticalVM").widget().setSelectedRow("uuid", uuid);
                                                }, 100);
                                            })(row.uuid);
                                        });
                                        $scope.vmSanSnapshotScope.uncriticalVM.availableTable.data = appUtils.encodeForHTML(_ncriticalVMList);
                                        $scope.$apply();
                                    }
                                });
                                $scope.vmSanSnapshotScope.uncriticalVM.isInit = false;
                            },
                            fail: function() {
                                $scope.vmSanSnapshotScope.uncriticalVM.isInit = false;
                                $scope.vmSanSnapshotScope.uncriticalVM.availableTable.data = [];
                                $scope.$apply();
                            }
                        });
                    },
                    validate: function(){
                    	return true;
                    }
                }
            };

            (function init() {

                /**
                 * [Nas复制范畴]
                 *
                 * Nas异步复制
                 */
                if ((_winData.templateType == 1 && _winData.templateSubType == 2) || _winData.isNasHyperCopy) {
                    $scope.vmSanSnapshotScope.accessSetting.display = true;
                    $scope.vmSanSnapshotScope.uncriticalVM.display = true;
                    $scope.vmSanSnapshotScope.constant.label.testBasedOnSANSnapshot = appUtils.getString(constsService.VMWARE_EXECUTE._copyDesc[_winData.operateType].nasCopy);
                }

                /**
                 * [SAN复制范畴]
                 *
                 * 0-存储复制(同步)；// SAN同步复制
                 * 1-存储复制(异步)；//
                 * 3-级联复制(同步+异步)；
                 * 4-级联复制(异步+异步)；
                 * 5-并联复制(同步+异步)；
                 * 6-并联复制(异步+异步)；
                 * 7-存储双活+存储复制(异步)；// VIS双活+SAN异步复制
                 * 13-存储镜像+存储复制(异步)；// VIS镜像+SAN异步复制
                 * 18-存储双活+存储复制(异步)；// SAN双活+SAN异步复制
                 * 20-存储复制(异步) + 存储双活23 存储双活+存储复制(同步)
                 * 24 存储复制(同步)+存储双活
                 * 26 双活+异步环形组网
                 * 27 异步+双活环形组网
                 * 30 san一体化备份
                 * 31 san双活+一体化备份
                 * 32 san一体化备份+双活
                 * 35 4dc串联
                 * 36 4dc并联
                 */
                if (_.contains([0, 3, 4, 5, 6, 7, 13, 18, 20, 23, 24, 26, 27, 30, 31, 32, 35, 36], _winData.templateType)
                    || (_winData.templateType == 1 && _winData.templateSubType == 1)) {
                    $scope.vmSanSnapshotScope.uncriticalVM.display = true;
                    $scope.vmSanSnapshotScope.constant.label.testBasedOnSANSnapshot = appUtils.getString(constsService.VMWARE_EXECUTE._copyDesc[_winData.operateType].sanCopy);
                }

                /**
                 * [SAN快照范畴]
                 *
                 * 2-存储快照；// 阵列SAN快照
                 * 19-存储双活+存储快照；// SAN双活+阵列SAN快照
                 */
                if (_.contains([2, 19], _winData.templateType)) {
                    $scope.copyInfoDisplay = true;
                    $scope.vmSanSnapshotScope.constant.label.testBasedOnSANSnapshot = appUtils.getString(constsService.VMWARE_EXECUTE._copyDesc[_winData.operateType].sanSnapshot);
                    $scope.vmSanSnapshotScope.datasTable.queryData();
                }

                $scope.vmSanSnapshotScope.clusterMapping.isInit && $scope.vmSanSnapshotScope.clusterMapping.initPage();
            }());

            appUtils.addWinOkBtnCls("vmwareIncrementTypeExecute");
        }];
    var vmwaresansnapshotExcute = angular.module("recoverydirector.recovery.config");
    vmwaresansnapshotExcute.tinyController("recovery.vmwaresansnapshot.execute.ctrl", sansnapshotExcuteCtrl);
    return vmwaresansnapshotExcute;
});
