define([], function() {
    "use strict";
    var editStepCtrl = [
        "$scope",
        "$state",
        "$compile",
        "$stateParams",
        "exception",
        "message",
        "communicationService",
        "utilService",
        "mask",
        "constsService",
        "appUtils",
        function($scope, $state, $compile, $stateParams, exception, message, communicationService, utilService, mask, constsService, appUtils) {

            var node = _.first($("#stepTree").widget().getZTreeObj().getSelectedNodes());
            $scope.addStepModel = {
                labels: {
                    stepName: appUtils.getStringWithColon("recovery.term.procedure.start.stepName.label"),
                    scriptName: appUtils.getStringWithColon("recovery.term.procedure.start.scriptName.label"),
                    stepPlacement: appUtils.getStringWithColon("recovery.term.procedure.start.placement.label"),
                    policy: appUtils.getStringWithColon("recovery.term.procedure.start.policy.label"),
                    scriptState: appUtils.getString("others_script_label"),
                },
                policy: {
                    id: "policy",
                    width: constsService.W3,
                    values: [{
                        "selectId": "true",
                        "label": appUtils.getString("recovery.term.procedure.policy.continue.label")
                    }, {
                        "selectId": "false",
                        "label": appUtils.getString("recovery.term.procedure.policy.stop.label")
                    }],
                    defaultSelectid: "true"
                },
                stepName: {
                    id: "_stepName",
                    width: constsService.W3,
                    value: "",
                    "require": true,
                    "validate": constsService.VALID.NAME
                },
                scriptName: {
                    id: "_scriptName",
                    width: constsService.W3,
                    value: "",
                    "require": true,
                    "validate": [{
                        validFn: "required"
                    }, {
                        validFn: "minSize",
                        params: [4],
                        errorDetail: appUtils.getString("validate_term_4_64_script")
                    }, {
                        validFn: "maxSize",
                        params: [32],
                        errorDetail: appUtils.getString("validate_term_4_64_script")
                    }, {
                        validFn: "isScript",
                        errorDetail: appUtils.getString("validate_term_4_64_script")
                    }]
                },
                stepPlacement: {
                    id: "_stepPlacement",
                    values: [{
                        "key": "0",
                        "text": appUtils.getString("recovery.term.procedure.start.beforeStep.label"),
                        "checked": !node.isFirstNode,
                        "disable": node.isFirstNode
                    }, {
                        "key": "1",
                        "text": appUtils.getString("recovery.term.procedure.start.afterStep.label"),
                        "checked": node.isFirstNode,
                        "disable": node.isLastNode
                    }],
                    spacing: {
                        "width": "60px"
                    }
                }
            };
        }
    ]
    var addStepApp = angular.module("recoverydirector.recovery.config");
    addStepApp.tinyController("app.add.step.ctrl", editStepCtrl);
    return addStepApp;
});
