define(["tiny-common/UnifyValid", "tiny-widgets/Window"],
    function (UnifyValid, Window) {
        var editStepCtrl = [
            "$scope",
            "$state",
            "$compile",
            "$sce",
            "$stateParams",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "appUtils",
            "mask",
            "constsService",
            "infoTransferredService",
            "cookieService",
            "restService",
            function ($scope, $state, $compile, $sce, $stateParams, exception, message, communicationService, utilService, appUtils, mask, constsService, infoTransferredService, cookieService, restService) {
                var winData = $("#" + constsService.EDIT_STEP_WIN.winId).widget().option("data");
                var planId = winData.uuid;
                var poType = winData.poType;
                var procType = winData.filterId;
                var proLabel = winData.filterLable;
                var filterObj = winData.values;

                $scope.unconfigurable = appUtils.getString("recoveryStep_term_unconfigurable_label");
                $scope.needSyncPgInfo = $sce.trustAsHtml(appUtils.getString("protection_lun_use_scriptscheme_change_label"));
                $scope.isNeedSyncPgInfo = false;
                $scope.duanbox = {
                    "id": "myDualSelectBox",
                    "left-values": [{
                        "title": constsService.PROCEDURE_LEFT_TITLE_URL,
                        "title-type": "url",
                        "content-cls": "content-cls",
                        "content": constsService.PROCEDURE_LEFT_URL,
                        "content-type": "url"
                    }],
                    "right-values": [{
                        "title": constsService.PROCEDURE_RIGHT_TITLE_URL,
                        "title-type": "url",
                        "content-type": "url",
                        "content": constsService.PROCEDURE_RIGHT_URL,
                        "content-cls": "content-cls",
                        "height": "340px",
                        "add": {
                            "id": "addbtn1",
                            "click": function() {
                                var datasAvailTable = $("#datasAvailTable").widget();
                                var datasSelTable = $("#datasSelTable").widget();
                                var selected = datasAvailTable.getTableCheckedItems();
                                var leftClicked = $("#datasAvailTable").find(".clickTrColor");
                                var isChecked = $("#startCheckBox").widget().option("checked");

                                try {
                                    var size = selected.length;
                                    for (var z = 0; z < size; z++) {
                                        datasSelTable.addTableRows(selected[z]);
                                        var index = $("#datasAvailTable tbody tr").index(leftClicked.get(z));
                                        datasAvailTable.deleteTableRow(index);
                                    }
                                } catch (e) {}
                                if (_.isEmpty(datasAvailTable.getTableData())) {
                                    datasAvailTable.clearTable();
                                }

                                if(!_.isEmpty(selected) && isChecked) {
                                    $scope.isStepApplied = false;
                                    $("#btnStartApply").widget().option("disable", false);
                                }
                                $scope.$apply();
                            }
                        },
                        "remove": {
                            "id": "rbtn1",
                            "click": function() {
                                var datasAvailTable = $("#datasAvailTable").widget();
                                var datasSelTable = $("#datasSelTable").widget();
                                var selected = datasSelTable.getTableCheckedItems();
                                var rightClicked = $("#datasSelTable").find(".clickTrColor");
                                var isChecked = $("#startCheckBox").widget().option("checked");
                                try {
                                    var size = selected.length;
                                    for (var z = 0; z < size; z++) {
                                        datasAvailTable.addTableRows(selected[z]);
                                        var index = $("#datasSelTable tbody tr").index(rightClicked.get(z));
                                        datasSelTable.deleteTableRow(index);
                                    }
                                } catch (e) {}
                                if (_.isEmpty(datasSelTable.getTableData())) {
                                    datasSelTable.clearTable();
                                }
                                if(!_.isEmpty(selected) && isChecked) {
                                    $scope.isStepApplied = false;
                                    $("#btnStartApply").widget().option("disable", false);
                                }

                                $scope.$apply();
                            }
                        }
                    }],
                    "setting": {
                        "left-width": "220px",
                        "height": "320px",
                        "right-width": "265px",
                        "cls": "mycls"
                    }
                };
                $scope.datasAvailTable = {
                    id: "datasAvailTable",
                    enablePagination: false,
                    columnsDraggable: false,
                    data: [],
                    columns: [
                        {
                            "mData": "uuid",
                            "bVisible": false
                        },
                        {
                            "sTitle": appUtils.getString("common_term_name_label"),
                            "mData": "name",
                            "sWidth": "130px",
                            "bSortable": false
                        }
                    ]
                };
                $scope.datasSelTable = {
                    id: "datasSelTable",
                    enablePagination: false,
                    columnsDraggable: false,
                    data: [],
                    columns: [
                        {
                            "mData": "uuid",
                            "bVisible": false
                        },
                        {
                            "sTitle": appUtils.getString("common_term_name_label"),
                            "mData": "name",
                            "sWidth": "130px",
                            "bSortable": false
                        }
                    ]
                };
                $scope.editStep = {
                    filter: {
                        id: "editFilter",
                        values: filterObj,
                        width: constsService.W2,
                        openFn: function (object) {
                        },
                        change: function (id) {
                            init($("#editFilter").widget().getSelectedId());
                        }
                    },
                    addStep: {
                        spanCls: "default",
                        btnCls: "iconbutton-add-disabled",
                        label: appUtils.getString("common_term_add_button"),
                        click: function() {
                            if (_.contains(["14", "10"], winData.poType) || winData.PROVIDER_TYPE == "FusionSphereOpenstack") {
                                return;
                            }

                            var node = _.first($("#stepTree").widget().getZTreeObj().getSelectedNodes());
                            var win = angular.copy(constsService.ADD_EDIT_STEP_WIN);
                            win.title = appUtils.getString(constsService.ADD_EDIT_STEP_WIN.title);
                            win.data = {stepId: node.extendParams.stepId};

                            appUtils.showWindow(win, function() {
                                var options = this.options;
                                if (!UnifyValid.FormValid($("#" + options.verifyId), {focusInvalid: true})) {
                                    return;
                                }

                                var stepName = $("#_stepName").widget().getValue();
                                var procType = $("#editFilter").widget().getSelectedId();
                                var scriptName = $("#_scriptName").widget().getValue();
                                var isContinueIfFailed = $("#policy").widget().getSelectedId();
                                var isBefore = $("#_stepPlacement").widget().opChecked("checked") == "0";
                                var stepId = $("#" + options.winId).widget().option("data")["stepId"];
                                message.warn({content: appUtils.getString("recovery_messsage_add_step_confirm_tips", stepName), ok: function() {
                                    restService.addStep({planId: planId, procType: procType}, {
                                        data: {
                                            sibStepId: stepId,
                                            name: stepName,
                                            scriptName: scriptName,
                                            isBefore: isBefore,
                                            isContinueIfFailed: isContinueIfFailed
                                        },
                                        success: function(result) {
                                            var index = 0;
                                            var nodes = $("#stepTree").widget().getZTreeObj().getNodes();
                                            var checkedNode = _.first($("#stepTree").widget().getZTreeObj().getSelectedNodes());
                                            _.find(nodes, function(node, key) {
                                                index = key;
                                                return node.stepId == checkedNode.stepId;
                                            });

                                            if (isBefore) {
                                                index = index + 1;
                                            }
                                            message.success({content: appUtils.getString("common_term_operation_success_label"), ok: function() {
                                                init($("#editFilter").widget().getSelectedId(), function(nodes) {
                                                    $("#stepTree li a:eq(" + index + ")").click();
                                                })
                                                $("#" + constsService.ADD_EDIT_STEP_WIN.winId).widget().destroy();
                                            }})
                                        }
                                    })
                                }})
                            })
                        }
                    },
                    startStepModel: {
                        systemScript: {
                            value: ""
                        },
                        labels: {
                            scriptState: appUtils.getString("others_script_label"),
                            stepName: appUtils.getStringWithColon("recovery.term.procedure.start.stepName.label"),
                            policy: appUtils.getStringWithColon("recovery.term.procedure.start.policy.label"),
                            scriptScheme: appUtils.getStringWithColon("protection_lun_script_config_setting_label")
                        },
                        stepName: {
                            id: "stepName",
                            width: constsService.W4,
                            value: "",
                            disable: true,
                            "require": true,
                            validate: constsService.VALID.NAME,
                            contentChange: function(eve,value) {
                                $("#btnStartApply").widget().option("disable", false);
                                $scope.newStepApplied = false;
                                $scope.isStepApplied = false;
                            }
                        },
                        userDefinedScript: {
                            id: "userDefinedScript",
                            width: constsService.W2,
                            value: "",
                            disable: true,
                            "require": true,
                            "validate": [
                                {
                                    validFn: "required"
                                }, {
                                    validFn: "minSize",
                                    params: [4],
                                    errorDetail: appUtils.getString("validate_term_4_64_script")
                                }, {
                                    validFn: "maxSize",
                                    params: [64],
                                    errorDetail: appUtils.getString("validate_term_4_64_script")
                                }, {
                                    validFn: "isScript",
                                    errorDetail: appUtils.getString("validate_term_4_64_script")
                                }],
                            contentChange:function (eve,value) {
                                $("#btnStartApply").widget().option("disable", false);
                                $scope.newStepApplied = false;
                                $scope.isStepApplied = false;
                            }
                        },
                        schemeOptions: {
                            id: "schemeOptions",
                            width: constsService.W2,
                            disable: false,
                            defaultSelectId: "false",
                            values: [
                                {"selectId": "false", "label": appUtils.getString("protection_lun_use_system_script_label")},
                                {"selectId": "true", "label": appUtils.getString("protection_lun_use_hosts_script_label")}
                            ],
                            change:function () {
                                var nodePosition = 0;
                                var schemeType = $("#schemeOptions").widget().getSelectedId();
                                var selectNode = _.first($("#stepTree").widget().getZTreeObj().getSelectedNodes());
                                var allNodes = $("#stepTree").widget().getZTreeObj().getNodes();

                                function changeEditStatus() {
                                    $("#btnStartApply").widget().option("disable", false);
                                    $("#stepName").widget().option("disable", schemeType == "false");
                                    $("#userDefinedScript").widget().option("disable", schemeType == "false");
                                    $scope.editStep.startStepModel.schemeOptions.defaultSelectId = $.trim(schemeType);
                                }

                                if (schemeType == "false") {
                                    restService.getPresetScrpitsBySchemeId(selectNode.extendParams.scriptSchemeId, function(result) {
                                        //系统脚本参数
                                        var sysScriptParams = {
                                            publicData: result.publicParams,
                                            data: function() {
                                                var systemScripts = _.findWhere(result.steps, {
                                                    position: selectNode.extendParams.position
                                                }) || {};
                                                $scope.editStep.startStepModel.systemScript.value = systemScripts.script;
                                                $("#stepName").widget().option("value", function() {
                                                    if (_.isString(systemScripts.name)) {
                                                        return appUtils.getString(systemScripts.name);
                                                    }

                                                    var i18nKey = systemScripts.name["i18nKey"];
                                                    if (!_.isEmpty(i18nKey)) {
                                                        return appUtils.getString(i18nKey);
                                                    }
                                                    return systemScripts.name[cookieService.get("language")];
                                                }());
                                                return !selectNode.extendParams.isUserDefined ? selectNode.extendParams.sysScriptParams.data : systemScripts.params;
                                            }(),
                                            props: !selectNode.extendParams.isUserDefined ? selectNode.extendParams.sysScriptParams.props : {
                                                "publicParam": selectNode.extendParams["publicParam"],
                                                "userAfterParam": {},
                                                "afterParam": {}
                                            }
                                        };

                                        _.find(allNodes, function(node, key) {
                                            var isFind = (node.stepId == selectNode.stepId);
                                            if (isFind) {
                                                nodePosition = key;
                                                node.extendParams.sysScriptParams = sysScriptParams;
                                            }
                                            return isFind;
                                        });
                                        $("#stepTree").widget().getZTreeObj().updateNode(allNodes[nodePosition]);
                                        changeEditStatus();
                                        $scope.$apply();
                                    });
                                }
                                else {
                                    if (!selectNode.extendParams.isUserDefined) {
                                        _.find(allNodes, function(node, key) {
                                            var isFind = (node.stepId == selectNode.stepId);
                                            if (isFind) {
                                                nodePosition = key;
                                                selectNode.extendParams.executeParams = {};
                                            }
                                            return isFind;
                                        });
                                        $("#stepTree").widget().getZTreeObj().updateNode(allNodes[nodePosition]);
                                    }
                                    $("#stepName").widget().option("value", selectNode.name);
                                    changeEditStatus();
                                    $scope.$apply();
                                }
                            }
                        },
                        configBtn: {
                            enable: true,
                            label: appUtils.getString("protection_lun_script_config_label"),
                            click: function(enable) {
                                if (!enable) {
                                    return;
                                }
                                var allNodes = $("#stepTree").widget().getZTreeObj().getNodes();
                                var selectedNode = $("#stepTree").widget().getZTreeObj().getSelectedNodes()[0];
                                var scriptConfigWin = angular.copy(constsService.CONFIG_SCRIPT_PARAMS_WIN);
                                    scriptConfigWin.title = appUtils.getString(scriptConfigWin.title);
                                var schemeType = $("#schemeOptions").widget().getSelectedId();

                                //选择的是系统脚本
                                if (schemeType == "false") {
                                    scriptConfigWin.content = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/configPublicScriptParamWin.html";
                                    scriptConfigWin.controller = scriptConfigWin.sysDefController;
                                    scriptConfigWin.data = selectedNode.extendParams.sysScriptParams;
                                }
                                //选择的是用户自定义脚本
                                else {
                                    scriptConfigWin.controller = scriptConfigWin.controller;
                                    scriptConfigWin.data.data = selectedNode.extendParams.executeParams;
                                }

                                appUtils.showWindow(scriptConfigWin, function() {
                                    if (!UnifyValid.FormValid($("#" + constsService.CONFIG_SCRIPT_PARAMS_WIN.verifyId), {focusInvalid: true})) {
                                        return;
                                    }

                                    var nodePosition = 0;
                                    var datas = $("#scrpitParamsTable").widget().getTableData();
                                    _.find(allNodes, function(node, key) {
                                        nodePosition = key;
                                        return node.stepId == selectedNode.stepId;
                                    });

                                    //系统脚本
                                    if (schemeType == "false") {
                                        _.each(datas, function(data) {
                                            var self = this;
                                            if (data.id == "publicUuid") {
                                                _.each(data.childResources, function(childRes) {
                                                    //未修改过的敏感参数
                                                    if (childRes.changeFlag != false) {
                                                        self.extendParams.sysScriptParams.props.publicParam[childRes.key] = childRes.value;
                                                    }
                                                });
                                            } else {
                                                _.each(data.childResources, function(childRes) {
                                                    //用户自行添加的
                                                    if (childRes.isUserAdd == true) {
                                                        self.extendParams.sysScriptParams.props.userAfterParam[childRes.key] = childRes.value;
                                                    } else {
                                                        //未修改过的敏感参数
                                                        if (childRes.changeFlag != false) {
                                                            self.extendParams.sysScriptParams.props.afterParam[childRes.key] = childRes.value;
                                                        }
                                                        self.extendParams.sysScriptParams.props.userAfterParam = {};
                                                    }
                                                });
                                            }
                                        }, selectedNode);
                                    }
                                    //用户自定义脚本
                                    else {
                                        selectedNode.extendParams.executeParams = {};
                                         _.each(datas, function(data) {
                                            this.extendParams.executeParams[data.key] = data["value"];
                                        }, selectedNode);
                                    }

                                    allNodes[nodePosition] = selectedNode;
                                    $("#stepTree").widget().getZTreeObj().updateNode(allNodes[nodePosition]);
                                    $("#" + this.options.winId).widget().destroy();
                                });

                            }
                        },
                        policy: {
                            id: "editPolicy",
                            width: constsService.W4,
                            values: [{ "selectId": "true", "label": appUtils.getString("recovery.term.procedure.policy.continue.label")},
                                     { "selectId": "false", "label": appUtils.getString("recovery.term.procedure.policy.stop.label")}],
                            defaultSelectId: "true",
                            change:function () {

                            }
                        },
                        startCheckBox: {
                            "id": "startCheckBox",
                            "text": appUtils.getString("recovery.term.procedure.start.checkBox.label"),
                            "checked": false,
                            "disable": false,
                            "change": function (event) {
                                var checked = $("#startCheckBox").widget().option("checked");
                                var selectedNode = $("#stepTree").widget().getZTreeObj().getSelectedNodes()[0];
                                $("#stepName").widget().option("disable", !(selectedNode.extendParams.isEditable && checked && $("#schemeOptions").widget().getSelectedId() == "true"));
                                $("#editPolicy").widget().option("disable", !(selectedNode.extendParams.isEditable && checked));
                                $("#schemeOptions").widget().option("disable", !(selectedNode.extendParams.isEditable && checked))
                                $("#userDefinedScript").widget().option("disable", !(selectedNode.extendParams.isEditable && checked));
                                $scope.editStep.startStepModel.configBtn.enable = selectedNode.extendParams.isEditable && checked;
                                $scope.vmwareForm && _setArrowAbled(checked);
                                $scope.$apply();
                            }
                        }
                    },
                    stepTree: {
                        "id": "stepTree",
                        "width": "200px",
                        "height": "380px",
                        "setting": {
                            view: {
                                showLine: true,
                                showIcon: true,
                                selectedMulti: false
                            },
                            edit: {
                                enable: true,
                                showRenameBtn: false,
                                editNameSelectAll: false,
                                removeTitle: appUtils.getString("common_term_delete_button"),
                                showRemoveBtn: function(treeId, node) {
                                    return !node.extendParams.isPresetled;
                                }
                            },
                            data: {
                                simpleData: {
                                    enable: true
                                }
                            },
                            callback: {
                                onClick: clickNode,
                                beforeRemove: function (treeId, node) {
                                    var params = {
                                        planId: planId,
                                        procType: $("#editFilter").widget().getSelectedId(),
                                        stepId: node.extendParams.stepId
                                    };

                                    var removeNode = function() {
                                        message.warn({content: appUtils.getString("recovery_messsage_delet_step_confirm_tips", node.name), ok: function() {
                                            restService.deleteStepByStepId(params, function(result) {
                                                 message.success({content: appUtils.getString("common_term_operation_success_label"), ok: function() {
                                                    $("#stepTree").widget().getZTreeObj().removeNode(node);
                                                    init(params.procType, function(nodes) {
                                                        //加载第一个步骤对应的面板信息
                                                        $("#stepTree li a:eq(0)").click();
                                                    })
                                                 }});
                                            })
                                        }})
                                    }

                                    removeNode();
                                    return false;
                                }
                            }
                        },
                        "values": []
                    },
                    btnApply: {
                        id: "btnStartApply",
                        disable: false,
                        text: appUtils.getString("common_term_apply_button"),
                        click: function () {
                            var isEnabled = $("#startCheckBox").widget().option("checked");
                            var selectedNode = $("#stepTree").widget().getZTreeObj().getSelectedNodes()[0];

                            if ($scope.vmwareForm) {
                                if (constsService.START_VM_HOST_TREE_NODE_2 == selectedNode.extendParams.stepName && !isEnabled) {
                                    message.warn({
                                        content: appUtils.getString('recovery_messsage_start_host_step_confirm_tips', selectedNode.name),
                                        ok: updateStepStatus
                                    });
                                } else if (isEnabled &&
                                    _.contains([constsService.VMWARE_TREE_NODE, constsService.HANGUP_TREE_NODE_1, constsService.HANGUP_TREE_NODE_2], selectedNode.extendParams.stepName)) {
                                    message.warn({
                                        content: appUtils.getString('recovery_messsage_hangup_ware_step_confirm_tips', selectedNode.name),
                                        ok: updateStepStatus
                                    });
                                } else {
                                    updateStepStatus();
                                }
                            } else {
                                if (!isEnabled) {
                                    message.warn({
                                        content: appUtils.getString('recovery_messsage_disable_step_confirm_tips', selectedNode.name),
                                        ok: updateStepStatus
                                    });
                                    return;
                                }

                                if ($scope.isDefault) {
                                    if (!UnifyValid.FormValid($("#recoveryEditStepDiv"), {focusInvalid: true})) {
                                        return;
                                    }
                                    var checked = $("#startCheckBox").widget().option("checked");
                                    var schemeType = $("#schemeOptions").widget().getSelectedId();
                                    var validateRequiredVal = function() {
                                        var validateResults = [];
                                        _.each(selectedNode.extendParams.sysScriptParams.data, function(data, key1, list) {
                                            if (_.has(data, "optional") && data["optional"] == "false") {
                                                var requireParamsObj = _.find(selectedNode.extendParams.sysScriptParams.props.afterParam, function(afterParam, key2, list){
                                                    return data.key == key2;
                                                });
                                                this.push(!(_.isUndefined(requireParamsObj) || _.first(_.values(requireParamsObj))));
                                            }
                                        }, validateResults);
                                        return !_.contains(validateResults, false);
                                    };

                                    //校验系统脚本的必填参数
                                    if (checked && schemeType == "false" && !validateRequiredVal()) {
                                        message.error(appUtils.getString("protection_lun_validate_scriptParams_label"));
                                        return;
                                    }

                                    var stepName = $.trim($("#stepName").widget().getValue());
                                    var scriptName = schemeType == "true"
                                        ? $.trim($("#userDefinedScript").widget().getValue()) : $scope.editStep.startStepModel.systemScript.value;
                                    var msg = appUtils.getString("protectionGroup_object_task_enableSelfDefinedScript_warm_msg", winData.name, winData.name);
                                    if (selectedNode.name != stepName || selectedNode.extendParams.scriptName != scriptName) {
                                        msg = appUtils.getString("protectionGroup_object_task_modifySelfDefinedScript_warm_msg", winData.name, winData.name);
                                    }

                                    message.warn({
                                        content: msg,
                                        ok: updateStepStatus
                                    });
                                    return;
                                }

                                var shutdownProAppProcessors = [
                                    "com.huawei.ism.drm.oracle.recovery.process.ShutdownProOracleAppProcessor",
                                    "com.huawei.ism.drm.db.recovery.process.ShutdownProAppProcessor",
                                    "com.huawei.ism.drm.exchange.recovery.process.ShutdownProExchangeProcessor",
                                    "com.huawei.ism.drm.filesystem.recovery.process.ShutdownProFileSystemProcessor"
                                ];

                                if (_.contains(shutdownProAppProcessors, selectedNode.extendParams.stepName)) {
                                    var checkedId = $("#editFilter").widget().getSelectedId(), msg;
                                    if (checkedId == 1) {
                                        msg = appUtils.getString("recovery_plannedMigration_task_stopAppStep_danger_msg");
                                    } else if (checkedId == 4) {
                                        msg = appUtils.getString("recovery_rollback_task_stopAppStep_danger_msg");
                                    }

                                    message.warn({
                                        content: msg,
                                        ok: updateStepStatus
                                    });

                                    return;
                                }

                                updateStepStatus();
                            }

                        }
                    },
                    btnCancel: {
                        id: "btnStartCancel",
                        disable: false,
                        text: appUtils.getString("common_term_cancel_button"),
                        click: function () {
                        }
                    }
                };

                function init(procType, callback) {
                    if (_.contains(["14", "10"], winData.poType) || winData.PROVIDER_TYPE == "FusionSphereOpenstack") {
                        $scope.editStep.addStep.spanCls = "default";
                        $scope.editStep.addStep.btnCls = "iconbutton-add-disabled";
                    } else {
                        $scope.editStep.addStep.btnCls = "iconbutton-add";
                        $scope.editStep.addStep.spanCls = "pointer";
                    }

                    var params = {
                        procType: procType,
                        planId: function() {
                            if (!_.isEmpty(planId)) {
                                return planId;
                            }
                            var checkRecoverys = $("#recoveryTable").widget().getTableCheckedItems();
                            return _.first(checkRecoverys)["uuid"];
                        }(),
                    }

                    restService.getRecoveryProcess(params, function(res) {
                        $scope.results = angular.copy(res);
                        $scope.nodes = [];
                        //查询预置的脚本信息
                        var initPresetScrpitsParams = function(node, index, callback) {
                            if (node.isPresetled || (_.has(node, "isUserDefined") && node.isUserDefined) || _.isUndefined(node["recoveryScriptSchemeId"])) {
                                _.isFunction(callback) && callback(node);
                                return;
                            }
                            //用户自定义步骤的系统脚本
                            restService.getPresetScrpitsBySchemeId(node["recoveryScriptSchemeId"], function(result) {
                                //系统脚本参数
                                var sysScriptParams = {
                                    publicData: result.publicParams,
                                    data: function() {
                                        var systemScripts = _.findWhere(result.steps, {
                                            position: node.position
                                        }) || {};
                                        return systemScripts["params"];
                                    }(),
                                    props: {
                                        "publicParam": node["publicParam"],
                                        "userAfterParam": function() {
                                            var executeParams = angular.copy(node["executeParams"]);
                                            var systemScripts = _.findWhere(result.steps, {
                                                script: node.scriptName
                                            }) || {};
                                            _.each(executeParams, function(value, key, list) {
                                                _.contains(_.keys(systemScripts.params), key) && (delete executeParams[key]);
                                            });
                                            return executeParams;
                                        }(),
                                        "afterParam": function() {
                                            var systemScripts = _.findWhere(result.steps, {
                                                script: node.scriptName
                                            }) || {};
                                            return _.pick(node["executeParams"], _.keys(systemScripts.params));
                                        }()
                                    }
                                };

                                _.isFunction(callback) && callback(_.extend(node, {sysScriptParams: sysScriptParams}), index);
                            })
                        }

                        //解析步骤名称
                        var initStepName = function(node) {
                            if (_.isString(node.stepName)) {
                                return appUtils.getString(node.stepName);
                            }

                            var i18nKey = node.stepName["i18nKey"];
                            if (!_.isEmpty(i18nKey)) {
                                return appUtils.getString(i18nKey);
                            }

                            return node.stepName["i18n"][cookieService.get("language")];
                        }

                        //初始化每个步骤
                        _.each(res, function (result, index) {
                            result["stepDescription"] == "--" && (result["stepDescription"] = "");
                            //所有的步骤参数
                            var extendParams = _.pick(result, "isEditable", "position", "publicParam", "isUserDefined", "executeParams", "scriptSchemeId", "recoveryScriptSchemeId",
                                    "stepId", "scriptName", "stepDescription", "isEnabled", "isPresetled", "isUserDefined", "isContinueIfFailed", "stepName");

                            var node = {
                                pId: procType,
                                selected: !index, //默认选中第一个步骤
                                name: initStepName(result),
                                stepId: extendParams["stepId"],
                                icon: function() {
                                    var actived = "/theme/recoverydirector/images/recovery/ic_step_actived.png";
                                    var deactived = "/theme/recoverydirector/images/recovery/ic_step_deactived.png";
                                    return result.isEnabled ? actived : deactived;
                                }()
                            }

                            initStepName(extendParams);
                            initPresetScrpitsParams(extendParams, index, function(params, position) {
                                if (!_.isUndefined(position)) {
                                    $scope.nodes.splice(position, 0, _.extend(node, {extendParams: params}));
                                    $scope.$apply();
                                }
                                else {
                                    $scope.nodes.push(_.extend(node, {extendParams: params}));
                                }
                            });
                        });

                        $scope.$watch("nodes", function(newNodes, oldNodes, scope) {
                            if (_.size(newNodes) != _.size($scope.results) || (!_.size(newNodes) || !_.size($scope.results))) {
                                return;
                            }
                            scope.editStep.stepTree.values = $scope.nodes;
                            scope.$apply();
                            _.isFunction(callback) && callback(scope.nodes);
                        }, true);

                        _.size($scope.nodes) == _.size($scope.results) && ($scope.editStep.stepTree.values = $scope.nodes);
                        $scope.$apply();
                    })

                    //判断是否需要进行同步
                    !window.isPrivateConsole && restService.getIsSyncSchemeInfo(planId, function(result) {
                        $scope.isNeedSyncPgInfo = result["demand"];
                        $scope.$apply();
                    });
                };
                function clickNode(event, id, node) {
                    $scope.editStep.title = appUtils.getString("common_term_step_label", node.name);
                    $scope.editStep.description = appUtils.getString(node.extendParams.stepDescription);
                    $scope.isEditable = node.extendParams.isEditable;
                    var refresh = true;

                    if (node.extendParams.isPresetled) {
                        $("#startCheckBox").widget().option("checked", node.extendParams.isEnabled);
                        $("#startCheckBox").widget().option("disable", !node.extendParams.isEditable);
                        $scope.isDefault = false;
                        if (_.contains([constsService.HANGUP_TREE_NODE_1, constsService.HANGUP_TREE_NODE_2], node.extendParams.stepName)) {
                            if (winData.PROVIDER_TYPE == "FusionCompute" || winData.PROVIDER_TYPE == "FusionManager") {
                                $scope.isVmware = false;
                            } else {
                                $scope.isVmware = true;
                                $scope.LEFTTITLE = appUtils.getString("recovery_vmware_unusered_label");
                                $scope.RIGHTTITLE = appUtils.getString("recovery_vmware_usered_label");
                                //查询可用的占位虚拟机
                                restService.getAvailableNonCirticalVm(planId, _updateLeftGrid);
                                //查询已选择的占位虚拟机
                                restService.getSelectedNonCriticalVm(planId, _updateRightGrid);
                                _setArrowAbled(node.extendParams.isEnabled);
                            }
                        } else if (constsService.START_VM_HOST_TREE_NODE_2 == node.extendParams.stepName) {
                            if (winData.PROVIDER_TYPE == "FusionCompute" || winData.PROVIDER_TYPE == "FusionManager"){
                                $scope.vmwareForm = false;
                            } else {
                                $scope.isVmware = true;
                                $scope.LEFTTITLE = appUtils.getString("recovery_host_unusered_label");
                                $scope.RIGHTTITLE = appUtils.getString("recovery_host_usered_label");
                                //查询可用的虚拟主机
                                restService.getAvailableHost(planId, _updateLeftGrid);
                                //查询已选择的虚拟机主机
                                restService.getSelectedHost(planId, _updateRightGrid);
                                _setArrowAbled(node.extendParams.isEnabled);
                            }
                        } else {
                            $scope.isVmware = false;
                        }
                    } else {
                        $scope.isDefault = true;
                        $scope.isVmware = false;
                        $("#userDefinedScript input").removeClass("valid_error_input")
                        function display(hidden) {
                            var values = [];
                            !hidden && values.push({"selectId": "false", "label": appUtils.getString("protection_lun_use_system_script_label")});
                            values.push({"selectId": "true", "label": appUtils.getString("protection_lun_use_hosts_script_label")});
                            $("#schemeOptions").widget().option("values", values);
                            $("#schemeOptions").widget().opChecked($.trim(node.extendParams.isUserDefined));
                            $("#stepName").widget().option("value", node.name);
                            $("#schemeOptions").widget().option("disable", !(node.extendParams.isEditable && node.extendParams.isEnabled));
                            $("#editPolicy").widget().opChecked($.trim(node.extendParams.isContinueIfFailed));
                            $("#userDefinedScript").widget().option("value", node.extendParams.isUserDefined && !node.extendParams.isPresetled ? node.extendParams.scriptName : "");
                            $("#userDefinedScript").widget().option("disable", !node.extendParams.isUserDefined || !(node.extendParams.isEditable && node.extendParams.isEnabled));
                            $("#editPolicy").widget().option("disable", !(node.extendParams.isEditable && node.extendParams.isEnabled));
                            $("#stepName").widget().option("disable", !node.extendParams.isUserDefined || !(node.extendParams.isEditable && node.extendParams.isEnabled));
                            $("#btnStartApply").widget().option("disable", !node.extendParams.isEditable);
                            $("#startCheckBox").widget().option("checked", node.extendParams.isEnabled);
                            $("#startCheckBox").widget().option("disable", !node.extendParams.isEditable);
                            $scope.editStep.startStepModel.schemeOptions.defaultSelectId = $.trim(node.extendParams.isUserDefined);
                            $scope.editStep.startStepModel.configBtn.enable = node.extendParams.isEditable && node.extendParams.isEnabled && (winData.poType != 12);
                            $scope.editStep.startStepModel.systemScript.value = node.extendParams.scriptName;
                            $scope.$apply();
                            refresh = false;
                        }
                        if (node.extendParams.isUserDefined) {
                            var nodes = $("#stepTree").widget().getZTreeObj().getNodes();
                            nodes = _.map(nodes, _.property('extendParams'));
                            var hidden = !_.isUndefined(_.findWhere(nodes, {position: node.extendParams.position, isUserDefined: false}));
                            var step;
                            if (!hidden) {
                                step = _.findWhere(nodes, {isPresetled: true});
                                hidden = !!step && _.isUndefined(step.scriptSchemeId);
                            }
                            if (!hidden && step && step.scriptSchemeId) {
                                restService.getPresetScrpitsBySchemeId(step.scriptSchemeId, function(result) {
                                    var step = _.findWhere(result.steps, {
                                        position: node.extendParams.position
                                    });
                                    display(_.isUndefined(step));
                                })
                            } else {
                                display(hidden)
                            }
                        } else {
                            display(false);
                        }
                    }
                    refresh && $scope.$apply();
                };

                function _updateRightGrid(result) {
                    var arr = [];
                    _.each(result, function (d) {
                        var tmo = _.pick(d, "uuid", "name");
                        arr.push(tmo);
                    });
                    var getTableData = [];
                    if ($("#datasSelTable").widget()) {
                        getTableData = $("#datasSelTable").widget().getTableData();
                    }
                    _.filter(arr, function (i) {
                        return _.contains(getTableData, i);
                    })

                    $("#datasSelTable").widget().option("data",appUtils.encodeForHTML(arr));
                    $scope.$apply();
                };

                function _updateLeftGrid(result) {
                    var arr = [];
                    _.each(result, function (d) {
                        var tmo = _.pick(d, "uuid", "name");
                        arr.push(tmo);
                    });
                    var getTableData = [];
                    if ($("#datasAvailTable").widget()) {
                        getTableData = $("#datasAvailTable").widget().getTableData();
                    }
                    _.filter(arr, function (i) {
                        return _.contains(getTableData, i);
                    })

                    $("#datasAvailTable").widget().option("data",appUtils.encodeForHTML(arr));
                    $scope.$apply();
                };

                function _setArrowAbled(isEnabled) {
                    !isEnabled ? $("#addbtn1").removeClass("buttons-default").addClass("tiny-img-disabled buttons-disabled")
                    : $("#addbtn1").removeClass("tiny-img-disabled buttons-disabled").addClass("buttons-default");
                    !isEnabled ? $("#rbtn1").removeClass("buttons-default").addClass("tiny-img-disabled buttons-disabled")
                    : $("#rbtn1").removeClass("tiny-img-disabled buttons-disabled").addClass("buttons-default");
                };

                function updateStepStatus() {
                    var checked = $("#startCheckBox").widget().option("checked");
                    var checkedNode = _.first($("#stepTree").widget().getZTreeObj().getSelectedNodes());
                    var procType = $("#editFilter").widget().getSelectedId();
                    var params = {
                        planId: planId,
                        stepId: checkedNode.stepId,
                        procType: procType
                    }
                    var dealStatusResult = function() {
                        if ($scope.isDefault) {
                            if (!checked) {
                                message.success({content:appUtils.getString("common_term_operation_success_label"), ok: updateCurrentNode});
                                return;
                            }
                            updateStepInfo(checkedNode);
                        } else if ($scope.vmwareForm) {
                            var tableData = $("#datasSelTable").widget().getTableData();
                            if (constsService.VMWARE_TREE_NODE == checkedNode.extendParams.stepName) {
                                var params = [];
                                _.each(tableData, function(data) {
                                    params.push({uuid: data.uuid, name: data.name});
                                });
                                updateVmStepInfo("/vcenters/vm/action/setNocriticalVm?planId=" + planId, params);
                            } else {
                                var url = "";
                                var params = {
                                    planId: planId,
                                    isEnable: checked,
                                    stepId: checkedNode.stepId,
                                    type: procType,
                                    uuids: function() {
                                        var uuids = [];
                                        _.each(tableData, function(data){
                                            uuids.push(data.uuid);
                                        })
                                        return uuids;
                                    }()
                                };
                                if (_.contains([constsService.HANGUP_TREE_NODE_1, constsService.HANGUP_TREE_NODE_2], checkedNode.extendParams.stepName)) {
                                    url = "/fusionsphere/vms/action/setNonCriticalvms";
                                } else if (constsService.START_VM_HOST_TREE_NODE_2 == checkedNode.extendParams.stepName) {
                                    url = "/fusionsphere/hosts/action/setHosts";
                                }
                                updateVmStepInfo(url, params);
                            }
                            _setArrowAbled(checked);
                        } else {
                            message.success({content:appUtils.getString("common_term_operation_success_label"), ok: updateCurrentNode});
                        }
                    }

                    if (checked) {
                        restService.enableStep(params, dealStatusResult);
                    } else {
                        restService.disableStep(params, dealStatusResult);
                    }
                }

                function updateStepInfo(checkedNode) {
                    var schemeType = $("#schemeOptions").widget().getSelectedId();
                    var params = {
                        name: $.trim($("#stepName").widget().getValue()),
                        isContinueIfFailed: $("#editPolicy").widget().getSelectedId(),
                        recoveryScriptSchemeId: function() {
                            if (schemeType == "true") {
                                return checkedNode.extendParams.recoveryScriptSchemeId;
                            }
                            return checkedNode.extendParams.scriptSchemeId;
                        }(),
                        isUserDefined: schemeType == "true",
                        scriptName: function() {
                            if ("true" == schemeType) {
                                return $.trim($("#userDefinedScript").widget().getValue())
                            }
                            return $scope.editStep.startStepModel.systemScript.value;
                        }(),
                        executeParams: function() {
                            return "true" == schemeType ? checkedNode.extendParams.executeParams : function() {
                                return _.extend(checkedNode.extendParams.sysScriptParams.props.afterParam, checkedNode.extendParams.sysScriptParams.props.userAfterParam);
                            }()
                        }()
                    }

                    if (schemeType == "false") {
                        params["publicParams"] = checkedNode.extendParams.sysScriptParams.props.publicParam;
                    }

                    restService.updateStepInfo({planId: planId, procType: $("#editFilter").widget().getSelectedId(), stepId: checkedNode.stepId}, {
                        data: params,
                        success: function(result) {
                            if (_.isUndefined(result["taskId"])) {
                                message.success({content: appUtils.getString("common_term_operation_success_label"), ok: updateCurrentNode});
                                return;
                            }
                            message.success({content:appUtils.getString("common_term_operation_success_label"), ok: updateCurrentNode});
                        }
                    })
                }

                function updateVmStepInfo(url, params) {
                    if (_.isEmpty(url)) {
                        return;
                    }
                    mask.show();
                    communicationService.put(utilService.getResouceUrl(url), params).promise().always(function(result) {
                        mask.hide();
                        exception.check(result) && message.success({content: appUtils.getString("common_term_operation_success_label"), ok: updateCurrentNode});
                    });
                }

                function updateCurrentNode() {
                    var index = 0;
                    var nodes = $("#stepTree").widget().getZTreeObj().getNodes();
                    var checkedNode = _.first($("#stepTree").widget().getZTreeObj().getSelectedNodes());
                    _.find(nodes, function(node, key) {
                        index = key;
                        return node.stepId == checkedNode.stepId;
                    });

                    init($("#editFilter").widget().getSelectedId(), function(nodes) {
                        setTimeout(function() {
                            addNodeConfigLabel(nodes);
                            $("#stepTree li a:eq(" + index + ")").click();
                        }, 100);
                    })
                }

                function addNodeConfigLabel(nodes) {
                    _.each(nodes, function(node, key) {
                        if (_.has(node, "extendParams") && node.extendParams.isEditable) {
                            if ($("#stepTree li a:eq("+ key +") > span").hasClass("configurable_label")) {
                                return;
                            }
                            $("#stepTree li a:eq("+ key +")").append("<span class='configurable_label'>"+"("+appUtils.getString("recoveryStep_term_configurable_label")+")"+"</span>");
                        }

                        if (key < _.size(nodes) - 1) {
                            $("#stepTree li a:eq("+ key +")").append("<span class='relatedLine_label'></span>");
                        }
                    });
                }

                //同步保护组脚本解决方案到恢复计划
                window["syncPgScriptPlan"] = function() {
                    restService.syncPgScriptPlan({planId: planId}, function(result) {
                        message.success({content: appUtils.getString("common_term_operation_success_label"), ok: function() {
                            init($("#editFilter").widget().getSelectedId());
                        }});
                    })
                }

                //初始化
                init(procType, function(nodes) {
                    setTimeout(function() {
                        addNodeConfigLabel(nodes);
                        //加载第一个步骤对应的面板信息
                        $("#stepTree li a:eq(0)").click();
                    }, 100);
                });
            }
        ]
        var editStepApp = angular.module("recoverydirector.recovery.config");
        editStepApp.tinyController("app.recovery.edit.step.ctrl", editStepCtrl);
        return editStepApp;
    })
;
