define([], function() {
    "use strict";
    var ctrler = [
        "$scope",
        "$state",
        "$timeout",
        "appUtils",
        "exception",
        "constsService",
        "statusEnumService",
        "restService",
        "recoveryService",
        "treeTableRenderService",
        "infoTransferredService",
        "message",
        "mask",
        function($scope, $state, $timeout, appUtils, exception, constsService, statusEnumService, restService, recoveryService, treeTableRenderService, infoTransferredService, message, mask) {
            var promise;
            var pgExecFlag = false;
            var hasExecDataFlag = false;
            var execEndFlag = false;
            var recovery = {};
            var labels = [];

            var _test = {
                    "selectId": "2",
                    "label": appUtils.getString("recovery.term.procedure.filter.values.test")
                },
                _clear = {
                    "selectId": "3",
                    "label": appUtils.getString("recovery.term.procedure.filter.values.clear")
                },
                _rollback = {
                    "selectId": "4",
                    "label": appUtils.getString("ism.drm.protect.group.rollback.recovery.label")
                },
                _planTransfer = {
                    "selectId": "1",
                    "label": appUtils.getString("recovery.term.procedure.filter.values.planTransfer")
                },
                _fault = {
                    "selectId": "0",
                    "label": appUtils.getString("ism.drm.protect.group.fault.recovery.label")
                },
                _protect = {
                    "selectId": "7",
                    "label": appUtils.getString("recovery.term.procedure.filter.values.protected")
                },
                _swap = {
                    "selectId": "8",
                    "label": appUtils.getString("recovery_nas_hypermetro_switch_label")
                },
                _mount = {
                    "selectId": "9",
                    "label": appUtils.getString("protection_object_action_mount_label")
                },
                _unMount = {
                    "selectId": "10",
                    "label": appUtils.getString("protection_object_action_umount_label")
                },
                _hostMigration = {
                    "selectId": "11",
                    "label": appUtils.getString("ism.drm.drp.auth.planed.hotmigration")
                };

            var _statusMap = {
                test: [0, 4, 5, 6],
                clear: [7, 8, 9],
                move: [1, 2, 3, 15, 18, 19, 99],
                rollback: [1, 2, 3, 15, 18, 19],
                fault: [10, 11, 12],
                protect: [16, 17, 20],
                swap: [0, 21, 22],
                mount: [23, 25, 26],
                unmount: [24, 27, 28],
                hostMigration: [29, 30]
            }

            var _tipInfo = {
                5: appUtils.getString("test_task_executeStepremote_des_success_message"),
                6: appUtils.getString("test_task_executeStep_des_fail_message"),
                8: appUtils.getString("clear_task_executeStep_des_success_message"),
                9: appUtils.getString("clear_task_executeStep_des_fail_message"),
                18: appUtils.getString("rollback_task_executeStep_des_fail_message"),
                19: appUtils.getString("rollback_task_executeStep_des_success_message"),
                16: appUtils.getString("reprotection_task_executeStep_des_fail_message"),
                20: appUtils.getString("reprotection_task_executeStep_des_success_message"),
                11: appUtils.getString("faultRecovery_task_executeStep_des_success_message"),
                12: appUtils.getString("faultRecovery_task_executeStep_des_fail_message"),
                2: appUtils.getString("plannedMigration_task_executeStep_des_success_message"),
                3: appUtils.getString("plannedMigration_task_executeStep_des_fail_message"),
                30: appUtils.getString("hotMigration_task_executeStep_des_fail_message")
            };

            function _setSelectIndex(items, index) {
                _.each(items, function(item, key) {
                    item.checked = key == index;
                });

                var target = _.findWhere(items, {
                    checked: true
                });
                if (_.isUndefined(target) || _.isEmpty(target)) {
                    _.extend(_.first(items), {
                        checked: true
                    });
                }

                return items;
            };

            function _getProTypeLabelIndex(status, statusMap) {
                var _index = -1;
                for (var i = 0, length = statusMap.length; i < length; i++) {
                    if (_.contains(statusMap[i], status)) {
                        _index = i;
                        break;
                    }
                }
                return _index;
            };

            function _getLabels(recovery) {
                if (_.isUndefined(recovery) || _.isEmpty(recovery)) {
                    return;
                }
                var _labels = [];
                var _labelMap = [];

                if (recovery.planType == 2) {
                    //vmware的NAS复制没有测试和清理 ps:纯NAS双活+复制没有测试、清理
                    if ((recovery["poType"] == constsService.VMware_VM_TYPE && (recovery["templateType"] == 1 && recovery["templateSubType"] == 2))
                        || (recovery["poType"] == 12 && recovery["templateType"] == 25)
                        || (recovery["poType"] == 14 && _.contains([18,20],parseInt(recovery["templateType"],10)))) {
                        _labels.push(_planTransfer, _fault, _protect);
                        _labelMap.push(_statusMap["move"], _statusMap["fault"], _statusMap["protect"]);

                        if (recovery["templateType"] == 25 && recovery["poType"] == 12) {
                            _labels.push(_hostMigration);
                            _labelMap.push(_statusMap["hostMigration"]);
                        }
                    } else {
                        //模板类型为 7、VIS双活+SAN异步复制，12、VIS异步复制，13、VIS镜像+SAN异步复制 过滤掉重保护
                        if (_.contains([7, 12, 13], recovery["templateType"])) {
                            _labels.push(_test, _clear, _planTransfer, _fault);
                            _labelMap.push(_statusMap["test"], _statusMap["clear"], _statusMap["move"], _statusMap["fault"]);
                        } else if (_.contains([30,31,32], parseInt(recovery["templateType"] ,10))) {
                            //CDM增加回滚
                            _labels.push(_rollback, _test, _clear, _planTransfer, _fault, _protect);
                            _labelMap.push([15,18,19], _statusMap["test"], _statusMap["clear"], _statusMap["move"], _statusMap["fault"], _statusMap["protect"]);
                        } else {
                            _labels.push(_test, _clear, _planTransfer, _fault, _protect);
                            _labelMap.push(_statusMap["test"], _statusMap["clear"], _statusMap["move"], _statusMap["fault"], _statusMap["protect"]);
                            if (recovery["templateType"] == 37) {
                                _labels.push(_hostMigration);
                                _labelMap.push(_statusMap["hostMigration"]);
                            }
                        }
                    }
                } else {
                    //vmware的Nas异步复制或者存储快照或者一体化备份
                    if (recovery["poType"] == constsService.VMware_VM_TYPE
                            && (((recovery["templateType"] == 1 && recovery["templateSubType"] == 2) || recovery["templateType"] == 14)
                                    || recovery["templateType"] == 17)) {
                        _labels.push(_rollback);
                        _labelMap.push(_statusMap["rollback"]);
                    } else if(_.contains([28,30,31,32], parseInt(recovery["templateType"] ,10))){
                        //挂载计划步骤
                        if($state.current.name == "dataUse.dataMount.procedure"){
                            _labels.push(_mount, _unMount);
                            _labelMap.push(_statusMap["mount"], _statusMap["unmount"]);
                        }else{
                            _labels.push(_rollback);
                            _labelMap.push(_statusMap["rollback"]);
                        }
                    } else {
                        if(recovery["templateType"] == 15 && !recovery["isNasRecovery"]){
                            _labels.push(_test, _clear);
                            _labelMap.push(_statusMap["test"], _statusMap["clear"]);
                        }else if (recovery["templateType"] == 15 && recovery["isNasRecovery"]){
                            _labels.push(_swap);
                            _labelMap.push(_statusMap["swap"]);
                        }else{
                            //挂载计划步骤
                            if($state.current.name == "dataUse.dataMount.procedure"){
                                _labels.push(_mount, _unMount);
                                _labelMap.push(_statusMap["mount"], _statusMap["unmount"]);
                            }else{
                                _labels.push(_test, _clear, _rollback);
                                _labelMap.push(_statusMap["test"], _statusMap["clear"], _statusMap["rollback"]);
                            }
                        }
                    }
                }
                return _setSelectIndex(_labels, _getProTypeLabelIndex(recovery.planStatus, _labelMap));
            };


            function _getSelectedId(labels) {
                if (_.isUndefined(labels) || _.isEmpty(labels)) {
                    return "";
                }
                return _.findWhere(labels, {
                    checked: true
                }).selectId;
            };


            function initTree(treeData) {
                if (!angular.isArray(treeData) || treeData.length == 0) {
                    clearTable();
                } else {
                    treeTableRenderService.treeTableBuf = "";
                    initTreeTabelHead();
                    if ($scope.$parent.recoveryObj.supportConfirmReprotection) {
                        treeTableRenderService.initTreeTabContent(treeData, false, initHtml);
                    } else {
                        treeTableRenderService.initTreeTabContent(treeData);
                    }
                    treeTableRenderService.initTableFinalTag("recoveryProcessTreeDiv");
                    treeTableRenderService.bindListenEvent();
                    runClick();
                    return treeTableRenderService.getTreeAllNodes(treeData);
                }
            }

            function clearTree(rep) {
                treeTableRenderService.treeTableBuf = "";
                initTreeTabelHead();
                treeTableRenderService.initEmptyTr();
                treeTableRenderService.initTableFinalTag();
                exception.checkSessionTimeout(rep, function() {
                    $timeout.cancel(promise);
                });
            }

            function updateProcessType() {
                recovery = $("#recoveryTable").widget().getTableCheckedItems()[0];
                if(_.isEmpty($scope.processScope.procType.values) || _.contains([1, 4, 7, 10, 15, 17], recovery.planStatus)) {
                    $scope.processScope.procType.values = _getLabels(recovery);
                }
                $scope.$apply();
            }

            function hideTips() {
                var sessionObj = infoTransferredService.get("tipModule", "obj"),
                    recoveryObj,
                    checkObj = $("#recoveryTable").widget().getTableCheckedItems()[0];
                if (_.isEmpty($scope.$parent) || _.isEmpty($scope.$parent.recoveryObj)) {
                    recoveryObj = checkObj;
                } else{
                    recoveryObj = $scope.$parent.recoveryObj;
                };
                if (_.isUndefined(sessionObj) || _.isEmpty(sessionObj[recoveryObj.uuid])
                        || (recoveryObj.planStatus == 0)
                        || (_.keys(sessionObj)[0] != recoveryObj.uuid && _.contains([1, 4, 7, 10, 15, 17], recoveryObj.planStatus))) {
                    $scope.processScope.tipContainer.display = false;
                } else {
                    sessionObj[recoveryObj.uuid].display = true;
                    $scope.$parent.recoveryObj.planStatus = parseInt($scope.$parent.recoveryObj.planStatus, 10);
                    if($scope.$parent.recoveryObj.planType == 1 && $scope.$parent.recoveryObj.planStatus == 5) { //测试完成
                        sessionObj[recoveryObj.uuid].text = appUtils.getString("test_task_executeSteplocal_des_success_message");
                    } else if($scope.$parent.recoveryObj.planType == 1 && $scope.$parent.recoveryObj.planStatus == 8){//清理完成
                        sessionObj[recoveryObj.uuid].text = appUtils.getString("clear_task_executeSteplocal_des_success_message");
                    } else {
                        sessionObj[recoveryObj.uuid].text = _tipInfo[$scope.$parent.recoveryObj.planStatus];
                    }
                    if (_.contains([5, 8, 19, 20, 11, 2], parseInt($scope.$parent.recoveryObj.planStatus, 10))) {
                        sessionObj[recoveryObj.uuid].icon = "icon-success";
                        sessionObj[recoveryObj.uuid].backgroundColor = "tip-container-success";
                    } else {
                        sessionObj[recoveryObj.uuid].icon = "icon-failed";
                        sessionObj[recoveryObj.uuid].backgroundColor = "tip-container-fail";
                    }
                    $scope.processScope.tipContainer = sessionObj[recoveryObj.uuid];
                }

                $scope.$apply();
            }

            function initTreeTabelHead() {
                var treeHead = "";
                if ($scope.$parent.recoveryObj.supportConfirmReprotection) {
                    treeHead = "<table class='x-grid3-table tbodytable' id='treeTable' style='margin-top:0px;margin-bottom:0px'><thead><tr class='x-grid3-hd-row'>"
                        + "<th class='cell-spliter' dragabled='true' width='20%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 11px;' class='ellipsis'>" + appUtils.getString("common_term_name_label") + "</div></th>"
                        + "<th class='cell-spliter' dragabled='true' width='14%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 3px;' class='ellipsis'>" + appUtils.getString("common_term_status_label") + "</div></th>"
                        + "<th class='cell-spliter' dragabled='true' width='19%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 3px;' class='ellipsis'>" + appUtils.getString("common_term_begintime_label") + "</div></th>"
                        + "<th class='cell-spliter' dragabled='true' width='19%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 3px;' class='ellipsis'>" + appUtils.getString("common_term_endtime_label") + "</div></th>"
                        + "<th class='cell-spliter' dragabled='true' width='10%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 3px;' class='ellipsis'>" + appUtils.getString("task_term_executeTime_label") + "</div></th>"
                        + "<th class='cell-spliter' dragabled='true' width='18%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 3px;' class='ellipsis'>" + appUtils.getString("common_term_description_column") + "</div></th>"
                        + "<th class='cell-spliter' dragabled='true' width='18%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 3px;' class='ellipsis'>" + appUtils.getString("recovery.term.colum.operate.title") + "</div></th>"
                        + "</tr></thead>"
                }
                treeTableRenderService.initTreeTabelHead(treeHead)
            }

            function initHtml(params) {
                var html = "";
                html += "<tr class='x-grid3-row treeTr " + params.classStyle + " id='suffex" + params.detailId + "'" + " value='" + params.processStatus + "' data-tt-id='" + params.detailId + "'" + params.parentIdSet + ">";
                html += "<td class='x-grid3-table-cell' width='20%' style='text-align:left;' title='" + params.processName + "'><span class='" + params.spanClass + "' style='" + params.spanStyle + "'>" + params.processName + "</span></td>";
                html += "<td class='x-grid3-table-cell td-left-align' width='14%' class='refHandle' title='" + params.processStatus + "'><div><label class='" + params.c + "'></label><label class='" + params.iconLabel + "'>" + params.processStatus + "</label><div></td>";
                html += "<td class='x-grid3-table-cell td-left-align' width='19%' title='" + params.startTime + "'><label class='maxTime'>" + params.startTime + "</label></td>";
                html += "<td class='x-grid3-table-cell td-left-align' width='19%' title='" + params.endTime + "'><label class='maxTime'>" + params.endTime + "</label></td>";
                html += "<td class='x-grid3-table-cell td-left-align' width='10%' title='" + params.executeTime + "'><label class='maxTime'>" + params.executeTime + "</label></td>";
                html += "<td class='x-grid3-table-cell td-left-align' width='18%' title='" + params.processDetail + "'><label class='maxDescContext'>" + params.processDetail + "</label></td>";
                html += "<td class='x-grid3-table-cell td-left-align' width='18%'>";
                if (params.logStatus == 4) {
                    html += "<span class='maxDescContext btn-link plan-run'>" + appUtils.getString("recovery_plan_excute_opt_run_label") + "</span></td>"
                } else {
                    html += "&nbsp;</td>";
                }
                html += "</tr>"
                return html;
            }

            function runClick() {
                $("#recoveryProcessTreeDiv #treeTable").on("click", ".plan-run", function(){
                    message.warn({
                        content: appUtils.getString("recovery_plan_paused_run_warn_label"),
                        okLabel: appUtils.getString("recovery_plan_excute_opt_on_label"),
                        cancelLabel: appUtils.getString("recovery_plan_excute_opt_stop_label"),
                        ok: function() {
                            report(true);
                        },
                        cancel: function() {
                            report(false);
                        },
                        close: function() { }
                    })
                });
            }

            function report(isContinue) {
                var planId = $scope.$parent.recoveryObj.uuid;
                mask.show();
                restService.pausedContinue([planId, "planedMotion"], {
                    data: { recovery_continue_key: isContinue },
                    success: function (res) {
                        mask.hide();
                        if (exception.check(res)) {
                            message.success({
                                content: appUtils.getString("common_term_command_send_success_label"),
                                ok: function () {
                                    initPage();
                                }
                            })
                        }
                    },
                    fail: function(err) {
                        mask.hide();
                    }
                })
            }

            function initPage(proType) {
                pgExecFlag = $scope.$parent.exec;
                execEndFlag = false;
                hasExecDataFlag = false;

                if (promise) {
                    $timeout.cancel(promise);
                }

                updateProcessType();

                if (!_.contains([1, 4, 7, 10, 15, 17, 23, 24, 29, 99], recovery.planStatus)) {
                    //取消禁用下拉框
                    $scope.processScope.procType.disable = false;
                }
                $scope.processScope.edit.clickActive();
                $scope.recoveryProcessMask = true;
                $scope.$apply();

                var type;
                if(_.isUndefined(proType) ) {
                    type = _getSelectedId(_getLabels(recovery));
                } else {
                    type = proType;
                }
                restService.getRecoveryProcessList({uuid: recovery.uuid, procType: type}, {
                    mask: false,
                    isShowMsgBox: false,
                    success: function(data) {
                        var treeData = initTree(data);
                        hasExecDataFlag = hasExecData(treeData);
                        autoRefresh();
                    },
                    fail: function(rep) {
                        clearTree(rep);
                    },
                    callback: function() {
                        $scope.recoveryProcessMask = false;
                        $scope.$apply();
                    }
                })

                hideTips();
                $scope.$apply();
            }

            //判断是否有正在执行
            function hasExecData(data) {
                if (!data || data.length == 0) return false;
                var ret = !!appUtils.getItemFromArray(data, "processStatus", "3");
                if (ret) {
                    //通知恢复计划页面刷新
                    $scope.$emit("recoveryExecute", {uuid: $scope.$parent.recoveryObj.uuid, mask: false});
                }
                return ret;
            };

            function showResultTip() {
                $scope.$parent.recoveryObj.planStatus = parseInt($scope.$parent.recoveryObj.planStatus, 10);
                if ($scope.$parent.recoveryObj.planType == 1 && $scope.$parent.recoveryObj.planStatus == 5) { //测试完成
                    $scope.processScope.tipContainer.text = appUtils.getString("test_task_executeSteplocal_des_success_message");
                } else if ($scope.$parent.recoveryObj.planType == 1 && $scope.$parent.recoveryObj.planStatus == 8) { //清理完成
                    $scope.processScope.tipContainer.text = appUtils.getString("clear_task_executeSteplocal_des_success_message");
                } else {
                    $scope.processScope.tipContainer.text = _tipInfo[$scope.$parent.recoveryObj.planStatus];
                }
                if (_.contains([5, 8, 19, 20, 11, 2], parseInt($scope.$parent.recoveryObj.planStatus, 10))) {
                    $scope.processScope.tipContainer.icon = "icon-success";
                    $scope.processScope.tipContainer.backgroundColor = "tip-container-success";
                } else {
                    $scope.processScope.tipContainer.icon = "icon-failed";
                    $scope.processScope.tipContainer.backgroundColor = "tip-container-fail";
                }

                $scope.processScope.tipContainer.display = true;

                var tipObj = infoTransferredService.get("tipModule", "obj");
                _.isEmpty(tipObj) && (tipObj = {});
                tipObj[recovery.uuid] = angular.copy($scope.processScope.tipContainer);
                infoTransferredService.put("tipModule", "obj", tipObj);
                $scope.$apply();
            }

            function autoRefresh() {
                hideTips();
                if ((!$state.includes("dataUse.dataRecovery.procedure") && !$state.includes("dataUse.dataMount.procedure")) || $scope.$$destroyed) {
                    $timeout.cancel(promise);
                } else {
                    updateProcessType();
                    //恢复计划正在执行中的状态值
                    var hasRuningRecovery = _.contains([1, 4, 7, 10, 15, 17, 23, 24, 29, 99], parseInt($scope.$parent.recoveryObj.planStatus, 10));
                    if (hasRuningRecovery) {
                        !execEndFlag && (pgExecFlag = true);
                        //禁用下拉框
                        $scope.processScope.procType.disable = true;
                        $scope.processScope.tipContainer.display = false;
                    } else {
                        $scope.processScope.procType.disable = false;
                    }
                    $scope.processScope.edit.clickActive();
                    $scope.$apply();
                    (pgExecFlag || hasRuningRecovery) && restService.getRecoveryProcessList({uuid: $scope.$parent.recoveryObj.uuid, procType: _getSelectedId(_getLabels($scope.$parent.recoveryObj))},
                    {
                        mask: false,
                        isShowMsgBox: false,
                        success: function(data) {
                            var treeData = initTree(data);
                            if (!hasExecDataFlag) {
                                hasExecDataFlag = hasExecData(treeData);
                            };

                            //判断是否执行完毕,所有步骤状态都由执行变为--
                            if (hasExecDataFlag) {
                                execEndFlag = treeData.every(function(item) {
                                    return item.processStatus == "-1";
                                });
                            }
                            //有一个步骤为失败
                            else {
                                execEndFlag = !!appUtils.getItemFromArray(treeData, "processStatus", "1");
                            }

                            //恢复计划执行完毕后,显示结果并通知父页面更新
                            if (execEndFlag) {
                                pgExecFlag = false;
                                //通知父页面更新
                                $scope.$emit("recoveryExecute", {uuid: recovery.uuid, mask: false, showResultTipFn: showResultTip});
                                //取消下拉框
                                $scope.processScope.procType.disable = false;
                                //重置按钮的状态
                                $scope.processScope.edit.clickActive();
                                $scope.$apply();
                            }
                        },
                        fail: function(rep) {clearTree(rep);}
                    })
                    promise = $timeout(autoRefresh, 2500);
                }
            }

            $scope.processScope = {
                tipContainer: {
                    display: false,
                    text: "",
                    icon: "",
                    backgroundColor: "",
                    hide: function() {
                        $scope.processScope.tipContainer.display = false;
                        $scope.$apply();
                        delete infoTransferredService.get("tipModule", "obj")[recovery.uuid];
                    }
                },
                edit: {
                    isActive: false,
                    hasRight: appUtils.checkRight("ism.drm.drp.auth.modify"),
                    cls: {
                        span: "btn-link",
                        icon: "iconbutton-edit"
                    },
                    text: appUtils.getString("recovery.term.procedure.editStepLabel"),
                    disable: {
                        recStatus: [1, 2, 4, 7, 10, 11, 15, 16, 17, 23, 24, 29]
                    },
                    click: function() {
                        var _procTypeWidget = $("#procType").widget();
                        this.isActive && recoveryService.execute(_.extend($scope.$parent.recoveryObj, {
                            action: "editProcess",
                            planId: $scope.$parent.recoveryObj.uuid,
                            filterId: _procTypeWidget.getSelectedId(),
                            filterLable: _procTypeWidget.getSelectedLabel(),
                            values: _procTypeWidget.option("values"),
                            $scope: $scope
                        }));
                    },
                    clickActive: function() {
                        //SAN双活屏蔽接口
                        if($scope.$parent.recoveryObj.templateType == 15){
                            _.extend(this, {
                                isActive: false,
                                cls: {
                                    icon: "iconbutton-edit-disabled",
                                    span: "btn-link-disable"
                                }
                            });
                            return;
                        }
                        //云双活屏蔽接口
                        if (_.contains([25,34,37], +$scope.$parent.recoveryObj.templateType) || ($scope.$parent.recoveryObj.serviceInstanceType == "replication" && $scope.$parent.recoveryObj.poType == 12)){
                            _.extend(this, {
                                isActive: false,
                                cls: {
                                    icon: "iconbutton-edit-disabled",
                                    span: "btn-link-disable"
                                }
                            });
                            return;
                        }
                        if ($scope.$parent.recoveryObj.planType == 1 && _.contains(this.disable.recStatus, $scope.$parent.recoveryObj.planStatus)) {
                            _.extend(this, {
                                isActive: false,
                                cls: {
                                    icon: "iconbutton-edit-disabled",
                                    span: "btn-link-disable"
                                }
                            });
                            return;
                        }
                        if ($scope.$parent.recoveryObj.planType == 2 && ($scope.$parent.recoveryObj.isAllowExecute == 0 || _.contains(this.disable.recStatus, $scope.$parent.recoveryObj.planStatus))) {
                            _.extend(this, {
                                isActive: false,
                                cls: {
                                    icon: "iconbutton-edit-disabled",
                                    span: "btn-link-disable"
                                }
                            });
                            return;
                        }
                        _.extend(this, {
                            isActive: true,
                            cls: {
                                icon: "iconbutton-edit",
                                span: "btn-link"
                            }
                        });
                    }
                },
                procType: {
                    id: "procType",
                    values: labels,
                    disable: false,
                    width: constsService.W2,
                    change: function() {
                        var selectWidget = $("#procType").widget();
                        var currentId = selectWidget.getSelectedId();
                        var typeValues = selectWidget.option("values");
                        _.each(typeValues, function(items) {
                            if (items.selectId != currentId) {
                                items.checked = false;
                            } else {
                                !items.checked && (items.checked = true);
                            }
                        });
                        initPage(currentId);
                    }
                }
            }

            $scope.$on("$destroy", function() {
                var routerMap = ["dataUse.dataRecovery", "dataUse.createRecoveryPlan", "dataUse.dataRecovery.abstract", "dataUse.dataRecovery.protected", "dataUse.dataRecovery.procedure", "dataUse.dataRecovery.history"];
                if(!_.contains(routerMap, $state.current.name)) {
                    infoTransferredService.remove("tipModule", "obj");
                }
                promise && $timeout.cancel(promise);
            });

            $scope.$on(constsService.RECOVERY_TAB, function(ev, param) {
                $scope.processScope.procType.values = _getLabels(_.extend((recovery = $scope.$parent.recoveryObj), param));
                $scope.$apply();
                initPage();
            })

            recovery = $("#recoveryTable").widget().getTableCheckedItems()[0];
            if(_.isEmpty(recovery)) {
                return;
            }

            $scope.processScope.procType.values = _getLabels(_.extend(recovery));
            initPage();

        }
    ]
    var module = angular.module('recoverydirector.recovery.config');
    module.tinyController('recovery.procedure.ctrl', ctrler);
    return module;
})
