define([], function() {
    "use strict";
    var startSettingCtrl = [
        "$scope",
        "$compile",
        "constsService",
        "appUtils",
        "restService",
        function($scope, $compile, constsService, appUtils, restService) {
            var _winData = $("#" + constsService.START_SETTING_WIN.winId).widget().option("data");
            var planId = _winData.uuid;
            var poType = parseInt(_winData.poType, 10);
            var isStartColumn = appUtils.getString("recovery.term.protected.colum.isStart.title");
            var startOrderColumn = appUtils.getString("recovery.term.protected.colum.startOrder.title");
            var placeholderVmsColumn = appUtils.getString("VMware_term_status_value_occupiedVM_value");
            var excuteResponse = [];
            var defaultIndex = 15;
            var placeHolderVms;

            function _insertSpinner(nRow, aData, iDataIndex, isSetDefault) {
                var spinnerBox = "<div id=container_" + iDataIndex + "><tiny-spinner id='id' value='value' width='width' step='step' max='max' min='min' change='change()'></tiny-spinner></div>";
                var spinnerLink = $compile(spinnerBox);
                var spinnerScope = $scope.$new();
                spinnerScope.id = "startOrder_" + aData['uuid'];
                spinnerScope.value = isSetDefault ? 10 : aData.props.startOrder;
                spinnerScope.width = constsService.W2;
                spinnerScope.step = 1;
                spinnerScope.min = 1;
                spinnerScope.max = _.contains([10, 12], poType) ? 512 : 32;
                spinnerScope.change = function() {
                    var spinnerWidget = $("#" + spinnerScope.id).widget();
                    _.isEmpty(spinnerWidget.option("value")) && spinnerWidget.option("value", 10);
                }
                var spinnerNode = spinnerLink(spinnerScope);
                spinnerScope.$evalAsync();
                $("td[tdtitle='" + startOrderColumn + "']", nRow).html(spinnerNode);
            }

            function _placeholderVms(nRow, aData, iDataIndex) {
                var setPlaceholderVms = "<tiny-combobox id='id' select='select' values-from='valuesFrom' values='values' value='value' validate='validate' keyup='keyup()' keydown='keydown()' content-change='contentChange(event, value)' trigger='trigger' width='width' search='search' extend-function='extendFunction'></tiny-combobox>";
                var placeholderLink = $compile(setPlaceholderVms);
                var placeholderScope = $scope.$new();
                var newValue;
                var lastSelectValue, currentSelectValue;
                var isSelected;
                var isChanged;
                var isKeyup;

                placeholderScope.id = "placeholder_" + aData['uuid'];
                placeholderScope.width = constsService.W2;
                placeholderScope.trigger = "delay";
                placeholderScope.valuesFrom = "interact";
                placeholderScope.value = _.isEmpty(aData.props.PLACEHOLDVM) ? appUtils.getString("common_term_pleaseSelect_listbox") : aData.props.PLACEHOLDVMNAME;
                placeholderScope.values = _.isEmpty(aData.props.PLACEHOLDVM) ? [{ "selectId": "-1", "label": appUtils.getString("common_term_pleaseSelect_listbox") }] : [{ "selectId": aData.props.PLACEHOLDVM, "label": aData.props.PLACEHOLDVMNAME }];
                lastSelectValue = _.isEmpty(aData.props.PLACEHOLDVM) ? appUtils.getString("common_term_pleaseSelect_listbox") : aData.props.PLACEHOLDVMNAME;

                restService.getPlaceholderVmsInfo({ planId: planId }, function(result) {
                    placeHolderVms = result;
                });

                placeholderScope.validate = [{
                    "validFn": "checkResult"
                }];

                placeholderScope.extendFunction = {
                    "checkResult": function() {
                        var currentValue = $(this).val(),
                            placeHolderVmsText = [];

                        _.each(placeHolderVms, function(val) {
                            var vmsObj = {
                                selectId: val.uuid,
                                label: val.name,
                                checked: true
                            };
                            placeHolderVmsText.push(vmsObj.label);
                        });

                        return !_.isEmpty(_.find(placeHolderVmsText, function(v) {
                            return v == currentValue;
                        }));
                    }
                };
                placeholderScope.keyup = function() {
                    newValue = $("#" + this.id).widget().getValue();
                    isKeyup = true;
                };
                
                placeholderScope.contentChange = function(e, currentValue) {
                    isChanged = true;
                }
                // 下拉选择未引起值变化，则重置isSelected
                placeholderScope.select = function(object) {
                    currentSelectValue = $("#" + object.id).widget().getValue();
                    if (isKeyup) {
                        if (newValue !== currentSelectValue) {
                            isSelected = true;
                        }
                        isKeyup = false;
                    } else {
                        if (lastSelectValue !== currentSelectValue) {
                            isSelected = true;
                        }
                    }
                    lastSelectValue = currentSelectValue;
                    newValue = currentSelectValue;
                }

                // 后台匹配模式下，两种情况触发search：输入框值发生变化/点击下拉按钮
                placeholderScope.search = function(object) {
                    if (_.isEmpty(placeHolderVms)) {
                        return;
                    }

                    var placeHolderVmsValues = [],
                        placeHolderVmsText = [];

                    _.each(placeHolderVms, function(val) {
                        var vmsObj = {
                            selectId: val.uuid,
                            label: val.name,
                            checked: true
                        };
                        placeHolderVmsValues.push(vmsObj);
                        placeHolderVmsText.push(vmsObj.label);
                    });

                    $("#" + object.id).widget().option("values", placeHolderVmsValues);
                    // 输入框值变化触发search
                    if (isChanged) {
                        // 选择下拉项引起的变化
                        if (isSelected) {
                            isSelected = false;
                            isChanged = false;
                            return;
                        }
                        // 输入引起的变化
                        else {
                            $("#" + object.id).widget().setSearch(_.filter(placeHolderVmsText, function(value) {
                                return value.indexOf(newValue) != -1;
                            }));
                            isChanged = false;
                            return;
                        }
                    }
                    // 点击下拉按钮触发search
                    $("#" + object.id).widget().setSearch(placeHolderVmsText);
                };
                var placeHolderVmsNode = placeholderLink(placeholderScope);
                placeholderScope.$evalAsync();
                $("td[tdtitle='" + placeholderVmsColumn + "']", nRow).html(placeHolderVmsNode);
            }
            $scope.startOrderScope = {
                msgTip: appUtils.getString("recovery.term.protected.startSetting.tips"),
                table: {
                    "id": "startOrderTable",
                    "columns": [{
                        "mData": "uuid",
                        "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("recovery.term.protected.colum.name.title"),
                        "mData": "name",
                        "bSortable": false
                    }, {
                        "sTitle": isStartColumn,
                        "mData": "props.isStart",
                        "bSortable": false
                    }, {
                        "sTitle": startOrderColumn,
                        "mData": "props.startOrder",
                        "bSortable": false
                    }],
                    data: [],
                    renderRow: function(nRow, aData, iDataIndex) {
                        if (_.contains([9, 11, 13, 14], poType)) {
                            aData.props.isStart = "--";
                            aData.props.startOrder = "--";
                        } else {
                            if (_.isEmpty($.trim(aData.props.isStart))) {
                                aData.props.isStart = "true";
                            }
                            if (_.isEmpty($.trim(aData.props.startOrder))) {
                                aData.props.startOrder = 10;
                            }
                        }

                        //是否启动
                        var isStartBox = "<tiny-select id='id' default-selectid='defaultId' values='values' width='width' change='change()'></tiny-select>";
                        var isStartBoxLink = $compile(isStartBox);
                        var isStartScope = $scope.$new();
                        isStartScope.id = 'isStart_' + aData['uuid'];
                        isStartScope.width = constsService.W2;
                        isStartScope.defaultId = $.trim(aData.props.isStart) == "true" ? "0" : "1";
                        isStartScope.values = [{
                            "selectId": "0",
                            "label": appUtils.getString("recovery.term.protected.colum.isStart.values.zero")
                        }, {
                            "selectId": "1",
                            "label": appUtils.getString("recovery.term.protected.colum.isStart.values.one")
                        }];
                        isStartScope.change = function() {
                            if (1 == $("#" + isStartScope.id).widget().getSelectedId()) {
                                $("td[tdtitle='" + startOrderColumn + "']", nRow).html("--");
                                return;
                            }
                            _insertSpinner(nRow, aData, iDataIndex, true);
                        };
                        var isStartNode = isStartBoxLink(isStartScope);
                        isStartScope.$evalAsync();
                        $("td[tdtitle='" + isStartColumn + "']", nRow).html(isStartNode);
                        if ($.trim(aData.props.isStart) == "true") {
                            _insertSpinner(nRow, aData, iDataIndex, false);
                        } else {
                            $("td[tdtitle='" + startOrderColumn + "']", nRow).html("--");
                        }


                    }
                },
                addColumn: function() {
                    if (_winData.poType == 12 && _winData.PROVIDER_TYPE == "FusionSphereOpenstack") {
                        $scope.startOrderScope.table.columns = $scope.startOrderScope.table.columns.concat([{
                            "sTitle": placeholderVmsColumn,
                            "mData": "props.PLACEHOLDVM",
                            "bSortable": false
                        }]);
                        _.extend($scope.startOrderScope.table, {
                            renderRow: function(nRow, aData, iDataIndex) {
                                if (_.isEmpty($.trim(aData.props.isStart))) {
                                    aData.props.isStart = "true";
                                }
                                if (_.isEmpty($.trim(aData.props.startOrder))) {
                                    aData.props.startOrder = 10;
                                }
                                //是否启动
                                var isStartBox = "<tiny-select id='id' default-selectid='defaultId' values='values' width='width' change='change()'></tiny-select>";
                                var isStartBoxLink = $compile(isStartBox);
                                var isStartScope = $scope.$new();
                                isStartScope.id = 'isStart_' + aData['uuid'];
                                isStartScope.width = constsService.W2;
                                isStartScope.defaultId = $.trim(aData.props.isStart) == "true" ? "0" : "1";
                                isStartScope.values = [{
                                    "selectId": "0",
                                    "label": appUtils.getString("recovery.term.protected.colum.isStart.values.zero")
                                }, {
                                    "selectId": "1",
                                    "label": appUtils.getString("recovery.term.protected.colum.isStart.values.one")
                                }];
                                isStartScope.change = function() {
                                    if (1 == $("#" + isStartScope.id).widget().getSelectedId()) {
                                        $("td[tdtitle='" + startOrderColumn + "']", nRow).html("--");
                                        return;
                                    }
                                    _insertSpinner(nRow, aData, iDataIndex, true);
                                };
                                var isStartNode = isStartBoxLink(isStartScope);
                                $("td[tdtitle='" + isStartColumn + "']", nRow).html(isStartNode);
                                if ($.trim(aData.props.isStart) == "true") {
                                    _insertSpinner(nRow, aData, iDataIndex, false);
                                } else {
                                    $("td[tdtitle='" + startOrderColumn + "']", nRow).html("--");
                                };
                                //openStack设置占位虚拟机
                                _placeholderVms(nRow, aData, iDataIndex);
                            }
                        })
                    }
                }
            };

            $scope.startOrderScope.addColumn();

            restService.getRecoveryProtectObjectInfo({
                uuid: planId
            }, function(result) {
                //过滤保护组类型为Nas的数据
                excuteResponse = appUtils.encodeForHTML(_.filter(result.records, function(po) {
                    return po['poType'] != 14;
                }));
                $scope.startOrderScope.table.data = excuteResponse.slice(0, defaultIndex);
                $scope.$apply();

            });

            var fun = function() {
                var n1 = this.scrollTop;
                var n2 = this.scrollHeight;
                var n3 = this.offsetHeight;
                if (n1 + n3 >= n2 && n2 > 0 && n3 > 0 && n1 > 0) {

                    var addData = excuteResponse.slice(defaultIndex, defaultIndex + 2);

                    var scrollTop = $(this).scrollTop();

                    defaultIndex += 2;

                    !_.isEmpty(addData) && $("#startOrderTable").widget().addTableRows(addData);

                    $(this).scrollTop(scrollTop);
                }
            };

            setTimeout(function() {
                $("div.viewport")[0].addEventListener("scroll", fun);
            }, 0);


            $("#" + constsService.START_SETTING_WIN.winId).widget().on("close", function() {
                $("div.viewport")[0].removeEventListener("scroll", fun);
            });

        }
    ]

    var startSettingApp = angular.module("recoverydirector.recovery.config");
    startSettingApp.tinyController("app.start.setting.ctrl", startSettingCtrl);
    return startSettingApp;
});
