define(["tiny-widgets/Message"], function(Message) {
    "use strict";
    var ctrl = [
        "$scope",
        "appUtils",
        "constsService",
        "message",
        function($scope, appUtils, constsService, message) {
            var data = $("#" + constsService.FC_IMPORT_NETWORK_SETTING_ERROR_WIN.winId).widget().option("data");
            $scope.errorMsgTitle = appUtils.getStringWithColon("recovery_fc_import_ip_setting_failed_title");
            $scope.errorMsgDes = appUtils.getString("recovery_fc_import_ip_setting_failed_msg");
            $scope.model = {
                errorMessage: {
                    id: "errorMessageTable",
                    enablePagination: false,
                    data: data,
                    columns: [{
                        "sTitle": appUtils.getString("common_term_name_label"),
                        "mData": "protectObjectName",
                        "bSortable": false
                    },{
                        "sTitle": appUtils.getString("recovery.term.protected.colum.owernerGroup.title"),
                        "mData": "protectGroupName",
                        "bSortable": false
                    },{
                        "sTitle": appUtils.getString("protect_object_ip_set_networkCard_label"),
                        "mData": "networkCardName",
                        "bSortable": false
                    },{
                       "sTitle": appUtils.getString("recovery_fc_import_ip_setting_failed_reason"),
                        "mData": "errorCode",
                        "bSortable": false
                    }],
                    renderRow: function(nRow, aData, iDataIndex){
                        $('td:eq(3)', nRow).html(appUtils.getString("lego.err." + aData.errorCode))
                    }
                }
            }
        }
    ]
    var module = angular.module("recoverydirector.recovery.config");
    module.tinyController("fc-import-network-setting-ctrl", ctrl);
    return module;
});
