define(["tiny-widgets/Message"], function(Message) {
    "use strict";
    var ctrl = [
        "$scope",
        "appUtils",
        "constsService",
        "message",
        "utilService",
        "mask",
        "cookieService",
        "exception",
        function($scope, appUtils, constsService, message, utilService, mask, cookieService, exception) {
            var data = $("#" + constsService.FC_IMPORT_NETWORK_SETTING_WIN.winId).widget().option("data");
            $scope.selectMessage = appUtils.getStringWithColon("fc_import_network_setting_win_mesaage");
            $scope.model = {
                id: "fileUpLoad",
                action:utilService.getResouceUrl("/fusionsphere/action/importnetworkadapters?planId=" + data.uuid),
                fileType: ".xlsx",
                maxSize: 10*1024*1024,
                "enableProgress" : false,
                "enableDetail" : false,
                selectError : function(event,file,errorMsg){
                    $("#fileUpLoad").widget().empty();
                    if("INVALID_FILE_TYPE" == errorMsg){
                        message.error(appUtils.getString("recovery_fc_import_ip_setting_failed_error_type"));
                        return;
                    }
                    if("EXCEED_FILE_SIZE" == errorMsg){
                        message.error(appUtils.getString("recovery_fc_import_ip_setting_size_error"));
                    }
                },
                beforeSubmit : function(){
                    mask.show();
                    $("#fileUpLoad").widget().addFormData({"rd_randomStr_HW": cookieService.getToken()});
                },
                complete:function(event,queue){
                    mask.hide();
                    $("#fileUpLoad").widget().empty();
                    var result = $(queue).text();
                    if(_.isString(result)){
                        result = JSON.parse(result)
                    }
                    if(!exception.check(result)){
                        return;
                    }
                    if(result.errorCode == "0"){
                        message.success({
                            content: appUtils.getString("common_term_operation_success_label"),
                            ok: function(){
                                $("#" + constsService.FC_IMPORT_NETWORK_SETTING_WIN.winId).widget().destroy();
                            }
                        })
                        return;
                    }
                    if(Object.prototype.toString.call(result) == "[object Array]"){
                        var win = _.clone(constsService.FC_IMPORT_NETWORK_SETTING_ERROR_WIN);
                        win.title = appUtils.getString(win.title);
                        win.data = result;
                        win.buttons = [{
                            key: "ok",
                            label: appUtils.getString('common_term_confirm_button'),
                            focused: true,
                            handler: function(event){
                                $("#" + win.winId).widget().destroy();
                                !_.isEmpty($("#" + constsService.FC_IMPORT_NETWORK_SETTING_WIN.winId)) && ($("#" + constsService.FC_IMPORT_NETWORK_SETTING_WIN.winId).widget().destroy())
                            }
                        }];
                        appUtils.showWindow(win,function(){})
                        return;
                    }
                    message.error({
                        content: appUtils.getString("lego.err." + result.errorCode),
                        ok: function(){
                            $("#" + constsService.FC_IMPORT_NETWORK_SETTING_WIN.winId).widget().destroy();
                        }
                    })
                }
            }
            $scope.fileUploadBtn = {
                id: "fileUploadBtn",
                text: appUtils.getString("fc_import_network_setting_fileUplod_btn_lable"),
                click:function(){}
            };
            $scope.fileSubmitBtn = {
                id: "fileSubmitBtn",
                text: appUtils.getString("fc_import_network_setting_fileSubmit_btn_lable"),
                click: function(){
                    var fileObject = Object.prototype.toString.call($("#fileUpLoad").widget().file);

                    if (fileObject != "[object Object]" && fileObject != "[object File]")
                    {
                        message.error(appUtils.getString("fc_import_network_setting_win_mesaage"))
                        return;
                    }

                    message.warn({
                        content: appUtils.getString("fc_import_network_setting_warn_confirm_mesaage"),
                        ok: function(){
                            $("#fileUpLoad").widget().submit();
                        }
                    })
                }
            }
        }
    ]
    var module = angular.module("recoverydirector.recovery.config");
    module.tinyController("fc-import-network-setting-win-ctrl", ctrl);
    return module;
});
