define([], function() {
    "use strict";
    var fcIpSetCtrl = [
        "$scope",
        "appUtils",
        "message",
        "constsService",
        "restService",
        function($scope, appUtils, message, constsService, restService) {
            var params = null;
            // 当前页面是否有修改
            var isChangeFlag = false;
            // 用户切换前的网卡ID
            var beforeChangeSelectID = "";
            // 用户想要切换的网卡ID
            var userSelectID = "";
            //下发设置网卡信息
            var saveNetworkInfo = function(btnTrigger, userSelectID){
                var jsonObj = {},
                    validateResult = [],
                    ipAddress6 = [],
                    ipv4Start = $("#startipv4").widget().option("checked"),
                    ipv6Start = $("#startipv6").widget().option("checked"),
                    mac = $("#networkCard").widget().getSelectedId();

                if(_.isEmpty(mac) || "default" === mac) {
                    message.error(appUtils.getString("protect_object_select_netcard_label"));
                    return;
                }

                if (ipv4Start) {
                    $.each($scope.fusionComputeScope.ipv4, function(index, obj) {
                        if(!_.isEmpty(obj) && _.isFunction(obj.validate)){
                            if(!obj.validate()){
                                validateResult.push(false)
                                return false;
                            }
                            _.isFunction(obj.getValue) && (jsonObj[obj.id] = $.trim(obj.getValue()));
                        }
                    })
                }

                if(!_.isEmpty(validateResult) && _.contains(validateResult, false)) {
                    return;
                }

                if (ipv6Start) {
                    $.each($scope.fusionComputeScope.ipv6.configureInfos, function(index, obj){
                        if(!_.isEmpty(obj) && _.isFunction(obj.validate)){
                            if(!obj.validate(obj)){
                                validateResult.push(false)
                                return false;
                            }
                        }
                        ipAddress6.push({
                            "ipv6Prefix" : obj.getValue(obj).ipv6Prefix,
                            "ipv6Addr" : obj.getValue(obj).ipv6Addr
                        });
                        jsonObj["ipAddress6"] = ipAddress6;
                    })

                    $.each($scope.fusionComputeScope.ipv6, function(key, obj){
                        if(_.contains(["gateway", "preferredDNS", "alternateDNS"], key)) {
                            if (!_.isEmpty(obj) && _.isFunction(obj.validate)) {
                                if(!obj.validate()){
                                    validateResult.push(false)
                                    return false;
                                }
                                _.isFunction(obj.getValue) && (jsonObj[obj.id] = $.trim(obj.getValue()));
                            }
                        }
                    })
                }

                if(!_.isEmpty(validateResult) && _.contains(validateResult, false)) {
                    return;
                }

                restService.modifyFusionComputeNetwork({mac: mac, poId: params.uuid, planId: params.planId}, {
                    data : jsonObj,
                    success: function() {
                        message.success({content: appUtils.getString("common_term_operation_success_label"), ok: function () {
                            btnTrigger && $("#" + constsService.HUAWEI_VM_IP_WIN.winId).widget().destroy();
                            if (!_.isEmpty(userSelectID)) {
                                $("#networkCard").widget().opChecked(userSelectID);
                                beforeChangeSelectID = $("#networkCard").widget().getSelectedId();
                                _queryNetworkSettingInfo();
                                isChangeFlag = false;
                            }
                        }});
                    }
                })
            };

            $("#" + constsService.HUAWEI_VM_IP_WIN.winId).widget().option("buttons", [
                    {
                        key: "ok",
                        label: appUtils.getString('common_term_confirm_button'),
                        focused: true,
                        handler: function(event) {
                            saveNetworkInfo(true);
                        }
                    },
                    {
                        key: "cancel",
                        label: appUtils.getString('common_term_cancel_button'),
                        focused: false,
                        handler: function(event) {
                            $("#" + constsService.HUAWEI_VM_IP_WIN.winId).widget().destroy();
                        }
                    }]
            );

            /**
             * 查询网络的配置信息
             * @private
             */
            function _queryNetworkSettingInfo() {
                var mac = $("#networkCard").widget().getSelectedId();
                if(mac == "default" || _.isEmpty(mac)) {
                    return
                }
                var startipv4Widget = $("#startipv4").widget(),
                    startipv6Widget = $("#startipv6").widget(),
                    ipWidget = $("#ip").widget(),
                    netmaskWidget = $("#netmask").widget(),
                    gatewayWidget = $("#gateway").widget(),
                    adddnsWidget = $("#adddns").widget(),
                    setDnsWidget = $("#setdns").widget(),
                    gatewayIpAddr6Widget = $("#gatewayIpAddr6").widget(),
                    setdns6Widget = $("#setdns6").widget(),
                    adddns6Widget = $("#adddns6").widget();
                restService.getNetworkSettingInfo({mac: mac, poId: params.uuid, planId: params.planId}, {
                    success: function(result) {
                        startipv4Widget.option("disable", false);
                        startipv6Widget.option("disable", false);
                        gatewayWidget.option("disable", false);
                        gatewayWidget.option("value", _.isEmpty(result.gateway) ? "" : result.gateway);
                        gatewayIpAddr6Widget.option("disable", false);
                        gatewayIpAddr6Widget.option("value", _.isEmpty(result.gatewayIpAddr6) ? "" : result.gatewayIpAddr6);

                        if(!_.isEmpty(result.ip) && !_.isEmpty(result.netmask))
                        {
                            startipv4Widget.option("checked", true);
                            ipWidget.option("value", result.ip);
                            netmaskWidget.option("value", _.isEmpty(result.netmask) ? "" : result.netmask);
                            adddnsWidget.option("value", _.isEmpty(result.adddns) ? "" : result.adddns);
                            setDnsWidget.option("value", _.isEmpty(result.setdns) ? "" : result.setdns);
                            ipWidget.option("disable", false);
                            netmaskWidget.option("disable", false);
                            adddnsWidget.option("disable", false);
                            setDnsWidget.option("disable", false);
                        }else {
                            startipv4Widget.option("checked", false);
                            ipWidget.option("value", "");
                            netmaskWidget.option("value", "");
                            adddnsWidget.option("value", "");
                            setDnsWidget.option("value", "");
                            ipWidget.option("disable", true);
                            netmaskWidget.option("disable", true);
                            adddnsWidget.option("disable", true);
                            setDnsWidget.option("disable", true);
                        }

                        if(_.isEmpty(result.ipAddress6)||_.isEmpty(result.ipAddress6[0].ipv6Addr)) {
                            $scope.fusionComputeScope.ipv6.configureInfos = [angular.copy($scope.fusionComputeScope.ipv6.tempConfigureInfos)];
                            $scope.fusionComputeScope.ipv6.configureInfos[0].ip.disable = true;
                            $scope.fusionComputeScope.ipv6.configureInfos[0].prefixLength.disable = true;
                            $scope.$apply();
                            startipv6Widget.option("checked", false);
                            setdns6Widget.option("disable", true);
                            adddns6Widget.option("disable", true);
                            setdns6Widget.option("value", "");
                            adddns6Widget.option("value", "");
                            $("#addIpv6Btn").removeClass("addBar btn-link").addClass("addBar btn-link-disable");
                            $("#addIpv6IconBtn").removeClass("iconbutton-add").addClass("iconbutton-add-disabled");
                            return;
                        }
                        startipv6Widget.option("checked", true);
                        $("#ipv6Addr").widget().option("disable", false);
                        $("#ipv6Prefix").widget().option("disable", false);
                        $scope.fusionComputeScope.ipv6.configureInfos = [angular.copy($scope.fusionComputeScope.ipv6.tempConfigureInfos)];
                        _.each(result.ipAddress6, function(ipAddress6, index) {
                            $scope.fusionComputeScope.ipv6.addRow(ipAddress6, index);
                        })
                        setdns6Widget.option("disable", false);
                        adddns6Widget.option("disable", false);
                        setdns6Widget.option("value", _.isEmpty(result.setdns6) ? "" : result.setdns6);
                        adddns6Widget.option("value", _.isEmpty(result.adddns6) ? "" : result.adddns6);
                        $("#addIpv6Btn").removeClass("addBar btn-link-disable").addClass("addBar btn-link");
                        $("#addIpv6IconBtn").removeClass("iconbutton-add-disabled").addClass("iconbutton-add");
                    }
                })
            }

            /**
             * 校验ipv4页面的ip地址，子网掩码，默认网关，首选DNS服务器，备用DNS服务器是否合法
             * @param ip ip地址(传入除子网掩码地址)
             * @param errorMsg 错误信息
             * @param id 对象id
             * @returns {boolean} true合法，false非法
             * @private
             */
            function _validateIpv4ValIllegal(ip, errorMsg, _id) {
                var regExp = /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/;
                var ipArray = ip.split(".");
                if(ipArray.length  == 4 )
                {
                    if(ipArray[0] == "0" || ipArray[0] == "127" || ipArray[3]== "0"){
                        message.error({
                            content: errorMsg,
                            ok: function() {
                                $("#" + _id).find("input:eq(1)").focus();
                            }
                        });
                        return false;
                    }
                }
                if(!regExp.test(ip))
                {
                    message.error({content: errorMsg, ok: function () {
                        $("#" + _id).find("input:eq(1)").focus();
                    }});
                    return false;
                }
                return true;
            }

            $scope.fusionComputeScope = {
                isDisabled:true,
                constant: {
                    IPV6_ADDR: appUtils.getString("protect_object_ip_ipv6_label"),
                    NETWORKLEN: appUtils.getString("protect_object_network_length_label"),
                    DELETE: appUtils.getString("common_term_delete_button"),
                    ADDRECORD: appUtils.getString("common_term_addline_button"),
                    IPV4TITLE: appUtils.getString("protect_object_ip_set_ipv4_label"),
                    IPV6TITLE: appUtils.getString("protect_object_ip_set_ipv6_label"),
                    IPV4_GATEWAY_TITLE: appUtils.getString("protect_object_gateway_set_ipv4_label"),
                    IPV6_GATEWAY_TITLE: appUtils.getString("protect_object_gateway_set_ipv6_label"),
                    NEW_NETWORK_TIP_ONE: appUtils.getString("recovery_network_newnetworkone_label"),
                    NEW_NETWORK_TIP_TWO: appUtils.getString("recovery_network_newnetworktwo_label"),
                    DEFAULT_GATEWAY: appUtils.getStringWithColon("protect_object_dns_gateway_label"),
                    GATEWAY_SET_TIP: appUtils.getString("recovery_network_setgateway_label")
                },
                networkCard: {
                    "id": "networkCard",
                    "width": constsService.W4,
                    "autoOpen": false,
                    "require" : true,
                    "defaultSelectId": "default",
                    "values": [{"selectId": "default", "label": appUtils.getString("common_term_pleaseSelect_listbox")}],
                    "label" : appUtils.getStringWithColon("protect_object_ip_set_networkCard_label"),
                    "closeFn": function (object, evt) {
                        // 每次关闭前保存当前选择的网卡ID
                        beforeChangeSelectID = $("#networkCard").widget().getSelectedId();
                        // 若当前没有修改，才执行重置当前网卡信息操作
                        if(!isChangeFlag){
                            _queryNetworkSettingInfo();
                        };
                    },
                    "change": function () {
                    },
                    "select" : function(selectId, label) {
                        // 保存用户想要去点击的网卡
                        userSelectID = selectId;
                        // 在选择框点击时触发校验，若值有变化，提示是否需要保存当前页面
                        if(isChangeFlag == true && userSelectID != beforeChangeSelectID){
                            // 停留在用户当前选择的网卡
                            $("#networkCard").widget().opChecked(beforeChangeSelectID);
                            // 弹出提示框
                            message.confirm({
                                content: appUtils.getString("recovery_network_switchnetworkcard_label"),
                                ok: function(){
                                    // 若点了确定，则模拟点击一次确定保存按钮
                                    saveNetworkInfo(false, userSelectID);
                                },
                                cancel: function(){
                                    // 若点了取消，则继续前往用户想要去的网卡，并重置flag
                                    $("#networkCard").widget().opChecked(userSelectID);
                                    beforeChangeSelectID = $("#networkCard").widget().getSelectedId();
                                    _queryNetworkSettingInfo();
                                    isChangeFlag = false;
                                }
                            });
                        };
                    },
                    "openFn": function (object) {
                        params = $("#" + constsService.HUAWEI_VM_IP_WIN.winId).widget().option("data");
                        var selectId = $("#networkCard").widget().getSelectedId();
                        !_.isEmpty(params) && restService.getNetworkadapters({planId: params.planId, poId: params.uuid}, function(result){
                            if (!_.isEmpty(result)) {
                                var array = [];
                                _.each(result, function( network, index){
                                    var opt = {
                                        "selectId": network.id,
                                        "checked": selectId == network.id,
                                        "label": appUtils.encodeForHTML(network.name)
                                    };
                                    array.push(opt);
                                })
                                $("#networkCard").widget().option("values", array);
                            } else {
                                $("#networkCard").widget().option("values",
                                    [{"selectId": "default", "checked": true, "label": appUtils.getString("common_term_pleaseSelect_listbox")}]
                                );
                            }
                            object.open();
                        });
                    }
                },
                ipv4: {
                    start: {
                        id: "startipv4",
                        disable: true,
                        checked: false,
                        require : false,
                        text: appUtils.getString("protect_object_enableIPv4_label"),
                        change: function(event) {
                            isChangeFlag = true;
                            var ipWidget = $("#ip").widget(),
                                netmaskWidget = $("#netmask").widget(),
                                setdnsWidget = $("#setdns").widget(),
                                adddnsWidget = $("#adddns").widget(),
                                isStart = $("#startipv4").widget().option("checked");

                            if (isStart)
                            {
                                ipWidget.option("disable", false);
                                netmaskWidget.option("disable", false);
                                setdnsWidget.option("disable", false);
                                adddnsWidget.option("disable", false);
                                return;
                            }
                            ipWidget.option("disable", true);
                            netmaskWidget.option("disable", true);
                            setdnsWidget.option("disable", true);
                            adddnsWidget.option("disable", true);
                        }
                    },
                    ip: {
                        id: "ip",
                        type: "ipv4",
                        disable: true,
                        require : true,
                        value: "",
                        focused: true,
                        width: constsService.W3,
                        label: appUtils.getStringWithColon("protect_object_ip_label"),
                        validate: function(){
                            var ip = $("#ip").widget().getValue();
                            if (_.isEmpty(ip)) {
                                message.error({content: appUtils.getString("validate_term_ipv4_ip_required"), ok: function() {
                                        $("#ip").find("input:eq(1)").focus();
                                    }
                                })
                                return false;
                            }
                            if(!_validateIpv4ValIllegal(ip, appUtils.getString("validate_term_ipv4_ip_invalid"), "ip")){
                                return false;
                            }
                            return true;
                        },
                        change: function() {
                            isChangeFlag = true;
                        },
                        getValue: function() {
                            return $("#ip").widget().getValue();
                        }
                    },
                    subnet: {
                        id: "netmask",
                        type: "ipv4",
                        disable: true,
                        value: "",
                        require : true,
                        width: constsService.W3,
                        label: appUtils.getStringWithColon("protect_object_dns_netmask_label"),
                        validate: function(){
                            var subnet = $("#netmask").widget().getValue();
                            if (_.isEmpty(subnet)) {
                                message.error({
                                    content: appUtils.getString("validate_term_ipv4_netmask_required"), ok: function() {
                                        $("#netmask").find("input:eq(1)").focus();
                                    }
                                })
                                return false;
                            }
                            var reg = new RegExp(constsService.Regex.mask);
                            if (!reg.test(subnet)) {
                                message.error({content: appUtils.getString("validate_term_ipv4_netmask_invalid"), ok: function () {
                                    $("#netmask").find("input:eq(1)").focus();
                                }});
                                return false;
                            }
                            return true;
                        },
                        change: function() {
                            isChangeFlag = true;
                        },
                        getValue: function() {
                            return $("#netmask").widget().getValue();
                        }
                    },
                    gateway: {
                        id: "gateway",
                        type: "ipv4",
                        disable: true,
                        value: "",
                        require : false,
                        width: constsService.W3,
                        label: appUtils.getStringWithColon("protect_object_dns_ipv4gateway_label"),
                        validate: function(){
                            var gateway = $("#gateway").widget().getValue();
                            if(!_.isEmpty(gateway) && !_validateIpv4ValIllegal(gateway, appUtils.getString("validate_term_ipv4_gateway_invalid"), "gateway")){
                                return false;
                            }
                            return true;
                        },
                        change: function() {
                            isChangeFlag = true;
                        },
                        getValue: function() {
                            return $("#gateway").widget().getValue();
                        }
                    },
                    preferredDNS: {
                        id: "setdns",
                        type: "ipv4",
                        disable: true,
                        value: "",
                        require : false,
                        width: constsService.W3,
                        label: appUtils.getStringWithColon("protect_object_dns_first_choose_label"),
                        validate: function(){
                            var preferredDNS = $("#setdns").widget().getValue();
                            if(!_.isEmpty(preferredDNS) && !_validateIpv4ValIllegal(preferredDNS, appUtils.getString("validate_term_ipv4_add_dns_invalid"), "setdns")){
                                return false;
                            }
                            return true;
                        },
                        change: function() {
                            isChangeFlag = true;
                        },
                        getValue: function() {
                            return $("#setdns").widget().getValue();
                        }
                    },
                    alternateDNS: {
                        id: "adddns",
                        type: "ipv4",
                        disable: true,
                        require : false,
                        value: "",
                        width: constsService.W3,
                        label: appUtils.getStringWithColon("protect_object_dns_reserve_label"),
                        validate: function(){
                            var alternateDNS = $("#adddns").widget().getValue();
                            if(!_.isEmpty(alternateDNS) && !_validateIpv4ValIllegal(alternateDNS, appUtils.getString("validate_term_ipv4_set_dns_invalid"), "adddns")) {
                                return false;
                            }
                            return true;
                        },
                        change: function() {
                            isChangeFlag = true;
                        },
                        getValue: function() {
                            return $("#adddns").widget().getValue();
                        }
                    }
                },
                ipv6: {
                    start: {
                        "id": "startipv6",
                        "text": appUtils.getString("protect_object_enableIPv6_label"),
                        "checked": false,
                        "disable": true,
                        "change": function (event) {
                            isChangeFlag = true;
                            var isStart = $("#startipv6").widget().option("checked"),
                                setdns6Widget = $("#setdns6").widget(),
                                adddns6Widget = $("#adddns6").widget();
                            if(isStart) {
                                _.each($scope.fusionComputeScope.ipv6.configureInfos, function(config, key){
                                    $("#" + config.ip.id).widget().option("disable", false);
                                    $("#" + config.prefixLength.id).widget().option("disable", false);
                                })
                                setdns6Widget.option("disable", false);
                                adddns6Widget.option("disable", false);
                                $("#addIpv6Btn").removeClass("addBar btn-link-disable").addClass("addBar btn-link");
                                $("#addIpv6IconBtn").removeClass("iconbutton-add-disabled").addClass("iconbutton-add");
                                return;
                            }

                            _.each($scope.fusionComputeScope.ipv6.configureInfos, function(config, key){
                                $("#" + config.ip.id).widget().option("disable", true);
                                $("#" + config.prefixLength.id).widget().option("disable", true);
                            })
                            setdns6Widget.option("disable", true);
                            adddns6Widget.option("disable", true);
                            $("#addIpv6Btn").removeClass("addBar btn-link").addClass("addBar btn-link-disable");
                            $("#addIpv6IconBtn").removeClass("iconbutton-add").addClass("iconbutton-add-disabled");
                        }
                    },
                    configureInfos: [{
                        ip: {
                            id: "ipv6Addr",
                            disable: true,
                            value: "",
                            width: constsService.W4,
                            change: function() {
                                isChangeFlag = true;
                            }
                        },
                        prefixLength: {
                            id: "ipv6Prefix",
                            width: 85,
                            value: "",
                            disable: true,
                            change: function() {
                                isChangeFlag = true;
                            }
                        },
                        validate: function(param){
                            var ipv6 = $("#" + param.ip.id).widget().getValue(),
                                prefixLength = $("#" + param.prefixLength.id).widget().getValue(),
                                subnetLenReg = /^([1-9]?\d|1[01]\d|12[0-8])$/;
                            if (!appUtils.validIPv6Address(ipv6))
                            {
                                message.error({content: appUtils.getString("validate_term_ipv6_ip_invalid"), ok: function(){
                                    $("#" + param.ip.id).find("input:eq(0)").focus();
                                }})
                                return false;
                            }
                            if(!subnetLenReg.test(prefixLength)) {
                                message.error({content: appUtils.getString("validate_term_ipv6_sublength_invalid"), ok: function(){
                                    $("#" + param.prefixLength.id).find("input:eq(0)").focus();
                                }})
                                return false;
                            }
                            return true;
                        },
                        getValue: function(param) {
                            return {
                                "ipv6Addr" : $("#" + param.ip.id).widget().getValue(),
                                "ipv6Prefix": $("#" + param.prefixLength.id).widget().getValue()
                            };
                        },
                        setValue: function(model) {
                            if(_.isUndefined(model))
                            {
                                return;
                            }
                            this.prefixLength.value = model.ipv6Prefix;
                            this.ip.value = model.ipv6Addr;
                        },
                        delCls: "iconbutton-fork-disabled",
                        removeRow: function() {
                            isChangeFlag = true;
                            return;
                        }
                    }],
                    tempConfigureInfos: {
                        ip: {
                            id: "ipv6Addr",
                            disable: false,
                            value: "",
                            width: constsService.W4,
                            change: function() {
                                isChangeFlag = true;
                            }
                        },
                        prefixLength: {
                            id: "ipv6Prefix",
                            width: 85,
                            value: "",
                            disable: false,
                            change: function() {
                                isChangeFlag = true;
                            }
                        },
                        validate: function(param){
                            var ipv6 = $("#" + param.ip.id).widget().getValue(),
                                prefixLength = $("#" + param.prefixLength.id).widget().getValue(),
                                subnetLenReg = /^([1-9]?\d|1[01]\d|12[0-8])$/;
                            if (!appUtils.validIPv6Address(ipv6))
                            {
                                message.error({content: appUtils.getString("validate_term_ipv6_ip_invalid"), ok: function(){
                                    $("#" + param.ip.id).find("input:eq(0)").focus();
                                }})
                                return false;
                            }
                            if(!subnetLenReg.test(prefixLength)) {
                                message.error({content: appUtils.getString("validate_term_ipv6_sublength_invalid"), ok: function(){
                                    $("#" + param.prefixLength.id).find("input:eq(0)").focus();
                                }})
                                return false;
                            }
                            return true;
                        },
                        getValue: function(param) {
                            return {
                                "ipv6Addr" : $("#" + param.ip.id).widget().getValue(),
                                "ipv6Prefix": $("#" + param.prefixLength.id).widget().getValue()
                            };
                        },
                        setValue: function(model) {
                            if(_.isUndefined(model))
                            {
                                return;
                            }
                            this.prefixLength.value = model.ipv6Prefix;
                            this.ip.value = model.ipv6Addr;
                        },
                        delCls: "iconbutton-fork",
                        removeRow: function(_this) {
                            isChangeFlag = true;
                            var vals = $scope.fusionComputeScope.ipv6.configureInfos;
                            var index = vals.indexOf(_this);
                            if(vals.length == 1){
                                return;
                            };
                            if (-1 != index) {
                                $scope.fusionComputeScope.ipv6.configureInfos.splice(index, 1);
                                $scope.$apply();
                            }
                        }
                    },
                    addRow: function(configure, index) {
                        if(!$("#startipv6").widget().option("checked")) {
                            return;
                        }

                        var configureInfos = $scope.fusionComputeScope.ipv6.configureInfos;
                        if (configureInfos.length > 4) {
                            message.error(appUtils.getString("protect_object_most_addIp_label"));
                            return;
                        }

                        if(index == 0) {
                            var configModel = _.first($scope.fusionComputeScope.ipv6.configureInfos);
                            configModel.setValue(configure);
                            $scope.$apply();
                            return;
                        }

                        var tempConfig = angular.copy($scope.fusionComputeScope.ipv6.tempConfigureInfos);
                        var configureInfo = $scope.fusionComputeScope.ipv6.configureInfos;
                        tempConfig.ip.id += configureInfo.length;
                        tempConfig.prefixLength.id += configureInfo.length;

                        var configs = $scope.fusionComputeScope.ipv6.configureInfos;
                        configs.push(tempConfig);

                        if(angular.isUndefined(configure))
                        {
                            return;
                        }
                        tempConfig.setValue(configure);
                        $scope.$apply();
                    },
                    gateway: {
                        id: "gatewayIpAddr6",
                        disable: true,
                        require : false,
                        width: constsService.W3,
                        value: "",
                        label: appUtils.getStringWithColon("protect_object_dns_ipv6gateway_label"),
                        validate: function(){
                            var gateway = $("#gatewayIpAddr6").widget().getValue();
                            if(!_.isEmpty(gateway) && !appUtils.validIPv6Address(gateway)) {
                                message.error({content: appUtils.getString("validate_term_ipv6_gateway_invalid"), ok: function () {
                                    $("#gatewayIpAddr6").find("input:eq(0)").focus();
                                }});
                                return false;
                            }
                            return true;
                        },
                        change: function() {
                            isChangeFlag = true;
                        },
                        getValue: function() {
                            return $("#gatewayIpAddr6").widget().getValue();
                        }
                    },
                    preferredDNS: {
                        id: "setdns6",
                        disable: true,
                        require : false,
                        width: constsService.W4,
                        value: "",
                        label: appUtils.getStringWithColon("protect_object_dns_first_choose_label"),
                        validate: function(){
                            var preferredDNS = $("#setdns6").widget().getValue();
                            if(!_.isEmpty(preferredDNS) && !appUtils.validIPv6Address(preferredDNS)) {
                                message.error({content: appUtils.getString("validate_term_ipv6_add_dns_invalid"), ok: function () {
                                    $("#setdns6").find("input:eq(0)").focus();
                                }});
                                return false;
                            }
                            return true;
                        },
                        change: function() {
                            isChangeFlag = true;
                        },
                        getValue: function() {
                            return $("#setdns6").widget().getValue();
                        }
                    },
                    alternateDNS: {
                        id: "adddns6",
                        disable: true,
                        require : false,
                        width: constsService.W4,
                        value: "",
                        label: appUtils.getStringWithColon("protect_object_dns_reserve_label"),
                        validate: function(){
                            var alternateDNS = $("#adddns6").widget().getValue();
                            if (!_.isEmpty(alternateDNS) && !appUtils.validIPv6Address(alternateDNS)) {
                                message.error({content: appUtils.getString("validate_term_ipv6_set_dns_invalid"), ok: function() {
                                    $("#adddns6").find("input:eq(0)").focus();
                                }});
                                return false;
                            }
                            return true;
                        },
                        change: function() {
                            isChangeFlag = true;
                        },
                        getValue: function() {
                            return $("#adddns6").widget().getValue();
                        }
                    }

                }
            }
        }]
    var huaweiVMApp = angular.module("recoverydirector.recovery.config");
    huaweiVMApp.tinyController("app.fusionsphere.fc.ctrl", fcIpSetCtrl);
    return huaweiVMApp;
});
