define([], function () {
        "use strict";
        var huaweiVMAppCtrl = [
            "$scope",
            "$state",
            "$compile",
            "$stateParams",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "appUtils",
            "constsService",
            "cookieService",
            "restService",
            function ($scope, $state, $compile, $stateParams, exception, message, communicationService, utilService, mask, appUtils, constsService, cookieService, restService) {
                var params = null;

                $("#" + constsService.FM_VM_IP_WIN.winId).widget().option("buttons", [
                    {
                        key: "ok",
                        label: appUtils.getString('common_term_confirm_button'),
                        focused: true,
                        handler: function(event) {
                            var jsonObj = {},
                                ipv4 = $("#ipv4").widget().getValue(),
                                publicPort = $("#publicPort").widget().getValue(),
                                privatePort = $("#privatePort").widget().getValue(),
                                protocalId = $("#protocal").widget().getSelectedId(),
                                nicSeqNum = $("#networkCard").widget().getSelectedId(),
                                enableDNATChecked = $("#enableDNAT").widget().option("checked"),
                                enableIPv4Checked = $("#enableIPv4").widget().option("checked"),
                                enableElasticIpChecked = $("#enableElasticIP").widget().option("checked");

                            if ("default" == nicSeqNum || _.isEmpty(nicSeqNum)) {
                                message.error(appUtils.getString("protect_object_select_netcard_label"));
                                return;
                            }

                            if (enableIPv4Checked) {
                                if (!_validateIpv4ValIllegal(ipv4, appUtils.getString("validate_term_ipv4_ip_invalid"), "ipv4"))
                                {
                                    return false;
                                }
                                jsonObj.ip = ipv4;
                            }

                            if (enableElasticIpChecked) {
                                var flexIpObj = {}, validateFlag = false, errorId = "";
                                for(var i = 0;i < $scope.flexIpArray.length;i++){
                                    var ipValue = $scope.flexIpArray[i].elasticIP.getVal();
                                    var inputId = $scope.flexIpArray[i].elasticIP.id;
                                    if (_validateIpv4ValIllegal(ipValue, "", inputId))
                                    {
                                        validateFlag = true;
                                        flexIpObj[inputId] = ipValue
                                    }else{
                                        _.isEmpty(errorId) && (errorId = inputId)
                                    }
                                }
                                if(!validateFlag){
                                    message.error({
                                        content: appUtils.getString("validate_term_ipv4_ip_invalid"),
                                        ok: function () {
                                        $("#" + errorId).find("input:eq(1)").focus();
                                    }})
                                    return false;
                                }
                                jsonObj.flexIpMap = flexIpObj;
                            }

                            if (enableDNATChecked) {
                                if (!_validatePort(privatePort, "privatePort", "private"))
                                {
                                    return false;
                                }

                                if (!_validatePort(publicPort, "publicPort", "public"))
                                {
                                    return false;
                                }
                                jsonObj.privatePort = privatePort;
                                jsonObj.publicPort = publicPort;
                                jsonObj.protocal = protocalId;
                            }
                            jsonObj.autoConfEnabled6 = false;
                            jsonObj.dhcpEnabled6 = false;
                            var url = utilService.getResouceUrl("/fusionsphere/networkadapters/" + nicSeqNum + "?poId=" + params.uuid + "&planId=" + params.planId);
                            mask.show();
                            communicationService.put(url, jsonObj).promise().always(function(response) {
                                mask.hide();
                                if (exception.check(response))
                                {
                                    message.success({content: appUtils.getString("common_term_operation_success_label"), ok: function() {
                                            $("#" + constsService.FM_VM_IP_WIN.winId).widget().destroy();
                                        }
                                    });
                                }
                            });
                        }
                    },
                    {
                        key: "cancel",
                        label: appUtils.getString('common_term_cancel_button'),
                        focused: false,
                        handler: function(event) {
                            $("#" + constsService.FM_VM_IP_WIN.winId).widget().destroy();
                        }
                    }
                ]);

                var _validatePort = function (port, id, portType) {
                    var nullMsg, errorMsg;
                    if ("public" == portType) {
                        nullMsg = appUtils.getString("validate_term_dnat_public_port_required");
                        errorMsg = appUtils.getString("validate_term_dnat_public_port_invalid");
                    } else if ("private" == portType) {
                        nullMsg = appUtils.getString("validate_term_dnat_private_port_required");
                        errorMsg = appUtils.getString("validate_term_dnat_private_port_invalid");
                    }
                    if (!port) {
                        message.error({content: nullMsg, ok: function () {$("#" + id).find("input:eq(0)").focus();}});
                        return false;
                    }

                    var portReg = /^([1-9]|[1-9][0-9]{1,3}|[1-5][0-9]{0,4}|6[0-4][0-9]{0,3}|65[0-4][0-9]{0,2}|655[0-2][0-9]|6553[0-5])$/;
                    if(!portReg.test(port)){
                        message.error({content: errorMsg, ok: function () {
                            $("#" + id).find("input:eq(0)").focus();
                        }})
                        return false;
                    }
                    return true;
                }

                /**
                 * 校验ipv4页面的ip地址，子网掩码，默认网关，首选DNS服务器，备用DNS服务器是否合法
                 * @param ip ip地址(传入除子网掩码地址)
                 * @param errorMsg 错误信息
                 * @param id 对象id
                 * @returns {boolean} true合法，false非法
                 * @private
                 */
                function _validateIpv4ValIllegal(ip, errorMsg, _id) {
                    var regExp = /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/;
                    var ipArray = ip.split(".");
                    if(ipArray.length  == 4 )
                    {
                        if(ipArray[0] == "0" || ipArray[0] == "127" || ipArray[3]== "0"){
                            !_.isEmpty(errorMsg) && message.error({
                                content: errorMsg,
                                ok: function() {
                                    $("#" + _id).find("input:eq(1)").focus();
                                }
                            });
                            return false;
                        }
                    }
                    if(!regExp.test(ip))
                    {
                        !_.isEmpty(errorMsg) && message.error({content: errorMsg, ok: function () {
                            $("#" + _id).find("input:eq(1)").focus();
                        }});
                        return false;
                    }
                    return true;
                }

                var _queryFromServer = function () {
                    var mac = $("#networkCard").widget().getSelectedId();
                    if(mac == "default" || _.isEmpty(mac)) {
                        return
                    }
                    var url = utilService.getResouceUrl("/fusionsphere/networkadapters/" + mac + "?planId=" + params.planId + "&poId=" + params.uuid);
                    communicationService.get(url).promise().always(function(result) {
                        if (exception.check(result)) {
                            _initIpv4TabForm(result);
                            _initDNATTabForm(result);
                            $scope.$apply();
                        }
                    });
                };

                var _initIpv4TabForm = function (result) {
                    var enableIpv4Widget = $("#enableIPv4").widget(),
                        ipv4Widget = $("#ipv4").widget();
                        enableIpv4Widget.option("disable", false);
                	if ( _.isEmpty(result.ip) )
                	{
                		$scope.model.require.ipv4 = false;
                        enableIpv4Widget.option("checked", false);
                        ipv4Widget.option("value", "");
                        ipv4Widget.option("disable", true);
                	}
                	else
            		{
                		$scope.model.require.ipv4 = true;
                        enableIpv4Widget.option("checked", true);
                        ipv4Widget.option("value", result.ip);
                        ipv4Widget.option("disable", false);
            		}
                    $scope.$apply()
                };

                var _initDNATTabForm = function (result) {
                    //set flex ip address
                    var enableFlexIpWidget = $("#enableElasticIP").widget();
                        enableFlexIpWidget.option("disable", false);
                    if ( _.isEmpty(result.flexIpMap) )
                    {
                        enableFlexIpWidget.option("checked", false);
                        _.each($scope.flexIpArray,function(val){
                            val.elasticIP.require = false;
                            val.elasticIP.disable = true;
                            val.elasticIP.value = "";
                            $("#" + val.elasticIP.vertifyId).removeClass("enable").addClass("disable")
                        })
                    }
                    else
                    {
                        enableFlexIpWidget.option("checked", true);
                        _.each($scope.flexIpArray,function(val){
                            val.elasticIP.disable = false;
                            val.elasticIP.value = result.flexIpMap[val.elasticIP.id];
                            $("#" + val.elasticIP.vertifyId).removeClass("disable").addClass("enable")
                        })
                    }

                    // set dnat port message info
                    var enablednatWidget = $("#enableDNAT").widget(),
                        privatePortWidget = $("#privatePort").widget(),
                        publicPortWidget = $("#publicPort").widget(),
                        protocalWidget = $("#protocal").widget();
                        enablednatWidget.option("disable", false);
                    if ( !_.isEmpty(result.privatePort) && !_.isEmpty(result.publicPort) && !_.isEmpty(result.protocal) )
                    {
                        $scope.model.require.publicPort = true;
                        $scope.model.require.privatePort = true;
                        enablednatWidget.option("checked", true);
                        privatePortWidget.option("disable", false);
                        privatePortWidget.option("value", result.privatePort);
                        publicPortWidget.option("disable", false);
                        publicPortWidget.option("value", result.publicPort);
                        protocalWidget.option("default-selectid", result.protocal);
                        protocalWidget.option("disable", false);
                    }
                    else
                    {
                        $scope.model.require.publicPort = false;
                        $scope.model.require.privatePort = false;
                        enablednatWidget.option("checked", false);
                        privatePortWidget.option("disable", true);
                        privatePortWidget.option("value", "");
                        publicPortWidget.option("disable", true);
                        publicPortWidget.option("value", "");
                        protocalWidget.option("default-selectid", "TCP");
                        protocalWidget.option("disable", true);
                    }
                    $scope.$apply()
                }

                var veriftyIP = function ()
                {
                    var that = this;
                    var flexIpChecked = $("#enableElasticIP").widget().option("checked");
                    if (!flexIpChecked)
                    {
                        return false;
                    }

                    var ip = that.getVal();
                    if ( _.isEmpty(ip) )
                    {
                        message.error({
                            content: appUtils.getString("validate_term_ipv4_ip_required"),
                            ok: function ()
                            {
                                $("#" + that.id).find("input:eq(1)").focus();
                            }
                        });
                    	return false;
                    }

                    var regExp = /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/;
                    var ipArray = ip.split(".");
                    if ( ipArray.length == 4 )
                    {
                        if(ipArray[0] == "0" || ipArray[0] == "127" || ipArray[3]== "0"){
                            message.error({
                                content: appUtils.getString("validate_term_ipv4_ip_invalid"),
                                ok: function ()
                                {
                                    $("#" + that.id).find("input:eq(1)").focus();
                                }
                            });
                            return false;
                        }
                    }
                    if(!regExp.test(ip)){
                        message.error({
                            content: appUtils.getString("validate_term_ipv4_ip_invalid"),
                            ok: function ()
                            {
                                $("#" + that.id).find("input:eq(1)").focus();
                            }
                        });
                        return false;
                    }

                    var urlStr = "/fusionsphere/action/checkElasticIp?" + "planId=" + params.planId + "&poId=" + params.uuid + "&elasticIp=" + ip + "&recoverySiteId=" + that.id;
                    mask.show();
                    communicationService.get(utilService.getResouceUrl(urlStr)).promise().always(function ( response )
                    {
                        mask.hide();
                        if ( exception.check(response) )
                        {
                            var result = parseInt(response.result, 10);
                            switch (result)
                            {
                                case 0 :
                                    message.success(appUtils.getString("recovery_term_elastic_ip_response_ok"));
                                    break;
                                case 1 :
                                    message.error(appUtils.getString("recovery_term_elastic_ip_response_bind"));
                                    break;
                                case 2 :
                                    message.error(appUtils.getString("recovery_term_elastic_ip_response_notexist"));
                                    break;
                                default :
                                    message.error(appUtils.getString("recovery_term_elastic_ip_response_notexist"));
                            }
                        }
                    });
                }

                $scope.CHECKIP = appUtils.getString("common_term_verifty_button");
                $scope.IPV4TITLE = appUtils.getString("protect_object_ip_set_ipv4_label");
                $scope.DNATTITLE = appUtils.getString("protect_object_ip_set_dnat_label");
                $scope.DNATTIPS = appUtils.getString("protect_object_fm_dnat_tips_label");
                $scope.IPV4TIPS = appUtils.getString("protect_object_fm_ipv4_tips_label");
                $scope.model = {
                    labelwidth: "zh" === cookieService.get("language") || "zh_CN" === cookieService.get("language") ? "75px" : "123px",
                    labelcls: {
                        enableElasticIP: "tiny_formfield_label_hide",
                        enableDNAT: "tiny_formfield_label_hide"
                    },
                    contentTdAttr: {
                        enableElasticIP: {
                            colspan: "2"
                        },
                        enableDNAT: {
                            colspan: "2"
                        }
                    },
                    require: {
                        networkCard: false,
                        ipv4: false,
                        elasticIP: false,
                        privatePort: false,
                        publicPort: false
                    },
                    labels: {
                        networkCard: appUtils.getStringWithColon("protect_object_ip_set_networkCard_label"),
                        ipv4: appUtils.getStringWithColon("protect_object_ip_label"),
                        elasticIP: appUtils.getStringWithColon("protect_object_dnatip_label"),
                        privatePort: appUtils.getStringWithColon("protect_object_private_port_label"),
                        publicPort: appUtils.getStringWithColon("protect_object_public_port_label"),
                        protocal: appUtils.getStringWithColon("res_term_protocal_label")
                    },
                    enableIPv4: {
                        "id": "enableIPv4",
                        "text": appUtils.getString("protect_object_enableIPv4_label"),
                        "checked": false,
                        "disable": true,
                        "change": function (event)
                        {
                            var enableipv4check = $("#enableIPv4").widget().option("checked"),
                                ipv4Widget = $("#ipv4").widget();
                            if ( enableipv4check )
                            {
                                $scope.model.require.ipv4 = true;
                                ipv4Widget.option("disable", false);
                            } else {
                                $scope.model.require.ipv4 = false;
                                ipv4Widget.option("disable", true);
                                ipv4Widget.option("value", "");
                            }
                        }
                    },
                    enableElasticIP: {
                        "id": "enableElasticIP",
                        "text": appUtils.getString("protect_object_enableElasticIP_label"),
                        "checked": false,
                        "disable": true,
                        "change": function (event)
                        {
                            var enableFlexIpCheck = $("#enableElasticIP").widget().option("checked"),
                                enablednatWidget = $("#enableDNAT").widget(),
                                privatePortWidget = $("#privatePort").widget(),
                                publicPortWidget = $("#publicPort").widget(),
                                protocalWidget = $("#protocal").widget();
                            if ( enableFlexIpCheck )
                            {
                                //check DNAT checkbox is checked, if checked, so uncheck;
                                if ( enablednatWidget.option("checked") )
                                {
                                    enablednatWidget.option("checked", false);
                                    privatePortWidget.option("disable", true);
                                    publicPortWidget.option("disable", true);
                                    protocalWidget.option("disable", true);
                                    privatePortWidget.option("value", "");
                                    publicPortWidget.option("value", "");
                                    protocalWidget.option("value", "");
                                }
                                _.each($scope.flexIpArray,function(val){
                                    val.elasticIP.disable = false;
                                    $("#" + val.elasticIP.vertifyId).removeClass("disable").addClass("enable")
                                })
                            }
                            else
                            {
                                _.each($scope.flexIpArray,function(val){
                                    val.elasticIP.disable = true;
                                    val.elasticIP.value = "";
                                    $("#" + val.elasticIP.vertifyId).removeClass("enable").addClass("disable")
                                })
                            }
                        }
                    },
                    enableDNAT: {
                        "id": "enableDNAT",
                        "text": appUtils.getString("protect_object_enableDNAT_label"),
                        "checked": false,
                        "disable": true,
                        "change": function (event) {
                            var enablednatCheck = $("#enableDNAT").widget().option("checked"),
                                enableFlexIpCheck = $("#enableElasticIP").widget(),
                                privatePortWidget = $("#privatePort").widget(),
                                publicPortWidget = $("#publicPort").widget(),
                                protocalWidget = $("#protocal").widget();
                            if ( enablednatCheck )
                            {
                                //check flex ip checkbox is checked, if checked, so uncheck;
                                if ( enableFlexIpCheck )
                                {
                                    enableFlexIpCheck.option("checked", false);
                                    _.each($scope.flexIpArray,function(val){
                                        val.elasticIP.disable = true;
                                        val.elasticIP.value = "";
                                        $("#" + val.elasticIP.vertifyId).removeClass("enable").addClass("disable")
                                    })
                                }
                                $scope.model.require.publicPort = true;
                                $scope.model.require.privatePort = true;
                                privatePortWidget.option("disable", false);
                                publicPortWidget.option("disable", false);
                                protocalWidget.option("disable", false);
                            }
                            else
                            {
                                $scope.model.require.publicPort = false;
                                $scope.model.require.privatePort = false;
                                privatePortWidget.option("disable", true);
                                publicPortWidget.option("disable", true);
                                protocalWidget.option("disable", true);
                                privatePortWidget.option("value", "");
                                publicPortWidget.option("value", "");
                                protocalWidget.option("default-selectid", "TCP");
                            }
                        }
                    },
                    ipv4: {
                        id: "ipv4",
                        value: "",
                        type: "ipv4",
                        focused: false,
                        disable: true,
                        width: constsService.W4
                    },
                    elasticIP: {
                        id: "elasticIP",
                        type: "ipv4",
                        focused: false,
                        disable: true,
                        value: "",
                        width: constsService.W4
                    },
                    privatePort: {
                        id: "privatePort",
                        width: constsService.W4,
                        disable: true,
                        value: ""
                    },
                    publicPort: {
                        id: "publicPort",
                        width: constsService.W4,
                        disable: true,
                        value: ""
                    },
                    protocal: {
                        id: "protocal",
                        width: constsService.W4,
                        defaultId: "TCP",
                        disable: true,
                        values: [
                            { selectId: "TCP", label: "TCP", checked: true},
                            { selectId: "UDP", label: "UDP"}
                        ]
                    },
                    removeRow: function (_this) {
                        var currentObj = $(_this).parent().parent();
                        if (currentObj.attr("id") == "cloneRow") {
                            return;
                        }
                        currentObj.remove();
                    },
                    networkCard: {
                        "id": "networkCard",
                        "width": constsService.W4,
                        "autoOpen": false,
                        "defaultSelectId": "default",
                        "values": [{"selectId": "default","label": appUtils.getString("common_term_pleaseSelect_listbox")}],
                        "closeFn": function (object, evt) {
                            _queryFromServer();
                        },
                        "change": function () {
                            _queryFromServer();
                        },
                        "openFn": function (object) {
                            params = $("#" + constsService.FM_VM_IP_WIN.winId).widget().option("data");
                            var networkadapterUrl = "/fusionsphere/networkadapters?poId=" + params.uuid + "&planId=" + params.planId;
                            communicationService.get(utilService.getResouceUrl(networkadapterUrl)).promise().always(function ( result ) {
                                var arr = [];
                                if (exception.check(result) && !_.isEmpty(result)) {
                                    _.each(result, function ( network, k )
                                    {
                                        if (0 == k) {
                                            var temp = {
                                                "selectId": network.id,
                                                "checked": true,
                                                "label": $.encoder.encodeForHTML(network.name)
                                            };
                                        } else {
                                            var temp = {
                                                "selectId": network.id,
                                                "label": $.encoder.encodeForHTML(network.name)
                                            };
                                        }
                                        arr.push(temp);
                                    });
                                    $("#networkCard").widget().option("values", arr);
                                }
                                else
                                {
                                    var defaultOption = [{ "selectId": "default", "label": appUtils.getString("common_term_pleaseSelect_listbox")}];
                                    $("#networkCard").widget().option("values", defaultOption);
                                }
                                object.open();
                            });
                        }
                    }

                }
                function queryIp(){
                    var productSite = angular.copy($("#recoveryTable").widget().getTableCheckedItems()[0]);
                    restService.getRemoteDisasterSite({uuid: productSite.uuid}, {
                        mask: false,
                        callback: function(result) {
                            var ipArray = [];
                            _.each(result,function(val){
                                var obj = {
                                    elasticIP: {
                                        labels: val.name + appUtils.getStringWithColon("protect_object_dnatip_label"),
                                        require: false,
                                        id: val.siteId,
                                        type: "ipv4",
                                        focused: false,
                                        disable: true,
                                        value: "",
                                        width: constsService.W4,
                                        getVal: function(){
                                            return $("#" + this.id).widget().getValue()
                                        },
                                        vertifyId: val.siteId + "vertify",
                                        veriftyIP: veriftyIP
                                    }
                                };
                               ipArray.push(obj)
                            })
                        $scope.flexIpArray = ipArray;
                        $scope.$apply()
                        }
                    });
                };
                queryIp()

            } ]
        var huaweiVMApp = angular.module("recoverydirector.recovery.config");
        huaweiVMApp.tinyController("app.fusionsphere.fm.ctrl", huaweiVMAppCtrl);
        return huaweiVMApp;
    });
