define(["tiny-common/UnifyValid","tiny-widgets/Window"], function(UnifyValid,Window) {
    "use strict";
    var setNetWorkCtrl = [
        "$scope",
        "$state",
        "$sce",
        "message",
        "utilService",
        "mask",
        "constsService",
        "appUtils",
        "restService",
        function($scope, $state, $sce, message, utilService, mask, constsService, appUtils,restService) {
            var winData = $("#"+constsService.OPENSTACK_SET_TEST_NETWORK_WIN.winId).widget().option("data");
            var defaultTable = [{
                net: {
                    id: "netWork0",
                    width: 100,
                    title: appUtils.getString("resource_mapping_network"),
                    defaultSelectId: "-1",
                    values: [{
                        "selectId": "-1",
                        "label": appUtils.getString("common_term_pleaseSelect_listbox")
                    }],
                    autoOpen: false,
                    validte: function() {
                        if ($("#" + this.id).widget().getSelectedId() == "-1") {
                            message.error(appUtils.getString("reccovery_openstack_choose_network"));
                            return false;
                        };
                        return true;
                    },
                    getIdValue: function() {
                        return $("#" + this.id).widget().getSelectedId();
                    },
                    getNameValue: function() {
                        return $("#" + this.id).widget().getSelectedLabel();
                    },
                    openFn: function(obj) {
                        var that = this;
                        restService.getOpenStackNetWorks({
                            planId: winData.planId,
                            poUuid: winData.uuid
                        }, {
                            success: function(result) {
                                if (!_.isEmpty(result)) {
                                    var netWorkValues = [];
                                    _.each(result, function(obj) {
                                        var netWorkobj = {
                                            selectId: obj.networkId,
                                            label: obj.networkName,
                                            checked: true
                                        };
                                        netWorkValues.push(netWorkobj)
                                    });
                                    netWorkValues.push({"selectId": "-1","label": appUtils.getString("common_term_pleaseSelect_listbox")})
                                    $("#" + that.id).widget().option("values", netWorkValues)
                                }else{
                                    $("#" + that.id).widget().option("values", [{"selectId": "-1","label": appUtils.getString("common_term_pleaseSelect_listbox"),"checked":true}])
                                }
                                obj.open();
                            }
                        });
                    },
                    closeFn: function(event) {
                        $("#subnet"+this.id.substring(7)).widget().option("values",[{"selectId": "-1","label": appUtils.getString("common_term_pleaseSelect_listbox"),"checked":true}])
                        $scope.$apply();
                    }
                },
                port: {
                    id: "port0",
                    width: 100,
                    title: appUtils.getString("reccovery_openstack_add_port_name"),
                    value: "",
                    extendFunction:["checkPortName"],
                    validate:"checkPortName:extend function;",
                    getValue: function() {
                        return $("#" + this.id).widget().getValue();
                    }
                },
                subnet: {
                    id: "subnet0",
                    width: 100,
                    title:appUtils.getString("reccovery_openstack_add_subnet"),
                    values:[{
                        "selectId": "-1",
                        "label": appUtils.getString("common_term_pleaseSelect_listbox")
                    }],
                    defaultSelectId:"-1",
                    autoOpen:false,
                    getIdValue: function() {
                        return $("#" + this.id).widget().getSelectedId();
                    },
                    getNameValue: function(){
                        return $("#" + this.id).widget().getSelectedLabel();
                    },
                    openFn:function(obj){
                       var that = this;
                       var networkId = $("#netWork"+that.id.substring(6)).widget().getSelectedId();
                       restService.getOpenStackSubnets({planId:winData.planId,networkId:networkId},{
                           success:function(result){
                               var subnetArr = [];
                               if(!_.isEmpty(result)){
                                   _.each(result,function(obj){
                                       var subnetObj = {
                                           selectId:obj.subnetId,
                                           label:obj.subnetName,
                                           checked:true
                                       };
                                       subnetArr.push(subnetObj)
                                   })
                                   subnetArr.push({"selectId": "-1","label": appUtils.getString("common_term_pleaseSelect_listbox")})
                                   $("#"+that.id).widget().option("values",subnetArr);
                               }else{
                                   $("#"+that.id).widget().option("values",[{"selectId": "-1","label": appUtils.getString("common_term_pleaseSelect_listbox"),"checked":true}]);
                               }
                               obj.open();
                           }
                       })
                    }
                },
                isDhcp: {
                    id:"isDhcp0",
                    width: 120,
                    values:[{
                        "selectId": "-1",
                        "label": appUtils.getString("reccovery_openstack_auto_ip")
                    },{
                        "selectId": "1",
                        "label": appUtils.getString("reccovery_openstack_fixed_ipv4")
                    },{
                        "selectId": "2",
                        "label": appUtils.getString("reccovery_openstack_fixed_ipv6")
                    }],
                    defaultSelectId:"-1",
                    autoOpen:true,
                    change: function(event){
                        var thisID = this.id;
                        var netWorks = $scope.netWork.table;
                        var index = -1;
                        _.each(netWorks, function(eachNetWork, k) {
                            if(eachNetWork.isDhcp.id == thisID){
                                index = k;
                                return;
                            }
                        });
                        if($("#"+this.id).widget().getSelectedId() == "-1"){
                            $scope.netWork.table[index].ipv4.disable=true;
                            $scope.netWork.table[index].ipv4.value="";
                            $scope.netWork.table[index].ipv6.value="";
                            $scope.netWork.table[index].ipv4.isShow=true;
                            $scope.netWork.table[index].ipv6.isShow=false;
                        };
                        if($("#"+this.id).widget().getSelectedId() == "1"){
                            $scope.netWork.table[index].ipv4.disable=false;
                            $scope.netWork.table[index].ipv4.isShow=true;
                            $scope.netWork.table[index].ipv6.isShow=false;
                        };
                        if($("#"+this.id).widget().getSelectedId() == "2"){
                            $scope.netWork.table[index].ipv6.disable=false;
                            $scope.netWork.table[index].ipv4.isShow=false;
                            $scope.netWork.table[index].ipv6.isShow=true;
                        };
                       $scope.$apply();
                    },
                    getValue: function(){
                       return $("#"+this.id).widget().getSelectedId()
                    }
                },
                ipv4: {
                    id:"ipv40",
                    value:"",
                    title:"IP",
                    width:constsService.W2,
                    type:"ipv4",
                    disable:true,
                    isShow:true,
                    validate:constsService.VALID.IP_STANDARD,
                    getValue:function(){
                        return $("#"+this.id).widget().getValue();
                    }
                },
                ipv6: {
                    id:"ipv60",
                    value:"",
                    title:"IP",
                    width:313,
                    type:"ipv6",
                    disable:true,
                    isShow:false,
                    validate:constsService.VALID.OPENSTACK_IPV6,
                    getValue:function(){
                        return $("#"+this.id).widget().getValue();
                    }
                },
                removeCls: "pointer",
                removePort: del,
                lable: appUtils.getString("common_term_delete_button")
            }];

            $scope.netWork = {
                tips: appUtils.getString("openStack_test_network_set_label"),
                netTitle: appUtils.getString("resource_mapping_network"),
                portTitle: appUtils.getString("reccovery_openstack_add_port_name"),
                subnetTitle: appUtils.getString("reccovery_openstack_add_subnet"),
                configExplain: $sce.trustAsHtml(appUtils.getString("recovery_openstack_network_config_label")),
                ipTitle: "IP",
                noTableDataLabel:appUtils.getString("emptyTable"),
                table: [],
                addNetWorkBtn: {
                    label: appUtils.getString("reccovery_openstack_add_network_label"),
                    click: function() {
                        if(_.isEmpty($scope.netWork.table)){
                            $scope.netWork.table = angular.copy(defaultTable);
                            return;
                        }
                        var tableDta = $scope.netWork.table;
                        var addId = 0;
                        _.each(tableDta, function(eachTable, k) {
                            addId = addId>parseInt(eachTable.isDhcp.id.slice(6),10)?addId:parseInt(eachTable.isDhcp.id.slice(6),10)+1;
                        });
                        var newTableData = angular.copy( $scope.netWork.table[0]);
                            _.each(newTableData, function(v, k) {
                                if(!_.isUndefined(v.id) && v.id.indexOf("netWork") != -1){
                                    v.id = "netWork"+addId;
                                    v.defaultSelectId = "-1";
                                    v.values = [{"selectId": "-1","label": appUtils.getString("common_term_pleaseSelect_listbox")}]
                                };
                                if(!_.isUndefined(v.id) && v.id.indexOf("port") != -1){
                                    v.id = "port"+addId;
                                    v.value = "";
                                };
                                if(!_.isUndefined(v.id) && v.id.indexOf("subnet") != -1){
                                    v.id = "subnet"+addId;
                                    v.defaultSelectId = "-1";
                                    v.values = [{"selectId": "-1","label": appUtils.getString("common_term_pleaseSelect_listbox")}];
                                };
                                if(!_.isUndefined(v.id) && v.id.indexOf("isDhcp") != -1){
                                    v.id = "isDhcp"+addId;
                                    v.defaultSelectId = "-1";
                                    v.values = [{"selectId": "-1","label": appUtils.getString("reccovery_openstack_auto_ip")},{"selectId": "1","label": appUtils.getString("reccovery_openstack_fixed_ipv4")},{"selectId": "2","label": appUtils.getString("reccovery_openstack_fixed_ipv6")}]
                                };
                                if(!_.isUndefined(v.id) && v.id.indexOf("ipv4") != -1){
                                    v.id = "ipv4"+addId;
                                    v.value = "";
                                    v.isShow=true;
                                    v.disable = true
                                };
                                if(!_.isUndefined(v.id) && v.id.indexOf("ipv6") != -1){
                                    v.id = "ipv6"+addId;
                                    v.value = "";
                                    v.isShow=false;
                                    v.disable = true
                                }
                            });
                        _.extend(newTableData,{
                            "removeCls":"pointer",
                            "removePort":del
                        });
                        $scope.netWork.table.push(newTableData);
                        $scope.$apply();
                    }
                }
            };
            $("#openStackNetWorkSetWin").widget().option("buttons", [{
                key: "ok",
                label: appUtils.getString("common_term_confirm_button"),
                focused: true,
                handler: function() {
                    if (!UnifyValid.FormValid($("#setNetWorkDiv"), {
                            focusInvalid: true
                        })) {
                        return;
                    };
                    var getNetWork = $scope.netWork.table;
                    var len = getNetWork.length;
                    var netWorkArr = [],setNetWorkArr = [],netWorkMap = {};
                    for (var i = 0; i < len; i++) {
                        if (_.isFunction(getNetWork[i].net.validte) && !getNetWork[i].net.validte()) {
                            return;
                        };
                        var obj = {};
                        obj.networkId = getNetWork[i].net.getIdValue();
                        obj.networkName = getNetWork[i].net.getNameValue();
                        obj.portName = getNetWork[i].port.getValue();
                        obj.isDhcp = getNetWork[i].isDhcp.getValue() == "-1";
                        if(getNetWork[i].subnet.getIdValue() != "-1"){
                           obj.subnetId = getNetWork[i].subnet.getIdValue();
                           obj.subnetName = getNetWork[i].subnet.getNameValue();
                        }
                        if(!obj.isDhcp){
                            if(getNetWork[i].isDhcp.getValue() == "1"){
                                obj.ipAddress = getNetWork[i].ipv4.getValue();
                            };
                            if(getNetWork[i].isDhcp.getValue() == "2"){
                                obj.ipAddress = getNetWork[i].ipv6.getValue();
                            };
                        };
                        netWorkArr.push(obj);
                    };
                    netWorkMap.uuid = winData.uuid;
                    netWorkMap.name = "TESTNETWORKCONFIG";
                    netWorkMap.value = JSON.stringify(netWorkArr);
                    setNetWorkArr.push(netWorkMap);
                    _.isArray(setNetWorkArr) && !_.isUndefined(_.first(setNetWorkArr)) && _sendNetWorkValue(setNetWorkArr);
                }
            }, {
                key: "cancel",
                label: appUtils.getString("common_term_cancel_button"),
                handler: function() {
                    $("#" + constsService.OPENSTACK_SET_TEST_NETWORK_WIN.winId).widget().destroy();
                }
            }]);

            function del(){
                var netWorks = $scope.netWork.table;
                var index = netWorks.indexOf(this);
                index != -1 && (netWorks.splice(index,1));
            };

            function _sendNetWorkValue(params) {
                restService.setProObjectStartSetting({planId:winData.planId},{
                    data:params,
                    success:function(result){
                        message.success({
                            content: appUtils.getString("common_term_operation_success_label"),
                            ok: function() {
                                 $("#" + constsService.OPENSTACK_SET_TEST_NETWORK_WIN.winId).widget().destroy();
                            }
                        });
                    }
                })
            };

            function init(){
                restService.getRecoveryProtectObjectInfo({uuid:winData.planId},function(result){
                    var queryNetWorkInfo = _.filter(result.records,function(val){
                        return val.uuid == winData.uuid
                    })
                    queryNetWorkInfo = queryNetWorkInfo[0].props.TESTNETWORKCONFIG;

                    if(_.isString(queryNetWorkInfo)){
                        queryNetWorkInfo = JSON.parse(queryNetWorkInfo)
                    };

                    if(!_.isEmpty(queryNetWorkInfo)){
                        var queryNetWork = [];
                        _.each(queryNetWorkInfo,function(val,index){
                            var netWorkObj = {
                                net: {
                                    id: "netWork"+index,
                                    width: 100,
                                    title: appUtils.getString("resource_mapping_network"),
                                    defaultSelectId: val.networkId,
                                    values: [{
                                        "selectId": val.networkId,
                                        "label":val.networkName
                                    }],
                                    autoOpen:false,
                                    validte: function() {
                                        if ($("#" + this.id).widget().getSelectedId() == "-1") {
                                            message.error(appUtils.getString("reccovery_openstack_choose_network"));
                                            return false;
                                        };
                                        return true;
                                    },
                                    getIdValue: function() {
                                        return $("#" + this.id).widget().getSelectedId();
                                    },
                                    getNameValue: function(){
                                        return $("#"+this.id).widget().getSelectedLabel();
                                    },
                                    openFn:function(obj){
                                        var that = this;
                                        restService.getOpenStackNetWorks({planId:winData.planId,poUuid:winData.uuid},{
                                            success:function(result){
                                                if(!_.isEmpty(result)){
                                                    var netWorkValues = [];
                                                    _.each(result,function(obj){
                                                        var netWorkobj = {
                                                            selectId:obj.networkId,
                                                            label:obj.networkName,
                                                            checked:true
                                                        };
                                                        netWorkValues.push(netWorkobj)
                                                    });
                                                    netWorkValues.push({"selectId": "-1","label": appUtils.getString("common_term_pleaseSelect_listbox")});
                                                    $("#"+that.id).widget().option("values",netWorkValues)
                                                }else{
                                                    $("#" + that.id).widget().option("values", [{"selectId": "-1","label": appUtils.getString("common_term_pleaseSelect_listbox"),"checked":true}])
                                                }
                                                obj.open();
                                            }
                                        });
                                    },
                                    closeFn:function(event){
                                        $("#subnet"+this.id.substring(7)).widget().option("values",[{"selectId": "-1","label": appUtils.getString("common_term_pleaseSelect_listbox"),"checked":true}])
                                        $scope.$apply();
                                    }
                                },
                                port: {
                                    id: "port"+index,
                                    width: 100,
                                    value:val.portName,
                                    title: appUtils.getString("reccovery_openstack_add_port_name"),
                                    extendFunction:["checkPortName"],
                                    validate:"checkPortName:extend function;",
                                    getValue: function() {
                                        return $("#" + this.id).widget().getValue();
                                    }
                                },
                                subnet: {
                                    id: "subnet"+index,
                                    width: 100,
                                    title:appUtils.getString("reccovery_openstack_add_subnet"),
                                    values:[{
                                        "selectId": _.isEmpty(val.subnetId) ? "-1" : val.subnetId,
                                        "label":  _.isEmpty(val.subnetName) ? appUtils.getString("common_term_pleaseSelect_listbox") : val.subnetName
                                    }],
                                    defaultSelectId:_.isEmpty(val.subnetId) ? "-1" : val.subnetId,
                                    autoOpen:false,
                                    getIdValue: function() {
                                        return $("#" + this.id).widget().getSelectedId();
                                    },
                                    getNameValue: function(){
                                        return $("#" + this.id).widget().getSelectedLabel();
                                    },
                                    openFn:function(obj){
                                       var that = this;
                                       var networkId = $("#netWork"+that.id.substring(6)).widget().getSelectedId();
                                       restService.getOpenStackSubnets({planId:winData.planId,networkId:networkId},{
                                           success:function(result){
                                               var subnetArr = [];
                                               if(!_.isEmpty(result)){
                                                   _.each(result,function(obj){
                                                       var subnetObj = {
                                                           selectId:obj.subnetId,
                                                           label:obj.subnetName,
                                                           checked:true
                                                       };
                                                       subnetArr.push(subnetObj)
                                                   })
                                                   subnetArr.push({"selectId": "-1","label": appUtils.getString("common_term_pleaseSelect_listbox")})
                                                   $("#"+that.id).widget().option("values",subnetArr);
                                               }else{
                                                   $("#" + that.id).widget().option("values", [{"selectId": "-1","label": appUtils.getString("common_term_pleaseSelect_listbox"),"checked":true}])
                                               }
                                               obj.open();
                                           }
                                       })
                                    }
                                },
                                isDhcp: {
                                    id:"isDhcp"+index,
                                    width: 120,
                                    values:[{
                                        "selectId": "-1",
                                        "label": appUtils.getString("reccovery_openstack_auto_ip")
                                    },{
                                        "selectId": "1",
                                        "label": appUtils.getString("reccovery_openstack_fixed_ipv4")
                                    },{
                                        "selectId": "2",
                                        "label": appUtils.getString("reccovery_openstack_fixed_ipv6")
                                    }],
                                    defaultSelectId: val.isDhcp ? "-1" :((val.ipAddress.indexOf(".")>0)?"1":"2"),
                                    autoOpen:true,
                                    change: function(event){
                                        var thisID = this.id;
                                        var netWorks = $scope.netWork.table;
                                        var index = -1;
                                        _.each(netWorks, function(eachNetWork, k) {
                                            if(eachNetWork.isDhcp.id == thisID){
                                                index = k;
                                                return;
                                            }
                                        });
                                        if($("#"+this.id).widget().getSelectedId() == "-1"){
                                            $scope.netWork.table[index].ipv4.disable=true;
                                            $scope.netWork.table[index].ipv4.value="";
                                            $scope.netWork.table[index].ipv6.value="";
                                            $scope.netWork.table[index].ipv4.isShow=true;
                                            $scope.netWork.table[index].ipv6.isShow=false;
                                        };
                                        if($("#"+this.id).widget().getSelectedId() == "1"){
                                            $scope.netWork.table[index].ipv4.disable=false;
                                            $scope.netWork.table[index].ipv4.isShow=true;
                                            $scope.netWork.table[index].ipv6.isShow=false;
                                        };
                                        if($("#"+this.id).widget().getSelectedId() == "2"){
                                            $scope.netWork.table[index].ipv6.disable=false;
                                            $scope.netWork.table[index].ipv4.isShow=false;
                                            $scope.netWork.table[index].ipv6.isShow=true;
                                        };
                                       $scope.$apply();
                                    },
                                    getValue: function(){
                                       return $("#"+this.id).widget().getSelectedId()
                                    }
                                },
                                ipv4: {
                                    id:"ipv4"+index,
                                    value: val.isDhcp ? "" : ((val.ipAddress.indexOf(".")>0)?val.ipAddress:""),
                                    title:"IP",
                                    width:constsService.W2,
                                    type:"ipv4",
                                    disable:val.isDhcp,
                                    isShow:function(){
                                        if(val.isDhcp){
                                            return true;
                                        };
                                        if(val.ipAddress.indexOf(".")>0){
                                            return true;
                                        }else{
                                            return false;
                                        }
                                    }(),
                                    validate:constsService.VALID.IP_STANDARD,
                                    getValue:function(){
                                        return $("#"+this.id).widget().getValue();
                                    }
                                },
                                ipv6: {
                                    id:"ipv6"+index,
                                    value: val.isDhcp ? "" : ((val.ipAddress.indexOf(":")>0)?val.ipAddress:""),
                                    title:"IP",
                                    width:313,
                                    type:"ipv6",
                                    disable:val.isDhcp,
                                    isShow:function(){
                                        if(val.isDhcp){
                                            return false;
                                        };
                                        if(val.ipAddress.indexOf(":")>0){
                                            return true;
                                        }else{
                                            return false;
                                        }
                                    }(),
                                    validate:constsService.VALID.OPENSTACK_IPV6,
                                    getValue:function(){
                                        return $("#"+this.id).widget().getValue();
                                    }
                                },
                                removePort:del,
                                lable:appUtils.getString("common_term_delete_button"),
                                removeCls:"pointer"
                            };
                            queryNetWork.push(netWorkObj);
                        });
                        $scope.netWork.table = queryNetWork;
                    }
                    if(_.isEmpty(queryNetWorkInfo)){
                        $scope.netWork.table = angular.copy(defaultTable);
                    };
                    $scope.$apply();
                })
            };

            UnifyValid.checkPortName = function(){
                var val = $.trim(this[0].value);
                var nameReg = /^[0-9a-zA-Z_]{1}[a-zA-Z_0-9-]{3,31}$/;
                if (!val) {
                    return appUtils.getString("common_term_empty_label");
                };
                if(!nameReg.test(val)){
                    return appUtils.getString("validate_term_common_name_4_32_msg");
                };
                return "";
            };

            $scope.$on('$destroy', function() {
                delete UnifyValid.checkPortName;
            });

            init()
        }
    ]
    var setNetWorkApp = angular.module("recoverydirector.recovery.config");
    setNetWorkApp.tinyController("app.openStack.netWork.set.ctrl", setNetWorkCtrl);
    return setNetWorkApp;
})
