define(["tiny-extra-lib/jquery.base64"], function() {
    "use strict";
    var oracleSettingCtrl = [
        "$scope",
        "$compile",
        "constsService",
        "appUtils",
        "restService",
        "infoTransferredService",
        function($scope, $compile, constsService, appUtils, restService, infoTransferredService) {
            var _winData = $("#" + constsService.ORACLE_PROSTART_SETTING_WIN.winId).widget().option("data");
            var planId = _winData.uuid;
            var poType = parseInt(_winData.poType, 10);
            var isStartColumn = appUtils.getString("recovery.term.protected.colum.isStart.title");
            var startOrderColumn = appUtils.getString("recovery.term.protected.colum.startOrder.title");
            var executeResponse = [];
            var pdbStartData = {},
                defaultIndex = 15;
            var placeHolderVms,
                _filterResult,
                _filterValue;
            var cacheStartData = [];
            var searchByStatusFlag = false;

            function _filterDbByName() {
                var filterData = [];
                var inputDbName =  $.trim($("#dbSearch").widget().getSearchboxValue().inputValue);
                if(inputDbName == "") {
                    filterData = angular.copy(cacheStartData);
                } else {
                    _.each(angular.copy(cacheStartData), function(value) {
                        if(value["name"].indexOf(inputDbName) >= 0) {
                            filterData.push(value);
                            return;
                        };

                        var childData = [];
                        if(!_.isEmpty(value.props.PDB)) {
                            _.each(value.props.PDB, function(child) {
                                if(child["pdbName"].indexOf(inputDbName) >= 0) {
                                    childData.push(child);
                                }
                            });
                            value.props.PDB = childData;
                            !_.isEmpty(childData) && filterData.push(value);
                        }
                    });
                }
                return filterData;
            };

            function _filterDbByStatus() {
                var filterData = [];
                var selectStatus = $("#chooseStart").widget().getSelectedId();
                if(selectStatus == "-1") {
                    filterData = angular.copy(cacheStartData);
                } else {
                    var isStartFlag;
                    isStartFlag = selectStatus == "0" ? "true" : "false";
                    _.each(angular.copy(cacheStartData), function(value) {
                        if(value.props["isStart"] == isStartFlag) {
                            filterData.push(value);
                        };

                        var childData = [];
                        if(!_.isEmpty(value.props.PDB)) {
                            //若是CDB未被启动,且要搜索未启动的数据库时,则应将此CDB下的PDB全部选上
                            if(isStartFlag == "false" && $.trim(value.props.isStart) == "false") {
                                childData.push(value.props.PDB);
                            } else {
                                _.each(value.props.PDB, function(child) {
                                    if(''+ child["isStart"] + ''== isStartFlag) {
                                        childData.push(child);
                                    };
                                });
                                value.props.PDB = childData;
                                if(!_.contains(filterData, value) && !_.isEmpty(childData)) {
                                    filterData.push(value);

                                    //若是CDB未被启动,且要搜索启动的数据库时，则应该将此CDB下的PDB全部筛除掉
                                    if(isStartFlag === "true" && $.trim(value.props.isStart) == "false") {
                                        filterData = _.without(filterData, value);
                                    }
                                }
                            }
                        }
                    });
                }
                return filterData;
            };

            function _insertSpinner(nRow, aData, iDataIndex, isSetDefault) {
                var spinnerBox = "<div id=container_" + iDataIndex + "><tiny-spinner id='id' value='value' width='width' step='step' max='max' min='min' change='change()'></tiny-spinner></div>";
                var spinnerLink = $compile(spinnerBox);
                var spinnerScope = $scope.$new();
                spinnerScope.id = "startOrder_" + aData['uuid'];
                spinnerScope.value = isSetDefault ? 10 : aData.props.startOrder;
                spinnerScope.width = constsService.W2;
                spinnerScope.step = 1;
                spinnerScope.min = 1;
                spinnerScope.max = 32;
                spinnerScope.change = function() {
                    var spinnerWidget = $("#" + spinnerScope.id).widget();
                    _.isEmpty(spinnerWidget.option("value")) && spinnerWidget.option("value", 10);
                };

                var spinnerNode = spinnerLink(spinnerScope);
                spinnerScope.$evalAsync();
                $("td[tdtitle='" + startOrderColumn + "']", nRow).html(spinnerNode);
            };

            $scope.oracleStartScope = {
                topTitle: appUtils.getString("recovery.term.protected.startSetting.tips"),
                table: {
                    "id": "oracleStartOrderTable",
                    "columns": [{
                        "mData": "detail",
                        "bSearchable": false,
                        "bSortable": false,
                        "sWidth": "7.5%"
                    }, {
                        "sTitle": appUtils.getString("recovery.term.protected.colum.name.title"),
                        "mData": "name",
                        "bSortable": false,
                        "sWidth": "17.5%"
                    }, {
                        "sTitle": appUtils.getString("common_term_pdb_type_label"),
                        "mData": "dbType",
                        "bSortable": false,
                        "sWidth": "20%"
                    }, {
                        "sTitle": isStartColumn,
                        "mData": "isStart",
                        "bSortable": false
                    }, {
                        "sTitle": startOrderColumn,
                        "mData": "startOrder",
                        "bSortable": false
                    }],
                    data: [],
                    userOpenNodeIds: [],
                    renderRow: function(nRow, aData, iDataIndex) {
                        var dbTypeTitle;
                        if($.trim(aData.props.IS_CDB) == "1") {
                            dbTypeTitle = appUtils.getString("common_term_is_pdb_label");
                        } else {
                            dbTypeTitle = appUtils.getString("common_term_isNot_pdb_label");
                        }
                        $("td[tdtitle='" + appUtils.getString("common_term_pdb_type_label") + "']", nRow).html(dbTypeTitle);

                        //设置CDB是否启动的下拉选择框控件
                        var isStartBox = "<tiny-select id='id' default-selectid='defaultId' values='values' width='width' change='change()'></tiny-select>";
                        var isStartBoxLink = $compile(isStartBox);
                        var isStartScope = $scope.$new();
                        isStartScope.id = 'isCDBStart_' + aData['uuid'];
                        isStartScope.width = constsService.W2;
                        isStartScope.defaultId = $.trim(aData.props.isStart) == "true" ? "0" : "1";
                        isStartScope.values = [{
                            "selectId": "0",
                            "label": appUtils.getString("recovery.term.protected.colum.isStart.values.zero")
                        }, {
                            "selectId": "1",
                            "label": appUtils.getString("recovery.term.protected.colum.isStart.values.one")
                        }];
                        isStartScope.change = function() {
                            var selectBoxs = $('select[id^=' + aData['uuid'] + ']');
                            if ("1" == $("#" + isStartScope.id).widget().getSelectedId()) {
                                $("td[tdtitle='" + startOrderColumn + "']", nRow).html("--");

                                $.each(selectBoxs, function(index, selectBox){
                                    $('select[id^=' + aData['uuid'] + ']').eq(index).val(1);
                                    $(selectBox).attr("disabled", "disabled");
                                });
                                return;
                            } else {
                                _insertSpinner(nRow, aData, iDataIndex, true);
                                $.each(selectBoxs, function(index, selectBox){
                                    var conID = $(selectBox).attr("id").split("_")[1];
                                    var isStart = "true" == $.trim(aData.props.PDB[index].isStart);
                                    var selectId = isStart ? 0 : 1;
                                    $('select[id^=' + aData['uuid'] + ']').eq(index).val(selectId);
                                    $(selectBox).removeAttr("disabled");

                                    //切换CBD启动选择框时,还应该将刚做的PDB是否启动的选择状态保留下来
                                    if(_.has(pdbStartData, "allPDBs_" + aData.uuid)) {
                                        _.each(pdbStartData["allPDBs_" + aData.uuid], function(status) {
                                            if(status.conID == conID) {
                                                var cacheStart = "true" == $.trim(status.isStart);
                                                var cacheId = cacheStart ? 0 : 1;
                                                $('select[id^=' + aData['uuid'] + ']').eq(index).val(cacheId);
                                            }
                                        });
                                    }
                                });
                            };
                        };
                        var isStartNode = isStartBoxLink(isStartScope);
                        $("td[tdtitle='" + isStartColumn + "']", nRow).html(isStartNode);
                        if ($.trim(aData.props.isStart) == "true") {
                            _insertSpinner(nRow, aData, iDataIndex, false);
                        } else {
                            $("td[tdtitle='" + startOrderColumn + "']", nRow).html("--");
                        };
                    },
                    showDetails: {
                        "colIndex": 0,
                        "domPendType": "nopend",
                        "openClick": function(event, aData) {
                            var createSelectNode = function(plugDb, trObject) {
                                var plugDbSetId;
                                var columnDbSetStart = $('#isCDBStart_' + aData['uuid']).widget().getSelectedId() === "1";
                                plugDbSetId = $.trim(plugDb.isStart) == "true" ? 0 : 1;
                                var isStartId = "isPDBStart_" + aData.uuid + plugDb.conID;
                                var pdbStatusId = aData.uuid + "_" + plugDb.conID;
                                function pdbStatusChange() {
                                    var pdbSelectBoxs = $('select[id^=' + aData['uuid'] + ']');
                                    var choosedStatus = [];
                                    $.each(pdbSelectBoxs, function(n, box) {
                                        choosedStatus.push({
                                            "conID": aData.props.PDB[n].conID,
                                            "pdbName": aData.props.PDB[n].pdbName,
                                            "isStart": box.selectedIndex == 0
                                        })
                                    });
                                    if(!_.has(pdbStartData, "allPDBs_" + aData.uuid)) {
                                        pdbStartData["allPDBs_" + aData.uuid] = choosedStatus;
                                    } else {
                                        _.extend(pdbStartData["allPDBs_" + aData.uuid], choosedStatus);
                                    };
                                };

                                var pdbStatusBox = "<div class='statusBox'>" +
                                                   "<select class='selectNotActive' id=" + pdbStatusId + ">" +
                                                        "<option value='0'>" + appUtils.getString("recovery.term.protected.colum.isStart.values.zero") + "</option>" +
                                                        "<option value='1'>" + appUtils.getString("recovery.term.protected.colum.isStart.values.one") +"</option>" +
                                                   "</select>" +
                                                   "</div>";
                                var pdbStatusDom = $compile(pdbStatusBox)($scope);
                                var checkBoxTr = $("#" + isStartId).parent();
                                $($("#" + isStartId), checkBoxTr).html(pdbStatusDom);
                                $("#" + pdbStatusId).val(plugDbSetId);
                                $("#" + pdbStatusId).bind("change", pdbStatusChange);
                                columnDbSetStart && ($("#" + pdbStatusId).attr("disabled", "disabled"));
                                $scope.$apply();

                                if(columnDbSetStart && !searchByStatusFlag) {
                                    if(_.has(pdbStartData, "allPDBs_" + aData.uuid)) {
                                        $.each(pdbStartData["allPDBs_" + aData.uuid], function(index, status) {
                                            if(status.conID == plugDb.conID) {
                                                var defaultId = "true" == $.trim(status.isStart) ? 0 : 1;
                                                $("#" + pdbStatusId).val(defaultId);
                                            }
                                        })
                                    };
                                };
                            };

                            var tr = $(event.target).parents("tr")[0],
                                trObject = $("#oracleStartOrderTable").widget().getTableData(tr);
                            var html = "";
                            var currentDb = appUtils.encodeForHTML($("#oracleStartOrderTable").widget().getTableData(tr).uuid);
                            var parentname = appUtils.encodeForHTML($("#oracleStartOrderTable").widget().getTableData(tr).name);
                            $scope.oracleStartScope.table.userOpenNodeIds.push(trObject.uuid);

                            var childs = [];
                            if(trObject.props.IS_CDB == "1") {
                                var childs = _.filter(trObject.props.PDB, function(child){
                                    if(_.has(child, "type")) {
                                        return child.type == "PDB";
                                    } else {
                                        return trObject.props.PDB;
                                    };
                                });
                                aData.props.PDB = childs;
                            }
                            if(!_.isEmpty(childs)) {
                                for(var len = 0; len < childs.length; len ++) {
                                    var conID = childs[len].conID,
                                        name = appUtils.encodeForHTML(childs[len].pdbName),
                                        isStartId = "isPDBStart_" + aData.uuid + conID,
                                        dbType = appUtils.getString("common_term_PluggableDB_type_label");

                                    html += '<tr class="odd clickTrColor" conID="' + conID + '" parentname="' + parentname + '" parentId="' + currentDb + '">'
                                    html += '<td tdname="detail" class="tiny-tdStyle" value="' + conID + '"></td>'
                                    html += '<td tdname="name" class="tiny-tdStyle" style="padding-left:35px">' + name + '</td>'
                                    html += '<td tdname="dbType" class="tiny-tdStyle">' + dbType + '</td>'
                                    html += '<td tdname="isStart" class="tiny-tdStyle" id="'+ isStartId +'"></td>'
                                    html += '<td tdname="startOrder" class="tiny-tdStyle"></td></tr>';
                                }
                                $(event.target).parents("tr").eq(0).after(html);
                                _.each(childs, function(plugDb) {
                                    createSelectNode(plugDb, trObject);
                                });
                            };
                        },
                        "closeClick": function(event, aData) {
                            var tr = $(event.target).parents("tr")[0],
                                trObject = $("#oracleStartOrderTable").widget().getTableData(tr);

                            $scope.oracleStartScope.table.userOpenNodeIds = _.without($scope.oracleStartScope.table.userOpenNodeIds, trObject.uuid);
                            $(event.target).parents("tr").eq(0).nextAll().filter(
                                function() {
                                    return $(this).attr("parentId") === $("#oracleStartOrderTable").widget().getTableData($(event.target).parents("tr")[0]).uuid;
                                }).unbind().remove();

                            //关闭CDB节点时,将其下的PDB启动状态信息存入infoTransferredService服务
                            var params = {};
                            var oracleChildren = [];
                            if(_.has(pdbStartData, "allPDBs_" + aData.uuid)) {
                                _.each(aData.props.PDB, function(child) {
                                    _.each(pdbStartData["allPDBs_" + aData.uuid], function(pdb) {
                                        if(child.conID == pdb.conID) {
                                            child.isStart = pdb.isStart;
                                        }
                                    });
                                    oracleChildren.push({
                                        "conID": child.conID,
                                        "pdbName": child.pdbName,
                                        "isStart": child.isStart
                                    })
                                });
                                if(!_.has(params, aData.uuid)) {
                                    params[aData.uuid] = oracleChildren;
                                } else {
                                    _.extend(params[aData.uuid], oracleChildren);
                                };
                                infoTransferredService.put("START_SETTING", "ORACLE_PROSTART_SETTING", params);
                            };
                            searchByStatusFlag = false;
                        }
                    }
                },
                dbSearchBox: {
                    "id": "dbSearch",
                    "values": [{selectId: "0", label: appUtils.getString("common_term_name_label")},
                               {selectId: "1", label: appUtils.getString("common_term_recoveryPlan_start_status_label")}],
                    "isSearchbox": true,
                    "defaultSelectid": "0",
                    "textWidth": constsService.W2,
                    "width": constsService.W2,
                    "textOptions": {
                        "id": "chooseStart",
                        "values": [{
                            selectId: "-1",
                            label: appUtils.getString("common_term_all_label")
                        },{
                            selectId: "0",
                            label: appUtils.getString("recovery.term.protected.colum.isStart.values.zero")
                        },{
                            selectId: "1",
                            label: appUtils.getString("recovery.term.protected.colum.isStart.values.one")
                        }],
                        "display" : true,
                        "default-selectid": "-1"
                    },
                    "change": function() {
                        var dbSearch = $("#dbSearch").widget(),
                            selected = dbSearch.getSelectedId();

                        if(selected == "1") {
                            this.isSearchbox = false;
                            dbSearch.changeTextBox(false, this.textOptions);
                        } else {
                            this.isSearchbox = true;
                            dbSearch.changeTextBox(true);
                        }
                    },
                    "click": function() {
                        if (this.isSearchbox) {
                            $scope.oracleStartScope.table.data = _filterDbByName();
                        } else {
                            $scope.oracleStartScope.table.data = _filterDbByStatus();
                        }
                        searchByStatusFlag = true;
                        setTimeout(function(){
                            $.each($(".btn_detail_switch"), function(index ,btn) {
                                if(!_.isEmpty($scope.oracleStartScope.table.data) && !$(btn).hasClass("ti-arrow-down")) {
                                    btn.click();
                                }
                            });
                            searchByStatusFlag = false;
                            infoTransferredService.put("STARTSETTING", "INITDATA", cacheStartData);
                        }, 0);
                        $scope.$apply();
                    }
                }
            };

            restService.getRecoveryProtectObjectInfo({
                uuid: planId
            }, function(result) {
                executeResponse = appUtils.encodeForHTML(_.filter(result.records, function(po) {
                    return po['poType'] != 14;
                }));
                _.each(executeResponse, function(res) {
                    res.name = appUtils.encodeForHTML(res.name);

                    if (_.isEmpty($.trim(res.props.isStart))) {
                        res.props.isStart = true;
                    };
                    if (_.isEmpty($.trim(res.props.startOrder))) {
                        res.props.startOrder = 10;
                    };

                    var pdbs;
                    if(res.props.IS_CDB == "1") {
                        pdbs = _.filter(JSON.parse(res.props.PDB), function(pdb) {
                            return pdb.type == "PDB";
                        });
                        if(!_.isEmpty(pdbs)) {
                            _.extend(res, {
                                "detail": {
                                    content: "",
                                    contentType: "simple"
                                }
                            });
                            _.each(pdbs, function(pdb) {
                                if (_.isEmpty($.trim(pdb.isStart))) {
                                    pdb.isStart = true;
                                };
                            })
                        };
                        res.props.PDB = pdbs;
                    };

                });

                cacheStartData = angular.copy(executeResponse);
                $scope.oracleStartScope.table.data = executeResponse;
                $scope.$apply();
            });
    }];

    var oracleSettingApp = angular.module("recoverydirector.recovery.config");
    oracleSettingApp.tinyController("app.start.oracleSetting.ctrl", oracleSettingCtrl);
    return oracleSettingApp;
});