define(["tiny-widgets/Message","tiny-widgets/FileUpload"], function(Message,FileUpload) {
    "use strict";
    var ctrler = [
        "$scope",
        "$state",
        "appUtils",
        "constsService",
        "statusEnumService",
        "restService",
        "recoveryService",
        "message",
        "infoTransferredService",
        "utilService",
        "mask",
        "cookieService",
        "exception",
        function($scope, $state, appUtils, constsService, statusEnumService, restService, recoveryService,message,infoTransferredService,utilService,mask,cookieService,exception) {
            var _startPage = 0,
                _pageSize = 10,
                _orderBy,
                _orderType,
                _recovery = _.first($("#recoveryTable").widget().getTableCheckedItems()),
                _opAreaConfig = [{
                    id: "iconBtnNetworkSet",
                    authKey: "ism.drm.drp.auth.recoverysetting.modify.operateID",
                    template: "<div class='iconbutton-edit' title='" + appUtils.getString('recovery.term.protected.setIpAddress.label') + "'></div>",
                    clickActive: function() {
                        if (!$("#iconBtnNetworkSet div").hasClass("iconbutton-edit")) {
                            return;
                        }
                        var hoverData = _.first($("#protectedTable").widget().getHoverData());
                        var hostName = hoverData.props.GUESTHOSTNAME;
                        var errorCharacter = [];
                        if (!_.isEmpty(hostName)) {
                            var hostNameArray = hostName.split("");
                            var codeReg = /^[0-9a-zA-Z]+$/;
                            if (_.isArray(hostNameArray) && !_.isEmpty(hostNameArray)) {
                                _.each(hostNameArray, function(item) {
                                    (!codeReg.test(item) && item != "-") && errorCharacter.push(item)
                                });
                            }
                        };
                        //主机名包含特殊字符，不允许设置IP
                        if (_.size(errorCharacter) > 0) {
                            var codeMsg = "";
                            _.each(errorCharacter, function(val){
                                codeMsg += val;
                            });
                            message.error(appUtils.getString("recovery_vmware_config_ip_error_label", codeMsg));
                            return;
                        };
                        if (hoverData["poType"] == constsService.VMware_VM_TYPE) {
                            if (hoverData.props.GUESTOSTYPE === "windowsGuest") {
                                var win = angular.copy(constsService.VMWARE_WINDOWS_NETWORK_SET_WIN);
                                win.data = {
                                    planId: _recovery.uuid,
                                    poId: hoverData.uuid,
                                };
                                appUtils.showWindow(win);
                                return;
                            }

                            if (hoverData.props.GUESTOSTYPE === "linuxGuest") {
                                var win = angular.copy(constsService.VMWARE_LINUX_NETWORK_SET_WIN);
                                win.data = {
                                    planId: _recovery.uuid,
                                    poId: hoverData.uuid,
                                }
                                appUtils.showWindow(win);
                                return;
                            }

                            if (hoverData.props.GUESTOSTYPE === "UNKNOW") {
                                var options={
                                    type : "confirm",
                                    content:appUtils.getString("res_system_info_unkown_label"),
                                    buttons:[{
                                        label:tinyLanguage.language.okBtnTitile,
                                        handler:function(){
                                            msg.destroy();
                                        }
                                    }]
                                };
                                var msg = new Message(options);
                                msg.show();
                                $("#"+msg.dialogId).parent().find(".ui-dialog-title").html(appUtils.getString("common_message_win_information_title"));
                                $("#"+msg.dialogId).css("min-height","40px");
                                return;
                            }

                            var options={
                                type : "confirm",
                                content:appUtils.getString("res_system_info_unsupport_label"),
                                buttons:[{
                                    label:tinyLanguage.language.okBtnTitile,
                                    handler:function(){
                                        msg.destroy();
                                    }
                                }]
                            };
                            var msg = new Message(options);
                            msg.show();
                            $("#"+msg.dialogId).parent().find(".ui-dialog-title").html(appUtils.getString("common_message_win_information_title"));
                            $("#"+msg.dialogId).css("min-height","40px");
                            return;
                        }
                        if (hoverData["poType"] == constsService.HUAWEI_VM_TYPE) {
                            recoveryService.execute(_.extend(hoverData, {
                                planId: _recovery.uuid,
                                planType: _recovery.planType,
                                action: "networkSet" + _recovery.PROVIDER_TYPE,
                                $scope: $scope
                            }));
                            return;
                        }
                    },
                    mouseActive: function(data) {
                        if (_recovery.templateType == 25 && _recovery.PROVIDER_TYPE == "FusionSphereOpenstack"){
                            $("#iconBtnNetworkSet div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                            return;
                        }
                        //云主备屏蔽接口
                        if (_recovery.serviceInstanceType == "replication" && _recovery.PROVIDER_TYPE == "FusionSphereOpenstack"){
                            $("#iconBtnNetworkSet div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                            return;
                        }
                        //VHA+CSDR屏蔽接口
                        if (_.contains([34,37], +_recovery.templateType) && _recovery.PROVIDER_TYPE == "FusionSphereOpenstack"){
                            $("#iconBtnNetworkSet div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                            return;
                        }
                        if (!$scope.protectObjectScope.start.isActive) {
                            $("#iconBtnNetworkSet div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                            return;
                        }
                        if(_recovery.PROVIDER_TYPE == "FusionSphereOpenstack" && _.isEmpty(data.props.PLACEHOLDVMNAME)){
                            $("#iconBtnNetworkSet div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                            return;
                        }
                        if(!$state.current.name =="dataUse.dataRecovery.protected" && !_.contains([0,27], parseInt(_recovery.planStatus, 10))) {
                            $("#iconBtnNetworkSet div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                            return;
                        }
                        $("#iconBtnNetworkSet div").removeClass("iconbutton-edit-disabled").addClass("iconbutton-edit");
                    }
                }];

            var systemColumn = appUtils.getString("common_term_system_label");
            var poTypeColumn = appUtils.getString("recovery.term.protected.colum.type.title");
            var isStartColumn = appUtils.getString("recovery.term.protected.colum.isStart.title");
            var startOrderColumn = appUtils.getString("recovery.term.protected.colum.startOrder.title");
            var disaterStatusColumn = appUtils.getString("recovery.term.protected.colum.recoveryStatus.title");
            var placeholderVmsColumn = appUtils.getString("VMware_term_status_value_occupiedVM_value");
            var vmHostNameColumn = appUtils.getString("recovery_vmware_host_name_label");
            $scope.FUSIONCOMPUTEIMPORTIPLABEL = appUtils.getString("recovery_fc_import_ip_setting_label");
            $scope.FUSIONCOMPUTEEXPORTIPLABEL = appUtils.getString("recovery_fc_export_ip_setting_label");
            $scope.isEn = appUtils.isEn();

            function _initPage(node) {
                if (_.isUndefined(node) && _.isUndefined(_recovery)) {
                    return;
                }
                $scope.recoveryProtectObjMask = true;
                $scope.$apply();
                if (_.isUndefined(node)) {
                    _.extend(_recovery, {
                        _mask: true
                    });
                } else {
                    _recovery = node;
                }

                $scope.protectObjectScope.start.clickActive(_recovery);
                $scope.protectObjectScope.export.clickActive(_recovery);
                $scope.fusioncompute.clickActive(_recovery);

                var _params = {
                    $scope: $scope,
                    uuid: _recovery.uuid,
                    startPage: _startPage,
                    pageSize: _pageSize,
                    orderBy: _orderBy,
                    orderType: _orderType
                }

                _.each(_params, function(value, key) {
                    (_.isUndefined(value) || _.isNull(value)) && delete _params[key];
                })

                _getProtectObjectList(_params, _.isUndefined(_recovery._mask) || _recovery._mask);

            }
            //对于openSatck如未设置占位虚拟机默认跳到保护对象页面并弹出设置窗口
            function _openWin(){
                if(infoTransferredService.get("OpenWinModule","isOpenWin")) {
                    infoTransferredService.remove("OpenWinModule","isOpenWin");
                    recoveryService.execute(_.extend(_recovery, {
                        planId: _recovery.uuid,
                        action: "proStartSetting",
                        $scope: $scope
                    }));
                }
            }

            function _getProtectObjectList(obj, _mask) {
                restService.getRecoveryProtectObject(obj, {
                    mask: false,
                    success: function(data) {
                        $scope.protectObjectScope.table.data = appUtils.encodeForHTML(data.records);
                        $scope.protectObjectScope.table.totalRecords = data["totalCount"];
                        if (data["totalCount"] > 10) {
                            $scope.protectObjectScope.table.enablePagination = true;
                        } else {
                            $scope.protectObjectScope.table.enablePagination = false;
                        }
                        $scope.$apply();
                    },
                    fail: function(data) {
                        $scope.protectObjectScope.table.data = [];
                        $scope.protectObjectScope.table.enablePagination = false;
                        $scope.$apply();
                    },
                    callback: function() {
                        $scope.recoveryProtectObjMask = false;
                        _startPage == 0 && ($scope.protectObjectScope.table.currPage = {
                            "pageIndex": 1
                        });
                        _openWin();
                        $scope.$apply();
                    }
                })
            }
            //FC批量配置测试网络
            $scope.fusioncompute = {
                hasRight: appUtils.getString("ism.drm.drp.auth.recoverysetting.modify.operateID"),
                isAvailable: true,
                importIp: {
                    cls: {
                       icon: "iconbutton-import-disabled",
                       span: "btn-link-disable"
                    },
                    click: function(){
                        if(this.cls.icon == "iconbutton-import-disabled"){
                            return;
                        }
                        var win = angular.copy(constsService.FC_IMPORT_NETWORK_SETTING_WIN);
                        win.title = appUtils.getString(win.title);
                        win.data = {uuid:_recovery.uuid};
                        win.buttons = [{
                            key: "ok",
                            label: appUtils.getString('common_term_close_button'),
                            focused: true,
                            handler: function(event){
                                $("#" + win.winId).widget().destroy();
                            }
                        }];
                        appUtils.showWindow(win);
                    }
                },
                exportIp: {
                   cls: {
                       icon: "iconbutton-export-disabled",
                       span: "btn-link-disable"
                    },
                    click: function(){
                        if(this.cls.icon == "iconbutton-export-disabled"){
                            return;
                        }

                        appUtils.export("/fusionsphere/action/exportProtectObjectIPSettingInfo",{planId:_recovery.uuid},"get")
                    }
                },
                disable: [1, 2, 4, 5, 6, 7, 9, 10, 11, 15, 16, 17],
                clickActive: function(recovery){
                    if(recovery.PROVIDER_TYPE == "FusionCompute" && !_.contains([2, 14, 15, 17, 19], parseInt(recovery["templateType"]))){
                        this.isAvailable = true
                        if(recovery.planType == 2 && (recovery.isAllowExecute == 0 || _.contains(this.disable, parseInt(recovery.planStatus,10)))){
                            this.importIp.cls.icon = "iconbutton-import-disabled";
                            this.importIp.cls.span = "btn-link-disable";
                            this.exportIp.cls.icon = "iconbutton-export-disabled";
                            this.exportIp.cls.span = "btn-link-disable";
                        }else{
                            this.importIp.cls.icon = "iconbutton-import";
                            this.importIp.cls.span = "btn-link";
                            this.exportIp.cls.icon = "iconbutton-export";
                            this.exportIp.cls.span = "btn-link";
                        }
                    }else{
                        this.isAvailable = false
                    }

                }
            }

            $scope.protectObjectScope = {
                start: {
                    isActive: false,
                    hasRight: appUtils.checkRight("ism.drm.drp.auth.recoverysetting.modify.operateID"),
                    cls: {
                        span: "btn-link",
                        icon: "iconbutton-setting"
                    },
                    text: appUtils.getString("recovery.term.protected.startSetting.label"),
                    disable: {
                        proType: [9, 11, 14],
                        recStatus: [1, 2, 4, 5, 6, 7, 9, 10, 11, 15, 16, 17, 23, 24]
                    },
                    click: function() {
                        if(parseInt(_recovery.poType, 10) == 1) {
                            this.isActive && recoveryService.execute(_.extend(_recovery, {
                                planId: _recovery.uuid,
                                action: "oracleProSetting",
                                $scope: $scope
                            }))
                        } else {
                            this.isActive && recoveryService.execute(_.extend(_recovery, {
                                planId: _recovery.uuid,
                                action: "proStartSetting",
                                $scope: $scope
                            }));
                        }
                    },
                    clickActive: function(recovery) {
                        var _that = this;
                        //SAN双活屏蔽接口
                        if(recovery.templateType == 15){
                            _.extend(_that, {
                                 isActive: false,
                                 cls: {
                                     icon: "iconbutton-setting-disabled",
                                     span: "btn-link-disable"
                                 }
                             });
                             return;
                        }
                        //云双活屏蔽接口
                        if(recovery.poType == 12 && recovery.templateType == 25){
                           _.extend(_that, {
                                isActive: false,
                                cls: {
                                    icon: "iconbutton-setting-disabled",
                                    span: "btn-link-disable"
                                }
                            });
                            return;
                        }
                        //云主备屏蔽接口
                        if(recovery.poType == 12 && recovery.serviceInstanceType == "replication"){
                           _.extend(_that, {
                                isActive: false,
                                cls: {
                                    icon: "iconbutton-setting-disabled",
                                    span: "btn-link-disable"
                                }
                            });
                            return;
                        }
                        //VHA+CSDR屏蔽接口
                        if(recovery.poType == 12 && _.contains([34,37], +recovery.templateType)){
                           _.extend(_that, {
                                isActive: false,
                                cls: {
                                    icon: "iconbutton-setting-disabled",
                                    span: "btn-link-disable"
                                }
                            });
                            return;
                        }
                        if (_.contains(_that.disable.proType, parseInt(recovery.poType,10))) {
                            _.extend(_that, {
                                isActive: false,
                                cls: {
                                    icon: "iconbutton-setting-disabled",
                                    span: "btn-link-disable"
                                }
                            });
                            return;
                        }
                        if (recovery.planType == 1 && _.contains(_that.disable.recStatus, parseInt(recovery.planStatus,10))) {
                            _.extend(_that, {
                                isActive: false,
                                cls: {
                                    icon: "iconbutton-setting-disabled",
                                    span: "btn-link-disable"
                                }
                            });
                            return;
                        }

                        if (recovery.planType == 2 && (recovery.isAllowExecute == 0 || _.contains(_that.disable.recStatus, parseInt(recovery.planStatus,10)))) {
                            _.extend(_that, {
                                isActive: false,
                                cls: {
                                    icon: "iconbutton-setting-disabled",
                                    span: "btn-link-disable"
                                }
                            });
                            return;
                        }

                        _.extend(_that, {
                            isActive: true,
                            cls: {
                                icon: "iconbutton-setting",
                                span: "btn-link"
                            }
                        });
                        if (!_.isUndefined(recovery.globalSettings)) {
                            if(recovery.globalSettings.isCloudSite == "true") {
                                _.extend(_that, {
                                    isActive: false,
                                    cls: {
                                        icon: "iconbutton-setting-disabled",
                                        span: "btn-link-disable"
                                    }
                                });
                                return;
                            }
                        }

                    }
                },
                export: {
                    isActive: false,
                    hasRight: appUtils.checkRight("ism.drm.drp.auth.recoverymapping.export"),
                    cls: {
                        span: "btn-link",
                        icon: "iconbutton-export"
                    },
                    text: appUtils.getString("common_term_export_button"),
                    click: function() {
                        this.isActive && appUtils.export("/resourcemapping/action/exportRecoveryReport?planId=" + _recovery.uuid, null, "get");
                    },
                    clickActive: function(recovery) {
                        if (recovery.poType == constsService.HUAWEI_VM_TYPE && _.contains([2, 11], recovery.planStatus)
                                && recovery.isAllowExecute != 0 && !_.contains([21, 22], recovery.templateType)) {
                            _.extend(this, {
                                isActive: true,
                                cls: {
                                    icon: "iconbutton-export",
                                    span: "btn-link"
                                }
                            });
                            return;
                        }
                        _.extend(this, {
                            isActive: false,
                            cls: {
                                icon: "iconbutton-export-disabled",
                                span: "btn-link-disable"
                            }
                        });
                    }
                },
                table: {
                    "id": "protectedTable",
                    "paginationStyle":"full_numbers",
                    "enablePagination": false,
                    "displayLength": 10,
                    "totalRecords": 0,
                    "data": [],
                    "opAreaConfig": [],
                    "currPage": {
                        "pageIndex": 1
                    },
                    "columns": [{
                        "mData": "uuid",
                        "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("recovery.term.protected.colum.name.title"),
                        "mData": "name",
                        "bSortable": true
                    }, {
                        "sTitle": appUtils.getString("recovery.term.protected.colum.owernerGroup.title"),
                        "mData": "pgName",
                        "bSortable": false
                    }, {
                        "sTitle": disaterStatusColumn,
                        "mData": "poRecoveryStatus",
                        "bSortable": true,
                        "bVisible": "dataUse.dataRecovery.protected" == $state.current.name
                    }, {
                        "sTitle": poTypeColumn,
                        "mData": "poType",
                        "bSortable": false
                    }, {
                        "sTitle": isStartColumn,
                        "mData": "props.isStart",
                        "bSortable": false
                    }, {
                        "sTitle": startOrderColumn,
                        "mData": "props.startOrder",
                        "bSortable": false
                    }, {
                        "sTitle": systemColumn,
                        "mData": "props.GUSTOS",
                        "bSortable": false
                    }, {
                        "sTitle": placeholderVmsColumn,
                        "mData": "props.PLACEHOLDVMNAME",
                        "bSortable": false
                    }, {
                        "sTitle": vmHostNameColumn,
                        "mData": "props.GUESTHOSTNAME",
                        "bSortable": false
                    }, {
                        "mData": "props.GUESTOSTYPE",
                        "bVisible": false
                    }],
                    "sortCallback": function(nNode, sortArr) {
                        $scope.protectObjectScope.table.currPage = {
                            "pageIndex": 1
                        };
                        _orderBy = $scope.protectObjectScope.table.columns[_.first(_.first(sortArr))].mData;
                        _orderType = _.first(sortArr)[1];
                        _startPage = 0;
                        _initPage();
                    },
                    "callback": function(evtObj) {
                        _startPage = evtObj.currentPage - 1;
                        _pageSize = evtObj.displayLength;
                        _initPage();
                    },
                    "drawCallback": function(oSetting) {
                        if (!oSetting.aoData.length) return;

                        if(_recovery.PROVIDER_TYPE != "FusionSphereOpenstack"){
                            $("th[aria-label='" + placeholderVmsColumn + "']").hide();
                            $("td[tdtitle='" + placeholderVmsColumn + "']").hide();
                        }
                        if(_recovery.PROVIDER_TYPE == "FusionSphereOpenstack"){
                            $("th[aria-label='" + placeholderVmsColumn + "']").show();
                            $("td[tdtitle='" + placeholderVmsColumn + "']").show();
                        }

                        if (oSetting.aoData[0]._aData.poType !== 10) {
                            $("th[aria-label='" + systemColumn + "']").hide();
                            $("td[tdtitle='" + systemColumn + "']").hide();
                            $("th[aria-label='" + vmHostNameColumn + "']").hide();
                            $("td[tdtitle='" + vmHostNameColumn + "']").hide();
                            return;
                        }

                        $("th[aria-label='" + systemColumn + "']").show();
                        $("td[tdtitle='" + systemColumn + "']").show();
                        $("th[aria-label='" + vmHostNameColumn + "']").show();
                        $("td[tdtitle='" + vmHostNameColumn + "']").show();
                    },
                    "renderRow": function(nRow, aData, iDataIndex) {
                        if (_.contains([9, 11, 13, 14], parseInt(aData["poType"], 10)) || _recovery.templateType == 15) {
                            aData.props.isStart = "--";
                            aData.props.startOrder = "--";
                        } else {
                            if (_.isEmpty($.trim(aData.props.isStart))) {
                                aData.props.isStart = "true";
                            }
                            if (_.isEmpty($.trim(aData.props.startOrder))) {
                                aData.props.startOrder = 10;
                            }
                        }
                        if(_recovery.templateType == 15){
                            $("td[tdtitle='"+ disaterStatusColumn +"']", nRow).html("--");
                        }else{
                            $("td[tdtitle='"+ disaterStatusColumn +"']", nRow).html(statusEnumService.getStatus("PROTECT_OBJECT_STATUS", aData['poRecoveryStatus']));
                        }
                        $("td[tdtitle='"+ poTypeColumn +"']", nRow).html(statusEnumService.getStatus("PROTECT_OBJECT_TYPE", aData['poType']));
                        $("td[tdtitle='"+ isStartColumn +"']", nRow).html(statusEnumService.getStatus("PROTECT_START_STATE", aData.props.isStart));
                        $("td[tdtitle='"+ startOrderColumn +"']", nRow).html($.trim(aData.props.isStart) == "true" ? aData.props.startOrder : "--");
                        $("td[tdtitle='"+ systemColumn +"']", nRow).html(!_.isEmpty(aData.props.GUSTOS) && aData["poType"] == 10 ? ("UNKNOWN" == aData.props.GUSTOS ? appUtils.getString("common_term_unknow_label") : aData.props.GUSTOS) : "--");
                        if (_recovery.templateType == 37) {
                            $("td[tdtitle='" + placeholderVmsColumn + "']", nRow).html(_.isEmpty(aData.props.PLACEHOLDVMNAME) ? "--" : aData.props.PLACEHOLDVMNAME + "; " + aData.props.CSHAPLACEHOLDVMNAME);
                        } else {
                            $("td[tdtitle='" + placeholderVmsColumn + "']", nRow).html(_.isEmpty(aData.props.PLACEHOLDVMNAME) ? "--" : aData.props.PLACEHOLDVMNAME);
                        }
                        $("td[tdtitle='"+ vmHostNameColumn +"']", nRow).html(_.isEmpty(aData.props.GUESTHOSTNAME) ? "--" : aData.props.GUESTHOSTNAME);
                    },
                    "hoverActive": function(e, param) {
                        var __opAreaConfig = [];
                        //10表示vmware虚拟机类型,12表示fusionsphere类型,vmware的san快照和nas快照不需要进行网络设置
                        if (_.contains([10, 12], parseInt(param["poType"], 10)) && !_.contains([2, 14, 15, 17, 19], parseInt(_recovery["templateType"]))) {
                            __opAreaConfig = appUtils.flilterOperRight(_opAreaConfig);
                            !_.isEmpty(__opAreaConfig) && _.isFunction(_.first(__opAreaConfig).mouseActive) && _.first(__opAreaConfig).mouseActive(param);
                        }
                        $scope.protectObjectScope.table.opAreaConfig = __opAreaConfig;
                        $scope.$apply();
                    }
                }
            }
            $scope.$on(constsService.RECOVERY_TAB, function(ev, param) {
                _startPage = 0;
                _initPage(param)
            });

            $scope.$on(constsService.ORACLE_RECOVERY_TAB, function(ev, param) {
                _startPage = 0;
                _initPage(param)
            });

            _initPage();
        }
    ]
    var module = angular.module('recoverydirector.recovery.config');
    module.tinyController('recovery.protected.ctrl', ctrler);
    return module;
});
