define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ipSetCtrl = [
        "$scope",
        "$timeout",
        "appUtils",
        "message",
        "constsService",
        "restService",
        function($scope, $timeout, appUtils, message, constsService, restService) {
            var vmareNetWorkIpInfo = $scope.$new();
            $("#" + constsService.VMWARE_WINDOWS_NETWORK_SET_WIN.winId).widget().option("buttons", [{
                key: "ok",
                label: appUtils.getString('common_term_confirm_button'),
                focused: true,
                handler: function(event) {
                    if (!UnifyValid.FormValid($("#vmwarepSetDiv"), {
                            focusInvalid: true
                        })) {
                        return;
                    };
                    var parms = _savePageData();
                    var mac = $("#networkCard").widget().getSelectedId();

                    if (_.isEmpty(mac) || "default" === mac) {
                        message.error(appUtils.getString("protect_object_select_netcard_label"));
                        return;
                    };

                    var data = $("#" + constsService.VMWARE_WINDOWS_NETWORK_SET_WIN.winId).widget().option("data");
                    restService.setVmareNetWorkIpInfo({
                        planId: data.planId,
                        poId: data.poId
                    }, {
                        data: parms,
                        success: function(result) {
                            message.success({
                                content: appUtils.getString("common_term_operation_success_label"),
                                ok: function() {
                                    $("#" + constsService.VMWARE_WINDOWS_NETWORK_SET_WIN.winId).widget().destroy();
                                }
                            });
                        }
                    })
                }
            }, {
                key: "cancel",
                label: appUtils.getString('common_term_cancel_button'),
                focused: false,
                handler: function(event) {
                    $("#" + constsService.VMWARE_WINDOWS_NETWORK_SET_WIN.winId).widget().destroy();
                }
            }]);

            /**
             * 初始化网络的配置信息
             * @private
             */
            function _initNetworkSettingInfo() {
                if (!_.isUndefined(vmareNetWorkIpInfo)) {
                    // 拿到当前选择的网卡
                    var mac = $("#networkCard").widget().getSelectedId();
                    // 拿到当前网卡中的对象
                    var thisObj = _.find(vmareNetWorkIpInfo.networkadpaters, function(value) {
                        return value.nicMac == mac;
                    });

                    var startipv4Widget = $("#startipv4").widget(),
                        startipv6Widget = $("#startipv6").widget(),
                        ip4Widget = $("#IPv4").widget(),
                        netmaskWidget = $("#IPv4Netmask").widget(),
                        gatewayWidget = $("#IPv4Gateway").widget(),
                        setDnsWidget = $("#IPv4Setdns").widget(),
                        adddnsWidget = $("#IPv4Adddns").widget(),
                        gatewayIpAddr6Widget = $("#gatewayIpAddr6").widget(),
                        setdns6Widget = $("#IPv6Setdns6").widget(),
                        adddns6Widget = $("#IPv6Adddns6").widget();
                    if ("default" == mac) {
                        // 去掉IPv6的红星
                        $scope.isAutoIPv6 = true;
                        // 自灰启用IPv4和IPv6
                        $scope.vmwareScope.ipv4.start.disable = true;
                        $scope.vmwareScope.ipv4.start.checked = false;
                        $scope.vmwareScope.ipv6.start.disable = true;
                        $scope.vmwareScope.ipv6.start.checked = false;
                        // 自灰IPv4
                        $scope.vmwareScope.ipv4.ip.value = "";
                        $scope.vmwareScope.ipv4.subnet.value = "";
                        $scope.vmwareScope.ipv4.gateway.value = "";
                        $scope.vmwareScope.ipv4.preferredDNS.value = "";
                        $scope.vmwareScope.ipv4.alternateDNS.value = "";
                        $scope.vmwareScope.ipv4.ip.disable = true;
                        $scope.vmwareScope.ipv4.subnet.disable = true;
                        $scope.vmwareScope.ipv4.gateway.disable = true;
                        $scope.vmwareScope.ipv4.preferredDNS.disable = true;
                        $scope.vmwareScope.ipv4.alternateDNS.disable = true;
                        $scope.vmwareScope.ipv4.ip.require = false;
                        $scope.vmwareScope.ipv4.subnet.require = false;
                        $scope.vmwareScope.ipv4.gateway.require = false;
                        $scope.vmwareScope.ipv4.preferredDNS.require = false;
                        $scope.vmwareScope.ipv4.ipSetWay.values[0].disable = true;
                        $scope.vmwareScope.ipv4.ipSetWay.values[1].disable = true;
                        $scope.vmwareScope.ipv4.dnsSetWay.values[0].disable = true;
                        $scope.vmwareScope.ipv4.dnsSetWay.values[1].disable = true;
                        $scope.vmwareScope.ipv4.ipSetWay.values[0].checked = true;
                        $scope.vmwareScope.ipv4.ipSetWay.values[1].checked = false;
                        $scope.vmwareScope.ipv4.dnsSetWay.values[0].checked = true;
                        $scope.vmwareScope.ipv4.dnsSetWay.values[1].checked = false;
                        // 自灰IPv6
                        // 自灰自动和手动IP按钮
                        $scope.vmwareScope.ipv6.ipSetWay.values[0].disable = true;
                        $scope.vmwareScope.ipv6.ipSetWay.values[1].disable = true;
                        // 自灰自动和手动DNS按钮
                        $scope.vmwareScope.ipv6.dnsSetWay.values[0].disable = true;
                        $scope.vmwareScope.ipv6.dnsSetWay.values[1].disable = true;
                        // 选中自动IP按钮
                        $scope.vmwareScope.ipv6.ipSetWay.values[0].checked = true;
                        $scope.vmwareScope.ipv6.ipSetWay.values[1].checked = false;
                        // 选中自动DNS按钮
                        $scope.vmwareScope.ipv6.dnsSetWay.values[0].checked = true;
                        $scope.vmwareScope.ipv6.dnsSetWay.values[1].checked = false;
                        // 去掉IPv6的红星
                        $scope.isAutoIPv6 = true;
                        // 自灰并清空IP、掩码
                        $scope.vmwareScope.ipv6.configureInfos = [angular.copy(tempConfigureInfo)];
                        // 自灰网关
                        $scope.vmwareScope.ipv6.gateway.disable = true;
                        $scope.vmwareScope.ipv6.gateway.require = false;
                        $scope.vmwareScope.ipv6.gateway.value = "";
                        // 自灰DNS
                        $scope.vmwareScope.ipv6.preferredDNS.disable = true;
                        $scope.vmwareScope.ipv6.alternateDNS.disable = true;
                        $scope.vmwareScope.ipv6.preferredDNS.require = false;
                        $scope.vmwareScope.ipv6.preferredDNS.value = "";
                        $scope.vmwareScope.ipv6.alternateDNS.value = "";

                        return;
                    };

                    // 恢复启用IPv4和IPv6
                    $scope.vmwareScope.ipv4.start.disable = false;
                    $scope.vmwareScope.ipv6.start.disable = false;

                    // 若启用了IPv4
                    if (!_.isUndefined(thisObj.openIp4) && ("true" == thisObj.openIp4 || true == thisObj.openIp4)) {

                        // 勾上启用IPv4
                        $scope.vmwareScope.ipv4.start.checked = true;
                        // 恢复自动和手动IP按钮
                        $scope.vmwareScope.ipv4.ipSetWay.values[0].disable = false;
                        $scope.vmwareScope.ipv4.ipSetWay.values[1].disable = false;
                        // 恢复自动和手动DNS按钮
                        $scope.vmwareScope.ipv4.dnsSetWay.values[0].disable = false;
                        $scope.vmwareScope.ipv4.dnsSetWay.values[1].disable = false;
                        // 若启用了手动IPv4地址
                        if ("false" == thisObj.dhcpEnabled4 || false == thisObj.dhcpEnabled4) {
                            // 选中手动
                            $scope.vmwareScope.ipv4.ipSetWay.values[0].checked = false;
                            $scope.vmwareScope.ipv4.ipSetWay.values[1].checked = true;
                            // 恢复IP、掩码、网关
                            $scope.vmwareScope.ipv4.ip.disable = false;
                            $scope.vmwareScope.ipv4.subnet.disable = false;
                            $scope.vmwareScope.ipv4.gateway.disable = false;
                            $scope.vmwareScope.ipv4.ip.require = true;
                            $scope.vmwareScope.ipv4.subnet.require = true;
                            $scope.vmwareScope.ipv4.gateway.require = true;
                            // 给IP、掩码、网关赋值
                            $scope.vmwareScope.ipv4.ip.value = thisObj.ip;
                            $scope.vmwareScope.ipv4.subnet.value = thisObj.netmask;
                            $scope.vmwareScope.ipv4.gateway.value = thisObj.gateway;
                        };

                        // 若启用了自动IPv4地址
                        if ("true" == thisObj.dhcpEnabled4 || true == thisObj.dhcpEnabled4) {
                            // 选中自动
                            $scope.vmwareScope.ipv4.ipSetWay.values[0].checked = true;
                            $scope.vmwareScope.ipv4.ipSetWay.values[1].checked = false;
                            // 自灰IP、掩码、网关
                            $scope.vmwareScope.ipv4.ip.disable = true;
                            $scope.vmwareScope.ipv4.subnet.disable = true;
                            $scope.vmwareScope.ipv4.gateway.disable = true;
                            $scope.vmwareScope.ipv4.ip.require = false;
                            $scope.vmwareScope.ipv4.subnet.require = false;
                            $scope.vmwareScope.ipv4.gateway.require = false;
                            // 清空IP、掩码、网关
                            $scope.vmwareScope.ipv4.ip.value = "";
                            $scope.vmwareScope.ipv4.subnet.value = "";
                            $scope.vmwareScope.ipv4.gateway.value = "";
                        };

                        // 若启用了手动DNS地址
                        if ("false" == thisObj.autoDns4 || false == thisObj.autoDns4) {
                            // 选中手动
                            $scope.vmwareScope.ipv4.dnsSetWay.values[0].checked = false;
                            $scope.vmwareScope.ipv4.dnsSetWay.values[1].checked = true;
                            // 恢复DNS
                            $scope.vmwareScope.ipv4.preferredDNS.disable = false;
                            $scope.vmwareScope.ipv4.alternateDNS.disable = false;
                            $scope.vmwareScope.ipv4.preferredDNS.require = true;
                            // 给DNS赋值
                            $scope.vmwareScope.ipv4.preferredDNS.value = thisObj.preferredDns;
                            $scope.vmwareScope.ipv4.alternateDNS.value = thisObj.alternateDns;
                        };

                        // 若启用了自动DNS地址
                        if ("true" == thisObj.autoDns4 || true == thisObj.autoDns4) {
                            // 选中自动
                            $scope.vmwareScope.ipv4.dnsSetWay.values[0].checked = true;
                            $scope.vmwareScope.ipv4.dnsSetWay.values[1].checked = false;
                            // 自灰DNS
                            $scope.vmwareScope.ipv4.preferredDNS.disable = true;
                            $scope.vmwareScope.ipv4.alternateDNS.disable = true;
                            $scope.vmwareScope.ipv4.preferredDNS.require = false;
                            // 清空IP、掩码、网关
                            $scope.vmwareScope.ipv4.preferredDNS.value = "";
                            $scope.vmwareScope.ipv4.alternateDNS.value = "";
                        };
                    } else {
                        // 取消勾选启用IPv4
                        $scope.vmwareScope.ipv4.start.checked = false;
                        $scope.vmwareScope.ipv4.ip.value = "";
                        $scope.vmwareScope.ipv4.subnet.value = "";
                        $scope.vmwareScope.ipv4.gateway.value = "";
                        $scope.vmwareScope.ipv4.preferredDNS.value = "";
                        $scope.vmwareScope.ipv4.alternateDNS.value = "";
                        $scope.vmwareScope.ipv4.ip.disable = true;
                        $scope.vmwareScope.ipv4.subnet.disable = true;
                        $scope.vmwareScope.ipv4.gateway.disable = true;
                        $scope.vmwareScope.ipv4.preferredDNS.disable = true;
                        $scope.vmwareScope.ipv4.alternateDNS.disable = true;
                        $scope.vmwareScope.ipv4.ip.require = false;
                        $scope.vmwareScope.ipv4.subnet.require = false;
                        $scope.vmwareScope.ipv4.gateway.require = false;
                        $scope.vmwareScope.ipv4.preferredDNS.require = false;
                        $scope.vmwareScope.ipv4.ipSetWay.values[0].disable = true;
                        $scope.vmwareScope.ipv4.ipSetWay.values[1].disable = true;
                        $scope.vmwareScope.ipv4.dnsSetWay.values[0].disable = true;
                        $scope.vmwareScope.ipv4.dnsSetWay.values[1].disable = true;
                        $scope.vmwareScope.ipv4.ipSetWay.values[0].checked = true;
                        $scope.vmwareScope.ipv4.ipSetWay.values[1].checked = false;
                        $scope.vmwareScope.ipv4.dnsSetWay.values[0].checked = true;
                        $scope.vmwareScope.ipv4.dnsSetWay.values[1].checked = false;
                    };

                    // 若启用了IPv6
                    if (!_.isUndefined(thisObj.openIp6) && ("true" == thisObj.openIp6 || true == thisObj.openIp6)) {
                        $scope.vmwareScope.ipv6.start.checked = true;
                        // 恢复自动和手动IP按钮
                        $scope.vmwareScope.ipv6.ipSetWay.values[0].disable = false;
                        $scope.vmwareScope.ipv6.ipSetWay.values[1].disable = false;
                        // 恢复自动和手动DNS按钮
                        $scope.vmwareScope.ipv6.dnsSetWay.values[0].disable = false;
                        $scope.vmwareScope.ipv6.dnsSetWay.values[1].disable = false;

                        // 若启用了手动IPv6地址
                        if ("false" == thisObj.dhcpEnabled6 || false == thisObj.dhcpEnabled6) {
                            // 添加IPv6的红星
                            $scope.isAutoIPv6 = false;
                            // 选中手动
                            $scope.vmwareScope.ipv6.ipSetWay.values[0].checked = false;
                            $scope.vmwareScope.ipv6.ipSetWay.values[1].checked = true;
                            // 恢复IP、掩码
                            $scope.vmwareScope.ipv6.configureInfos = [];
                            _.each(thisObj.ipv6List, function(ipv6, index) {
                                var tempConfig = angular.copy(tempConfigureInfo);
                                tempConfig.ip.value = ipv6.address;
                                tempConfig.ip.id = tempConfig.ip.id + index;
                                tempConfig.prefixLength.value = ipv6.prefix;
                                tempConfig.prefixLength.id = tempConfig.prefixLength.id + index;
                                tempConfig.ip.disable = false;
                                tempConfig.removeRow.disable = false;
                                tempConfig.prefixLength.disable = false;
                                $scope.vmwareScope.ipv6.addRow.disable = false;
                                $scope.vmwareScope.ipv6.configureInfos.push(tempConfig);
                            });
                            // 恢复网关并赋值
                            $scope.vmwareScope.ipv6.gateway.disable = false;
                            $scope.vmwareScope.ipv6.gateway.require = true;
                            $scope.vmwareScope.ipv6.gateway.value = thisObj.gateway6;
                        };

                        // 若启用了自动IPv6地址
                        if ("true" == thisObj.dhcpEnabled6 || true == thisObj.dhcpEnabled6) {
                            // 去掉IPv6的红星
                            $scope.isAutoIPv6 = true;
                            // 选中自动
                            $scope.vmwareScope.ipv6.ipSetWay.values[0].checked = true;
                            $scope.vmwareScope.ipv6.ipSetWay.values[1].checked = false;
                            // 自灰网关
                            $scope.vmwareScope.ipv6.gateway.disable = true;
                            $scope.vmwareScope.ipv6.gateway.require = false;
                            $scope.vmwareScope.ipv6.gateway.value = "";
                            // 自灰并清空IP、掩码
                            $scope.vmwareScope.ipv6.configureInfos = [angular.copy(tempConfigureInfo)];
                        };

                        // 若启用了手动DNS地址
                        if ("false" == thisObj.autoDns6 || false == thisObj.autoDns6) {
                            // 选中手动
                            $scope.vmwareScope.ipv6.dnsSetWay.values[0].checked = false;
                            $scope.vmwareScope.ipv6.dnsSetWay.values[1].checked = true;
                            // 恢复DNS
                            $scope.vmwareScope.ipv6.preferredDNS.disable = false;
                            $scope.vmwareScope.ipv6.alternateDNS.disable = false;
                            $scope.vmwareScope.ipv6.preferredDNS.require = true;
                            $scope.vmwareScope.ipv6.preferredDNS.value = thisObj.preferredDns6;
                            $scope.vmwareScope.ipv6.alternateDNS.value = thisObj.alternateDns6;
                        };

                        // 若启用了自动DNS地址
                        if ("true" == thisObj.autoDns6 || true == thisObj.autoDns6) {
                            // 选中自动
                            $scope.vmwareScope.ipv6.dnsSetWay.values[0].checked = true;
                            $scope.vmwareScope.ipv6.dnsSetWay.values[1].checked = false;
                            // 自灰DNS
                            $scope.vmwareScope.ipv6.preferredDNS.disable = true;
                            $scope.vmwareScope.ipv6.alternateDNS.disable = true;
                            $scope.vmwareScope.ipv6.preferredDNS.require = false;
                            $scope.vmwareScope.ipv6.preferredDNS.value = "";
                            $scope.vmwareScope.ipv6.alternateDNS.value = "";
                        };
                    } else {
                        $scope.vmwareScope.ipv6.start.checked = false;

                        // 自灰IPv6
                        // 自灰自动和手动IP按钮
                        $scope.vmwareScope.ipv6.ipSetWay.values[0].disable = true;
                        $scope.vmwareScope.ipv6.ipSetWay.values[1].disable = true;
                        // 自灰自动和手动DNS按钮
                        $scope.vmwareScope.ipv6.dnsSetWay.values[0].disable = true;
                        $scope.vmwareScope.ipv6.dnsSetWay.values[1].disable = true;
                        // 选中自动IP按钮
                        $scope.vmwareScope.ipv6.ipSetWay.values[0].checked = true;
                        $scope.vmwareScope.ipv6.ipSetWay.values[1].checked = false;
                        // 选中自动DNS按钮
                        $scope.vmwareScope.ipv6.dnsSetWay.values[0].checked = true;
                        $scope.vmwareScope.ipv6.dnsSetWay.values[1].checked = false;
                        // 去掉IPv6的红星
                        $scope.isAutoIPv6 = true;
                        // 自灰并清空IP、掩码
                        $scope.vmwareScope.ipv6.configureInfos = [angular.copy(tempConfigureInfo)];
                        // 自灰网关
                        $scope.vmwareScope.ipv6.gateway.disable = true;
                        $scope.vmwareScope.ipv6.gateway.require = false;
                        $scope.vmwareScope.ipv6.gateway.value = "";
                        // 自灰DNS
                        $scope.vmwareScope.ipv6.preferredDNS.disable = true;
                        $scope.vmwareScope.ipv6.alternateDNS.disable = true;
                        $scope.vmwareScope.ipv6.preferredDNS.require = false;
                        $scope.vmwareScope.ipv6.preferredDNS.value = "";
                        $scope.vmwareScope.ipv6.alternateDNS.value = "";
                    };

                };

                $scope.$apply();
            };

            // 用户名、密码、页首段落
            $scope.model = {
                authenticationTips: appUtils.getString("res_vmware_windows_network_tips"),
                labels: {
                    userName: appUtils.getStringWithColon("common_term_username_label"),
                    password: appUtils.getStringWithColon("common_term_password_label")
                },
                userName: {
                    id: "userName",
                    width: constsService.W4,
                    value: "administrator",
                    disable: true,
                    require: true,
                    extendFunction: ["checkUserName"],
                    validate: "checkUserName : extend function;"
                },
                password: {
                    id: "password",
                    width: constsService.W4,
                    value: "",
                    require: true,
                    type: "password",
                    extendFunction: ["checkPassword"],
                    validate: "checkPassword : extend function;",
                    passwordIsFocus: false,
                    focus: function() {
                        this.passwordIsFocus = true;
                        $("#password").widget().option("value", "");
                        $scope.$apply();
                    }
                }
            };
            $scope.userNameMessage = appUtils.getString("recovery_vm_ip_set_username_label");

            $scope.showIpvContainer = false;

            UnifyValid.checkPassword = function() {
                var deviceName = $.trim($("#password").widget().getValue());
                if (!$scope.model.password.require) {
                    return "";
                };
                if (!deviceName) {
                    return appUtils.getString("common_term_empty_label");
                }
                if (deviceName.length < 1 || deviceName.length > 128) {
                    return appUtils.getString("validate_term_expr_length");
                }

                return "";
            };

            UnifyValid.checkUserName = function() {
                var deviceName = $.trim($("#userName").widget().getValue());
                if (!deviceName) {
                    return appUtils.getString("common_term_empty_label");
                }

                if (deviceName.length < 1 || deviceName.length > 128) {
                    return appUtils.getString("validate_term_expr_length");
                }

                return "";
            };

            UnifyValid.checkIPv6 = function() {
                var val = this[0].value;
                if (_.isEmpty(val)) {
                    return appUtils.getString("common_term_empty_label");
                };
                if (!appUtils.validIPv6Address(val)) {
                    return appUtils.getString("validate_term_common_ip_v6_rule_msg");
                }
                return "";
            };

            UnifyValid.checkIPv6AddDNS = function() {
                var val = this[0].value;
                if (_.isEmpty(val)) {
                    return "";
                };
                if (!appUtils.validIPv6Address(val)) {
                    return appUtils.getString("validate_term_common_ip_v6_rule_msg");
                }
                return "";
            };

            UnifyValid.checkIPv4 = function() {
                var val = this[0].value;
                if (_.isEmpty(val)) {
                    return appUtils.getString("common_term_empty_label");
                };
                if (!appUtils.validIPv4Address(val)) {
                    return appUtils.getString("validate_term_common_ip_v4_rule_msg");
                }
                return "";
            };

            UnifyValid.checkIPv4AddDNS = function() {
                var val = this[0].value;
                if (_.isEmpty(val)) {
                    return "";
                };
                if (!appUtils.validIPv4Address(val)) {
                    return appUtils.getString("validate_term_common_ip_v4_rule_msg");
                }
                return "";
            };

            $scope.$on('$destroy', function() {
                delete UnifyValid.checkIPv6;
                delete UnifyValid.checkIPv6AddDNS;
                delete UnifyValid.checkIPv4;
                delete UnifyValid.checkIPv4AddDNS;
                delete UnifyValid.checkUserName;
            });

            var tempConfigureInfo = {
                ip: {
                    id: "ipv6Addr",
                    disable: true,
                    value: "",
                    width: constsService.W5,
                    extendFunction: ["checkIPv6"],
                    validate: "checkIPv6 : extend function;",
                    getValue: function() {
                        return $.trim($("#" + this.id).widget().getValue());
                    }
                },
                prefixLength: {
                    id: "ipv6Prefix",
                    width: 107,
                    value: "",
                    disable: true,
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "rangeValue",
                        params: [0, 128],
                        errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 0, 128)
                    }, {
                        validFn: "integer"
                    }],
                    getValue: function() {
                        return $.trim($("#" + this.id).widget().getValue());
                    }
                },
                removeRow: {
                    disable: true,
                    click: function(row) {
                        if (_.size($scope.vmwareScope.ipv6.configureInfos) == 1) {
                            return;
                        }
                        var index = _.indexOf($scope.vmwareScope.ipv6.configureInfos, row, true);
                        $scope.vmwareScope.ipv6.configureInfos.splice(index, 1);
                        if (_.size($scope.vmwareScope.ipv6.configureInfos) == 1) {
                            _.each($scope.vmwareScope.ipv6.configureInfos, function(configureInfo) {
                                configureInfo.removeRow.disable = true;
                            });
                        }
                        $scope.vmwareScope.ipv6.addRow.disable = !(_.size($scope.vmwareScope.ipv6.configureInfos) < 5);
                        $scope.$apply();
                    }
                }
            }

            // 网卡、IPv4、IPv6
            $scope.vmwareScope = {
                constant: {
                    IPV6_ADDR: appUtils.getString("protect_object_ip_ipv6_label"),
                    NETWORKLEN: appUtils.getString("protect_object_network_length_label"),
                    IPV4TITLE: appUtils.getString("protect_object_ip_set_ipv4_label"),
                    IPV6TITLE: appUtils.getString("protect_object_ip_set_ipv6_label")
                },
                networkCard: {
                    "id": "networkCard",
                    "width": constsService.W4,
                    "autoOpen": false,
                    "require": true,
                    "defaultSelectId": "default",
                    "values": [{
                        "selectId": "default",
                        "label": appUtils.getString("common_term_pleaseSelect_listbox")
                    }],
                    "label": appUtils.getStringWithColon("protect_object_ip_set_networkCard_label"),
                    "closeFn": function(object, evt) {},
                    "change": function() {
                        _initNetworkSettingInfo();
                    },
                    "openFn": function(object) {
                        _savePageData();
                        object.open();
                    }
                },
                ipv4: {
                    start: {
                        id: "startipv4",
                        disable: true,
                        checked: false,
                        require: false,
                        text: appUtils.getString("protect_object_enableIPv4_label"),
                        change: function(event) {
                            var isStart = $("#startipv4").widget().option("checked");

                            if (isStart) {
                                $scope.vmwareScope.ipv4.ip.disable = true;
                                $scope.vmwareScope.ipv4.subnet.disable = true;
                                $scope.vmwareScope.ipv4.gateway.disable = true;
                                $scope.vmwareScope.ipv4.preferredDNS.disable = true;
                                $scope.vmwareScope.ipv4.alternateDNS.disable = true;
                                $scope.vmwareScope.ipv4.ipSetWay.values[0].disable = false;
                                $scope.vmwareScope.ipv4.ipSetWay.values[1].disable = false;
                                $scope.vmwareScope.ipv4.dnsSetWay.values[0].disable = false;
                                $scope.vmwareScope.ipv4.dnsSetWay.values[1].disable = false;
                                $scope.vmwareScope.ipv4.ipSetWay.values[0].checked = true;
                                $scope.vmwareScope.ipv4.ipSetWay.values[1].checked = false;
                                $scope.vmwareScope.ipv4.dnsSetWay.values[0].checked = true;
                                $scope.vmwareScope.ipv4.dnsSetWay.values[1].checked = false;
                                $scope.$apply();
                                return;
                            };
                            $scope.vmwareScope.ipv4.ip.value = "";
                            $scope.vmwareScope.ipv4.subnet.value = "";
                            $scope.vmwareScope.ipv4.gateway.value = "";
                            $scope.vmwareScope.ipv4.preferredDNS.value = "";
                            $scope.vmwareScope.ipv4.alternateDNS.value = "";
                            $scope.vmwareScope.ipv4.ip.disable = true;
                            $scope.vmwareScope.ipv4.subnet.disable = true;
                            $scope.vmwareScope.ipv4.gateway.disable = true;
                            $scope.vmwareScope.ipv4.preferredDNS.disable = true;
                            $scope.vmwareScope.ipv4.alternateDNS.disable = true;
                            $scope.vmwareScope.ipv4.ip.require = false;
                            $scope.vmwareScope.ipv4.subnet.require = false;
                            $scope.vmwareScope.ipv4.gateway.require = false;
                            $scope.vmwareScope.ipv4.preferredDNS.require = false;
                            $scope.vmwareScope.ipv4.ipSetWay.values[0].disable = true;
                            $scope.vmwareScope.ipv4.ipSetWay.values[1].disable = true;
                            $scope.vmwareScope.ipv4.dnsSetWay.values[0].disable = true;
                            $scope.vmwareScope.ipv4.dnsSetWay.values[1].disable = true;
                            $scope.vmwareScope.ipv4.ipSetWay.values[0].checked = true;
                            $scope.vmwareScope.ipv4.ipSetWay.values[1].checked = false;
                            $scope.vmwareScope.ipv4.dnsSetWay.values[0].checked = true;
                            $scope.vmwareScope.ipv4.dnsSetWay.values[1].checked = false;
                            $scope.$apply();
                        }
                    },
                    ipSetWay: {
                        id: "IPv4SetWay",
                        values: [{
                            "key": "auto",
                            "text": appUtils.getString("protect_object_ip_get_auto_label"),
                            "checked": true,
                            "disable": true
                        }, {
                            "key": "manual",
                            "text": appUtils.getString("protect_object_ip_set_manual_label"),
                            "disable": true
                        }],
                        space: {
                            "height": "23px"
                        },
                        layout: "vertical",
                        labelcls: "tiny_formfield_label_hide",
                        contentTdAttr: {
                            colspan: "2"
                        },
                        ipSetChange: function() {
                            var IPv4SetWay = $("#IPv4SetWay").widget().opChecked("checked");
                            if ("auto" == IPv4SetWay) {
                                $scope.vmwareScope.ipv4.ip.value = "";
                                $scope.vmwareScope.ipv4.subnet.value = "";
                                $scope.vmwareScope.ipv4.gateway.value = "";
                                $scope.vmwareScope.ipv4.ip.require = false;
                                $scope.vmwareScope.ipv4.subnet.require = false;
                                $scope.vmwareScope.ipv4.gateway.require = false;
                                $scope.vmwareScope.ipv4.ip.disable = true;
                                $scope.vmwareScope.ipv4.subnet.disable = true;
                                $scope.vmwareScope.ipv4.gateway.disable = true;
                            } else {
                                $scope.vmwareScope.ipv4.ip.require = true;
                                $scope.vmwareScope.ipv4.subnet.require = true;
                                $scope.vmwareScope.ipv4.gateway.require = true;
                                $scope.vmwareScope.ipv4.ip.disable = false;
                                $scope.vmwareScope.ipv4.subnet.disable = false;
                                $scope.vmwareScope.ipv4.gateway.disable = false;
                            }
                            $scope.$apply();
                        }
                    },
                    ip: {
                        id: "IPv4",
                        type: "ipv4",
                        disable: true,
                        require: false,
                        value: "",
                        width: constsService.W3,
                        label: appUtils.getStringWithColon("protect_object_ip_label"),
                        extendFunction: ["checkIPv4"],
                        validate: "checkIPv4 : extend function;"
                    },
                    subnet: {
                        id: "IPv4Netmask",
                        type: "ipv4",
                        disable: true,
                        value: "",
                        require: false,
                        width: constsService.W3,
                        label: appUtils.getStringWithColon("protect_object_dns_netmask_label"),
                        validate: constsService.VALID.union("required", constsService.VALID.MASK)
                    },
                    gateway: {
                        id: "IPv4Gateway",
                        type: "ipv4",
                        disable: true,
                        value: "",
                        require: false,
                        width: constsService.W3,
                        label: appUtils.getStringWithColon("protect_object_dns_gateway_label"),
                        validate: constsService.VALID.IP_STANDARD
                    },
                    dnsSetWay: {
                        id: "IPv4DnsSetWay",
                        values: [{
                            "key": "auto",
                            "text": appUtils.getString("protect_object_dns_get_auto_label"),
                            "checked": true,
                            "disable": true
                        }, {
                            "key": "manual",
                            "text": appUtils.getString("protect_object_dns_set_manuallabel"),
                            "disable": true
                        }],
                        space: {
                            "height": "23px"
                        },
                        layout: "vertical",
                        labelcls: "tiny_formfield_label_hide",
                        contentTdAttr: {
                            colspan: "2"
                        },
                        dnsSetChange: function() {
                            var IPv4DnsSetWay = $("#IPv4DnsSetWay").widget().opChecked("checked");
                            if ("auto" == IPv4DnsSetWay) {
                                $scope.vmwareScope.ipv4.preferredDNS.value = "";
                                $scope.vmwareScope.ipv4.alternateDNS.value = "";
                                $scope.vmwareScope.ipv4.preferredDNS.require = false;
                                $scope.vmwareScope.ipv4.preferredDNS.disable = true;
                                $scope.vmwareScope.ipv4.alternateDNS.disable = true;
                            } else {
                                $scope.vmwareScope.ipv4.preferredDNS.require = true;
                                $scope.vmwareScope.ipv4.preferredDNS.disable = false;
                                $scope.vmwareScope.ipv4.alternateDNS.disable = false;
                            }
                        }
                    },
                    preferredDNS: {
                        id: "IPv4Setdns",
                        type: "ipv4",
                        disable: true,
                        value: "",
                        require: false,
                        width: constsService.W3,
                        label: appUtils.getStringWithColon("protect_object_dns_first_choose_label"),
                        extendFunction: ["checkIPv4"],
                        validate: "checkIPv4 : extend function;"
                    },
                    alternateDNS: {
                        id: "IPv4Adddns",
                        type: "ipv4",
                        disable: true,
                        require: false,
                        value: "",
                        width: constsService.W3,
                        label: appUtils.getStringWithColon("protect_object_dns_reserve_label"),
                        extendFunction: ["checkIPv4AddDNS"],
                        validate: "checkIPv4AddDNS : extend function;"
                    }
                },
                ipv6: {
                    start: {
                        "id": "startipv6",
                        "text": appUtils.getString("protect_object_enableIPv6_label"),
                        "checked": false,
                        "disable": true,
                        "change": function(event) {
                            var isStart = $("#startipv6").widget().option("checked");
                            if (isStart) {
                                // 恢复自动和手动IP按钮
                                $scope.vmwareScope.ipv6.ipSetWay.values[0].disable = false;
                                $scope.vmwareScope.ipv6.ipSetWay.values[1].disable = false;
                                // 恢复自动和手动DNS按钮
                                $scope.vmwareScope.ipv6.dnsSetWay.values[0].disable = false;
                                $scope.vmwareScope.ipv6.dnsSetWay.values[1].disable = false;
                            } else {
                                // 自灰自动和手动IP按钮
                                $scope.vmwareScope.ipv6.ipSetWay.values[0].disable = true;
                                $scope.vmwareScope.ipv6.ipSetWay.values[1].disable = true;
                                // 自灰自动和手动DNS按钮
                                $scope.vmwareScope.ipv6.dnsSetWay.values[0].disable = true;
                                $scope.vmwareScope.ipv6.dnsSetWay.values[1].disable = true;
                            };

                            // 选中自动IP按钮
                            $scope.vmwareScope.ipv6.ipSetWay.values[0].checked = true;
                            $scope.vmwareScope.ipv6.ipSetWay.values[1].checked = false;
                            // 选中自动DNS按钮
                            $scope.vmwareScope.ipv6.dnsSetWay.values[0].checked = true;
                            $scope.vmwareScope.ipv6.dnsSetWay.values[1].checked = false;
                            // 去掉IPv6的红星
                            $scope.isAutoIPv6 = !isStart;
                            // 自灰并清空IP、掩码
                            _.each($scope.vmwareScope.ipv6.configureInfos, function(configureInfos, index) {
                                configureInfos.ip.disable = !isStart;
                                configureInfos.ip.value = "";
                                configureInfos.prefixLength.disable = !isStart;
                                configureInfos.prefixLength.value = "";
                                configureInfos.removeRow.disable = !isStart;
                            });

                            // 自灰网关
                            $scope.vmwareScope.ipv6.gateway.disable = !isStart;
                            $scope.vmwareScope.ipv6.gateway.require = isStart;
                            $scope.vmwareScope.ipv6.gateway.value = "";
                            $scope.vmwareScope.ipv6.addRow.disable = !isStart;
                            // 自灰DNS
                            $scope.vmwareScope.ipv6.preferredDNS.disable = true;
                            $scope.vmwareScope.ipv6.alternateDNS.disable = true;
                            $scope.vmwareScope.ipv6.preferredDNS.require = false;
                            $scope.vmwareScope.ipv6.preferredDNS.value = "";
                            $scope.vmwareScope.ipv6.alternateDNS.value = "";
                            $scope.$apply();
                        }
                    },
                    ipSetWay: {
                        id: "IPv6SetWay",
                        values: [{
                            "key": "auto",
                            "text": appUtils.getString("protect_object_ip_get_auto_label"),
                            "checked": true,
                            "disable": true
                        }, {
                            "key": "manual",
                            "text": appUtils.getString("protect_object_ip_set_manual_label"),
                            "disable": true
                        }],
                        space: {
                            "height": "23px"
                        },
                        layout: "vertical",
                        ipSetChange: function() {
                            var IPv6SetWay = $("#IPv6SetWay").widget().opChecked("checked");
                            if ("auto" == IPv6SetWay) {
                                // 去掉IPv6的红星
                                $scope.isAutoIPv6 = true;
                                // 自灰并清空IP、掩码
                                $scope.vmwareScope.ipv6.configureInfos = [angular.copy(tempConfigureInfo)];
                                // 自灰网关
                                $scope.vmwareScope.ipv6.gateway.disable = true;
                                $scope.vmwareScope.ipv6.gateway.require = false;
                                $scope.vmwareScope.ipv6.gateway.value = "";
                                $scope.$apply();
                            } else {
                                // 添加IPv6的红星
                                $scope.isAutoIPv6 = false;
                                // 恢复IP、掩码
                                $scope.vmwareScope.ipv6.configureInfos = [];
                                var tempConfig = angular.copy(tempConfigureInfos);
                                $scope.vmwareScope.ipv6.configureInfos.push(tempConfig);
                                // 恢复网关
                                $scope.vmwareScope.ipv6.gateway.disable = false;
                                $scope.vmwareScope.ipv6.gateway.require = true;
                                $scope.$apply();
                            }
                        }
                    },
                    configureInfos: [angular.copy(tempConfigureInfo)],
                    gateway: {
                        id: "gatewayIpAddr6",
                        disable: true,
                        require: false,
                        width: 405,
                        value: "",
                        label: appUtils.getStringWithColon("protect_object_dns_gateway_label"),
                        extendFunction: ["checkIPv6"],
                        validate: "checkIPv6 : extend function;"
                    },
                    dnsSetWay: {
                        id: "IPv6DnsSetWay",
                        values: [{
                            "key": "auto",
                            "text": appUtils.getString("protect_object_dns_get_auto_label"),
                            "checked": true,
                            "disable": true
                        }, {
                            "key": "manual",
                            "text": appUtils.getString("protect_object_dns_set_manuallabel"),
                            "disable": true
                        }],
                        space: {
                            "height": "23px"
                        },
                        layout: "vertical",
                        labelcls: "tiny_formfield_label_hide",
                        contentTdAttr: {
                            colspan: "2"
                        },
                        dnsSetChange: function() {
                            var IPv6DnsSetWay = $("#IPv6DnsSetWay").widget().opChecked("checked");
                            if ("auto" == IPv6DnsSetWay) {
                                $scope.vmwareScope.ipv6.preferredDNS.disable = true;
                                $scope.vmwareScope.ipv6.alternateDNS.disable = true;
                                $scope.vmwareScope.ipv6.preferredDNS.require = false;
                                $scope.vmwareScope.ipv6.preferredDNS.value = "";
                                $scope.vmwareScope.ipv6.alternateDNS.value = "";
                            } else {
                                $scope.vmwareScope.ipv6.preferredDNS.disable = false;
                                $scope.vmwareScope.ipv6.alternateDNS.disable = false;
                                $scope.vmwareScope.ipv6.preferredDNS.require = true;
                            }
                        }
                    },
                    preferredDNS: {
                        id: "IPv6Setdns6",
                        disable: true,
                        require: false,
                        width: 405,
                        value: "",
                        label: appUtils.getStringWithColon("protect_object_dns_first_choose_label"),
                        extendFunction: ["checkIPv6"],
                        validate: "checkIPv6 : extend function;"
                    },
                    alternateDNS: {
                        id: "IPv6Adddns6",
                        disable: true,
                        require: false,
                        width: 405,
                        value: "",
                        label: appUtils.getStringWithColon("protect_object_dns_reserve_label"),
                        extendFunction: ["checkIPv6AddDNS"],
                        validate: "checkIPv6AddDNS : extend function;"
                    },
                    addRow: {
                        text: appUtils.getString("common_term_addline_button"),
                        disable: true,
                        click: function() {
                            if (_.size($scope.vmwareScope.ipv6.configureInfos) == 5
                                || $scope.vmwareScope.ipv6.addRow.disable) {
                                return;
                            }

                            var tempConfigs = $scope.vmwareScope.ipv6.configureInfos,
                                size = _.size(tempConfigs);
                            _.each(tempConfigs, function(config) {
                                config.ip.disable = false;
                                config.prefixLength.disable = false;
                                config.removeRow.disable = false;
                            }, tempConfigs);

                            var tempObj = angular.copy(tempConfigureInfo);
                            tempObj.ip.disable = false;
                            tempObj.prefixLength.disable = false;
                            tempObj.ip.id = !_.size(tempConfigs) ? tempObj.ip.id + size : _.last(tempConfigs).ip.id + size;
                            tempObj.prefixLength.id = !_.size(tempConfigs) ? tempObj.prefixLength.id + size : _.last(tempConfigs).prefixLength.id + size;
                            tempObj.removeRow.disable = false;
                            $scope.vmwareScope.ipv6.configureInfos.push(tempObj);
                            $scope.vmwareScope.ipv6.addRow.disable = _.size($scope.vmwareScope.ipv6.configureInfos) == 5;
                            $scope.$apply();
                        }
                    }
                }
            };

            // 保存当前页面数据的方法，改变下拉框或者点击确定的时候触发
            function _savePageData() {
                // 若查询结果中当前没有网卡
                if (_.isUndefined(vmareNetWorkIpInfo)) {
                    return;
                };

                // 拿到当前选择的网卡
                var mac = $("#networkCard").widget().getSelectedId();
                // 若是默认选项
                if ("default" == mac) {
                    return;
                };
                // 拿到当前网卡中的对象
                var thisObj = _.find(vmareNetWorkIpInfo.networkadpaters, function(value) {
                    return value.nicMac == mac;
                });
                // 把表格中的值赋给thisObj
                thisObj.openIp4 = $("#startipv4").widget().option("checked");
                thisObj.dhcpEnabled4 = "auto" == $("#IPv4SetWay").widget().opChecked("checked");
                thisObj.ip = $("#IPv4").widget().getValue();
                thisObj.netmask = $("#IPv4Netmask").widget().getValue();
                thisObj.gateway = $("#IPv4Gateway").widget().getValue();
                thisObj.autoDns4 = "auto" == $("#IPv4DnsSetWay").widget().opChecked("checked");
                thisObj.preferredDns = $("#IPv4Setdns").widget().getValue();
                thisObj.alternateDns = $("#IPv4Adddns").widget().getValue();
                thisObj.openIp6 = $("#startipv6").widget().option("checked");
                thisObj.dhcpEnabled6 = false; //只有手动
        	    thisObj.ipv6List = function() {
                    var ipv6Infos = [];
                    thisObj.openIp6 && _.each($scope.vmwareScope.ipv6.configureInfos, function(config) {
                        ipv6Infos.push({
                            address: config.ip.getValue(),
                            prefix: config.prefixLength.getValue()
                        })
                    });
                    return ipv6Infos;
                }();
                thisObj.gateway6 = $("#gatewayIpAddr6").widget().getValue();
                thisObj.autoDns6 = "auto" == $("#IPv6DnsSetWay").widget().opChecked("checked");
                thisObj.preferredDns6 = $("#IPv6Setdns6").widget().getValue();
                thisObj.alternateDns6 = $("#IPv6Adddns6").widget().getValue();
                // 拿到当前网卡的index，并把thisObj替换到vmareNetWorkIpInfo
                var thisIndex = _.findIndex(vmareNetWorkIpInfo.networkadpaters, {
                    "nicMac": thisObj.nicMac
                });
                _.each(vmareNetWorkIpInfo.networkadpaters, function(networkadpater) {
                    !networkadpater.openIp6 && (networkadpater.ipv6List = []);
                });
                _.extend(vmareNetWorkIpInfo.networkadpaters[thisIndex], thisObj);
                vmareNetWorkIpInfo.username = $("#userName").widget().getValue();
                vmareNetWorkIpInfo.password = !$scope.model.password.passwordIsFocus ? "" : $("#password").widget().getValue();
                return vmareNetWorkIpInfo;
            };

            function init() {
                var params = $("#" + constsService.VMWARE_WINDOWS_NETWORK_SET_WIN.winId).widget().option("data");
                !_.isEmpty(params) && restService.getVmareNetWorkIpInfo({
                    planId: params.planId,
                    poId: params.poId
                }, function(result) {
                    var array = [{
                        "selectId": "default",
                        "checked": false,
                        "label": appUtils.getString("common_term_pleaseSelect_listbox")
                    }];
                    if (!_.isEmpty(result)) {
                        $scope.showIpvContainer = true;
                        vmareNetWorkIpInfo = result;
                        _.each(result.networkadpaters, function(network, index) {
                            var opt = {
                                "selectId": network.nicMac,
                                "checked": index == 0,
                                "label": appUtils.encodeForHTML(network.nicName)
                            };
                            array.push(opt);
                        });
                        $scope.vmwareScope.networkCard.values = array;
                        $scope.vmwareScope.networkCard.defaultSelectId = result.networkadpaters[0].nicMac;
                        $timeout(function() {
                            _initNetworkSettingInfo();
                        }, 0)
                        if (!_.isEmpty(result.username)) {
                            $scope.model.userName.value = result.username;
                            $scope.model.password.value = "********";
                            $scope.model.password.require = false;
                        };
                        // 去掉IPv6的红星
                        $scope.isAutoIPv6 = true;
                        $scope.$apply();
                    };
                });
            };

            init();

        }
    ]
    var module = angular.module("recoverydirector.recovery.config");
    module.tinyController("vmware.win.ipSetCtrl", ipSetCtrl);
    return module;

});
