define(["tiny-widgets/Window"],
    function(Window) {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$compile",
            "$timeout",
            "message",
            "restService",
            "constsService",
            "appUtils",
            "exception",
            "statusEnumService",
            "recoveryService",
            "servicesPlugin",
            function($scope, $state, $compile, $timeout, message, restService, constsService, appUtils, exception, statusEnumService, recoveryService, servicesPlugin) {
                $scope.drProjectName = {};
                $scope.drRegionName = {};
                $scope.regionName = {};
                var planId;
                var scrollTop = 0;
                var _startPage = 0,
                    _pageSize = 10,
                    _orderBy,
                    _orderType,
                    _name,
                    _appType,
                    _planStatus,
                    _regionId,
                    _azId,
                    _projectId,
                    _instProtectType;
                var remoteOpAreaConfig = [{
                        id: "iconBtnTest",
                        authKey: "ism.drm.drp.auth.test",
                        template: "<div class='iconbutton-test-disabled' title='" + appUtils.getString('common_term_test_button') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnTest div").hasClass("iconbutton-test")) {
                                return;
                            }
                            var __params = _getHoverData();
                            var __extendParams = {
                                $scope: $scope,
                                $state: $state
                            };
                            if ((__params.poType == 10 && _.contains([2, 19], __params.templateType) && __params.planType == 1) || __params.planType == 2) {
                                __extendParams.action = "test";
                            } else {
                                //华为虚拟机的存储双活+存储快照的本地测试
                                if (__params.poType == 12 && __params.templateType == 19) {
                                    __extendParams.action = "fusionsphereLocalTest";
                                } else {
                                    __extendParams.action = "localTest";
                                }
                            }
                            recoveryService.execute(_.extend(__params, __extendParams));
                        },
                        mouseActive: function(data) {
                            var testStatus = {
                                enable: [0, 8, 18, 19, 20],
                                disable: [1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 15, 16, 17, 99]
                            };
                            //云双活屏蔽接口
                            if (data["templateType"] == 25 && data["poType"] == 12){
                                $("#iconBtnTest div").removeClass("iconbutton-test").addClass("iconbutton-test-disabled");
                                return;
                            }
                            //VHA+CSDR屏蔽测试、清理操作
                            if(_.contains([34,37], +data["templateType"]) && data["poType"] == 12){
                                $("#iconBtnTest div").removeClass("iconbutton-test").addClass("iconbutton-test-disabled");
                                return;
                            }
                            //云主备屏蔽测试、清理操作
                            if (data["serviceInstanceType"] == "replication" && data["poType"] == 12){
                                $("#iconBtnTest div").removeClass("iconbutton-test").addClass("iconbutton-test-disabled");
                                return;
                            }
                            //纯NAS的双活+复制屏蔽测试操作,appType="14" procType="2" protectionType="18,20"
                            if(data["poType"] == 14 && (data["templateType"] == 18 || data["templateType"] == 20)){
                                $("#iconBtnTest div").removeClass("iconbutton-test").addClass("iconbutton-test-disabled");
                                return;
                            }
                            //NAS的双活+复制没有测试操作（包含FC、FM、VMvare、纯NAS)
                            if(_.contains([10,12,14],parseInt(data["poType"],10)) && data["isNasHyperCopy"] && _.contains([18,20],parseInt(data["templateType"],10))){
                                $("#iconBtnTest div").removeClass("iconbutton-test").addClass("iconbutton-test-disabled");
                                return;
                            }

                            if (_.contains(testStatus.disable, data["planStatus"]) || (data["templateType"] == 1 && data["templateSubType"] == 2 && data["poType"] == 10) || data["templateType"] == 14 && data["poType"] == 10 || data["templateType"] == 17 && data["poType"] == 10) {
                                $("#iconBtnTest div").removeClass("iconbutton-test").addClass("iconbutton-test-disabled");
                                return;
                            }
                            //NAS的异步复制不支持测试
                            if (data["templateType"] == 1 && data["poType"] == 14) {
                                $("#iconBtnTest div").removeClass("iconbutton-test").addClass("iconbutton-test-disabled");
                                return;
                            }

                            $("#iconBtnTest div").removeClass("iconbutton-test-disabled").addClass("iconbutton-test");
                        }
                    }, {
                        id: "iconBtnClear",
                        authKey: "ism.drm.drp.auth.cleartest",
                        template: "<div class='conbutton-clear-disabled' title='" + appUtils.getString('common_term_clear_button') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnClear div").hasClass("conbutton-clear")) {
                                return;
                            }
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "clear",
                                $scope: $scope,
                                $state: $state
                            }));
                        },
                        mouseActive: function(data) {
                            var clearStatus = {
                                disable: [0, 1, 2, 3, 4, 7, 8, 10, 11, 12, 15, 16, 17, 18, 19, 20, 99],
                                enable: [5, 6, 9]
                            };
                            //云双活屏蔽接口
                            if (data["templateType"] == 25 && data["poType"] == 12){
                                $("#iconBtnClear div").removeClass("conbutton-clear").addClass("conbutton-clear-disabled");
                                return;
                            }
                            //VHA+CSDR屏蔽接口
                            if (_.contains([34,37], +data["templateType"]) && data["poType"] == 12){
                                $("#iconBtnClear div").removeClass("conbutton-clear").addClass("conbutton-clear-disabled");
                                return;
                            }
                            //云主备屏蔽接口
                            if (data["serviceInstanceType"] == "replication" && data["poType"] == 12){
                                $("#iconBtnClear div").removeClass("conbutton-clear").addClass("conbutton-clear-disabled");
                                return;
                            }

                            if (_.contains(clearStatus.disable, data["planStatus"]) || (data["templateType"] == 1 && data["templateSubType"] == 2 && data["poType"] == 10) || data["templateType"] == 14 && data["poType"] == 10) {
                                $("#iconBtnClear div").removeClass("conbutton-clear").addClass("conbutton-clear-disabled");
                                return;
                            }
                            $("#iconBtnClear div").removeClass("conbutton-clear-disabled").addClass("conbutton-clear");
                        }
                    }, {
                        id: "iconHotMigration",
                        authKey: "ism.drm.drp.auth.planed.hotmigration",
                        template: "<div class='iconbutton-hotMigration-disabled' title='" + appUtils.getString('ism.drm.drp.auth.planed.hotmigration') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconHotMigration div").hasClass("iconbutton-hotMigration")) {
                                return;
                            }
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "hotMigration",
                                $scope: $scope,
                                $state: $state
                            }));
                        },
                        mouseActive: function(data) {
                            var enable = [0, 8, 20, 30];
                            if(window.isPrivateConsole && _.isEmpty($scope.regionInfo) && data['props'] && data['props']['instProtectType'] == "csha_csdr") {
                                $("#iconHotMigration div").removeClass("iconbutton-hotMigration").addClass("iconbutton-hotMigration-disabled");
                                return;
                            }
                            if (_.contains(enable, data["planStatus"])) {
                                $("#iconHotMigration div").removeClass("iconbutton-hotMigration-disabled").addClass("iconbutton-hotMigration");
                                return;
                            }
                            $("#iconHotMigration div").removeClass("iconbutton-hotMigration").addClass("iconbutton-hotMigration-disabled");
                        }
                    }, {
                        id: "iconMigration",
                        authKey: "ism.drm.drp.auth.planed.motion",
                        template: "<div class='iconbutton-migration-disabled' title='" + appUtils.getString('common_term_plan_move_button') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconMigration div").hasClass("iconbutton-migration")) {
                                return;
                            }
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "move",
                                $scope: $scope,
                                $state: $state
                            }));
                        },
                        mouseActive: function(data) {
                            var disable = [1, 2, 4, 5, 6, 7, 9, 10, 11, 12, 15, 16, 17, 18, 19, 99];

                            if(window.isPrivateConsole && _.isEmpty($scope.regionInfo) && data['props'] && data['props']['instProtectType'] == "csha_csdr") {
                                $("#iconMigration div").removeClass("iconbutton-migration").addClass("iconbutton-migration-disabled");
                                return;
                            }
                            if (_.contains(disable, data["planStatus"])) {
                                $("#iconMigration div").removeClass("iconbutton-migration").addClass("iconbutton-migration-disabled");
                                //CDM已完成回滚、回滚失败可以迁移
                                if(_.contains([18,19], data["planStatus"]) && _.contains([30,31,32], parseInt(data["templateType"],10))){
                                    $("#iconMigration div").removeClass("iconbutton-migration-disabled").addClass("iconbutton-migration");
                                };
                                return;
                            }
                            if ((_.contains([0, 3, 8, 20, 30], data["planStatus"]))) {
                                $("#iconMigration div").removeClass("iconbutton-migration-disabled").addClass("iconbutton-migration");
                                return;
                            }
                            $("#iconMigration div").removeClass("iconbutton-migration").addClass("iconbutton-migration-disabled");
                        }
                    }, {
                        id: "iconBtnProtected",
                        authKey: "ism.drm.drp.auth.reprotect",
                        template: "<div class='iconbutton-protect-disabled' title='" + appUtils.getString('common_term_protect_button') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnProtected div").hasClass("iconbutton-protect")) {
                                return;
                            }
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "reprotect",
                                $scope: $scope,
                                $state: $state
                            }));
                        },
                        mouseActive: function(data) {
                            var disable = [0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 12, 15, 17, 18, 19, 20, 99];
                            //NAS的双活+复制故障恢复后没有重保护操作（包含FC、FM、VMvare、纯NAS)
                            if(_.contains([10,12,14],parseInt(data["poType"],10)) && data["isNasHyperCopy"] && data["planStatus"] == "11" && _.contains([18],parseInt(data["templateType"],10))){
                                $("#iconBtnProtected div").removeClass("iconbutton-protect").addClass("iconbutton-protect-disabled");
                                return;
                            }
                            if (_.contains(disable, data["planStatus"])) {
                                $("#iconBtnProtected div").removeClass("iconbutton-protect").addClass("iconbutton-protect-disabled");
                                return;
                            }
                            if (_.contains([2, 11, 16], data["planStatus"])) {
                                $("#iconBtnProtected div").removeClass("iconbutton-protect-disabled").addClass("iconbutton-protect");
                                return;
                            }
                            $("#iconBtnProtected div").removeClass("iconbutton-protect").addClass("iconbutton-protect-disabled");
                        }
                    }, {
                        id: "iconBtnFaultRecovery",
                        authKey: "ism.drm.drp.auth.disaster.recovery",
                        template: "<div class='iconbutton-fault-recovery-disabled' title='" + appUtils.getString('ism.drm.protect.group.fault.recovery.label') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnFaultRecovery div").hasClass("iconbutton-fault-recovery")) {
                                return;
                            }
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "fault",
                                $scope: $scope,
                                $state: $state
                            }));
                        },
                        mouseActive: function(data) {
                            var disable = [1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 15, 16, 17, 18, 19, 99];

                            if(window.isPrivateConsole && _.isEmpty($scope.regionInfo) && data['props'] && data['props']['instProtectType'] == "csha_csdr") {
                                $("#iconBtnFaultRecovery div").removeClass("iconbutton-fault-recovery").addClass("iconbutton-fault-recovery-disabled");
                                return;
                            }
                            //云双活屏蔽接口
                            if (data["planStatus"] == 11 && data["templateType"] == 37 && data.props.RECOVERY_REGION_TYPE == "REGION_TYPE_WITHIN" && data.props.originalAvailableRegion == data.props.regionId) {
                                $("#iconBtnFaultRecovery div").removeClass("iconbutton-fault-recovery-disabled").addClass("iconbutton-fault-recovery");
                                return;
                            };
                            if (_.contains(disable, data["planStatus"]) || data["isAllowExecute"] == 0) {
                                $("#iconBtnFaultRecovery div").removeClass("iconbutton-fault-recovery").addClass("iconbutton-fault-recovery-disabled");
                                //CDM已完成回滚、回滚失败可以迁移
                                if(_.contains([18,19], data["planStatus"]) && _.contains([30,31,32], parseInt(data["templateType"],10)) && data["isAllowExecute"] != 0){
                                    $("#iconBtnFaultRecovery div").removeClass("iconbutton-fault-recovery-disabled").addClass("iconbutton-fault-recovery");
                                };
                                return;
                            }
                            if (_.contains([0, 8, 12, 20], data["planStatus"])) {
                                $("#iconBtnFaultRecovery div").removeClass("iconbutton-fault-recovery-disabled").addClass("iconbutton-fault-recovery");
                                return;
                            }
                            $("#iconBtnFaultRecovery div").removeClass("iconbutton-fault-recovery").addClass("iconbutton-fault-recovery-disabled");
                        }
                    }, {
                        id: "iconBtnEdit",
                        authKey: "ism.drm.drp.auth.modify",
                        template: "<div class='iconbutton-edit-disabled' title='" + appUtils.getString('common_term_edit_button') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnEdit div").hasClass("iconbutton-edit")) {
                                return;
                            }
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "edit",
                                $scope: $scope
                            }));
                        },
                        mouseActive: function(data) {
                            var disable = [1, 2, 4, 7, 10, 11, 15, 17, 99],
                                enable = [0, 3, 5, 6, 8, 9, 12, 16, 18, 19, 20];
                            //CSHA，VHA+CSDR，CSDR
                            if ((_.contains([25, 34, 37], +data["templateType"]) || data["serviceInstanceType"] == "replication") && data["poType"] == 12) {
                                $("#iconBtnEdit div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                                return;
                            }

                            if (_.contains(disable, data["planStatus"])) {
                                $("#iconBtnEdit div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                                return;
                            }
                            if (_.contains(enable, data["planStatus"])) {
                                $("#iconBtnEdit div").removeClass("iconbutton-edit-disabled").addClass("iconbutton-edit");
                                return;
                            }

                            $("#iconBtnEdit div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                        }
                    }, {
                        id: "iconBtnDel",
                        authKey: "ism.drm.drp.auth.delete",
                        template: "<div class='iconbutton-delete-disabled' title='" + appUtils.getString('common_term_delete_button') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnDel div").hasClass("iconbutton-delete")) {
                                return;
                            }
                            _startPage = 0;
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "del",
                                $scope: $scope
                            }));
                        },
                        mouseActive: function(data) {
                            var enable = [0, 2, 3, 5, 6, 8, 9, 11, 12, 16, 18, 19, 20],
                                disable = [1, 4, 7, 10, 15, 17, 99];
                            //CSHA，VHA+CSDR，CSDR
                            if ((_.contains([25, 34, 37], +data["templateType"]) || data["serviceInstanceType"] == "replication") && data["poType"] == 12) {
                                $("#iconBtnDel div").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                                return;
                            }

                            if (_.contains(disable, data["planStatus"])) {
                                $("#iconBtnDel div").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                                return;
                            }
                            if (_.contains(enable, data["planStatus"])) {
                                $("#iconBtnDel div").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
                                return
                            }
                            $("#iconBtnDel div").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                        }
                    }],
                    localOpAreaConfig = [{
                        id: "iconBtnTest",
                        authKey: "ism.drm.drp.auth.test",
                        template: "<div class='iconbutton-test-disabled' title='" + appUtils.getString('common_term_test_button') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnTest div").hasClass("iconbutton-test")) {
                                return;
                            }
                            var __params = _getHoverData();
                            var __extendParams = {
                                $scope: $scope,
                                $state: $state
                            };
                            if ((__params.poType == 10 && _.contains([2, 19], __params.templateType) && __params.planType == 1) || __params.planType == 2) {
                                __extendParams.action = "test";
                            } else {
                                //华为虚拟机的存储双活+存储快照的本地测试
                                if (__params.poType == 12 && __params.templateType == 19) {
                                    __extendParams.action = "fusionsphereLocalTest";
                                } else {
                                    __extendParams.action = "localTest";
                                }
                            }
                            recoveryService.execute(_.extend(__params, __extendParams));
                        },
                        mouseActive: function(data) {
                            var testStatus = {
                                enable: [0, 8, 18, 19, 20],
                                disable: [1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 15, 16, 17]
                            };
                            if (_.contains(testStatus.disable, data["planStatus"]) || (data["templateType"] == 1 && data["templateSubType"] == 2 && data["poType"] == 10) || data["templateType"] == 14 && data["poType"] == 10 || data["templateType"] == 17 && data["poType"] == 10) {
                                $("#iconBtnTest div").removeClass("iconbutton-test").addClass("iconbutton-test-disabled");
                                return;
                            }
                            //NAS+一体化备份不需要测试,SAN一体化和双活+一体化
                            if(_.contains([28,30,31], parseInt(data["templateType"], 10))){
                                $("#iconBtnTest div").removeClass("iconbutton-test").addClass("iconbutton-test-disabled");
                                return;
                            }
                            $("#iconBtnTest div").removeClass("iconbutton-test-disabled").addClass("iconbutton-test");
                        }
                    }, {
                        id: "iconBtnClear",
                        authKey: "ism.drm.drp.auth.cleartest",
                        template: "<div class='conbutton-clear-disabled' title='" + appUtils.getString('common_term_clear_button') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnClear div").hasClass("conbutton-clear")) {
                                return;
                            }
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "clear",
                                $scope: $scope,
                                $state: $state
                            }));
                        },
                        mouseActive: function(data) {
                            var clearStatus = {
                                disable: [0, 1, 2, 3, 4, 7, 8, 10, 11, 12, 15, 16, 17, 18, 19, 20],
                                enable: [5, 6, 9]
                            };
                            if (_.contains(clearStatus.disable, data["planStatus"]) || (data["templateType"] == 1 && data["templateSubType"] == 2 && data["poType"] == 10) || data["templateType"] == 14 && data["poType"] == 10) {
                                $("#iconBtnClear div").removeClass("conbutton-clear").addClass("conbutton-clear-disabled");
                                return;
                            }
                            $("#iconBtnClear div").removeClass("conbutton-clear-disabled").addClass("conbutton-clear");
                        }
                    }, {
                        id: "iconBtnExcute",
                        authKey: "ism.drm.drp.local.auth.rollback",
                        template: "<div class='iconbutton-fault-recovery-disabled' title='" + appUtils.getString('recovery_operate_backuprecovery_label') + "'></div>",
                        clickActive: function(){
                            if (!$("#iconBtnExcute div").hasClass("iconbutton-fault-recovery")) {
                                return;
                            }
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "running",
                                $scope: $scope,
                                $state: $state
                            }));
                        },
                        mouseActive: function(data) {
                            var enable = [0, 8, 18, 19],
                                disable = [1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 15, 16, 17, 20];
                            if (_.contains(disable, data["planStatus"])) {
                                $("#iconBtnExcute div").removeClass("iconbutton-fault-recovery").addClass("iconbutton-fault-recovery-disabled");
                                return;
                            }
                            if (_.contains(enable, data["planStatus"])) {
                                $("#iconBtnExcute div").removeClass("iconbutton-fault-recovery-disabled").addClass("iconbutton-fault-recovery");
                                return;
                            }
                            $("#iconBtnExcute div").removeClass("iconbutton-fault-recovery").addClass("iconbutton-fault-recovery-disabled");
                        }
                    }, {
                        id: "iconBtnEdit",
                        authKey: "ism.drm.drp.auth.modify",
                        template: "<div class='iconbutton-edit-disabled' title='" + appUtils.getString('common_term_edit_button') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnEdit div").hasClass("iconbutton-edit")) {
                                return;
                            }
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "edit",
                                $scope: $scope
                            }));
                        },
                        mouseActive: function(data) {
                            var disable = [1, 2, 4, 7, 10, 11, 15, 17],
                                enable = [0, 3, 5, 6, 8, 9, 12, 16, 18, 19, 20];
                            if (_.contains(disable, data["planStatus"])) {
                                $("#iconBtnEdit div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                                return;
                            }
                            if (_.contains(enable, data["planStatus"])) {
                                $("#iconBtnEdit div").removeClass("iconbutton-edit-disabled").addClass("iconbutton-edit");
                                return;
                            }
                            $("#iconBtnEdit div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                        }
                    }, {
                        id: "iconBtnDel",
                        authKey: "ism.drm.drp.auth.delete",
                        template: "<div class='iconbutton-delete-disabled' title='" + appUtils.getString('common_term_delete_button') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnDel div").hasClass("iconbutton-delete")) {
                                return;
                            }
                            _startPage = 0;
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "del",
                                $scope: $scope
                            }));
                        },
                        mouseActive: function(data) {
                            var enable = [0, 2, 3, 5, 6, 8, 9, 11, 12, 16, 18, 19, 20],
                                disable = [1, 4, 7, 10, 15, 17];
                            if (_.contains(disable, data["planStatus"])) {
                                $("#iconBtnDel div").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                                return;
                            }
                            if (_.contains(enable, data["planStatus"])) {
                                $("#iconBtnDel div").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
                                return
                            }
                            $("#iconBtnDel div").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                        }
                    }];
                    //SAN双活恢复计划测试、清理
                    var sanOpAreaConfig = [{
                        id: "iconBtnTest",
                        authKey: "ism.drm.drp.auth.test",
                        template: "<div class='iconbutton-test-disabled' title='" + appUtils.getString('common_term_test_button') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnTest div").hasClass("iconbutton-test")) {
                                return;
                            }
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "sanHypermetroTest",
                                $scope: $scope,
                                $state: $state
                            }));
                        },
                        mouseActive: function(data) {
                            var testStatus = {
                                enable: [0, 8],
                                disable: [4, 5, 6, 7, 9]
                            };
                            if (_.contains(testStatus.disable, data["planStatus"])) {
                                $("#iconBtnTest div").removeClass("iconbutton-test").addClass("iconbutton-test-disabled");
                                return;
                            }
                            $("#iconBtnTest div").removeClass("iconbutton-test-disabled").addClass("iconbutton-test");
                        }
                    }, {
                        id: "iconBtnClear",
                        authKey: "ism.drm.drp.auth.cleartest",
                        template: "<div class='conbutton-clear-disabled' title='" + appUtils.getString('common_term_clear_button') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnClear div").hasClass("conbutton-clear")) {
                                return;
                            }
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "clear",
                                $scope: $scope,
                                $state: $state
                            }));
                        },
                        mouseActive: function(data) {
                            var clearStatus = {
                                disable: [0, 4, 7, 8],
                                enable: [5, 6, 9]
                            };
                            if (_.contains(clearStatus.disable, data["planStatus"])) {
                                $("#iconBtnClear div").removeClass("conbutton-clear").addClass("conbutton-clear-disabled");
                                return;
                            }
                            $("#iconBtnClear div").removeClass("conbutton-clear-disabled").addClass("conbutton-clear");
                        }
                    }, {
                        id: "iconBtnEdit",
                        authKey: "ism.drm.drp.auth.modify",
                        template: "<div class='iconbutton-edit-disabled' title='" + appUtils.getString('common_term_edit_button') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnEdit div").hasClass("iconbutton-edit")) {
                                return;
                            }
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "edit",
                                $scope: $scope
                            }));
                        },
                        mouseActive: function(data) {
                            var disable = [4, 7],
                                enable = [0, 5, 6, 8, 9];
                            if (_.contains(disable, data["planStatus"])) {
                                $("#iconBtnEdit div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                                return;
                            }
                            if (_.contains(enable, data["planStatus"])) {
                                $("#iconBtnEdit div").removeClass("iconbutton-edit-disabled").addClass("iconbutton-edit");
                                return;
                            }
                            $("#iconBtnEdit div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                        }
                    }, {
                        id: "iconBtnDel",
                        authKey: "ism.drm.drp.auth.delete",
                        template: "<div class='iconbutton-delete-disabled' title='" + appUtils.getString('common_term_delete_button') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnDel div").hasClass("iconbutton-delete")) {
                                return;
                            }
                            _startPage = 0;
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "del",
                                $scope: $scope
                            }));
                        },
                        mouseActive: function(data) {
                            var enable = [0, 5, 6, 8, 9],
                                disable = [4, 7];
                            if (_.contains(disable, data["planStatus"])) {
                                $("#iconBtnDel div").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                                return;
                            }
                            if (_.contains(enable, data["planStatus"])) {
                                $("#iconBtnDel div").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
                                return
                            }
                            $("#iconBtnDel div").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                        }
                    }];

                    var nasOpAreaConfig = [{
                        id: "iconBtnSwap",
                        authKey: "ism.drm.drp.auth.test",
                        template: "<div class='iconbutton-test-disabled' title='" + appUtils.getString('recovery_nas_hypermetro_switch_label') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnSwap div").hasClass("iconbutton-test")) {
                                return;
                            }
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "nasSwitchover",
                                $scope: $scope,
                                $state: $state
                            }));
                        },
                        mouseActive: function(data) {
                            var testStatus = {
                                enable: [0, 22],
                                disable: [21]
                            };
                            if (_.contains(testStatus.disable, data["planStatus"])) {
                                $("#iconBtnSwap div").removeClass("iconbutton-test").addClass("iconbutton-test-disabled");
                                return;
                            }
                            $("#iconBtnSwap div").removeClass("iconbutton-test-disabled").addClass("iconbutton-test");
                        }
                    }, {
                        id: "iconBtnEdit",
                        authKey: "ism.drm.drp.auth.modify",
                        template: "<div class='iconbutton-edit-disabled' title='" + appUtils.getString('common_term_edit_button') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnEdit div").hasClass("iconbutton-edit")) {
                                return;
                            }
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "edit",
                                $scope: $scope
                            }));
                        },
                        mouseActive: function(data) {
                            var disable = [21],
                                enable = [0, 22];
                            if (_.contains(disable, data["planStatus"])) {
                                $("#iconBtnEdit div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                                return;
                            }
                            if (_.contains(enable, data["planStatus"])) {
                                $("#iconBtnEdit div").removeClass("iconbutton-edit-disabled").addClass("iconbutton-edit");
                                return;
                            }
                            $("#iconBtnEdit div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                        }
                    }, {
                        id: "iconBtnDel",
                        authKey: "ism.drm.drp.auth.delete",
                        template: "<div class='iconbutton-delete-disabled' title='" + appUtils.getString('common_term_delete_button') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnDel div").hasClass("iconbutton-delete")) {
                                return;
                            }
                            _startPage = 0;
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "del",
                                $scope: $scope
                            }));
                        },
                        mouseActive: function(data) {
                            var enable = [0, 22],
                                disable = [21];
                            if (_.contains(disable, data["planStatus"])) {
                                $("#iconBtnDel div").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                                return;
                            }
                            if (_.contains(enable, data["planStatus"])) {
                                $("#iconBtnDel div").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
                                return
                            }
                            $("#iconBtnDel div").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                        }
                    }];
                    //SAN一体化备份支持容灾
                    var sanHyperValutSupportDrOpAreaConfig = angular.copy(_.reject(remoteOpAreaConfig, function(config) {
                        return config.id == 'iconHotMigration';
                    }));
                    sanHyperValutSupportDrOpAreaConfig.unshift({
                        id: "iconBtnExcute",
                        authKey: "ism.drm.drp.local.auth.rollback",
                        template: "<div class='iconbutton-fault-recovery-disabled' title='" + appUtils.getString('recovery_operate_backuprecovery_label') + "'></div>",
                        clickActive: function() {
                            if (!$("#iconBtnExcute div").hasClass("iconbutton-fault-recovery")) {
                                return;
                            }
                            recoveryService.execute(_.extend(_getHoverData(), {
                                action: "running",
                                $scope: $scope,
                                $state: $state
                            }));
                        },
                        mouseActive: function(data) {
                            var enable = [0, 8, 18, 19, 20],
                                disable = [1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 15, 16, 17];
                            if (_.contains(disable, data["planStatus"])) {
                                $("#iconBtnExcute div").removeClass("iconbutton-fault-recovery").addClass("iconbutton-fault-recovery-disabled");
                                return;
                            }
                            if (_.contains(enable, data["planStatus"])) {
                                $("#iconBtnExcute div").removeClass("iconbutton-fault-recovery-disabled").addClass("iconbutton-fault-recovery");
                                return;
                            }
                            $("#iconBtnExcute div").removeClass("iconbutton-fault-recovery").addClass("iconbutton-fault-recovery-disabled");
                        }
                    });
                    //查询华为云信息，根据此信息展示相关私有云项
                    var defaultColumns = [{
                        "mData": "uuid",
                        "bVisible": false
                    }, {
                        "mData": "protectUuid",
                        "bVisible": false
                    }, {
                        "mData": "isAllowExecute",
                        "bVisible": false
                    }, {
                        "mData": "PROVIDER_TYPE",
                        "bVisible": false
                    }, {
                        "mData": "protectType",
                        "bVisible": false
                    }, {
                        "mData": "templateUuid",
                        "bVisible": false
                    }, {
                        "mData": "templateType",
                        "bVisible": false
                    }, {
                        "mData": "templateSubType",
                        "bVisible": false
                    }, {
                        "mData": "planType",
                        "bSortable": false,
                        "bVisible": false
                    }, {
                        "mData": "name",
                        "bSortable": true,
                        "sTitle": appUtils.getString("recovery.term.colum.name.title")
                    }, {
                        "mData": "planStatus",
                        "bSortable": true,
                        "sWidth": "10%",
                        "sTitle": appUtils.getString("recovery.term.colum.status.title")
                    }, {
                        "mData": "planProgress",
                        "bSortable": false,
                        "sWidth": "12%",
                        "sTitle": appUtils.getString("recovery.term.colum.process.title")
                    }, {
                        "mData": "productSiteName",
                        "bSortable": false,
                        "sWidth": "15%",
                        "sTitle": appUtils.getString("recovery.term.colum.productionSite.title")
                    }, {
                        "mData": "protectGroupName",
                        "bSortable": false,
                        "sWidth": "14%",
                        "sTitle": appUtils.getString("recovery_protected_plan_label")
                    }, {
                        "mData": "poType",
                        "sWidth": "14%",
                        "bSortable": false,
                        "sTitle": appUtils.getString("recovery.term.colum.productionObject.title")
                    }];
                    var consoleColumns = angular.copy(defaultColumns).concat([{
                        "mData": "region",
                        "bSortable": false,
                        "sTitle": appUtils.getString("site_create_area_label")
                    },{
                        "mData": "az",
                        "bSortable": false,
                        "sTitle": appUtils.getString("site_cloudserver_az_label")
                    },{
                        "mData": "project",
                        "bSortable": false,
                        "sTitle": appUtils.getString("datarecovery_cloumn_project_name_label")
                    },{
                        "mData": "protectedType",
                        "bSortable": false,
                        "sTitle": appUtils.getString("common_term_protectedType_label")
                    }]);
                    var isFireFox = _.isObject(tinyWidget.util.browser) ? tinyWidget.util.browser.firefox === true : false;
                    _.each(consoleColumns, function(col) {
                        //火狐列宽有所调整
                        if (appUtils.isEn()) {
                            col["mData"] == "name" && (isFireFox ? col["sWidth"] = "7%" : col["sWidth"] = "8%")
                            col["mData"] == "productSiteName" && (col["sWidth"] = "8%")
                            col["mData"] == "protectGroupName" && (isFireFox ? col["sWidth"] = "7%" : col["sWidth"] = "9%")
                            col["mData"] == "poType" && (isFireFox ? col["sWidth"] = "7%" : col["sWidth"] = "9%")
                            col["mData"] == "planProgress" && (col["sWidth"] = "10%")
                            col["mData"] == "region" && (isFireFox ? col["sWidth"] = "7%" : col["sWidth"] = "8%")
                            col["mData"] == "az" && (isFireFox ? col["sWidth"] = "6%" : col["sWidth"] = "7%")
                            col["mData"] == "project" && (isFireFox ? col["sWidth"] = "6%" : col["sWidth"] = "7%")
                            col["mData"] == "protectedType" && (col["sWidth"] = "7%")
                            col["mData"] == "name" && (col["sWidth"] = "8%")
                        } else {
                            col["mData"] == "name" && (isFireFox ? col["sWidth"] = "7%" : col["sWidth"] = "8%")
                            col["mData"] == "productSiteName" && (col["sWidth"] = "8%")
                            col["mData"] == "protectGroupName" && (isFireFox ? col["sWidth"] = "7%" : col["sWidth"] = "9%")
                            col["mData"] == "poType" && (isFireFox ? col["sWidth"] = "8%" : col["sWidth"] = "10%")
                            col["mData"] == "planProgress" && (col["sWidth"] = "10%")
                            col["mData"] == "region" && (isFireFox ? col["sWidth"] = "8%" : col["sWidth"] = "10%")
                            col["mData"] == "az" && (col["sWidth"] = "7%")
                            col["mData"] == "project" && (isFireFox ? col["sWidth"] = "7%" : col["sWidth"] = "8%")
                            col["mData"] == "protectedType" && (col["sWidth"] = "6%")
                            col["mData"] == "name" && (col["sWidth"] = "8%")
                        }
                    });
                    $scope.isHuaweiCloud = window.isPrivateConsole;
                    $scope.regionInfo = [];
                    $scope.projectInfo = [];
                    var ngdom = $("<div></div>");
                    window.isPrivateConsole && restService.queryHwstackInfo([], {
                        mask: false,
                        isShowMsgBox: false,
                        success: function(result){
                            //私有云会返回这些信息，展示region
                            if (!_.isEmpty(result) && !_.isEmpty(result.cloudInfras) && !_.isEmpty(result.projects)) {
                                $scope.regionInfo = angular.copy(result.cloudInfras);
                                _initPage(($scope.recoveryObj.uuid || ""), false);
                                $scope.projectInfo = angular.copy(result.projects);
                                var regionArray = [{
                                    "selectId" : "-1",
                                    "label" : appUtils.getString("datarecovery_filter_condition_all_label", "site_create_area_label")
                                }];
                                _.each(result.cloudInfras, function(value){
                                    regionArray.push({
                                        "selectId" : value.regionId,
                                        "label" : value.regionName
                                    });
                                });
                                $scope.advance.regionSelect.values = regionArray;
                                $scope.advance.regionSelect.defaultSelectid = "-1";
                                var projectInfo = [{
                                    "selectId" : "-1",
                                    "label" : appUtils.getString("datarecovery_filter_condition_all_label", "datarecovery_cloumn_pro_project_name_label")
                                }];
                                _.each(result.projects, function(item){
                                    projectInfo.push({
                                        "selectId" : item.projectId,
                                        "label" : item.projectName
                                    });
                                });
                                $scope.advance.projectSelect.values = projectInfo;
                                $scope.advance.projectSelect.defaultSelectid = "-1";
                                $scope.$apply();
                            };
                        }
                    });
                    $scope.ADVANCED_LABEL = appUtils.getString("common_term_adgsearch_button");
                    $scope.advanceSearchPop = {
                        "id": "advanceSearchPopId",
                        "elementId": "advanceSearchPopEleId",
                        "template": ngdom,
                        "popStyle": {
                            "width": !appUtils.isEn() ? '410px' : "435px",
                            "height": !appUtils.isEn() ? '260px' : "280px"
                        }
                    };
                    $scope.showAdvanceSearch = function() {
                        ngdom.load("app/business/recoverydirector/recovery/views/operate/recoveryAdvanceSearch.html", function() {
                            $scope.advance.regionSelect.defaultSelectid = !_.isEmpty(_regionId) ? _regionId : "-1";
                            $scope.advance.azSelect.defaultSelectid = !_.isEmpty(_azId) ? _azId : "-1";
                            $scope.advance.projectSelect.defaultSelectid = !_.isEmpty(_projectId) ? _projectId : "-1";
                            $scope.advance.protectedType.defaultSelectid = !_.isEmpty(_instProtectType) ? _instProtectType : "-1";
                            $compile($("#advanceSearchDiv"))($scope);
                            $scope.$apply();
                            $("#advanceSearchPopId").widget().setPopShow(true);
                        });
                    };
                    $scope.advance = {
                        labels: {
                            cls: "alarmAdvance a_td_label",
                            regionSelect: appUtils.getStringWithColon("site_create_area_label"),
                            azSelect: appUtils.getStringWithColon("site_cloudserver_az_label"),
                            projectSelect: appUtils.getStringWithColon("datarecovery_cloumn_pro_project_name_label"), 
                            protectedType: appUtils.getStringWithColon("common_term_protectedType_label")
                        },
                        regionSelect: {
                            id: "regionSelect",
                            width: 240,
                            closeFn: function(){
                                var selectId = $("#" + this.id).widget().getSelectedId();
                                if (!_.isEmpty($scope.regionInfo)) {
                                    var selectedRegion = _.filter($scope.regionInfo, function(val){
                                        return val["regionId"] == selectId;
                                    })[0];
                                    if(!_.isEmpty(selectedRegion)){
                                        var azArray = [{
                                            "selectId" : "-1",
                                            "label" : appUtils.getString("datarecovery_filter_condition_all_label", "site_cloudserver_az_label")
                                        }];
                                        _.each(selectedRegion["availableZones"], function(item){
                                            azArray.push({
                                                "selectId" : item.azId,
                                                "label" : item.azName
                                            });
                                        });
                                        $("#azSelect").widget().option("values", azArray);
                                        $scope.advance.azSelect.defaultSelectid = "-1";
                                        $scope.$apply();
                                    };
                                };
                            },
                            getVal: function(){
                                return $("#" + this.id).widget().getSelectedId() == "-1" ? "" : $("#" + this.id).widget().getSelectedId()
                            }
                        },
                        azSelect: {
                            id: "azSelect",
                            width: 240,
                            values: [{
                                "selectId" : "-1",
                                "label" : appUtils.getString("datarecovery_filter_condition_all_label", "site_cloudserver_az_label")
                            }],
                            defaultSelectid: "-1",
                            getVal: function(){
                                return $("#" + this.id).widget().getSelectedId() == "-1" ? "" : $("#" + this.id).widget().getSelectedId()
                            }
                        },
                        projectSelect: {
                            id: "projectSelect",
                            width: 240,
                            getVal: function(){
                                return $("#" + this.id).widget().getSelectedId() == "-1" ? "" : $("#" + this.id).widget().getSelectedId()
                            }
                        },
                        protectedType: {
                            id: "protectedType",
                            width: 240,
                            values: [{
                                "selectId" : "-1",
                                "label" : appUtils.getString("datarecovery_filter_condition_all_label", "common_term_protectedType_label")
                            },{
                                "selectId" : "csha",
                                "label" : "CSHA"
                            },{
                                "selectId" : "csdr",
                                "label" : "CSDR"
                            },{
                                "selectId" : "vha_csdr",
                                "label" : "VHA+CSDR"
                            },{
                                "selectId" : "csha_csdr",
                                "label" : "CSHA+CSDR"
                            }],
                            defaultSelectid: "-1",
                            getVal: function(){
                                return $("#" + this.id).widget().getSelectedId() == "-1" ? "" : $("#" + this.id).widget().getSelectedId()
                            }
                        },
                        btnOK: {
                            text: appUtils.getString("common_term_search_button"),
                            click: function(){
                                _startPage = 0;
                                _regionId = $scope.advance.regionSelect.getVal();
                                _azId = $scope.advance.azSelect.getVal();
                                _projectId = $scope.advance.projectSelect.getVal();
                                _instProtectType = $scope.advance.protectedType.getVal();
                                _initPage();
                                $scope.recoveryScope.table.currPage = {
                                    "pageIndex": 1
                                };
                            }
                        }
                    };

                    function updateProcess(columnData) {
                        var tData = $("#recoveryTable").widget().getTableData();
                        var findData = _.findWhere(tData, {uuid: columnData["uuid"]});

                        if (_.isUndefined(findData)) return;

                        var oldPlanPro = findData["planProgress"],
                            newPlanPro = columnData["planProgress"];

                        if (newPlanPro == 0 && oldPlanPro <= 100 && findData["planStatus"] == 17) {
                            columnData["planProgress"] = oldPlanPro;
                        }
                    }

                function _updateUI(result) {
                    var arr = [];
                    _.each(result.records, function(obj) {
                        var protectGroups = !_.isEmpty(obj.protectGroups) && _.isArray(obj.protectGroups) && _.first(obj.protectGroups);
                        obj.productSiteName = protectGroups.productSiteName;
                        obj.productSiteId = protectGroups.productSiteId;
                        obj.protectGroupName = protectGroups.name;
                        obj.protectUuid = protectGroups.uuid;
                        if (!_.isUndefined(protectGroups.template) && !_.isEmpty(protectGroups.template)) {
                            obj.templateUuid = protectGroups.template.uuid;
                            obj.templateType = protectGroups.template.type;
                            obj.templateSubType = protectGroups.template.subType;
                        }
                        obj.poType = protectGroups.poType;
                        obj.PROVIDER_TYPE = _.isNull(protectGroups.props.PROVIDER_TYPE) ? "" : protectGroups.props.PROVIDER_TYPE;
                        obj.protectType = _.isNull(protectGroups.props.protectType) ? "" : protectGroups.props.protectType;
                        obj.operate = "";
                        obj.props = protectGroups.props;
                        updateProcess(obj);
                        var tmo;
                        if(protectGroups.props.serviceInstanceType == "replication"){
                            obj.serviceInstanceType = "replication";
                            tmo = _.pick(obj,"serviceInstanceType", "processStatus", "logId", "uuid", "protectUuid", "templateUuid", "templateType", "templateSubType", "name", "planStatus", "planType", "planProgress", "productSiteId", "productSiteName", "protectGroupName", "poType", "isAllowExecute", "protectType", "PROVIDER_TYPE", "operate", "props", "supportConfirmReprotection");
                        }else if(protectGroups.template.type == 15){
                            obj.isNasRecovery = (!_.isEmpty(protectGroups.props.PROP_KEY_VSTORE_PAIR_ID) && !_.isEmpty(protectGroups.props.PROP_KEY_VSTORE_ID))
                            tmo = _.pick(obj,"isNasRecovery", "processStatus", "logId", "uuid", "protectUuid", "templateUuid", "templateType", "templateSubType", "name", "planStatus", "planType", "planProgress", "productSiteId", "productSiteName", "protectGroupName", "poType", "isAllowExecute", "protectType", "PROVIDER_TYPE", "operate", "props", "supportConfirmReprotection");
                        }else if(protectGroups.template.type == 18 || protectGroups.template.type == 20){
                            obj.isNasHyperCopy = !_.isEmpty(protectGroups.props.PROP_KEY_VSTORE_PAIR_ID);
                            tmo = _.pick(obj,"isNasHyperCopy", "processStatus", "logId", "uuid", "protectUuid", "templateUuid", "templateType", "templateSubType", "name", "planStatus", "planType", "planProgress", "productSiteId", "productSiteName", "protectGroupName", "poType", "isAllowExecute", "protectType", "PROVIDER_TYPE", "operate", "props", "supportConfirmReprotection");
                        }else{
                            tmo = _.pick(obj,"processStatus", "logId", "uuid", "protectUuid", "templateUuid", "templateType", "templateSubType", "name", "planStatus", "planType", "planProgress", "productSiteId", "productSiteName", "protectGroupName", "poType", "isAllowExecute", "protectType", "PROVIDER_TYPE", "operate", "props", "supportConfirmReprotection");
                        }
                        arr.push(tmo);
                    });
                    $scope.recoveryScope.table.totalRecords = result["totalCount"];
                    $scope.recoveryScope.table.data = appUtils.encodeForHTML(arr);
                    if (result["totalCount"] > 10) {
                        $scope.recoveryScope.table.enablePagination = true;
                        $(".bottom-tab-container").eq(0).css("margin-top", "50px");
                    } else {
                        $scope.recoveryScope.table.enablePagination = false;
                        $(".bottom-tab-container").eq(0).css("margin-top", "20px");
                    }
                    $scope.recoveryScope.tabBox = !_.isEmpty(result.records);
                    $scope.$apply();
                    $(window).scrollTop(scrollTop);
                };

                function _getHoverData() {
                    var hoverData = _.first($("#recoveryTable").widget().getHoverData());
                    hoverData.planId = hoverData.uuid;
                    return hoverData;
                };

                $scope.recoveryObj;

                function _initPage(uuid, mask, showResultTipFn,clickFlag) {
                    var params = {
                        startPage: _startPage,
                        pageSize: _pageSize,
                        orderBy: _orderBy,
                        orderType: _orderType,
                        planType: 0, //0：恢复计划,1：挂载计划
                        "Rp.appType": _appType,
                        "Rp.name": _name,
                        "Rp.planStatus": _planStatus,
                        "Rp.regionId": _regionId,
                        "Rp.azId": _azId,
                        "Rp.projectId": _projectId,
                        "Rp.instProtectType": _instProtectType
                    }

                    _.each(params, function(value, key) {
                        (_.isUndefined(value) || _.isNull(value)) && delete params[key];
                    })

                    var _mask = mask || _.isUndefined(mask); //_mask为false表示自动刷新
                    restService.getRecoveryListData(_.pick(params, "startPage", "pageSize", "orderBy", "orderType", "planType", "Rp.name", "Rp.appType", "Rp.planStatus", "Rp.regionId", "Rp.azId", "Rp.projectId", "Rp.instProtectType"), {
                        "mask": _mask,
                        "timeout": 3600000,
                        "success": function(data) {
                            _startPage == 0 && ($scope.recoveryScope.table.currPage = {
                                "pageIndex": 1
                            });
                            _updateUI(data);
                            if (!_.isEmpty(data.records)) {
                                var recoveryTableWidget = $("#recoveryTable").widget();
                                var tableData = recoveryTableWidget.getTableData();
                                var findCheckObj = _.findWhere(tableData, { "uuid": uuid});
                                if (!_.isEmpty(uuid) && !_.isEmpty(findCheckObj)) {
                                    planId = uuid;
                                    recoveryTableWidget.setSelectedRow("uuid", uuid);
                                } else {
                                    planId = tableData[0].uuid;
                                    recoveryTableWidget.setSelectedRow('uuid', tableData[0].uuid);
                                }
                                var checkNode = _.first(recoveryTableWidget.getTableCheckedItems());
                                $scope.exec = false;
                                $scope.recoveryObj = checkNode;
                                (_mask || _.isUndefined(findCheckObj) || clickFlag) && $scope.$broadcast(constsService.RECOVERY_TAB, _.extend(checkNode, {
                                    planId: checkNode.uuid,
                                    _mask: _mask
                                }));
                            }
                            if (!_.isUndefined(showResultTipFn) && _.isFunction(showResultTipFn) && !_.contains([0, 1, 4, 7, 10, 15, 17], parseInt(checkNode["planStatus"], 10))) {
                                showResultTipFn();
                            }
                        },
                        "fail": function(rep) {
                            exception.checkSessionTimeout(rep, function() {
                                $timeout.cancel(promise);
                            });
                        }
                    });
                };

                //接收广播信息更新当前对应的数据的信息
                $scope.$on("recoveryExecute", function(ev, obj) {
                    var timeFlag = 2000;
                    if(!_.isObject(obj) && !_.isUndefined(obj)){
                        obj.indexOf("true") != -1 && (timeFlag = 10)
                    };
                    setTimeout(function() {
                        if (_.isObject(obj)) {
                            planId = obj.uuid;
                            _initPage(obj.uuid, false, obj.showResultTipFn);
                        } else {
                            if(!_.isUndefined(obj) && obj.indexOf("true") != -1){
                                var flag = planId == obj.slice(4) ? false : true
                                planId = obj.slice(4);
                                obj = obj.slice(4);
                                _initPage(obj, false,undefined,flag);
                            }else{
                                planId = obj;
                                _initPage(obj, false);
                            }
                        }
                    }, timeFlag);
                });

                //销毁定时器
                $scope.$on("$destroy", function() {
                    _promise && $timeout.cancel(_promise);
                });

                function showHistoryDetail(params){
                    var options = {
                        "winId": constsService.EXCUTE_HISTORY_DETAIL_WIN.winId,
                        "title": appUtils.getString(constsService.EXCUTE_HISTORY_DETAIL_WIN.title),
                        "params": params,
                        "height": constsService.EXCUTE_HISTORY_DETAIL_WIN.height,
                        "width": constsService.EXCUTE_HISTORY_DETAIL_WIN.width,
                        "modal": true,
                        "content-type": "url",
                        "draggable": true,
                        "minimizable": false,
                        "maximizable": false,
                        "content": constsService.EXCUTE_HISTORY_DETAIL_WIN.url,
                        "buttons": [{
                            key: "close",
                            label: appUtils.getString("common_term_close_button"),
                            focused: true,
                            handler: function(event) {
                                $("#" + constsService.EXCUTE_HISTORY_DETAIL_WIN.winId).widget().destroy();
                            }
                        }]
                    };
                    var win = new Window(options);
                    win.show();
                };

                $scope.recoveryScope = {
                    create: {
                        id: "createBtn",
                        hasRight: appUtils.checkRight("ism.drm.drp.auth.add"),
                        text: appUtils.getString("common_term_create_button"),
                        click: function() {
                            $state.go("dataUse.createRecoveryPlan");
                        }
                    },
                    refresh: {
                        title: appUtils.getString("common_term_refresh_button"),
                        action: function() {
                            _startPage = 0;
                            _orderBy = null;
                            _orderType = null;
                            _name = "";
                            _planStatus = "";
                            _regionId = "";
                            _azId = "";
                            _projectId = "";
                            _instProtectType = "";
                            _initPage();
                            $("#recoverySearch").widget().setSearchboxValue("");
                        }
                    },
                    table: {
                        "id": "recoveryTable",
                        "paginationStyle":"full_numbers",
                        "enablePagination": false,
                        "buttonContainerPosition": "right",
                        "totalRecords": 0,
                        "displayLength": 10,
                        "currPage": {
                            "pageIndex": 1
                        },
                        "isDraggedRemember": true,
                        "data": [],
                        "opAreaConfig": [],
                        "columns": window.isPrivateConsole ? consoleColumns : defaultColumns,
                        "lengthMenu": constsService.TABLE_LENGTH_AUTO_MENU,
                        "changeSelect": function(evtObj){
                            $scope.recoveryScope.table.currPage = {
                                "pageIndex": 1
                            };
                            _startPage = 0;
                            _pageSize = evtObj.displayLength;
                            _initPage();
                        },
                        "callback": function(evtObj) {
                            _startPage = evtObj.currentPage - 1;
                            _pageSize = evtObj.displayLength
                            _initPage();
                        },
                        "sortCallback": function(nNode, sortArr) {
                            $scope.recoveryScope.table.currPage = {
                                "pageIndex": 1
                            };
                            _orderBy = $scope.recoveryScope.table.columns[_.first(_.first(sortArr))].mData;
                            _orderType = _.first(sortArr)[1];
                            _startPage = 0;
                            _initPage();
                        },
                        "hoverActive": function(e, param) {
                            var opAreaConfig = [];
                            if (param["planType"] == 1) {
                                if(param.templateType == "15"){
                                    opAreaConfig = param["isNasRecovery"] ? nasOpAreaConfig : sanOpAreaConfig
                                }else if (_.contains([30,31,32], parseInt(param.templateType, 10))) {
                                    opAreaConfig = sanHyperValutSupportDrOpAreaConfig;
                                }else{
                                    opAreaConfig = localOpAreaConfig;
                                }
                            } else {
                                if(param.templateType == "15"){
                                    opAreaConfig = sanOpAreaConfig
                                }else if (_.contains([30,31,32], parseInt(param.templateType, 10))) {
                                    opAreaConfig = sanHyperValutSupportDrOpAreaConfig;
                                }else{
                                    opAreaConfig = (param["templateType"] == 25 || (param["templateType"] == 37 && param.props.regionId === param.props.originalAvailableRegion)) && param["poType"] == 12 ? remoteOpAreaConfig : _.reject(remoteOpAreaConfig, function (config) {
                                        return config.id === "iconHotMigration";
                                   });
                                }
                            }
                            $scope.recoveryScope.table.opAreaConfig = appUtils.flilterOperRight(opAreaConfig);
                            $scope.$apply();
                            _.each($scope.recoveryScope.table.opAreaConfig, function (config) {
                                !_.isEmpty(config) && _.isFunction(config.mouseActive) && config.mouseActive(param);
                            })
                            $("#recoveryTable").widget()._doOpAreaHandle.mouseenter($("#recoveryTable").widget(), $(e.target).closest("tr"));
                        },
                        "cellClickActive": function(e, param) {
                            planId = param.uuid;
                            $scope.recoveryObj = param;
                            $scope.$broadcast(constsService.RECOVERY_TAB, _.extend(param, {
                                planId: param.uuid,
                                _mask: true
                            }));
                        },
                        "renderRow": function(nRow, aData, iDataIndex) {
                            var failedBtn = "<span>"+statusEnumService.getStatus("RECOVERY_STATUS", aData['planStatus'])+"</span><a href='javascript:void(0)' class='icon-error' title='"+appUtils.getString('exist_failed_step_tips')+"' style='display:inline-block;width:16px;height:16px;margin-left:6px;position:relative;top:4px' ng-click='showDetail($event)'></a>";
                            var linkBtn = $compile($(failedBtn));
                            var linkScope = $scope.$new();
                            var params = {
                                planId:aData.uuid,
                                logId:aData.logId
                            };
                            linkScope.showDetail = function($event){
                                $event.stopPropagation?$event.stopPropagation():window.event.cancelBubble = true;
                                showHistoryDetail(params)
                            };
                            var linkNode = linkBtn(linkScope);
                            $("td:eq(3)", nRow).html(aData["productSiteName"]);
                            $("td:eq(5)", nRow).html(statusEnumService.getStatus("PROTECT_OBJECT_TYPE", aData['poType']));
                            var progressColumn = "<div class='progressbar'><tiny-progressbar id='id' label-position='position' color='color' value='value' width='width' height='height'></tiny-progressbar></div>";
                            var progressLink = $compile(progressColumn);
                            var progressScope = $scope.$new();
                            progressScope.id = "progress_" + iDataIndex;
                            progressScope.value = aData['planProgress'];
                            progressScope.position = "right";
                            progressScope.width = "80px";
                            progressScope.height = "10px";
                            progressScope.color = _.contains([6, 3, 12, 16, 9, 18, 22, 30], aData["planStatus"]) ? constsService.COLOR_RED : constsService.COLOR_GREEN;
                            var progressNode = progressLink(progressScope);
                            $("td:eq(2)", nRow).html(progressNode);
                            if(_.contains([2,5,8,11,19,20],aData['planStatus']) && aData.processStatus == 1){
                                $("td:eq(1)", nRow).html(linkNode);
                            } else {
                                $("td:eq(1)", nRow).html(statusEnumService.getStatus("RECOVERY_STATUS", aData['planStatus']));
                            }
                            //私有云展示的相关列
                            $scope.$watchGroup(['regionInfo', 'projectInfo'], function(newValue, oldValue, scope) {
                                if (_.isEmpty(newValue[0]) || _.isEmpty(newValue[1]) || !window.isPrivateConsole) {
                                    return;
                                };
                                $("td[tdtitle='" + appUtils.getString("common_term_protectedType_label") + "']", nRow).html(!_.isEmpty(aData.props.instProtectType) ? constsService.RECOVERY_PROTECTED_TYPE[aData.props.instProtectType] : "--");
                                if (!_.isEmpty(aData.props.projectId)) {
                                    var currentProject = _.find(newValue[1], function(val){
                                        return val["projectId"] == aData.props.projectId.split(":")[1]
                                    });
                                    $("td[tdtitle='" + appUtils.getString("datarecovery_cloumn_project_name_label") + "']", nRow).html(!_.isEmpty(currentProject) ? currentProject.projectName : "--");
                                } else {
                                    $("td[tdtitle='" + appUtils.getString("datarecovery_cloumn_project_name_label") + "']", nRow).html("--");
                                };
                                if (!_.isEmpty(aData.props.regionId)) {
                                    var currentRegion = _.find(newValue[0], function(val) {
                                        return val["regionId"] == aData.props.regionId.split(":")[1]
                                    });
                                    $scope.regionName[aData.uuid] = currentRegion["regionName"] || "";
                                    if (aData.props.instProtectType != "csha") {
                                        var drRegion = _.find(newValue[0], function(val) {
                                            return val["regionId"] == aData.props.drRegionId.split(":")[1]
                                        });
                                        $scope.drRegionName[aData.uuid] = drRegion["regionName"] || "";
                                        $("td[tdtitle='" + appUtils.getString("site_create_area_label") + "']", nRow).html(!_.isEmpty(currentRegion) && !_.isEmpty(drRegion) ? currentRegion["regionName"] + "-->" + drRegion["regionName"] : "--");
                                    } else {
                                        $scope.drRegionName[aData.uuid] = currentRegion["regionName"] || "";
                                        $("td[tdtitle='" + appUtils.getString("site_create_area_label") + "']", nRow).html(!_.isEmpty(currentRegion) ? currentRegion["regionName"] : "--");
                                    };
                                } else {
                                    $("td[tdtitle='" + appUtils.getString("site_create_area_label") + "']", nRow).html("--");
                                };
                                if (!_.isEmpty(aData.props.zoneName)) {
                                    var currentRegion = _.find(newValue[0], function(val){
                                        return val["regionId"] == aData.props.regionId.split(":")[1]
                                    });
                                    if(!_.isEmpty(currentRegion)){
                                        var currentAz = _.find(currentRegion["availableZones"], function(item){
                                            return item.azId == aData.props.zoneName
                                        });
                                        var drAz = _.find(currentRegion["availableZones"], function(item){
                                            return item.azId == aData.props.drZoneName
                                        });
                                        var drAz2;
                                        if (aData.props.instProtectType == "csha_csdr") {
                                            var originalRegion = _.find(newValue[0], function(val) {
                                                return val["regionId"] == aData.props.originalAvailableRegion.split(":")[1]
                                            });
                                            drAz2 = !_.isEmpty(originalRegion) ? _.find(originalRegion["availableZones"], function(val){
                                                return val.azId == aData.props.prod_region_drZoneName
                                            }) || {} : {};
                                        };
                                        if(aData.props.instProtectType != "csha"){
                                            var drRegion = _.find(newValue[0], function(val) {
                                                return val["regionId"] == aData.props.drRegionId.split(":")[1]
                                            });
                                            drAz = _.find(drRegion["availableZones"], function(item){
                                                return item.azId == aData.props.drZoneName
                                            });
                                        };
                                        if (aData.props.instProtectType == "csha_csdr") {
                                            $("td[tdtitle='" + appUtils.getString("site_cloudserver_az_label") + "']", nRow).html(!_.isEmpty(currentAz) && !_.isEmpty(drAz) ? currentAz["azName"] + "-->" + drAz2["azName"] + ", " + drAz["azName"] : "--");
                                        } else {
                                            $("td[tdtitle='" + appUtils.getString("site_cloudserver_az_label") + "']", nRow).html(!_.isEmpty(currentAz) && !_.isEmpty(drAz) ? currentAz["azName"] + "-->" + drAz["azName"] : "--");
                                        };
                                    }else{
                                        $("td[tdtitle='" + appUtils.getString("site_cloudserver_az_label") + "']", nRow).html("--");
                                    }
                                } else {
                                    $("td[tdtitle='" + appUtils.getString("site_cloudserver_az_label") + "']", nRow).html("--");
                                };

                                if (!_.isEmpty(aData.props.drProjectId)) {
                                    var srcProject = _.find(newValue[1], function(val){
                                        return val["projectId"] == aData.props.projectId.split(":")[1];
                                    });

                                    if (_.isEmpty(srcProject)) {
                                        $("td[tdtitle='" + appUtils.getString("datarecovery_cloumn_project_name_label") + "']", nRow).html("--");
                                    } else {
                                        if (aData.props.instProtectType == "csha") {
                                            $scope.drProjectName[aData.uuid] = srcProject.projectName || "";
                                            $("td[tdtitle='" + appUtils.getString("datarecovery_cloumn_project_name_label") + "']", nRow).html(srcProject.projectName);
                                        } else {
                                            var drProject = _.find(newValue[1], function(val){
                                                return val["projectId"] == aData.props.drProjectId.split(":")[1];
                                            });

                                            if (_.isEmpty(drProject) || _.isEmpty(srcProject)) {
                                                $("td[tdtitle='" + appUtils.getString("datarecovery_cloumn_project_name_label") + "']", nRow).html("--");
                                            }
                                            $scope.drProjectName[aData.uuid] = drProject.projectName || "";
                                            $("td[tdtitle='" + appUtils.getString("datarecovery_cloumn_project_name_label") + "']", nRow).html(srcProject.projectName + "-->" + drProject.projectName);
                                        }
                                    }
                                }

                            });
                        }
                    },
                    search: {
                        "id": "recoverySearch",
                        "values": [{selectId: "0", label: appUtils.getString("common_term_name_label")},
                                   {selectId: "1",label: appUtils.getString("common_term_status_label")}],
                        "display": true,
                        "disable": false,
                        "showTip": true,
                        "isSearchbox": true,
                        "defaultSelectid": "0",
                        "textWidth": constsService.W2,
                        "width": constsService.W2,
                        "textOptions": {
                            "id": "choiseStatus",
                            "values": function (params) {
                                var arrays = [], status = statusEnumService.getJsonArray("RECOVERY_STATUS");
                                status.unshift({"": appUtils.getString("common_term_all_label")});
                                _.filter(status, function (obj) {
                                    var id = _.first(_.keys(obj)),  label = _.first(_.values(obj));
                                    if (!_.contains([15, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28], +id)) {
                                        this.push({
                                            selectId: id,
                                            label: label
                                        });
                                    }
                                    return !_.contains([23, 24, 25, 26, 27, 28], +id);
                                }, arrays);
                                if (window.isUltraVR) {
                                    arrays = _.filter(arrays, function(item) {
                                        return item.selectId != 29 && item.selectId != 30;
                                    });
                                };
                                return arrays;
                            }(),
                            "display" : true,
                            "default-selectid": "",
                        },
                        "change": function() {
                            var widget = $("#recoverySearch").widget(),
                                searchId = widget.getSelectedId();
                            if (searchId == "1") {
                                this.isSearchbox = false;
                                widget.changeTextBox(false, this.textOptions);
                            } else {
                                this.isSearchbox = true;
                                widget.changeTextBox(true);
                            }
                        },
                        "click": function() {
                            _startPage = 0, $scope.recoveryScope.table.currPage = {
                                "pageIndex": 1
                            };
                            if (this.isSearchbox) {
                                _planStatus = "";
                                _name = $.encoder.encodeForURL($.trim($("#recoverySearch").widget().getSearchboxValue().inputValue));
                            } else {
                                _name = "";
                                _planStatus = $("#choiseStatus").widget().getSelectedId();
                            }
                            _initPage();
                        }
                    },
                }

                $scope.plugins = [{
                    "openState": "dataUse.dataRecovery.abstract",
                    "id": "_abstract",
                    "name": appUtils.getString("recovery.term.detailTitle.tab")
                }, {
                    "openState": "dataUse.dataRecovery.protected",
                    "id": "_protected",
                    "name": appUtils.getString("recovery.term.protectedObjTitle.tab")
                }, {
                    "openState": "dataUse.dataRecovery.procedure",
                    "id": "_procedure",
                    "name": appUtils.getString("recovery.term.procedureTitle.tab")
                }, {
                    "openState": "dataUse.dataRecovery.history",
                    "id": "_history",
                    "name": appUtils.getString("recovery.term.excuteHistoryTitle.tab")
                }]

                var _promise,
                    _times = 15000;

                function _autoRefresh() {
                    if ($state.$current.name.indexOf("dataUse.dataRecovery") == -1 || $scope.$$destroyed) {
                        $timeout.cancel(_promise);
                    } else {
                        scrollTop = $(window).scrollTop();
                        !_.isUndefined($scope.recoveryObj) && _initPage($scope.recoveryObj.uuid, false);
                        _promise = $timeout(_autoRefresh, _times);
                    }
                }
                _promise = $timeout(_autoRefresh, _times);

                _initPage();

                $scope.$on("$stateChangeSuccess", function(){
                    $('.table-container').width($('#service-content').width() * 0.98);
                });
            }
        ]
        var module = angular.module('recoverydirector.recovery.config');
        module.tinyController('recovery.ctrl', ctrler);
        return module;
    })
