define(["lazy-load/lazyLoad", "ui-router/angular-ui-router.min", "tiny-extra-directives/FloatingPanel", "tiny-extra-directives/DualSelectBox"],
    function(lazyLoadModule, router) {
        "use strict";

        var routerConfig = [{
            name: "settings",
            url: "/settings",
            breadcrumbs: { name: "settings_title" },
            templateUrl: "app/business/recoverydirector/setting/views/main.html",
            controller: "settings.ctrl",
            scripts: {
                'controllers': ["app/business/recoverydirector/setting/controllers/settingsCtrl"],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.userList",
            url: "/userList",
            templateUrl: "app/business/recoverydirector/setting/views/user/userList.html",
            controller: "settings.user.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/user/userCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.userEdit",
            url: "/userEdit/{id}",
            stateParamsKey: "id",
            templateUrl: "app/business/recoverydirector/setting/views/user/userEdit.html",
            controller: "settings.userEdit.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/user/userEditCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.userEdit.userGroup",
            url: "/userGroup",
            stateParamsKey: "id",
            templateUrl: "app/business/recoverydirector/setting/views/user/userRole.html",
            controller: "settings.userRole.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/user/userRoleCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.userEdit.resource",
            url: "/resource",
            stateParamsKey: "id",
            templateUrl: "app/business/recoverydirector/setting/views/user/moTree.html",
            controller: "settings.moTree.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/user/moTreeCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.userEdit.ipRange",
            url: "/ipRange",
            stateParamsKey: "id",
            templateUrl: "app/business/recoverydirector/setting/views/user/ipRange.html",
            controller: "settings.ipRang.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/user/ipRangCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.userEdit.bo",
            url: "/bo",
            stateParamsKey: "id",
            templateUrl: "app/business/recoverydirector/setting/views/user/boTree.html",
            controller: "settings.boTree.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/user/boTreeCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.roleAdd",
            url: "/roleAdd/{id}",
            stateParamsKey: "id",
            templateUrl: "app/business/recoverydirector/setting/views/role/roleAdd.html",
            controller: "settings.roleAdd.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/role/roleAddCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.roleList",
            url: "/roleList",
            templateUrl: "app/business/recoverydirector/setting/views/role/roleList.html",
            controller: "settings.roleList.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/role/roleListCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.onlineUserList",
            url: "/onlineUserList",
            templateUrl: "app/business/recoverydirector/setting/views/user/onlineUserList.html",
            controller: "settings.onlineUserList.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/user/onLineUserCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.securityPolicy",
            url: "/securityPolicy",
            templateUrl: "app/business/recoverydirector/setting/views/security/policy.html",
            controller: "settings.securityPolicy.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/security/policyCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.performance",
            url: "/performance",
            templateUrl: "app/business/recoverydirector/setting/views/performance/performance.html",
            controller: "settings.performance.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/performance/performanceCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.debugLog",
            url: "/debugLog",
            templateUrl: "app/business/recoverydirector/setting/views/syslog/debugLog.html",
            controller: "settings.debugLog.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/syslog/debugLogCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.operLogMaintance",
            url: "/operLogMaintance",
            templateUrl: "app/business/recoverydirector/setting/views/maintance/operLogMaintaince.html",
            controller: "settings.alarmMaintance.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/maintance/dataBakCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.alarmMaintance",
            url: "/operLogMaintance/{id}",
            templateUrl: "app/business/recoverydirector/setting/views/maintance/operLogMaintaince.html",
            controller: "settings.alarmMaintance.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/maintance/dataBakCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.sysData",
            url: "/sysData",
            templateUrl: "app/business/recoverydirector/setting/views/maintance/sysDataMaintaince.html",
            controller: "settings.sysData.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/maintance/systemConfCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.dataExport",
            url: "/dataExport",
            templateUrl: "app/business/recoverydirector/setting/views/maintance/dataExport.html",
            controller: "settings.dataExport.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/maintance/dataExportCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.sysOperLog",
            url: "/sysOperLog",
            templateUrl: "app/business/recoverydirector/setting/views/syslog/sysLogList.html",
            controller: "settings.sysOperLog.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/syslog/sysLogCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.license",
            url: "/license",
            templateUrl: "app/business/recoverydirector/setting/views/license/licenseManage.html",
            controller: "settings.license.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/license/licenseManageCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.oc_manage",
            url: "/ocManage",
            templateUrl: "app/business/recoverydirector/setting/views/cloudServiceManage/osManage.html",
            controller: "settings.osManage.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/cloudServiceManage/ocManageCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.area_manage",
            url: "/areaManage",
            templateUrl: "app/business/recoverydirector/setting/views/cloudServiceManage/areaManage.html",
            controller: "settings.areaManage.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/cloudServiceManage/areaManageCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.sysLog_manage",
            url: "/sysLogManage",
            templateUrl: "app/business/recoverydirector/setting/views/cloudServiceManage/sysLogReport.html",
            controller: "settings.sysLogReport.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/cloudServiceManage/sysLogReportCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "settings.proxy",
            url: "/proxy",
            templateUrl: "app/business/recoverydirector/setting/views/proxy/backupProxy.html",
            controller: "settings.backupProxy.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/setting/controllers/proxy/backupProxyCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }];

        var module = angular.module("recoverydirector.setting.config", ["ui.router"]);
        module = lazyLoadModule.makeLazy(module);
        module.tinyStateConfig({ stateConfig: routerConfig });
        return module;
    });