define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrl = [
        "$scope",
        "$sce",
        "message",
        "constsService",
        "appUtils",
        "infoTransferredService",
        "restService",
        function($scope, $sce, message, constsService, appUtils, infoTransferredService, restService) {
            var data = $("#" + constsService.AREA_ADD_EDIT_WIN.winId).widget().option("data");
            $scope.model = {
                TIPS: $sce.trustAsHtml(appUtils.getString("area_editdelete_tips_label")),
                labels: {
                    name: appUtils.getStringWithColon("area_manage_name_label"),
                    ID: appUtils.getStringWithColon("area_manage_id_label")
                },
                name: {
                    id: "name",
                    width: constsService.W4,
                    value: data.name,
                    disabled: false,
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "regularCheck",
                        params: ["/^[\\u4e00-\\u9fa50-9a-zA-Z_]{1}[\\u4e00-\\u9fa5a-zA-Z_0-9-]{1,255}$/"],
                        errorDetail: appUtils.getString("validate_term_common_name_1_255_msg")
                    }],
                    placeholder: appUtils.getString("area_manage_nameplaceholder_label")
                },
                ID: {
                    id: "ID",
                    width: constsService.W4,
                    value: data.regionId,
                    disabled: false,
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "maxSize",
                        params: [255],
                        errorDetail: appUtils.getString("validate_term_common_length_range_1_255_msg")
                    }],
                    placeholder: appUtils.getString("area_manage_idplaceholder_label")
                }
            }
        }
    ];

    var module = angular.module("recoverydirector.setting.config");
    module.tinyController("setting.addModifyAreaCtrl", ctrl);
    return module;
})