define(["tiny-common/UnifyValid"], function(UnifyValid) {
    var ctrl = [
        "$scope",
        "constsService",
        "appUtils",
        "restService",
        "statusEnumService",
        "message",
        "infoTransferredService",
        function($scope, constsService, appUtils, restService, statusEnumService, message, infoTransferredService) {

            var _editRegionAction = function(rowData) {
                restService.queryRegion(rowData.uuid, function(result) {
                    var win = angular.copy(constsService.AREA_ADD_EDIT_WIN);
                    win.title = appUtils.getString("common_term_edit_button") + appUtils.getString("site_create_area_label");
                    win.data = result;
                    appUtils.showWindow(win, function() {
                        var options = this.options;
                        if (!UnifyValid.FormValid($("#" + options.verifyId), { focusInvalid: true })) {
                            return;
                        }

                        var params = {};
                        params.name = $.trim($("#name").widget().getValue());
                        params.regionId = $.trim($("#ID").widget().getValue());
                        restService.modifyRegion([rowData.uuid], {
                            data: params,
                            success: function() {
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function() {
                                        queryRegions();
                                        $("#" + options.winId).widget().destroy();
                                    }
                                });
                            }
                        })
                    })
                })
            };

            var _deleteRegionAction = function(rowData) {
                message.warn({
                    content: appUtils.getString("area_delete_warn_label", rowData.name),
                    ok: function() {
                        restService.deleteRegion([rowData.uuid], function(result) {
                            message.success({
                                content: appUtils.getString("common_term_operation_success_label"),
                                ok: function() {
                                    queryRegions();
                                }
                            });
                        })
                    }
                })
            }

            var queryRegions = function() {
                    restService.queryRegions([], function(result) {
                        _.each(result.records, function(record) {
                            record.name = appUtils.getString(record.name);
                        });
                        $scope.model.datasTable.data = appUtils.encodeForHTML(result.records);
                        $scope.model.datasTable.totalRecords = result.totalCount;
                        $scope.$apply();
                    })
                },
                opt = {
                    edit: {
                        id: "iconBtnEdit",
                        template: "<div class='iconbutton-edit' title='" + appUtils.getString(
                            "common_term_edit_button") + "'></div>",
                        clickActive: function(rowData) {
                            _editRegionAction(rowData);
                        },
                        hover: function(rowData) {
                            return !rowData.ispreSet;
                        }
                    },
                    delete: {
                        id: "iconBtnDel",
                        template: "<div class='iconbutton-delete'  title='" + appUtils.getString(
                            "common_term_delete_button") + "'></div>",
                        clickActive: function(rowData) {
                            _deleteRegionAction(rowData);
                        },
                        hover: function(rowData) {
                            return !rowData.ispreSet;
                        }
                    }
                },
                opt = appUtils.tableHoverWrapper(opt);

            $scope.model = {
                btnCreate: {
                    id: "btnCreate",
                    text: appUtils.getString("common_term_add_button"),
                    click: function() {
                        var areaAddWin = angular.copy(constsService.AREA_ADD_EDIT_WIN);
                        areaAddWin.title = this.text + appUtils.getString("site_create_area_label");
                        appUtils.showWindow(areaAddWin, function() {
                            var options = this.options;
                            if (!UnifyValid.FormValid($("#" + options.verifyId), { focusInvalid: true })) {
                                return;
                            }

                            var params = {};
                            params.name = $.trim($("#name").widget().getValue());
                            params.regionId = $.trim($("#ID").widget().getValue());
                            restService.createRegion([], {
                                data: params,
                                success: function() {
                                    message.success({
                                        content: appUtils.getString("common_term_operation_success_label"),
                                        ok: function() {
                                            queryRegions();
                                            $("#" + options.winId).widget().destroy();
                                        }
                                    });
                                }
                            })
                        })
                    }
                },
                btnRefresh: {
                    text: appUtils.getString("common_term_refresh_button"),
                    click: queryRegions
                },
                datasTable: {
                    id: "datasTable",
                    data: [],
                    displayLength: constsService.TABLE_COUNT_PER_PAGE_BIG,
                    totalRecords: 0,
                    paginationStyle: "full_numbers",
                    startPage: 0,
                    pageSize: constsService.TABLE_COUNT_PER_PAGE_BIG,
                    paging: "auto",
                    operateButtonCount: 2,
                    buttonContainerPosition: "right",
                    columns: [{
                        "mData": "uuid",
                        "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("area_manage_name_label"),
                        "mData": "name"
                    }, {
                        "sTitle": appUtils.getString("area_manage_id_label"),
                        "mData": "regionId",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("area_manage_preset_label"),
                        "mData": "ispreSet",
                        "bSortable": false
                    }],
                    callback: function(evtObj) {},
                    sortCallback: function(th, sortObj) {},
                    renderRow: function(nRow, aData, iDataIndex) {
                        var isPresetArea = statusEnumService.getStatus("IS_PRESET_AREA", $.trim(
                            aData['ispreSet']));
                        $("td[tdtitle='" + appUtils.getString("area_manage_preset_label") + "']",
                            nRow).html(isPresetArea);
                    },
                    cellClickActive: function(e, param) {},
                    hoverActive: function(e, param) {
                        opt.notify(param);
                    },
                    opAreaConfig: [opt.edit, opt.delete]
                }
            };

            queryRegions();
        }
    ]
    var module = angular.module('recoverydirector.setting.config');
    module.tinyController('settings.areaManage.ctrl', ctrl);
    return module;
})