define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrler = [
        "$scope",
        "$state",
        "$stateParams",
        "message",
        "mask",
        "constsService",
        "appUtils",
        "restService",
        function($scope, $state, $stateParams, message, mask, constsService, appUtils, restService) {
            $scope.ocConfigTitle = appUtils.getString("settings_cloud_service_oc_configuration");
            $scope.northConfigTitle = appUtils.getString("settings_cloud_service_northAPI_configuration");
            var focusFlag = false;
            $scope.model = {
                labels: {
                    domain: appUtils.getStringWithColon("common_domain_or_ip_address_label"),
                    port: appUtils.getStringWithColon("common_term_port_label"),
                    user: appUtils.getStringWithColon("common_term_username_label"),
                    password: appUtils.getStringWithColon("common_term_password_label")
                },
                northDomain: {
                    id: "northDomain",
                    width: constsService.W4,
                    value: "",
                    extendFunction: ["checkDomain"],
                    validate: "checkDomain : extend function;",
                    focus: function() {}
                },
                domain: {
                    id: "domainText",
                    width: constsService.W4,
                    value: "",
                    extendFunction: ["checkDomain"],
                    validate: "checkDomain : extend function;",
                    focus: function() {
                        !focusFlag && ($scope.model.password.value = "");
                        focusFlag = true;
                        $scope.$apply();
                    }
                },
                northPort: {
                    id: "northPort",
                    width: constsService.W4,
                    value: "",
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "rangeValue",
                        params: [1, 65535],
                        errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 1, 65535)
                    }, {
                        validFn: "integer"
                    }],
                    focus: function() {}
                },
                port: {
                    id: "portText",
                    width: constsService.W4,
                    value: "",
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "rangeValue",
                        params: [1, 65535],
                        errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 1, 65535)
                    }, {
                        validFn: "integer"
                    }],
                    focus: function() {
                        !focusFlag && ($scope.model.password.value = "");
                        focusFlag = true;
                        $scope.$apply();
                    }
                },
                user: {
                    id: "userText",
                    width: constsService.W4,
                    value: "",
                    validate: "required",
                    focus: function() {
                        !focusFlag && ($scope.model.password.value = "");
                        focusFlag = true;
                        $scope.$apply();
                    }
                },
                password: {
                    id: "passwordText",
                    width: constsService.W4,
                    type: "password",
                    value: "",
                    validate: "required",
                    focus: function() {
                        !focusFlag && (this.value = "");
                        focusFlag = true;
                        $scope.$apply();
                    }
                },
                northOkBtn: {
                    authKey: appUtils.checkRight("ism.drm.thirdservice.oc.modify"),
                    id: "northOKBtn",
                    text: appUtils.getString("common_term_confirm_button"),
                    click: function() {
                        if (!UnifyValid.FormValid($("#northManageRestForm"), {
                                focusInvalid: true
                            })) {
                            return;
                        }

                        var params = {
                            domain: $("#northDomain").widget().getValue(),
                            port: $("#northPort").widget().getValue()
                        }

                        restService.setNorthAPIConfig({}, {
                            data: params,
                            success: function(result) {
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function() {
                                        init()
                                    }
                                })
                            }
                        })



                    }
                },
                northCancelBtn: {
                    id: "northCancelBtn",
                    text: appUtils.getString("common_term_cancel_button"),
                    click: function() {
                        init();
                    }
                }
            };

            $scope.btnOk = {
                authKey: appUtils.checkRight("ism.drm.thirdservice.oc.modify"),
                id: "ocManangConfirmBtn",
                text: appUtils.getString("common_term_confirm_button"),
                click: function() {
                    if (!UnifyValid.FormValid($("#ocManageRestForm"), {
                            focusInvalid: true
                        })) {
                        return;
                    }
                    if (!focusFlag) {
                        $scope.model.password.value = "";
                        $scope.$apply();
                        focusFlag = true;
                        UnifyValid.FormValid($("#ocManageRestForm"), {
                            focusInvalid: true
                        });
                        return;
                    }
                    var params = {
                        domain: $("#domainText").widget().getValue(),
                        port: $("#portText").widget().getValue(),
                        username: $("#userText").widget().getValue(),
                        password: $("#passwordText").widget().getValue()
                    }
                    restService.setOcAlarmService({}, {
                        data: params,
                        success: function(result) {
                            message.success({
                                content: appUtils.getString("common_term_operation_success_label"),
                                ok: function() {
                                    init()
                                }
                            })
                        }
                    })
                }
            };
            $scope.btnCancel = {
                id: "ocManangCancleBtn",
                text: appUtils.getString("common_term_cancel_button"),
                click: function() {
                    init();
                }
            };
            //查询OC对接信息
            function init() {
                restService.getOcAlarmService({}, function(result) {
                    $scope.model.domain.value = !_.isEmpty(result.domain) ? result.domain : "";
                    $scope.model.port.value = (Object.prototype.toString.call(result.port) == "[object Number]" && result.port != 0) ? result.port : "";
                    $scope.model.user.value = !_.isEmpty(result.username) ? result.username : "";
                    $scope.model.password.value = !_.isEmpty(result.username) ? "********" : "";
                    focusFlag = false;
                    $scope.$apply();
                });

                restService.getNorthAPIConfig({}, function(result) {
                    $scope.model.northDomain.value = !_.isEmpty(result.domain) ? result.domain : "";
                    $scope.model.northPort.value = (Object.prototype.toString.call(result.port) == "[object Number]" && result.port != 0) ? result.port : "";
                    $scope.$apply();
                });
            }

            //校验domain
            UnifyValid.checkDomain = function() {
                var val = $(this).val();
                var ipReg = /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/;
                var httpsReg = /^(?=^.{3,255}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+$/;
                if (_.isEmpty(val)) {
                    return appUtils.getString("common_term_empty_label");
                };
                if (ipReg.test(val) || httpsReg.test(val) || appUtils.validIPv4OrIPv6Address(val)) {
                    return "";
                }
                if (!ipReg.test(val) && !httpsReg.test(val) && !appUtils.validIPv4OrIPv6Address(val)) {
                    return appUtils.getString("validate_term_https_erro");
                }
                return "";
            };

            $scope.$on('$destroy', function() {
                delete UnifyValid.checkDomain;
            });

            init();
        }
    ];

    var module = angular.module('recoverydirector.setting.config');
    module.tinyController('settings.osManage.ctrl', ctrler);
    return module;
});
