define(["tiny-common/UnifyValid"], function(UnifyValid) {
	"use strict";
	var ctrler = [
			"$scope",
			"$state",
			"$sce",
			"$compile",
			"$stateParams",
			"message",
			"mask",
			"constsService",
			"appUtils",
			"restService",
			"cookieService",
			function($scope, $state, $sce, $compile, $stateParams, message, mask ,constsService, appUtils, restService, cookieService) {
				$scope.sysLogReportTitle = appUtils.getString("setting_syslog_report_administrator_label");
				$scope.sysLogReportMessage = appUtils.getString("syslognotify_tip");
				$scope.sysLogReportImportTips = $sce.trustAsHtml(appUtils.getString("setting_syslog_report_import_ca_label"));
				$scope.tenantLogReportTitle = appUtils.getString("setting_syslog_report_talent_label");
				$scope.tenantLogReportMessage = "";
				$scope.model = {
					labels: {
						ip:appUtils.getStringWithColon("common_domain_or_ip_address_label"),
						port: appUtils.getStringWithColon("common_term_port_label"),
						securityProtocol: appUtils.getStringWithColon("syslognotify_securityssl_label")
					},
					checkBox:{
						id: "sysLogCheckBox",
						checked: false,
						text: appUtils.getString("setting_syslog_report_administrator_enable_label"),
						click: function(){
								$scope.model.ip.disable = this.checked;
								$scope.model.port.disable = this.checked;
								$("#securityProtocol").widget().opDisabled("TCP", this.checked);
								$("#securityProtocol").widget().opDisabled("SSL_TCP", this.checked);
								$("#securityProtocol").widget().opDisabled("TLS_TCP", this.checked);
								this.checked && ($scope.model.ip.value = "");
								this.checked && ($scope.model.port.value = "");

								$scope.$apply();
						}
					},
					tenantCheckBox: {
						id: "tenantCheckBox",
						checked: false,
						text: appUtils.getString("setting_syslog_report_talent_enable_label"),
						click: function(){
							$scope.model.tenantIp.disable = this.checked;
							$scope.model.tenantPort.disable = this.checked;
							this.checked && ($scope.model.tenantIp.value = "");
							this.checked && ($scope.model.tenantPort.value = "");
							$scope.$apply();
						}
					},
					ip:{
						id: "sysLogIp",
						value: "",
						width: 200,
						validate: "checkDomain : extend function;",
						extendFunction: ["checkDomain"],
						disable: true
					},
					tenantIp: {
						id: "tenantLogIp",
						value: "",
						width: 200,
						validate: "checkDomain : extend function;",
						extendFunction: ["checkDomain"],
						disable: true
					},
					port:{
						id: "sysLogPort",
						value: "",
						width: 200,
						validate:[{
                         validFn: "required"
	                     },{
	                         validFn: "rangeValue",
	                         params: [1, 65535],
	                         errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 1, 65535)
	                     },{
	                         validFn: "integer"
	                     }],
	                     disable: true
					},
					tenantPort: {
						id: "tenantLogPort",
						value: "",
						width: 200,
						validate:[{
                         validFn: "required"
	                     },{
	                         validFn: "rangeValue",
	                         params: [1, 65535],
	                         errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 1, 65535)
	                     },{
	                         validFn: "integer"
	                     }],
	                     disable: true
					},
					securityProtocol: {
						id: "securityProtocol",
						contentcls: "contentcls",
						sysLogSecurityProtocolShow: false,
						sysLogSecurityProtocolTcpShow: false,
						sysLogSecurityProtocolTlsShow: false,
						sysLogSecurityProtocol: $sce.trustAsHtml(appUtils.getString("syslognotify_securityProtocol_tip")),
						sysLogSecurityProtocolTcp: appUtils.getString("syslognotify_securityProtocol_tcp_tip"),
						sysLogSecurityProtocolTls: $sce.trustAsHtml(appUtils.getString("syslognotify_securityProtocol_tls_tip")),
						contentTdAttr: {
							colspan:"2",
							align: "right"
						},
						values: [
							{
								"key": "TLS_TCP",
								"text": "TLS+TCP",
								"checked": true,
								"disable": true
							},
						    {
						        "key": "SSL_TCP",
						        "text": "SSL+TCP",
						        "checked": false,
						        "disable": true
						    },
						    {
						        "key": "TCP",
						        "text": "TCP",
						        "checked": false,
						        "disable": true
						    }
						],
						spacing: {"width": "80px"},
						change: function(event) {
							var protocalId = $("#securityProtocol").widget().opChecked("checked");
							if("TLS_TCP" != protocalId){
								message.warn({
									content: appUtils.getString("setting_syslog_report_warn_label", protocalId.replace("_","+"), "TLS+TCP"),
									cancel: function(){
										$("#securityProtocol").widget().opChecked("TLS_TCP", true)
									},
								})
							};
							$scope.$apply();
						}
					}
				}
				$scope.btnOk = {
					authKey: appUtils.checkRight("ism.drm.thirdservice.oc.modify"),
					id: "sysLogReportConfirmBtn",
					text: appUtils.getString("common_term_confirm_button"),
					click: function(){
						if (!UnifyValid.FormValid($("#sysLogReportRestForm"), {focusInvalid: true})) {
                            return;
                        }
						var params = {
							logType: "administratorlog",
							isEnabled: $("#sysLogCheckBox").widget().option("checked"),
							protocalType: "syslog",
							protocalProps:{
								port: $("#sysLogPort").widget().getValue(),
								ip: $("#sysLogIp").widget().getValue(),
								encryptionMode: $("#securityProtocol").widget().opChecked("checked")
							}
						}
						params.protocalProps = JSON.stringify(params.protocalProps);
						var userInfo = appUtils.getString("setting_syslog_report_role_admin_label");
						if(!params.isEnabled){
							message.warn({
								content: appUtils.getString("setting_syslog_report_cancel_warn_label", userInfo, userInfo, userInfo),
								ok: function(){
									restService.setBcmLognotify({},{
										data: params,
										success: function(result){
											message.success({
												content: appUtils.getString("common_term_operation_success_label"),
												ok: function(){
													init()
												}
											})
										}
									})
								}
							})
						}else{
							restService.setBcmLognotify({},{
								data: params,
								success: function(result){
									message.success({
										content: appUtils.getString("common_term_operation_success_label"),
										ok: function(){
											init()
										}
									})
								}
							})
						}
					}
				};
				$scope.btnCancel = {
					id: "sysLogReportCancleBtn",
					text: appUtils.getString("common_term_cancel_button"),
					click: function(){
						init()
					}
				};
				$scope.btnTenantOk = {
					id: "tenantLogReportConfirmBtn",
					text: appUtils.getString("common_term_confirm_button"),
					click: function(){
						if (!UnifyValid.FormValid($("#tenantLogReportRestForm"), {focusInvalid: true})) {
                            return;
                        };
						var params = {
							logType: "tenantlog",
							isEnabled: $("#tenantCheckBox").widget().option("checked"),
							protocalType: "CTS",
							protocalProps:{
								port: $("#tenantLogPort").widget().getValue(),
								ip: $("#tenantLogIp").widget().getValue()
							}
						};
						params.protocalProps = JSON.stringify(params.protocalProps);
						var userInfo = appUtils.getString("setting_syslog_report_role_talent_label");
						if(!params.isEnabled){
							message.warn({
								content: appUtils.getString("setting_syslog_report_cancel_warn_label", userInfo, userInfo, userInfo),
								ok: function(){
									restService.setBcmLognotify({},{
										data: params,
										success: function(result){
											message.success({
												content: appUtils.getString("common_term_operation_success_label"),
												ok: function(){
													tenantInit();
												}
											})
										}
									});
								}
							})
						}else{
							restService.setBcmLognotify({},{
								data: params,
								success: function(result){
									message.success({
										content: appUtils.getString("common_term_operation_success_label"),
										ok: function(){
											tenantInit();
										}
									})
								}
							});
						}
					}
				};
				$scope.btnTenantCancel = {
					id: "tenantLogReportCancleBtn",
					text: appUtils.getString("common_term_cancel_button"),
					click: function(){
						tenantInit();
					}
				};
				UnifyValid.checkDomain = function(){
					var val = $(this).val();
					var ipReg = /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/;
					var httpsReg = /^(?=^.{3,255}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+$/;
					if (_.isEmpty(val)) {
					    return appUtils.getString("common_term_empty_label");
					};
					if (ipReg.test(val) || httpsReg.test(val) || appUtils.validIPv4OrIPv6Address(val)) {
					    return "";
					}
					if (!ipReg.test(val) && !httpsReg.test(val) && !appUtils.validIPv4OrIPv6Address(val)) {
					    return appUtils.getString("validate_term_https_erro");
					}
					return "";
				};
				$scope.$on('$destroy', function() {
				    delete UnifyValid.checkDomain;
				});
				//查询sysLog上报地址信息
				function init(){
					restService.getBcmLognotify({logType:"administratorlog"},function(result){
						result = result[0];
						$scope.model.ip.value = _.isEmpty(result) || _.isEmpty(result.protocalProps) ? "" : JSON.parse(result.protocalProps).ip;
						$scope.model.port.value = _.isEmpty(result) || _.isEmpty(result.protocalProps) ? "" : JSON.parse(result.protocalProps).port;
						$("#securityProtocol").widget().opChecked(_.isEmpty(result) || _.isEmpty(result.protocalProps) ? "TLS_TCP" : JSON.parse(result.protocalProps).encryptionMode, "true");
						$scope.model.checkBox.checked = _.isEmpty(result) ? false : result.isEnabled;
						$scope.model.ip.disable = _.isEmpty(result) ? true : !result.isEnabled;
						$scope.model.port.disable = _.isEmpty(result) ? true : !result.isEnabled;
						$("#securityProtocol").widget().opDisabled("TCP", _.isEmpty(result) ? true : !result.isEnabled);
						$("#securityProtocol").widget().opDisabled("SSL_TCP", _.isEmpty(result) ? true : !result.isEnabled);
						$("#securityProtocol").widget().opDisabled("TLS_TCP", _.isEmpty(result) ? true : !result.isEnabled);
						$scope.$apply();
					})
				}
				//查询租户日志上报地址信息
				function tenantInit(){
					restService.getBcmLognotify({logType:"tenantlog"},function(result){
						result = result[0];
						$scope.model.tenantIp.value = _.isEmpty(result) || _.isEmpty(result.protocalProps) ? "" : JSON.parse(result.protocalProps).ip;
						$scope.model.tenantPort.value = _.isEmpty(result) || _.isEmpty(result.protocalProps) ? "" : JSON.parse(result.protocalProps).port;
						$scope.model.tenantCheckBox.checked = _.isEmpty(result) ? false : result.isEnabled;
						$scope.model.tenantIp.disable = _.isEmpty(result) ? true : !result.isEnabled;
						$scope.model.tenantPort.disable = _.isEmpty(result) ? true : !result.isEnabled;
						$scope.$apply();
					})
				};

				window['openCA'] = function() {
					openHelpLinkByKey("settings.sysLog_protocal_manage");
				}

				/**
				 * 根据对象key定位到对应的链接帮助页面
				 * @param  {[type]} key [description]  从HELP_MAP和WIN_HELP_MAP中获取的key值
				 * @return {[type]}     [description]
				 */
				function openHelpLinkByKey(key) {
				    restService.getSoftwareInfo([], {
				        mask: false,
				        success: function(result) {
				            var url = window.isEn ? "/help/en/en-us_bookmap_0229729142.htm" : "/help/zh/zh-cn_bookmap_0229728260.htm";
				            if (window.isUltraVR) {
				                url = window.isEn ? "/help_fs/en/en-us_bookmap_0229730378.htm" : "/help_fs/zh/zh-cn_bookmap_0229730378.htm";
				            }

				            var currKey = _.isUndefined(key) ? "" : key;
				            if (!currKey ||!_.has(constsService.HELP_MAP, currKey)) {
				                return;
				            }
				            window.open(url + "#" + constsService.HELP_MAP[currKey], "online_help");
				        }
				    })
				}

				init()
				tenantInit()
			}];

	var module = angular.module('recoverydirector.setting.config');
    module.tinyController('settings.sysLogReport.ctrl', ctrler);
    return module;
});
