define(["tiny-common/UnifyValid"], function(UnifyValid) {
	"use strict";
	var ctrler = [
			"$scope",
			"$state",
			"$stateParams",
			"message",
			"mask",
			"constsService",
			"appUtils",
			"restService",
			function($scope, $state, $stateParams, message, mask ,constsService, appUtils, restService) {
				$scope.sysConfigTitle = appUtils.getString("thirdservcie_sysnetwork_domain_IP_config_label");
				$scope.domainOS = {
					labels: appUtils.getStringWithColon("common_domain_or_ip_address_label"),
					id:"domainOsText",
					value:"",
					extendFunction: ["checkDomain"],
					validate:"checkDomain : extend function;"
				};
				$scope.domainOC = {
					labels: appUtils.getStringWithColon("thirdservcie_sysnetwork_domain2_label"),
					id:"domainOcText",
					value:"",
					extendFunction: ["checkDomain"],
					validate:"checkDomain : extend function;"
				};
				$scope.btnOk = {
					authKey: appUtils.checkRight("ism.drm.thirdservice.sysnetwork.modify"),
					id: "sysconfigOkBtn",
					text: appUtils.getString("common_term_confirm_button"),
					click: function(){
						if (!UnifyValid.FormValid($("#sysManageRestForm"), {focusInvalid: true})) {
                            return;
                        }
                        var domainOs = $("#domainOsText").widget().getValue();
                        restService.setBcmDomainService({},{
                        	data:{businessDomain:domainOs},
                        	success:function(result){
                        		message.success({
                        			content: appUtils.getString("common_term_operation_success_label"),
                        			ok: function(){
                        				init()
                        			}
                        		})
                        	}
                        })
					}
				};
				$scope.btnCancel = {
					id: "sysconfigCancleBtn",
					text: appUtils.getString("common_term_cancel_button"),
					click: function(){
						init()
					}
				};
				$scope.FOROPENSATCK = appUtils.getString("thirdservcie_sysnetwork_Interconnect_openstack_tips");
				$scope.FOROCCENTER = appUtils.getString("thirdservcie_sysnetwork_Interconnect_oc_tips");
				function init(){
					restService.getBcmDomainService({},function(result){
						$scope.domainOS.value = !_.isEmpty(result.businessDomain) ? result.businessDomain : "" ;
						$scope.$apply();
					})
				};
				UnifyValid.checkDomain = function(){
					var val = this[0].value;
					var ipReg = /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/;
                    var httpsReg = /^(?=^.{3,255}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+$/;
                    if(_.isEmpty(val)){
                        return appUtils.getString("common_term_empty_label");
                    };
                    if(ipReg.test(val) || httpsReg.test(val) || appUtils.validIPv4OrIPv6Address(val)){
                        return "";
                    }
                    if(!ipReg.test(val) && !httpsReg.test(val) && !appUtils.validIPv4OrIPv6Address(val)){
                        return appUtils.getString("validate_term_https_erro");
                    }
		            return "";
				};
				$scope.$on('$destroy', function() {
                    delete UnifyValid.checkDomain;
                });
                init()
			}];

	return ctrler;
});
