define(["tiny-widgets/FileUpload"], function(FileUpload) {
	"use strict";
	var ctrler = [
			"$rootScope",
			"$scope",
			"$compile",
			"$state",
			"$stateParams",
			"$timeout",
			"exception",
			"message",
			"communicationService",
			"utilService",
			"mask",
			"constsService",
			"statusEnumService",
			"appUtils",
			"cookieService",
			function($rootScope, $scope,$compile, $state,$stateParams, $timeout, exception, message,
					communicationService, utilService, mask ,constsService,statusEnumService,appUtils,cookieService) {
				(function(scope){
					var license =
					{
						title : appUtils.getString("license_manage_title"),
						desc : appUtils.getString("license_manage_desc"),
						"export" :
						{
							id : "export",
							label : appUtils.getString("common_term_export_button"),
							click : function()
							{
								appUtils.export("/license/action/export");
							}
						},
						"import" :
						{
							id : "import",
							label : appUtils.getString("common_term_import_button"),
							click : function()
							{
							}
						}
					};

					var info =
						{
							licenseSn :
							{
								label : appUtils.getStringWithColon("license_manage_sn_label"),
								value : "--"
							},
							formatVersion :
							{
								label : appUtils.getStringWithColon("license_manage_version_label"),
								value : "--"
							},
							activeTime :
							{
								label : appUtils.getStringWithColon("license_manage_activeTime_label"),
								value : "--"
							},
							softId:
							{
								label:appUtils.getStringWithColon("license_manage_softId_label"),
								value:"--"
							}
						};

					license.info = info;
					scope.license = license;
				})($scope);

				//功能项
				var functionItems = (function(license){
					var functionItems =
					{
						title : appUtils.getString("license_manage_function_items_title"),
			            id : "functionItemsTable",
			            columns : [ {
			            	"sTitle" : appUtils.getString("common_term_description_column"),
			            	"bSortable" :false,
			            	"mData" : "funcName"
			            }],
			            displayLength: constsService.TABLE_COUNT_MAX_PAGE,
			            data : []
					};

					license.functionItems = functionItems;
					return functionItems;
				})($scope.license);


				//资源项
				(function(license){
					var resourcesItems = {
						title : appUtils.getString("license_manage_resources_items_title"),
						id : "rsourcesItemsTable",
		            	columns : [ {
		            		"sTitle" : appUtils.getString("license_resource_term_description_column"),
		            		"bSortable" :false,
		            		"mData" : "resName",
		            		"sWidth" : "60%"
		            	},{
		            		"sTitle" : appUtils.getString("setting_term_license_used_title"),
		            		"bSortable" :false,
		            		"mData" : "useCount"
		            	},{
		            		"sTitle" : appUtils.getString("setting_term_license_auth_title"),
		            		"bSortable" :false,
		            		"mData" : "fixCount"
		            	}],
		            	renderRow : function(nRow, aData, iDataIndex) {
						},
						displayLength: constsService.TABLE_COUNT_MAX_PAGE,
		            	data : []
					};

					license.resourcesItems = resourcesItems;
				})($scope.license);


				var licenseManage = {
					init : function()
						{
							mask.show();
							communicationService.get(utilService.getResouceUrl("/license"))
                            .promise().always(function (result) {
                            	mask.hide();

								if (!exception.check(result)) {
                                    return;
                                }

                            	appUtils.encodeForHTML(result);

                            	//初始化基本信息
                            	var info = $scope.license.info;
                            	angular.forEach(info,function(value,key){
                            		info[key].value = _.isEmpty(result[key]) || result[key] === "null" ? "--" : result[key];
                            	});

								//资源项
								var singleChar = appUtils.getString("common_label_single_label");

								$scope.license.resourcesItems.data = result.resList;

								$scope.$apply();
                        	});
						}
				};

				licenseManage.init();
				var user = appUtils.getCurrentUser();
		        $scope.isLicenseOpt = angular.isDefined(user) && (user.isAdministrator || user.isAdmin);

		        if(!$scope.isLicenseOpt)
		        {
		        	return;
		        }
				var upLoad = new tinyWidget.FileUpload({
					id : "fileUpLoad",
				    action : utilService.getResouceUrl("/license/action/import"),
					fileType : ".xml",
					"enableProgress" : false,
					"enableDetail" : false,
					auto : true,
					showSubmitBtn : false,
					select : function(){
				    },
				    selectError : function(){
				    	$("#fileUpLoad .tiny-fileUpload").widget().empty();
				    	message.error(appUtils.getString("import_license_fileType_msg"));
				    },
				    beforeSubmit : function(){
				    	mask.show();
				    	$("#fileUpLoad .tiny-fileUpload").widget().addFormData({"rd_randomStr_HW": cookieService.getToken()});
				   	},
					afterSubmit : function(){
					},
					complete : function(event,queue)
					{
						mask.hide();
						$("#fileUpLoad .tiny-fileUpload").widget().empty();

						var json = $(queue).text();
						if(_.isEmpty(json))
						{
							message.success({content: appUtils.getString("common_term_operation_success_label"), ok: function(){
								licenseManage.init();
    				    	}});
							return;
						}

						if (!exception.check(json)) {
                            return;
                        }
					}
				});
			}];

	var module = angular.module('recoverydirector.setting.config');
    module.tinyController('settings.license.ctrl', ctrler);
    return module;
});
