define(["tiny-common/UnifyValid"], function(UnifyValid) {
        "use strict";
        var ctrler = [
            "$scope",
            "$compile",
            "$state",
            "$stateParams",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "restService",

            function ($scope, $compile, $state, $stateParams, exception, message, communicationService, utilService, mask, constsService, appUtils, restService) {

                $scope.DAY = appUtils.getString("securtiy_term_day_field_label");
                $scope.configformTitle1 = appUtils.getString("maintance_term_param_title");
                $scope.configformTitle2 = appUtils.getString("maintance_term_histroy_title");
                $scope.TIPS = $stateParams.id == "" ? appUtils.getString("maintance_term_alarmbak_tips") : appUtils.getString("maintance_term_logbak_tips");
                //2告警转储 1日志转储
                var urlPreffx = ($stateParams.id == "") ? "/alarms/" : "/operationlogs/";
                var btnKey = appUtils.checkRight("lego.sys.dataStorage.sysOptLog.modify");
                var delKey = "lego.sys.dataStorage.sysOptLog.delete";
                if (urlPreffx == /alarms/){
                	btnKey = appUtils.checkRight("lego.sys.dataStorage.event.modify");
                	delKey = "lego.sys.dataStorage.event.delete";
                }
                var exportScope = $scope.$new();
                exportScope.exportFile = function (id) {
                    var exportUrl = urlPreffx + "action/exportLogTransferStorage";
                    if ($stateParams.id == "") {
                        exportUrl = urlPreffx + "action/exportAlarmTransferStorage";
                    }
                    appUtils.export(exportUrl, {
                        fileId: id
                    });
                };

                $scope.btnOk = {
                    id: "btnCreateOk",
                    text: appUtils.getString("common_term_confirm_button"),
                    authKey: btnKey,
                    click: function () {
                        var result = UnifyValid.FormValid($("#resetForm"), {focusInvalid: true});
                        if (!result) {
                            return;
                        }
                        var param = {};
                        param.fileType = parseInt($("#fileformat").widget().getSelectedId(), 10);
                        param.languageType = parseInt($("#language").widget().getSelectedId(), 10);
                        param.transferStartTime = $("#baktime").widget().getDateTime();
                        param.period = parseInt($("#bakcycle").widget().option("value"), 10);
                        param.dataSavedTime = parseInt($("#retaintime").widget().option("value"), 10);
                        mask.show();
                        communicationService.put(utilService.getResouceUrl(urlPreffx + "action/modifyTransferStorageConfig"), param)
                            .promise().always(function (result) {
                            mask.hide();
                            if (exception.check(result)) {
                                message.success({
                                    "content": appUtils.getString("common_term_operation_success_label"),
                                    "ok": function () {
                                        _init();
                                    }
                                })
                            }
                        });
                    }
                };

                $scope.btnCancel = {
                    id: "btnCreateCancel",
                    text: appUtils.getString("common_term_cancel_button"),
                    click: function () {
                        _init();
                    }
                };

                $scope.model = {
                    labels: {
                        baktime: appUtils.getStringWithColon("maintance_term_baktime_label"),
                        bakcycle: appUtils.getStringWithColon("maintance_term_bakcycle_label"),
                        retaintime: appUtils.getStringWithColon("maintance_term_retaintime_label"),
                        nextbaktime: appUtils.getStringWithColon("maintance_term_nextbaktime_label"),
                        filepath: appUtils.getStringWithColon("maintance_term_filepath_label"),
                        fileformat: appUtils.getStringWithColon("maintance_term_fileformat_label"),
                        language: appUtils.getStringWithColon("maintance_term_language_label")

                    },
                    baktime: {
                        id: "baktime",
                        width: constsService.W3,
                        timeFormat: "hh:mm:ss",
                        type: "time",
                        value: "11:00:20",
                        validate: "required"
                    },
                    retaintime: {
                        width: constsService.W3,
                        id: "retaintime",
                        max: "120",
                        min: "7",
                        validate: "required"
                    },
                    bakcycle: {
                        width: constsService.W3,
                        id: "bakcycle",
                        max: "120",
                        min: "7",
                        validate: "required"
                    },
                    nextbaktime: {
                        width: constsService.W3,
                        id: "nextbaktime"
                    },
                    filepath: {
                        width: constsService.W3,
                        id: "filepath"
                    },
                    fileformat: {
                        width: constsService.W3,
                        id: "fileformat",
                        values: [{
                            selectId: "1",
                            label: "CSV"
                        }, {
                            selectId: "2",
                            label: "Excel"
                        }],
                        defaultSelectid: "1"
                    },
                    language: {
                        width: constsService.W3,
                        id: "language",
                        values: [{
                            selectId: "1",
                            label: "English"
                        }, {
                            selectId: "2",
                            label: appUtils.getString("common_term_chinese_label")
                        }],
                        defaultSelectid: "1"
                    }
                };


                $scope.datasTable = {
                    id: "datasBakTable",
                    paginationStyle:"full_numbers",
                    columns: [{
                        "sTitle": "resultId",
                            "mData": "resultId",
                            "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("task_term_begintime_label"),
                            "mData": "startTime",
                            "bSortable":false
                    }, {
                        "sTitle": appUtils.getString("task_term_endtime_label"),
                            "mData": "endTime",
                            "bSortable":false
                    }, {
                        "sTitle": appUtils.getString("task_term_result_label"),
                            "mData": "result",
                            "bSortable":false
                    }, {
                        "sTitle": appUtils.getString("maintance_term_download_title"),
                            "mData": "resultLink",
                            "bSortable":false
                    }],
                    enablePaging: false,
                    displayLength: constsService.TABLE_COUNT_PER_PAGE,
                    totalRecords: 0,
                    renderRow: function (nRow, aData, iDataIndex) {
                        var result = "--";
                        if (0 === +aData.result) {
                            result = appUtils.getString("common_term_failed_label");
                        } else if (1 === +aData.result) {
                            result = appUtils.getString("common_term_succeed_label");
                        } else {
                            result = appUtils.getString("common_term_all_label");
                        }

                        $('td:eq(2)', nRow).html(result);

                        var resultLink = [];

                        var resultLink = "<a href='javascript:void(0)' class='btn-link' ng-click='exportFile(" + aData["resultId"] + ")'>" + aData['resultLink'] + "</a> ";
                        var optLink = $compile($(resultLink));
                        var optNode = optLink(exportScope);
                        $("td:eq(3)", nRow).html(optNode);
                    },

                    data: [],
                    opAreaConfig: appUtils.flilterOperRight([{
                        id: "iconBtnDel",
                        template: "<div class='iconbutton-delete' title='" + appUtils.getString('common_term_delete_button') + "'></div>",
                        authKey: delKey,
                        clickActive: function () {
                            var selectId = $('#datasBakTable').widget().getHoverData()[0].resultId;
                            message.warn({
                                "content": appUtils.getString("transfer_storage_remote_msg"),
                                "ok": function () {
                                    mask.show();
                                    communicationService.remove(
                                            utilService.getResouceUrl(urlPreffx + "action/deleteTransferStorageHistory"), [selectId])
                                        .promise().always(function(result) {
                                            mask.hide();
                                            if (exception.check(result)) {
                                                message.success({
                                                    content: appUtils.getString("common_term_operation_success_label"),
                                                    ok: function() {
                                                        $scope.refreshDataTable();
                                                    }
                                                });
                                            }

                                        });
                                }
                            });

                        }
                    }]),
                    cellClickActive: function (e, param) {
                        $scope.current = param;
                    },
                    start: 0,
                    callback: function(evtObj) {
                        $scope.datasTable.start = evtObj.currentPage - 1;
                        _getBakTableData();
                    }
                };

                var _getBakTableData = function() {
                    if (urlPreffx == "/alarms/" && appUtils.checkRight("lego.sys.dataStorage.event.scan") || urlPreffx == "/operationlogs/" && appUtils.checkRight("lego.sys.dataStorage.sysOptLog.scan")) {
                        var paramObj = {
                            startPage: $scope.datasTable.start,
                            pageSize: $scope.datasTable.displayLength
                        };
                        var url = urlPreffx + "action/queryTransferStorageHistory?startPage={startPage}&pageSize={pageSize}";
                        url = appUtils.fillUrl(url, paramObj);
                        communicationService.get(utilService.getResouceUrl(url)).promise().always(function(result) {
                            if (exception.check(result)) {
                                $scope.datasTable.data = appUtils.encodeForHTML(result.records);
                                $scope.datasTable.totalRecords = result.totalCount;
                                $scope.datasTable.enablePaging = result.totalCount > $scope.datasTable.displayLength;
                                $scope.$apply();
                            }
                        });
                    }
                };
                //增加help信息
                $scope.bakTime = {
                    mouseenter:function(evt){
                        var tipDiv = $("<div id='bakTimeHelpTip' class='tiny-icontip-content'></div>");
                        restService.getSystemTime([], {
                            mask: false,
                            success: function(response) {
                                if($("#bakTimeHelpTip").length > 0){
                                    return;
                                }
                                var systime = response.time;
                                var cruentTime = $("#baktime").widget().options.defaultTime
                                var nextDay = new Date(appUtils.newDate(systime).getTime() + 1000*60*60*24);
                                nextDay = nextDay.getFullYear()+"-"+(nextDay.getMonth()+1)+"-"+nextDay.getDate();
                                if(systime.split(" ")[1] < cruentTime){
                                    nextDay = systime.split(" ")[0]
                                };
                                var nextBakTime = nextDay +" "+cruentTime;
                                tipDiv.text(appUtils.getString("setting_next_bak_time_help_label",nextBakTime));
                                var offsetX = 0 , offsetY = 0;
                                if( evt.offsetX ){
                                    offsetX = evt.offsetX;
                                    offsetY = evt.offsetY;
                                }else if( evt.originalEvent && evt.originalEvent.layerX ){
                                    offsetX = evt.originalEvent.layerX;
                                    offsetY = evt.originalEvent.layerY;
                                }

                                var x = evt.pageX - offsetX + 10 + 16 + 5, y = evt.pageY - offsetY;

                                if( x + tipDiv.width() > $("body").width() ){
                                    x =  x - tipDiv.width() - 10;
                                }

                                if( y + tipDiv.height() > $("body").height() ){
                                    y = y - tipDiv.height() + 16;
                                }

                                tipDiv.css("left", x).css("top", y);
                                $("body").append(tipDiv);
                            }
                        });
                    },
                    mouseleave:function(evt){
                        $("#bakTimeHelpTip").remove()
                    }
                }
                var _getBakConf = function() {
                    if (urlPreffx == "/alarms/" && appUtils.checkRight("lego.sys.dataStorage.event.scan") || urlPreffx == "/operationlogs/" && appUtils.checkRight("lego.sys.dataStorage.sysOptLog.scan")) {
                        communicationService.get(utilService.getResouceUrl(urlPreffx + "action/queryTransferStorageConfig")).promise().always(function(result) {
                            if (exception.check(result)) {

                                $("#fileformat").widget().opChecked("" + result["fileType"]);
                                $("#language").widget().opChecked("" + result["languageType"]);
                                $scope.model.baktime.value = result["transferStartTime"];
                                $scope.model.bakcycle.value = result["period"];
                                $scope.model.retaintime.value = result["dataSavedTime"]
                                $scope.NEXT_BAK_TIME = result["baseTimeStr"];
                                $scope.taskId = result["taskId"];
                                $scope.$apply();
                            }
                        });
                    }
                };

                var _init = function () {
                    _getBakTableData();
                    _getBakConf();
                };

                $scope.refreshDataTable = function() {
                	$("#datasBakTable").widget().option("cur-page",{pageIndex: 1})
                	$scope.datasTable.start = 0;
                    _getBakTableData();
                }
                _init();

            }]

        var module = angular.module('recoverydirector.setting.config');
        module.tinyController('settings.alarmMaintance.ctrl', ctrler);
        return module;
})
