define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var exportCtrl = [
        "$scope",
        "appUtils",
        "constsService",
        function($scope, appUtils, constsService) {
            $scope.exportLabel = appUtils.getString("system_data_export_to_local");
            $scope.model = {
                password: {
                    label: appUtils.getStringWithColon("export_dataPassword_label"),
                    id: "exportPwd",
                    type: "password",
                    width: constsService.W3,
                    extendFunction: ["checkExportPassword"],
                    validate: "checkExportPassword : extend function;"
                },
                confirmPwd: {
                    label: appUtils.getStringWithColon("user_term_userrepwd_label"),
                    id: "confirmPwd",
                    type: "password",
                    width: constsService.W3,
                    extendFunction: ["validateConfirmPassword"],
                    validate: "validateConfirmPassword : extend function;"
                },
                isDataAnonymous: {
                    text: appUtils.getString("export_isDataAnonymous_label"),
                    message: appUtils.getString("export_isDataAnonymous_message"),
                    id: "isDataAnonymous",
                    checked: false
                }
            };

            UnifyValid.validateConfirmPassword = function() {
                var newPwd = $("#exportPwd").widget().getValue();
                var confirmPwd = $("#confirmPwd").widget().getValue();

                if (newPwd !== confirmPwd) {
                    return appUtils.getString("Login_Message_Password_Different");
                }

                return "";
            }

            UnifyValid.checkExportPassword = function() {
                var dataPassword = $("#exportPwd").widget().getValue(),
                    isChecked = appUtils.checkUserPwd(dataPassword, 8, 2, 15),
                    pwdArray = dataPassword.split("");

                for (var i = 0; i < pwdArray.length; i++) {
                    if (pwdArray[i] === " ") {
                        return appUtils.getString("validate_term_dataPwd_error", 8, 15);
                    }
                }

                if (!dataPassword) {
                    return appUtils.getString("common_term_empty_label");
                }


                if (!isChecked) {
                    return appUtils.getString("validate_term_dataPwd_error", 8, 15);
                }

                return "";
            }

            $scope.$on('$destroy', function() {
                delete UnifyValid.checkExportPassword;
            });
        }
    ];
    var exportApp = angular.module("recoverydirector.setting.config");
    exportApp.tinyController("app.export.confirm.ctrl", exportCtrl);
    return exportApp;
})
